/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.pcg;

import java.io.File;
import tno.geoenergy.data.Grid;
import tno.geoenergy.data.InputXyzPropData;
import tno.geoenergy.data.SmartGrid;
import tno.geoenergy.data.Voxet;
import tno.geoenergy.data.VoxetReader;
import tno.geoenergy.data.VoxetWriter;
import tno.geoenergy.fdintegration.model.ModelBC;
import tno.geoenergy.fdintegration.model.ModelBCContainer;
import tno.geoenergy.fdintegration.model.WellPerforation;
import tno.geoenergy.fdintegration.model.WellPerforationContainer;
import tno.geoenergy.pcg.PCGBand;
import tno.geoenergy.pcg.SymBandMatrix;
import tno.geoenergy.properties.AquiferProperties;
import tno.geoenergy.properties.PropertyFactory;

public class PCG3DBand
extends PCGBand {
    public static final int SURFER = 0;
    public static final int ARCINFO = 1;
    public static final int ZYCOR = 2;
    public static double[][][] values = null;
    public int NX = 10;
    public int NY = 10;
    public int NZ = 10;
    protected boolean[][] active = null;
    protected int[][] indexYstart = null;
    public static final int IJ = 0;
    public static final int IMIN = 1;
    public static final int IPLUS = 2;
    public static final int JMIN = 3;
    public static final int JPLUS = 4;
    public static final int KMIN = 5;
    public static final int KPLUS = 6;
    public static final int DIRICHLET = 1;
    public static final int SOURCE = 2;
    public static final int HWELL = 3;
    public static final int UNDEFINED = 0;
    public double dx;
    public double dy;
    double[][] topdepth;
    double[][][] h;
    double[][][] z;
    double originx;
    double originy;
    double originz;
    double[][][] conductancei = null;
    double[][][] conductancej = null;
    double[][][] conductancek = null;
    double[][][] overcpdxdydz = null;
    double[][][] density = null;
    double refDensity;
    double[][][] densitypseudosourcei = null;
    double[][][] densitypseudosourcej = null;
    double[][][] densitypseudosourcek = null;
    double[][][] rightHandSide = null;
    public int[][][] bccodes = null;
    public double[][][] bcval = null;
    double[][][] CWC = null;
    double[][][] heatprodA = null;
    boolean[][][] okconnect = null;
    boolean[] infinite = new boolean[7];
    boolean[] heatflow = new boolean[7];
    double[] heatflowval = new double[7];
    double[] potentialval = new double[7];
    double[] lmult = new double[7];
    double LMULT = 1000.0;
    double defaultvalue = 1.0;
    double rhocpscale = 1.0;
    int[][][] index = null;
    int[][][] actnum = null;
    public static final String[] GRIDEXTENSION = new String[]{".grd", ".asc", ".dat", ".gmt", "csv"};
    public static final String[] GRIDDATAFORMAT = new String[]{"SURFER", "ARC", "ZYCOR", "GMT", "CSV"};
    double adiag;
    SymBandMatrix amatrix;

    public double getX(int i, int j) {
        return this.originx + (double)i * this.dx;
    }

    public double getY(int i, int j) {
        return this.originy + (double)j * this.dy;
    }

    public int getOrigIndex(int i, int j, int k) {
        return this.indexYstart[i][j] + k;
    }

    public int getIndex(int i, int j, int k) {
        return this.index[i][j][k];
    }

    public int getI(double x) {
        int i = (int)((x - this.originx) / this.dx);
        if (i < 0 || i > this.NX - 1) {
            i = -1;
        }
        return i;
    }

    public int getJ(double y) {
        int i = (int)((y - this.originy) / this.dy);
        if (i < 0 || i > this.NY - 1) {
            i = -1;
        }
        return i;
    }

    public int getK(int ii, int jj, double z) {
        if (ii == -1 || jj == -1) {
            return -1;
        }
        double zz = z - this.topdepth[ii][jj];
        if (zz < 0.0) {
            return -1;
        }
        int kk = 0;
        while (kk < this.NZ) {
            if (zz < this.h[ii][jj][kk]) {
                return kk;
            }
            zz -= this.h[ii][jj][kk];
            ++kk;
        }
        return -1;
    }

    public double getZres(int ii, int jj, int kk, double z) {
        if (ii == -1 || jj == -1) {
            return -1.0;
        }
        double zz = z - this.topdepth[ii][jj];
        if (zz < 0.0) {
            return -1.0;
        }
        int k = 0;
        while (k < kk) {
            if (zz < this.h[ii][jj][kk]) {
                return zz;
            }
            zz -= this.h[ii][jj][kk];
            ++k;
        }
        return -1.0;
    }

    public double getZmid(int ii, int jj, int kk) {
        if (ii == -1 || jj == -1 || kk == -1) {
            return -1.0;
        }
        double zz = -this.topdepth[ii][jj];
        int k = 0;
        while (k < kk) {
            zz -= this.h[ii][jj][k];
            ++k;
        }
        return zz -= 0.5 * this.h[ii][jj][kk];
    }

    private void copyValuesToVoxet(Voxet kx, double[][][] v) {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    kx.getValues()[k][j][i] = (float)v[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void getOK(boolean[] ok, int i, int j) {
        int n = this.getOrigIndex(i, j, 0);
        boolean bl = ok[0] = n >= 0;
        if (ok[0]) {
            n = i == 0 ? -100000000 : this.getOrigIndex(i - 1, j, 0);
            ok[1] = n > -1;
            n = i == this.NX - 1 ? -100000000 : this.getOrigIndex(i + 1, j, 0);
            ok[2] = n > 0;
            n = j == 0 ? -100000000 : this.getOrigIndex(i, j - 1, 0);
            ok[3] = n > -1;
            n = j == this.NY - 1 ? -100000000 : this.getOrigIndex(i, j + 1, 0);
            ok[4] = n > -1;
        }
    }

    @Override
    double getDefaultvalue() {
        return this.defaultvalue;
    }

    public void setDefaultvalue(double defaultvalue) {
        this.defaultvalue = defaultvalue;
    }

    protected void setBCfromdata(InputXyzPropData bcd) {
        try {
            double[] x = bcd.parseDouble(bcd.getColNames()[0], true);
            double[] y = bcd.parseDouble(bcd.getColNames()[1], true);
            double[] z = bcd.parseDouble(bcd.getColNames()[2], true);
            double[] p = bcd.parseDouble(bcd.getColNames()[3], true);
            int ii = 0;
            while (ii < x.length) {
                int i = this.getI(x[ii]);
                int j = this.getJ(y[ii]);
                int k = this.getK(i, j, z[ii]);
                if (i > -1 && j > -1 && k > -1) {
                    this.bccodes[i][j][k] = 1;
                    this.bcval[i][j][k] = p[ii];
                }
                ++ii;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    void scaleOvercdxdydz(int[] idiag, double[] a, double[] b) {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    int n = this.getIndex(i, j, k);
                    if (n >= 0) {
                        int in = idiag[n];
                        while (in < idiag[n + 1]) {
                            int n2 = in++;
                            a[n2] = a[n2] / 1.0;
                            int n3 = n;
                            b[n3] = b[n3] / 1.0;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void getCalculatedWellData(ModelBCContainer bcContainer, WellPerforationContainer wpc, double[][][] pres) {
        int i = 0;
        while (i < wpc.size()) {
            WellPerforation wp = wpc.getWellPerforation(i);
            wp.setPwell_calculated(0.0);
            wp.setQ_calculated(0.0);
            ++i;
        }
        i = 0;
        while (i < bcContainer.size()) {
            double qcell;
            ModelBC bc = bcContainer.getModelBoundaryCondition(i);
            int ii = bc.getIlow();
            int jj = bc.getJlow();
            int kk = bc.getKlow();
            WellPerforation wp = wpc.getWellPerforation(bc.getWellid());
            if (bc.getType() == 7) {
                qcell = bc.getValue() * this.h[ii][jj][kk] * this.dx * this.dy;
                double pp = pres[ii][jj][kk];
                double p = (qcell + bc.getCwc() * pp) / bc.getCwc();
                bc.setQ_calculated(qcell);
                wp.setPwell_calculated(p);
                wp.setQ_calculated(wp.getQ_calculated() + qcell);
            } else if (bc.getType() == 8) {
                qcell = (bc.getValue() - pres[ii][jj][kk]) * bc.getCwc();
                double p = (qcell + bc.getCwc() * pres[ii][jj][kk]) / bc.getCwc();
                wp.setPwell_calculated(p);
                bc.setQ_calculated(qcell);
                wp.setQ_calculated(wp.getQ_calculated() + qcell);
            }
            ++i;
        }
    }

    protected void initializeDensity(double[][][] densityVal) {
        this.density = densityVal;
    }

    protected void initializeRhsForOutput(double[][][] rhsforoutput) {
        this.rightHandSide = rhsforoutput;
    }

    protected void initializeDensityPseudoSource(double[][][] densityPseudoSourcei, double[][][] densityPseudoSourcej, double[][][] densityPseudoSourcek) {
        this.densitypseudosourcei = densityPseudoSourcei;
        this.densitypseudosourcej = densityPseudoSourcej;
        this.densitypseudosourcek = densityPseudoSourcek;
    }

    private void initializeDensity(double[][] densityVal) {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    this.density[i][j][k] = densityVal[i][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void initializeRhsForOutput(double[][] rhsforoutput) {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    this.rightHandSide[i][j][k] = rhsforoutput[i][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void initializeDensityPseudoSource(double[][] densityPseudoSourcei, double[][] densityPseudoSourcej) {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    this.densitypseudosourcei[i][j][k] = densityPseudoSourcei[i][j];
                    this.densitypseudosourcej[i][j][k] = densityPseudoSourcej[i][j];
                    this.densitypseudosourcek[i][j][k] = 0.0;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void get2DDensityPseudoSource(double[][] densityPseudoSourcei, double[][] densityPseudoSourcej) {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                densityPseudoSourcei[i][j] = this.densitypseudosourcei[i][j][0];
                densityPseudoSourcej[i][j] = this.densitypseudosourcej[i][j][0];
                ++j;
            }
            ++i;
        }
    }

    protected void initializeRefDensity(double refDensityVal) {
        this.refDensity = refDensityVal;
    }

    private void initializeConductance(Voxet kx, Voxet ky, Voxet kz) {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    this.conductancei[i][j][k] = kx.getUnknown();
                    this.conductancej[i][j][k] = ky.getUnknown();
                    this.conductancek[i][j][k] = kz.getUnknown();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.NX) {
            int j = 0;
            while (j < this.NY) {
                boolean[] ok = this.okconnect[i2][j];
                if (ok[0]) {
                    int k = 0;
                    while (k < this.NZ) {
                        double c2;
                        double dl2;
                        double kh2;
                        double dl1;
                        double kh1;
                        if (ok[2]) {
                            kh1 = this.h[i2][j][k] * (double)kx.getValues()[k][j][i2];
                            dl1 = this.dx;
                            kh2 = i2 < this.NX - 1 ? this.h[i2 + 1][j][k] * (double)kx.getValues()[k][j][i2 + 1] : kh1;
                            dl2 = this.dx;
                            this.conductancei[i2][j][k] = c2 = 2.0 * this.dy * kh1 * kh2 / (kh1 * dl1 + kh2 * dl2);
                        }
                        if (ok[4]) {
                            kh1 = this.h[i2][j][k] * (double)ky.getValues()[k][j][i2];
                            dl1 = this.dy;
                            kh2 = j < this.NY - 1 ? this.h[i2][j + 1][k] * (double)ky.getValues()[k][j + 1][i2] : kh1;
                            dl2 = this.dy;
                            this.conductancej[i2][j][k] = c2 = 2.0 * this.dx * kh1 * kh2 / (kh1 * dl1 + kh2 * dl2);
                        }
                        kh1 = this.dx * (double)kz.getValues()[k][j][i2];
                        dl1 = this.h[i2][j][k];
                        if (k < this.NZ - 1) {
                            kh2 = this.dx * (double)kz.getValues()[k + 1][j][i2];
                            dl2 = this.h[i2][j][k + 1];
                        } else {
                            kh2 = kh1;
                            dl2 = dl1;
                        }
                        this.conductancek[i2][j][k] = c2 = 2.0 * this.dy * kh1 * kh2 / (kh1 * dl1 + kh2 * dl2);
                        ++k;
                    }
                }
                ++j;
            }
            ++i2;
        }
    }

    private void initializeConductance(double[][] iconductancei, double[][] iconductancej) {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    this.conductancei[i][j][k] = iconductancei[i][j];
                    this.conductancej[i][j][k] = iconductancej[i][j];
                    this.conductancek[i][j][k] = 0.0;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void initializeConductance(double[][][] iconductancei, double[][][] iconductancej, double[][][] iconductancek) {
        this.conductancei = iconductancei;
        this.conductancej = iconductancej;
        this.conductancek = iconductancek;
    }

    public void initializeValTemperatureLITH(double basetemp) {
        this.infinite[1] = false;
        this.infinite[2] = false;
        this.infinite[4] = false;
        this.infinite[3] = false;
        this.infinite[6] = false;
        this.infinite[5] = false;
        this.lmult[1] = 10000.0;
        this.lmult[2] = 10000.0;
        this.lmult[4] = 10000.0;
        this.lmult[3] = 10000.0;
        this.lmult[6] = 0.1;
        this.lmult[5] = 0.1;
        this.LMULT = 1.0;
        this.heatflow[1] = true;
        this.heatflow[2] = true;
        this.heatflow[4] = true;
        this.heatflow[3] = true;
        this.heatflow[6] = false;
        this.heatflow[5] = false;
        this.heatflowval[1] = 0.0;
        this.heatflowval[2] = 0.0;
        this.heatflowval[4] = 0.0;
        this.heatflowval[3] = 0.0;
        this.heatflowval[6] = 0.0;
        this.heatflowval[5] = 0.0;
        this.potentialval[1] = 0.0;
        this.potentialval[2] = 0.0;
        this.potentialval[4] = 0.0;
        this.potentialval[3] = 0.0;
        this.potentialval[6] = basetemp;
        this.potentialval[5] = 0.0;
    }

    public void initializeValTemperatureBCD() {
        this.infinite[1] = false;
        this.infinite[2] = false;
        this.infinite[4] = false;
        this.infinite[3] = false;
        this.infinite[6] = false;
        this.infinite[5] = false;
        this.lmult[1] = 10000.0;
        this.lmult[2] = 10000.0;
        this.lmult[4] = 10000.0;
        this.lmult[3] = 10000.0;
        this.lmult[6] = 10000.0;
        this.lmult[5] = 0.1;
        this.LMULT = 1.0;
        this.heatflow[1] = true;
        this.heatflow[2] = true;
        this.heatflow[4] = true;
        this.heatflow[3] = true;
        this.heatflow[6] = true;
        this.heatflow[5] = false;
        this.heatflowval[1] = 0.0;
        this.heatflowval[2] = 0.0;
        this.heatflowval[4] = 0.0;
        this.heatflowval[3] = 0.0;
        this.heatflowval[6] = 0.0;
        this.heatflowval[5] = 0.0;
        this.potentialval[1] = 0.0;
        this.potentialval[2] = 0.0;
        this.potentialval[4] = 0.0;
        this.potentialval[3] = 0.0;
        this.potentialval[6] = 0.0;
        this.potentialval[5] = 0.0;
    }

    public void initializeValTemperatureBCDNEW() {
        this.initializeValTemperatureBCD();
        this.heatflowval[6] = 0.06;
        this.heatflow[6] = true;
        this.infinite[6] = false;
        this.lmult[6] = 10000.0;
        this.potentialval[5] = 10.0;
    }

    public void initializeValTemperatureBASEHF0() {
        this.initializeValTemperatureBCD();
        this.heatflowval[6] = 0.0;
        this.heatflow[6] = true;
        this.infinite[6] = false;
        this.lmult[6] = 10000.0;
        this.potentialval[5] = 10.0;
    }

    public void initializeValPressure(double infinel) {
        this.infinite[1] = true;
        this.infinite[2] = true;
        this.infinite[4] = true;
        this.infinite[3] = true;
        this.infinite[6] = false;
        this.infinite[5] = false;
        this.lmult[1] = this.LMULT = infinel;
        this.lmult[2] = this.LMULT;
        this.lmult[4] = this.LMULT;
        this.lmult[3] = this.LMULT;
        this.lmult[6] = this.LMULT;
        this.lmult[5] = this.LMULT;
        this.heatflow[1] = false;
        this.heatflow[2] = false;
        this.heatflow[4] = false;
        this.heatflow[3] = false;
        this.heatflow[6] = true;
        this.heatflow[5] = true;
        this.heatflowval[1] = 0.0;
        this.heatflowval[2] = 0.0;
        this.heatflowval[4] = 0.0;
        this.heatflowval[3] = 0.0;
        this.heatflowval[6] = 0.0;
        this.heatflowval[5] = 0.0;
        this.potentialval[1] = 0.0;
        this.potentialval[2] = 0.0;
        this.potentialval[4] = 0.0;
        this.potentialval[3] = 0.0;
        this.potentialval[6] = 0.0;
        this.potentialval[5] = 0.0;
    }

    public void initializeValPressure2(double infinel) {
        this.infinite[1] = false;
        this.infinite[2] = false;
        this.infinite[4] = false;
        this.infinite[3] = false;
        this.infinite[6] = false;
        this.infinite[5] = false;
        this.lmult[1] = this.LMULT = infinel;
        this.lmult[2] = this.LMULT;
        this.lmult[4] = this.LMULT;
        this.lmult[3] = this.LMULT;
        this.lmult[6] = this.LMULT;
        this.lmult[5] = this.LMULT;
        this.heatflow[1] = true;
        this.heatflow[2] = true;
        this.heatflow[4] = true;
        this.heatflow[3] = true;
        this.heatflow[6] = true;
        this.heatflow[5] = true;
        this.heatflowval[1] = 0.0;
        this.heatflowval[2] = 0.0;
        this.heatflowval[4] = 0.0;
        this.heatflowval[3] = 0.0;
        this.heatflowval[6] = 0.0;
        this.heatflowval[5] = 0.0;
        this.potentialval[1] = 0.0;
        this.potentialval[2] = 0.0;
        this.potentialval[4] = 0.0;
        this.potentialval[3] = 0.0;
        this.potentialval[6] = 0.0;
        this.potentialval[5] = 0.0;
    }

    private void initializeArrays() {
        boolean okallocate;
        boolean bl = okallocate = this.h == null || this.h.length < this.NX || this.h[0].length < this.NY || this.h[0][0].length < this.NZ;
        if (okallocate) {
            this.topdepth = new double[this.NX][this.NY];
            this.h = new double[this.NX][this.NY][this.NZ];
            this.z = new double[this.NX][this.NY][this.NZ];
            this.indexYstart = new int[this.NX][this.NY];
            this.conductancei = new double[this.NX][this.NY][this.NZ];
            this.conductancej = new double[this.NX][this.NY][this.NZ];
            this.conductancek = new double[this.NX][this.NY][this.NZ];
            this.overcpdxdydz = new double[this.NX][this.NY][this.NZ];
            this.density = new double[this.NX][this.NY][this.NZ];
            this.densitypseudosourcei = new double[this.NX][this.NY][this.NZ];
            this.densitypseudosourcej = new double[this.NX][this.NY][this.NZ];
            this.densitypseudosourcek = new double[this.NX][this.NY][this.NZ];
            this.rightHandSide = new double[this.NX][this.NY][this.NZ];
            this.bccodes = new int[this.NX][this.NY][this.NZ];
            this.bcval = new double[this.NX][this.NY][this.NZ];
            this.CWC = new double[this.NX][this.NY][this.NZ];
            this.heatprodA = new double[this.NX][this.NY][this.NZ];
            this.okconnect = new boolean[this.NX][this.NY][5];
            this.index = new int[this.NX][this.NY][this.NZ];
            this.actnum = new int[this.NX][this.NY][this.NZ];
        }
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    this.actnum[i][j][k] = 1;
                    this.topdepth[i][j] = 0.0;
                    this.h[i][j][k] = 0.0;
                    this.z[i][j][k] = 0.0;
                    this.indexYstart[i][j] = 0;
                    this.conductancei[i][j][k] = 0.0;
                    this.conductancej[i][j][k] = 0.0;
                    this.conductancek[i][j][k] = 0.0;
                    this.density[i][j][k] = 0.0;
                    this.bccodes[i][j][k] = 0;
                    this.bcval[i][j][k] = 0.0;
                    this.index[i][j][k] = 0;
                    this.CWC[i][j][k] = 0.0;
                    this.heatprodA[i][j][k] = 0.0;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    protected void initializeOvercpdxdydzConstant(double v) {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    this.overcpdxdydz[i][j][k] = v;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private int initializeIndex() {
        int lastindex = 0;
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    this.index[i][j][k] = -1;
                    if (this.getOrigIndex(i, j, k) >= 0 && this.bccodes[i][j][k] != 1 && this.actnum[i][j][k] > 0) {
                        this.index[i][j][k] = lastindex++;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return lastindex;
    }

    private int initializeOrigIndex(Voxet kk) {
        this.active = new boolean[this.NX][this.NY];
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                if (kk.defined(kk.getValues()[0][j][i])) {
                    this.active[i][j] = true;
                }
                ++j;
            }
            ++i;
        }
        return this.initializeOrigIndex(this.active);
    }

    protected int initializeOrigIndex(double[][] kk, double unknown) {
        this.active = new boolean[this.NX][this.NY];
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                if (Grid.defined((float)kk[i][j], (float)unknown)) {
                    this.active[i][j] = true;
                }
                ++j;
            }
            ++i;
        }
        return this.initializeOrigIndex(this.active);
    }

    private int initializeOrigIndex(boolean[][] active) {
        int lastindex = 0;
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                if (active[i][j]) {
                    this.indexYstart[i][j] = lastindex;
                    lastindex += this.NZ;
                } else {
                    this.indexYstart[i][j] = -10000000;
                }
                ++j;
            }
            ++i;
        }
        return lastindex;
    }

    void generateZarray() {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    this.z[i][j][k] = k == 0 ? this.topdepth[i][j] + 0.5 * this.h[i][j][k] : this.z[i][j][k - 1] + 0.5 * this.h[i][j][k - 1] + 0.5 * this.h[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void initGeometryProp(int nx, int ny, double dx, double dy, double orx, double ory, double[][] iconductancei, double[][] iconductancej, double unknown, double[][] itopdepth, double[][] ih, double[][] iactnum, double[][] overrhocp) {
        int k;
        int j;
        this.rhocpscale = 1.0;
        this.NX = nx;
        this.NY = ny;
        this.NZ = 1;
        this.originx = orx;
        this.originy = ory;
        this.originz = 0.0;
        this.dx = dx;
        this.dy = dy;
        this.initializeArrays();
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                this.topdepth[i][j] = this.originz + itopdepth[i][j];
                k = 0;
                while (k < this.NZ) {
                    this.h[i][j][k] = ih[i][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.generateZarray();
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    this.actnum[i][j][k] = (int)iactnum[i][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        nx = this.initializeOrigIndex(ih, unknown);
        this.initializeOK(this.okconnect);
        this.initializeOvercpdxdydzConstant(1.0);
        this.initializeConductance(iconductancei, iconductancej);
    }

    public void initGeometryProp(int nx, int ny, double dx, double dy, double orx, double ory, double[][] iconductancei, double[][] iconductancej, double unknown, double refDensityVal, double[][] itopdepth, double[][] ih, double[][] iactnum, double[][] overrhocp, double[][] densityVal, double[][] densityPseudoSourcei, double[][] densityPseudoSourcej, double[][] rhsforoutput) {
        int k;
        int j;
        this.rhocpscale = 1.0;
        this.NX = nx;
        this.NY = ny;
        this.NZ = 1;
        this.originx = orx;
        this.originy = ory;
        this.originz = 0.0;
        this.dx = dx;
        this.dy = dy;
        this.initializeArrays();
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                this.topdepth[i][j] = this.originz + itopdepth[i][j];
                k = 0;
                while (k < this.NZ) {
                    this.h[i][j][k] = ih[i][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.generateZarray();
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    this.actnum[i][j][k] = (int)iactnum[i][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        nx = this.initializeOrigIndex(ih, unknown);
        this.initializeOK(this.okconnect);
        this.initializeOvercpdxdydzConstant(1.0);
        this.initializeConductance(iconductancei, iconductancej);
        this.initializeDensity(densityVal);
        this.initializeDensityPseudoSource(densityPseudoSourcei, densityPseudoSourcej);
        this.initializeRefDensity(refDensityVal);
        this.initializeRhsForOutput(rhsforoutput);
    }

    public void initGeometryProp(int nx, int ny, int nz, double dx, double dy, double orx, double ory, double[][][] iconductancei, double[][][] iconductancej, double[][][] iconductancek, double unknown, double[][] itopdepth, double[][][] ih, double[][][] iactnum, double[][][] overrhocp) {
        int k;
        int j;
        this.rhocpscale = 1.0;
        this.NX = nx;
        this.NY = ny;
        this.NZ = nz;
        this.originx = orx;
        this.originy = ory;
        this.originz = 0.0;
        this.dx = dx;
        this.dy = dy;
        this.initializeArrays();
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                this.topdepth[i][j] = this.originz + itopdepth[i][j];
                k = 0;
                while (k < this.NZ) {
                    this.h[i][j][k] = ih[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.generateZarray();
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    this.actnum[i][j][k] = (int)iactnum[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        nx = this.initializeOrigIndex(itopdepth, unknown);
        this.initializeOK(this.okconnect);
        this.initializeOvercpdxdydzConstant(1.0);
        this.initializeConductance(iconductancei, iconductancej, iconductancek);
    }

    public void initGeometryProp(int nx, int ny, int nz, double dx, double dy, double orx, double ory, double[][][] iconductancei, double[][][] iconductancej, double[][][] iconductancek, double unknown, double refDensityVal, double[][] itopdepth, double[][][] ih, double[][][] iactnum, double[][][] overrhocp, double[][][] densityVal, double[][][] densityPseudoSourcei, double[][][] densityPseudoSourcej, double[][][] densityPseudoSourcek, double[][][] rhsforoutput) {
        int k;
        int j;
        this.rhocpscale = 1.0;
        this.NX = nx;
        this.NY = ny;
        this.NZ = nz;
        this.originx = orx;
        this.originy = ory;
        this.originz = 0.0;
        this.dx = dx;
        this.dy = dy;
        this.initializeArrays();
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                this.topdepth[i][j] = this.originz + itopdepth[i][j];
                k = 0;
                while (k < this.NZ) {
                    this.h[i][j][k] = ih[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.generateZarray();
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    this.actnum[i][j][k] = (int)iactnum[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        nx = this.initializeOrigIndex(itopdepth, unknown);
        this.initializeOK(this.okconnect);
        this.initializeOvercpdxdydzConstant(1.0);
        this.initializeConductance(iconductancei, iconductancej, iconductancek);
        this.initializeDensity(densityVal);
        this.initializeDensityPseudoSource(densityPseudoSourcei, densityPseudoSourcej, densityPseudoSourcek);
        this.initializeRefDensity(refDensityVal);
        this.initializeRhsForOutput(rhsforoutput);
    }

    public void initGeometryProp(Voxet kx, Voxet ky, Voxet kz, Voxet A, double rhocpscale, double rhocp, int nclipz) {
        int k;
        int j;
        rhocp = rhocpscale * rhocp;
        this.rhocpscale = rhocpscale;
        this.NX = kx.getNx();
        this.NY = kx.getNy();
        this.NZ = Math.min(kx.getNz(), nclipz);
        this.originx = kx.getOriginx();
        this.originy = kx.getOriginy();
        this.originz = kx.getOriginz();
        this.dx = kx.getDx();
        this.dy = kx.getDy();
        this.initializeArrays();
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                this.topdepth[i][j] = this.originz;
                k = 0;
                while (k < this.NZ) {
                    this.h[i][j][k] = kx.getDz();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.generateZarray();
        System.out.println("kx unknow : " + kx.getUnknown());
        this.nx = this.initializeOrigIndex(kx);
        this.initializeOK(this.okconnect);
        this.initializeOvercpdxdydzConstant(1.0);
        this.initializeConductance(kx, ky, kz);
        if (A != null) {
            i = 0;
            while (i < this.NX) {
                j = 0;
                while (j < this.NY) {
                    k = 0;
                    while (k < this.NZ) {
                        this.heatprodA[i][j][k] = A.getValues()[k][j][i];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        String fbase = new File(kx.getFileName()).getParent();
        Voxet kxx = new Voxet(kx, String.valueOf(fbase) + "/kxx", "kxx");
        this.copyValuesToVoxet(kxx, this.conductancei);
        VoxetWriter.write(kxx);
        Voxet kyy = new Voxet(ky, String.valueOf(fbase) + "/kyy", "kyy");
        this.copyValuesToVoxet(kyy, this.conductancej);
        VoxetWriter.write(kyy);
        Voxet kzz = new Voxet(kz, String.valueOf(fbase) + "/kzz", "kzz");
        this.copyValuesToVoxet(kzz, this.conductancek);
        VoxetWriter.write(kzz);
        Voxet cp = new Voxet(kx, String.valueOf(fbase) + "/cp", "cp");
        this.copyValuesToVoxet(cp, this.overcpdxdydz);
        VoxetWriter.write(cp);
    }

    public void initializeDirichlet(InputXyzPropData bcd) {
        this.initializeDirichlet(bcd, false);
    }

    public void initializeDirichlet(InputXyzPropData bcd, boolean constantpres) {
        int k;
        int j;
        boolean fixedyet = false;
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    if (this.actnum[i][j][k] == 1 && (this.bccodes[i][j][k] == 1 || this.bccodes[i][j][k] == 3)) {
                        fixedyet = true;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        fixedyet = true;
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                boolean[] ok = this.okconnect[i][j];
                if (ok[0]) {
                    k = 0;
                    while (k < this.NZ) {
                        int ik = 1;
                        while (ik < 5) {
                            if (!ok[ik]) {
                                if (!this.heatflow[ik] && !this.infinite[ik]) {
                                    if (this.bccodes[i][j][k] == 0) {
                                        this.bccodes[i][j][k] = 1;
                                        this.bcval[i][j][k] = this.potentialval[ik];
                                    }
                                } else if (this.heatflow[ik] && !constantpres && this.actnum[i][j][k] == 1 && !fixedyet) {
                                    int ii = 0;
                                    while (ii < this.NX) {
                                        int jj = 0;
                                        while (jj < this.NY) {
                                            this.bccodes[ii][jj][0] = 1;
                                            this.bcval[ii][jj][0] = 0.0;
                                            ++jj;
                                        }
                                        ++ii;
                                    }
                                    fixedyet = true;
                                }
                            }
                            ++ik;
                        }
                        ik = -1;
                        if (k == 0) {
                            ik = 5;
                        } else if (k == this.NZ - 1) {
                            ik = 6;
                        }
                        if (ik > 0 && !this.heatflow[ik] && !this.infinite[ik] && this.bccodes[i][j][k] == 0) {
                            this.bccodes[i][j][k] = 1;
                            this.bcval[i][j][k] = this.potentialval[ik];
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (bcd != null) {
            this.setBCfromdata(bcd);
        }
        this.nx = this.initializeIndex();
        System.out.println("number of equations " + this.nx);
    }

    public void initializeOK(boolean[][][] ok) {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                this.getOK(ok[i][j], i, j);
                ++j;
            }
            ++i;
        }
    }

    public void initializeConstantDensityRHS(double[] b) {
        int k;
        int j;
        int n = 0;
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    n = this.getIndex(i, j, k);
                    if (n > -1) {
                        b[n] = 0.0;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.initialize_dirichlet();
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    if (this.bccodes[i][j][k] == 2) {
                        n = this.getIndex(i, j, k);
                        if (n < 0) {
                            System.out.println(" ERROR bccodes (" + i + "," + j + "," + k + ") + refers to non-active cell in A matrix");
                        }
                        int n2 = n;
                        b[n2] = b[n2] + -this.heatprodA[i][j][k] * (this.dx * this.dy * this.h[i][j][k]) * DIAGSCALE * this.overcpdxdydz[i][j][k];
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    if (this.bccodes[i][j][k] == 2) {
                        n = this.getIndex(i, j, k);
                        b[n] = -this.bcval[i][j][k] * DIAGSCALE * this.overcpdxdydz[i][j][k];
                    }
                    if (this.bccodes[i][j][k] == 3) {
                        n = this.getIndex(i, j, k);
                        b[n] = -this.bcval[i][j][k] * this.CWC[i][j][k] * DIAGSCALE * this.overcpdxdydz[i][j][k];
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.NX) {
            int j2 = 0;
            while (j2 < this.NY) {
                int k2 = 0;
                while (k2 < this.NZ) {
                    if (this.active[i2][j2]) {
                        boolean ok;
                        boolean bl = ok = k2 == this.NZ - 1;
                        if (ok && this.heatflow[6] && (n = this.getIndex(i2, j2, k2)) > -1) {
                            int n3 = n;
                            b[n3] = b[n3] + -this.heatflowval[6] * (this.dx * this.dy) * DIAGSCALE * this.overcpdxdydz[i2][j2][k2];
                        }
                        boolean bl2 = ok = k2 == 0;
                        if (ok && this.heatflow[5] && (n = this.getIndex(i2, j2, k2)) > -1) {
                            int n4 = n;
                            b[n4] = b[n4] + -this.heatflowval[5] * (this.dx * this.dy) * DIAGSCALE * this.overcpdxdydz[i2][j2][k2];
                        }
                    }
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
    }

    @Override
    public void initializeRHS(double[] b) {
        boolean updateDensity;
        boolean bl = updateDensity = PropertyFactory.getProperty(AquiferProperties.ISWITCH_PTS_DENSITY).getDefaultvalue() == 1.0;
        if (updateDensity) {
            this.initializeVariableDensityRHS(b);
        } else {
            this.initializeConstantDensityRHS(b);
        }
    }

    public void initializeVariableDensityRHS(double[] b) {
        int k;
        int j;
        int k2;
        int j2;
        int n = 0;
        this.initialize_dirichlet();
        double[][][] densitypseudosource2 = new double[this.NX][this.NY][this.NZ];
        int i = 0;
        while (i < this.NX) {
            int j3 = 0;
            while (j3 < this.NY) {
                int k3 = 0;
                while (k3 < this.NZ) {
                    n = this.getIndex(i, j3, k3);
                    if (n > -1) {
                        double rhs;
                        b[n] = 0.0;
                        boolean upflowboundary = k3 == 0 || this.actnum[i][j3][k3 - 1] != 1;
                        boolean downflowboundary = k3 == this.NZ - 1 || this.actnum[i][j3][k3 + 1] != 1;
                        boolean jlflowboundary = j3 == 0;
                        boolean jrflowboundary = j3 == this.NY - 1;
                        boolean ilflowboundary = i == 0;
                        boolean irflowboundary = i == this.NX - 1;
                        int iplus = i + 1;
                        int jplus = j3 + 1;
                        int kplus = k3 + 1;
                        int imin = i - 1;
                        int jmin = j3 - 1;
                        int kmin = k3 - 1;
                        if (this.NZ == 1) {
                            kplus = k3;
                            kmin = k3;
                        }
                        if (upflowboundary) {
                            kmin = k3;
                        }
                        if (downflowboundary) {
                            kplus = k3;
                        }
                        if (jlflowboundary) {
                            jmin = j3;
                        }
                        if (jrflowboundary) {
                            jplus = j3;
                        }
                        if (ilflowboundary) {
                            imin = i;
                        }
                        if (irflowboundary) {
                            iplus = i;
                        }
                        double condcPlus = this.conductancei[i][j3][k3];
                        double condrPlus = this.conductancej[i][j3][k3];
                        double condvPlus = this.conductancek[i][j3][k3];
                        double dziPlus = this.z[iplus][j3][k3] - this.z[i][j3][k3];
                        double dzjPlus = this.z[i][jplus][k3] - this.z[i][j3][k3];
                        double dzkPlus = this.z[i][j3][kplus] - this.z[i][j3][k3];
                        double densityiPlus = (this.density[i][j3][k3] + this.density[iplus][j3][k3]) / 2.0;
                        double densityjPlus = (this.density[i][j3][k3] + this.density[i][jplus][k3]) / 2.0;
                        double densitykPlus = dzkPlus > 1.0E-10 ? (this.density[i][j3][k3] * 0.5 * this.h[i][j3][k3] + this.density[i][j3][kplus] * 0.5 * this.h[i][j3][kplus]) / dzkPlus : 1.0E-10;
                        double condcMinus = this.conductancei[imin][j3][k3];
                        double condrMinus = this.conductancej[i][jmin][k3];
                        double condvMinus = this.conductancek[i][j3][kmin];
                        double dziMinus = this.z[imin][j3][k3] - this.z[i][j3][k3];
                        double dzjMinus = this.z[i][jmin][k3] - this.z[i][j3][k3];
                        double dzkMinus = -(this.z[i][j3][k3] - this.z[i][j3][kmin]);
                        double densityiMinus = (this.density[imin][j3][k3] + this.density[i][j3][k3]) / 2.0;
                        double densityjMinus = (this.density[i][jmin][k3] + this.density[i][j3][k3]) / 2.0;
                        double densitykMinus = -dzkMinus > 1.0E-10 ? (this.density[i][j3][kmin] * 0.5 * this.h[i][j3][kmin] + this.density[i][j3][k3] * 0.5 * this.h[i][j3][k3]) / -dzkMinus : 1.0E-5;
                        if (this.NZ == 1) {
                            condvPlus = 0.0;
                            condvMinus = 0.0;
                        }
                        if (upflowboundary) {
                            condvMinus = 0.0;
                        }
                        if (downflowboundary) {
                            condvPlus = 0.0;
                        }
                        if (jlflowboundary) {
                            condrMinus = 0.0;
                        }
                        if (jrflowboundary) {
                            condrPlus = 0.0;
                        }
                        if (ilflowboundary) {
                            condcMinus = 0.0;
                        }
                        if (irflowboundary) {
                            condcPlus = 0.0;
                        }
                        double correction = 9.81 * this.refDensity * 1.0E-5;
                        densitypseudosource2[i][j3][k3] = rhs = correction * condcPlus * ((densityiPlus - this.refDensity) * dziPlus / this.refDensity) + correction * condcMinus * ((densityiMinus - this.refDensity) * dziMinus / this.refDensity) + correction * condrPlus * ((densityjPlus - this.refDensity) * dzjPlus / this.refDensity) + correction * condrMinus * ((densityjMinus - this.refDensity) * dzjMinus / this.refDensity) + correction * condvPlus * ((densitykPlus - this.refDensity) * dzkPlus / this.refDensity) + correction * condvMinus * ((densitykMinus - this.refDensity) * dzkMinus / this.refDensity);
                        this.densitypseudosourcei[i][j3][k3] = dziPlus * 9.81 * (densityiPlus - this.refDensity) * 1.0E-5;
                        this.densitypseudosourcej[i][j3][k3] = dzjPlus * 9.81 * (densityjPlus - this.refDensity) * 1.0E-5;
                        this.densitypseudosourcek[i][j3][k3] = dzkPlus * 9.81 * (densitykPlus - this.refDensity) * 1.0E-5;
                        int n2 = n;
                        b[n2] = b[n2] + DIAGSCALE * rhs;
                    }
                    ++k3;
                }
                ++j3;
            }
            ++i;
        }
        double sumeff = 0.0;
        int i2 = 0;
        while (i2 < this.NX) {
            j2 = 0;
            while (j2 < this.NY) {
                k2 = 0;
                while (k2 < this.NZ) {
                    sumeff += -densitypseudosource2[i2][j2][k2];
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
        System.out.println("RHS density  terms concvection " + sumeff);
        i2 = 0;
        while (i2 < this.NX) {
            j2 = 0;
            while (j2 < this.NY) {
                k2 = 0;
                while (k2 < this.NZ) {
                    if (this.bccodes[i2][j2][k2] == 2) {
                        n = this.getIndex(i2, j2, k2);
                        if (n < 0) {
                            System.out.println(" ERROR bccodes (" + i2 + "," + j2 + "," + k2 + ") + refers to non-active cell in A matrix");
                        }
                        int n3 = n;
                        b[n3] = b[n3] + -this.heatprodA[i2][j2][k2] * (this.dx * this.dy * this.h[i2][j2][k2]) * DIAGSCALE * this.overcpdxdydz[i2][j2][k2];
                    }
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
        double[][] middepth = new double[this.NX][this.NY];
        double[][] correctionpseudo = new double[this.NX][this.NY];
        int i3 = 0;
        while (i3 < this.NX) {
            j = 0;
            while (j < this.NY) {
                double zsum = 0.0;
                int ncount = 0;
                double z = this.topdepth[i3][j] - 0.5 * this.h[i3][j][0];
                int k4 = 0;
                while (k4 < this.NZ) {
                    z += this.h[i3][j][k4];
                    if (this.actnum[i3][j][k4] > 0) {
                        zsum += z;
                        ++ncount;
                    }
                    ++k4;
                }
                middepth[i3][j] = zsum / (double)ncount;
                z = this.topdepth[i3][j] - 0.5 * this.h[i3][j][0];
                boolean found = false;
                int k5 = 0;
                while (k5 < this.NZ) {
                    z += this.h[i3][j][k5];
                    if (!found) {
                        double[] dArray = correctionpseudo[i3];
                        int n4 = j;
                        dArray[n4] = dArray[n4] + this.densitypseudosourcek[i3][j][k5];
                        if (z > middepth[i3][j]) {
                            found = true;
                        }
                    }
                    ++k5;
                }
                ++j;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < this.NX) {
            j = 0;
            while (j < this.NY) {
                double correction = 0.0;
                double sumcorrection = 0.0;
                int k6 = 0;
                while (k6 < this.NZ) {
                    if (this.bccodes[i3][j][k6] == 2) {
                        int n5 = n = this.getIndex(i3, j, k6);
                        b[n5] = b[n5] + -this.bcval[i3][j][k6] * DIAGSCALE * this.overcpdxdydz[i3][j][k6];
                    }
                    sumcorrection += this.densitypseudosourcek[i3][j][k6];
                    if (this.bccodes[i3][j][k6] == 3) {
                        int n6 = n = this.getIndex(i3, j, k6);
                        b[n6] = b[n6] + -this.bcval[i3][j][k6] * this.CWC[i3][j][k6] * DIAGSCALE * this.overcpdxdydz[i3][j][k6];
                        correction = -(sumcorrection - correctionpseudo[i3][j]);
                        int n7 = n;
                        b[n7] = b[n7] + correction * this.CWC[i3][j][k6] * DIAGSCALE * this.overcpdxdydz[i3][j][k6];
                        System.out.println("xxxxxxx corr " + correction + " sumcorr " + sumcorrection + " pseudo " + correctionpseudo[i3][j] + " ij " + i3 + " " + j);
                    }
                    ++k6;
                }
                ++j;
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.NX) {
            int j4 = 0;
            while (j4 < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    if (this.active[i4][j4]) {
                        boolean ok;
                        boolean bl = ok = k == this.NZ - 1;
                        if (ok && this.heatflow[6] && (n = this.getIndex(i4, j4, k)) > -1) {
                            int n8 = n;
                            b[n8] = b[n8] + -this.heatflowval[6] * (this.dx * this.dy) * DIAGSCALE * this.overcpdxdydz[i4][j4][k];
                        }
                        boolean bl2 = ok = k == 0;
                        if (ok && this.heatflow[5] && (n = this.getIndex(i4, j4, k)) > -1) {
                            int n9 = n;
                            b[n9] = b[n9] + -this.heatflowval[5] * (this.dx * this.dy) * DIAGSCALE * this.overcpdxdydz[i4][j4][k];
                        }
                    }
                    ++k;
                }
                ++j4;
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < this.NX) {
            int j5 = 0;
            while (j5 < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    n = this.getIndex(i4, j5, k);
                    if (n > -1) {
                        this.rightHandSide[i4][j5][k] = b[n];
                    }
                    ++k;
                }
                ++j5;
            }
            ++i4;
        }
    }

    @Override
    public void initialize_dirichlet() {
        boolean[] ok = null;
        if (this.b == null) {
            this.b = new double[this.nx];
        }
        int i = 0;
        while (i < this.nx) {
            this.b[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                ok = this.okconnect[i][j];
                if (ok[0]) {
                    int k = 0;
                    while (k < this.NZ) {
                        int n = this.getIndex(i, j, k);
                        if (n >= 0) {
                            int ik = 1;
                            while (ik < 5) {
                                if (!ok[ik] && this.infinite[ik]) {
                                    if (ik < 3) {
                                        int n2 = n;
                                        this.b[n2] = this.b[n2] + -DIAGSCALE * this.overcpdxdydz[i][j][k] * this.conductancei[i][j][k] * this.lmult[ik] * this.getDefaultPotential(ik, i, j, k);
                                    } else {
                                        int n3 = n;
                                        this.b[n3] = this.b[n3] + -DIAGSCALE * this.overcpdxdydz[i][j][k] * this.conductancej[i][j][k] * this.lmult[ik] * this.getDefaultPotential(ik, i, j, k);
                                    }
                                }
                                ++ik;
                            }
                            boolean okKMIN = k > 0;
                            boolean okKPLUS = k < this.NZ - 1;
                            ik = -1;
                            if (okKMIN) {
                                ik = 5;
                            } else if (okKPLUS) {
                                ik = 6;
                            }
                            if (ik > 0 && this.infinite[ik]) {
                                int n4 = n;
                                this.b[n4] = this.b[n4] + -DIAGSCALE * this.overcpdxdydz[i][j][k] * this.conductancek[i][j][k] * this.lmult[ik] * this.getDefaultPotential(ik, i, j, k);
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        this.initialize_DirichletInternal();
    }

    public void initialize_DirichletInternal() {
        boolean[] ok = null;
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                ok = this.okconnect[i][j];
                if (ok[0]) {
                    int k = 0;
                    while (k < this.NZ) {
                        int n = this.getIndex(i, j, k);
                        if (n >= 0) {
                            boolean okKPLUS;
                            int n2;
                            if (ok[2] && (n2 = this.getIndex(i + 1, j, k)) < 0 && this.bccodes[i + 1][j][k] == 1) {
                                double txf = this.bcval[i + 1][j][k];
                                int n3 = n;
                                this.b[n3] = this.b[n3] - this.conductancei[i][j][k] * txf * this.overcpdxdydz[i][j][k];
                            }
                            if (ok[4] && (n2 = this.getIndex(i, j + 1, k)) < 0 && this.bccodes[i][j + 1][k] == 1) {
                                double tyf = this.bcval[i][j + 1][k];
                                int n4 = n;
                                this.b[n4] = this.b[n4] - this.conductancej[i][j][k] * tyf * this.overcpdxdydz[i][j][k];
                            }
                            if (ok[1] && (n2 = this.getIndex(i - 1, j, k)) < 0 && this.bccodes[i - 1][j][k] == 1) {
                                double txb = this.bcval[i - 1][j][k];
                                int n5 = n;
                                this.b[n5] = this.b[n5] - this.conductancei[i - 1][j][k] * txb * this.overcpdxdydz[i][j][k];
                            }
                            if (ok[3] && (n2 = this.getIndex(i, j - 1, k)) < 0 && this.bccodes[i][j - 1][k] == 1) {
                                double tyb = this.bcval[i][j - 1][k];
                                int n6 = n;
                                this.b[n6] = this.b[n6] - this.conductancej[i][j - 1][k] * tyb * this.overcpdxdydz[i][j][k];
                            }
                            boolean okKMIN = k > 0;
                            boolean bl = okKPLUS = k < this.NZ - 1;
                            if (okKPLUS && (n2 = this.getIndex(i, j, k + 1)) < 0 && this.bccodes[i][j][k + 1] == 1) {
                                double tzf = this.bcval[i][j][k + 1];
                                int n7 = n;
                                this.b[n7] = this.b[n7] - this.conductancek[i][j][k] * tzf * this.overcpdxdydz[i][j][k];
                            }
                            if (okKMIN && (n2 = this.getIndex(i, j, k - 1)) < 0 && this.bccodes[i][j][k - 1] == 1) {
                                double tzb = this.bcval[i][j][k - 1];
                                int n8 = n;
                                this.b[n8] = this.b[n8] - this.conductancek[i][j][k - 1] * tzb * this.overcpdxdydz[i][j][k];
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void initializeDefaultValue() {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    if (this.bccodes[i][j][k] == 1 && Math.abs(this.bcval[i][j][k]) > Math.abs(this.getDefaultvalue())) {
                        this.setDefaultvalue(this.bcval[i][j][k]);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 7) {
            if (Math.abs(this.potentialval[i]) > Math.abs(this.getDefaultvalue())) {
                this.setDefaultvalue(this.potentialval[i]);
            }
            ++i;
        }
    }

    @Override
    public void APrepare(int iprepmode) {
        int i;
        boolean[] ok = null;
        int idiagcount = 0;
        int ioffset = -1;
        int ioffset0 = -1;
        int icount_i = -1;
        int nold = -1;
        if (iprepmode == 0) {
            this.symband.nfill = 0;
        }
        if (iprepmode == 1) {
            i = 0;
            while (i < this.symband.nfill) {
                this.symband.a[i] = 0.0;
                ++i;
            }
        }
        i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                ok = this.okconnect[i][j];
                if (ok[0]) {
                    int k = 0;
                    while (k < this.NZ) {
                        int n = this.getIndex(i, j, k);
                        if (n >= 0) {
                            boolean okKPLUS;
                            int n2;
                            double t = this.x[n];
                            if (iprepmode == 0) {
                                if (n != nold + 1) {
                                    System.out.println(" ordering of valid nodes not increasing from 0.. nnodes: node n" + n + "  nold " + nold);
                                }
                                nold = n;
                                ++this.symband.nfill;
                                this.symband.idiag[idiagcount] = this.symband.nfill - 1;
                                ++idiagcount;
                            }
                            if (iprepmode == 1) {
                                ioffset0 = ioffset = this.symband.idiag[++icount_i];
                                this.symband.ix[ioffset] = n;
                                if (this.bccodes[i][j][k] == 3) {
                                    double cwc = this.CWC[i][j][k];
                                    int n3 = ioffset0;
                                    this.symband.a[n3] = this.symband.a[n3] + -cwc * this.overcpdxdydz[i][j][k];
                                }
                            }
                            double dd = 0.0;
                            this.adiag = 0.0;
                            if (ok[2]) {
                                n2 = this.getIndex(i + 1, j, k);
                                double txf = 0.0;
                                if (n2 >= n) {
                                    txf = this.x[n2];
                                    if (iprepmode == 0) {
                                        ++this.symband.nfill;
                                    }
                                    if (iprepmode == 1) {
                                        this.symband.ix[++ioffset] = n2;
                                    }
                                }
                                dd += this.conductancei[i][j][k] * (txf - t);
                                if (iprepmode == 1) {
                                    int n4 = ioffset0;
                                    this.symband.a[n4] = this.symband.a[n4] + -this.conductancei[i][j][k] * this.overcpdxdydz[i][j][k];
                                    if (n2 >= n) {
                                        if (ioffset == 1) {
                                            System.out.println(" a[1] " + this.conductancei[i][j][k] * this.overcpdxdydz[i][j][k]);
                                        }
                                        int n5 = ioffset;
                                        this.symband.a[n5] = this.symband.a[n5] + this.conductancei[i][j][k] * this.overcpdxdydz[i][j][k];
                                    }
                                }
                                this.adiag += this.conductancei[i][j][k];
                            } else {
                                dd = this.applyBCside(dd, i, j, k, 2, ioffset0);
                            }
                            if (ok[4]) {
                                n2 = this.getIndex(i, j + 1, k);
                                double tyf = 0.0;
                                if (n2 >= n) {
                                    tyf = this.x[n2];
                                    if (iprepmode == 0) {
                                        ++this.symband.nfill;
                                    }
                                    if (iprepmode == 1) {
                                        this.symband.ix[++ioffset] = n2;
                                    }
                                }
                                dd += this.conductancej[i][j][k] * (tyf - t);
                                if (iprepmode == 1) {
                                    int n6 = ioffset0;
                                    this.symband.a[n6] = this.symband.a[n6] + -this.conductancej[i][j][k] * this.overcpdxdydz[i][j][k];
                                    if (n2 >= n) {
                                        int n7 = ioffset;
                                        this.symband.a[n7] = this.symband.a[n7] + this.conductancej[i][j][k] * this.overcpdxdydz[i][j][k];
                                    }
                                }
                                this.adiag += this.conductancej[i][j][k];
                            } else {
                                dd = this.applyBCside(dd, i, j, k, 4, ioffset0);
                            }
                            if (ok[1]) {
                                n2 = this.getIndex(i - 1, j, k);
                                double txb = 0.0;
                                if (n2 >= n) {
                                    txb = this.x[n2];
                                    if (iprepmode == 0) {
                                        ++this.symband.nfill;
                                    }
                                    if (iprepmode == 1) {
                                        this.symband.ix[++ioffset] = n2;
                                    }
                                }
                                dd += this.conductancei[i - 1][j][k] * (txb - t);
                                if (iprepmode == 1) {
                                    int n8 = ioffset0;
                                    this.symband.a[n8] = this.symband.a[n8] + -this.conductancei[i - 1][j][k] * this.overcpdxdydz[i][j][k];
                                    if (n2 >= n) {
                                        int n9 = ioffset;
                                        this.symband.a[n9] = this.symband.a[n9] + this.conductancei[i - 1][j][k] * this.overcpdxdydz[i][j][k];
                                    }
                                }
                                this.adiag += this.conductancei[i - 1][j][k];
                            } else {
                                dd = this.applyBCside(dd, i, j, k, 1, ioffset0);
                            }
                            if (ok[3]) {
                                n2 = this.getIndex(i, j - 1, k);
                                double tyb = 0.0;
                                if (n2 >= n) {
                                    tyb = this.x[n2];
                                    if (iprepmode == 0) {
                                        ++this.symband.nfill;
                                    }
                                    if (iprepmode == 1) {
                                        this.symband.ix[++ioffset] = n2;
                                    }
                                }
                                dd += this.conductancej[i][j - 1][k] * (tyb - t);
                                if (iprepmode == 1) {
                                    int n10 = ioffset0;
                                    this.symband.a[n10] = this.symband.a[n10] + -this.conductancej[i][j - 1][k] * this.overcpdxdydz[i][j][k];
                                    if (n2 >= n) {
                                        int n11 = ioffset;
                                        this.symband.a[n11] = this.symband.a[n11] + this.conductancej[i][j - 1][k] * this.overcpdxdydz[i][j][k];
                                    }
                                }
                                this.adiag += this.conductancej[i][j - 1][k];
                            } else {
                                dd = this.applyBCside(dd, i, j, k, 3, ioffset0);
                            }
                            boolean okKMIN = k > 0;
                            boolean bl = okKPLUS = k < this.NZ - 1;
                            if (okKPLUS) {
                                n2 = this.getIndex(i, j, k + 1);
                                double tzf = 0.0;
                                if (n2 >= n) {
                                    tzf = this.x[n2];
                                    if (iprepmode == 0) {
                                        ++this.symband.nfill;
                                    }
                                    if (iprepmode == 1) {
                                        this.symband.ix[++ioffset] = n2;
                                    }
                                }
                                dd += this.conductancek[i][j][k] * (tzf - t);
                                if (iprepmode == 1) {
                                    int n12 = ioffset0;
                                    this.symband.a[n12] = this.symband.a[n12] + -this.conductancek[i][j][k] * this.overcpdxdydz[i][j][k];
                                    if (n2 >= n) {
                                        int n13 = ioffset;
                                        this.symband.a[n13] = this.symband.a[n13] + this.conductancek[i][j][k] * this.overcpdxdydz[i][j][k];
                                    }
                                }
                                this.adiag += this.conductancek[i][j][k];
                            } else {
                                dd = this.applyBCside(dd, i, j, k, 6, ioffset0);
                            }
                            if (okKMIN) {
                                n2 = this.getIndex(i, j, k - 1);
                                double tzb = 0.0;
                                if (n2 >= n) {
                                    tzb = this.x[n2];
                                    if (iprepmode == 0) {
                                        ++this.symband.nfill;
                                    }
                                    if (iprepmode == 1) {
                                        this.symband.ix[++ioffset] = n2;
                                    }
                                }
                                dd += this.conductancek[i][j][k - 1] * (tzb - t);
                                if (iprepmode == 1) {
                                    int n14 = ioffset0;
                                    this.symband.a[n14] = this.symband.a[n14] + -this.conductancek[i][j][k - 1] * this.overcpdxdydz[i][j][k];
                                    if (n2 >= n) {
                                        int n15 = ioffset;
                                        this.symband.a[n15] = this.symband.a[n15] + this.conductancek[i][j][k - 1] * this.overcpdxdydz[i][j][k];
                                    }
                                }
                                this.adiag += this.conductancek[i][j][k - 1];
                            } else {
                                dd = this.applyBCside(dd, i, j, k, 5, ioffset0);
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (iprepmode == 0) {
            System.out.println(" surplue diagonal entry at " + idiagcount);
            this.symband.idiag[idiagcount] = this.symband.nfill;
        }
    }

    protected double applyBCside(double dd, int i, int j, int k, int BCSIDE, int ioffset) {
        double mult = 1.0;
        if (this.infinite[BCSIDE]) {
            if (this.infinite[BCSIDE]) {
                mult = 1.0 / this.lmult[BCSIDE];
            }
            if (BCSIDE == 5 || BCSIDE == 6) {
                if (ioffset > -1) {
                    int n = ioffset;
                    this.symband.a[n] = this.symband.a[n] + -this.conductancek[i][j][k] * mult * this.overcpdxdydz[i][j][k];
                }
                this.adiag += this.conductancek[i][j][k] * mult;
            }
            if (BCSIDE == 1 || BCSIDE == 2) {
                if (ioffset > -1) {
                    int n = ioffset;
                    this.symband.a[n] = this.symband.a[n] + -this.conductancei[i][j][k] * mult * this.overcpdxdydz[i][j][k];
                }
                this.adiag += this.conductancei[i][j][k] * mult;
            }
            if (BCSIDE == 3 || BCSIDE == 4) {
                if (ioffset > -1) {
                    int n = ioffset;
                    this.symband.a[n] = this.symband.a[n] + -this.conductancej[i][j][k] * mult * this.overcpdxdydz[i][j][k];
                }
                this.adiag += this.conductancej[i][j][k] * mult;
            }
        }
        return dd;
    }

    protected double getDefaultPotential(int BCSIDE, int i, int j, int k) {
        return this.potentialval[BCSIDE];
    }

    public SmartGrid getGridValues(boolean[][] active, double[][] values) {
        SmartGrid grid = new SmartGrid();
        float unknown = -999.25f;
        grid.values = new float[this.NX][this.NY];
        grid.originx = (float)this.originx;
        grid.originy = (float)this.originy;
        grid.dx = (float)this.dx;
        grid.dy = (float)this.dy;
        grid.nx = this.NX;
        grid.ny = this.NY;
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                grid.values[i][j] = active[i][j] ? (float)values[i][j] : unknown;
                ++j;
            }
            ++i;
        }
        grid.m_Grid.originx = grid.originx;
        grid.m_Grid.originy = grid.originy;
        grid.m_Grid.dx = grid.dx;
        grid.m_Grid.dy = grid.dy;
        grid.m_Grid.nx = grid.nx;
        grid.m_Grid.ny = grid.ny;
        grid.m_Grid.values = grid.values;
        grid.m_Grid.unknown = -999.25f;
        return grid;
    }

    public void output(boolean[][] active, double[][] values, String fname, int format) {
        String ffname = fname;
        SmartGrid grid = this.getGridValues(active, values);
        grid.m_Grid.setFileName(String.valueOf(ffname) + GRIDEXTENSION[format]);
        grid.m_Grid.setDataFormat(GRIDDATAFORMAT[format]);
        try {
            grid.m_Grid.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Voxet outputAsVoxet(Voxet mask, boolean init, String filename, String propname) {
        double[][] values = null;
        Voxet v = new Voxet(mask, filename, propname);
        int k = 0;
        while (k < this.NZ) {
            values = this.getValues(k, init);
            int i = 0;
            while (i < this.NX) {
                int j = 0;
                while (j < this.NY) {
                    if (this.active[i][j]) {
                        v.getValues()[k][j][i] = (float)values[i][j];
                    }
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        return v;
    }

    public void outputAsGrids(Voxet kk, boolean init) {
        String fbase = new File(kk.getFileName()).getParent();
        String stage = "init";
        if (!init) {
            stage = "run";
        }
        Voxet vtemp = null;
        vtemp = init ? new Voxet(kk, String.valueOf(fbase) + "/temp_init", "initial_temperature") : new Voxet(kk, String.valueOf(fbase) + "/temp_result", "calculated_temperature");
        vtemp.setNz(this.NZ);
        vtemp.setUnknown(-999.25f);
        double zz = 0.0;
        int k = 0;
        while (k < this.NZ) {
            double[][] values = this.getValues(k, init);
            int i = 0;
            while (i < this.NX) {
                int j = 0;
                while (j < this.NY) {
                    vtemp.getValues()[k][j][i] = (float)values[i][j];
                    ++j;
                }
                ++i;
            }
            this.output(this.active, values, String.valueOf(fbase) + "/potential_" + stage + "_" + (int)(zz += this.h[0][0][k]), 1);
            ++k;
        }
        vtemp.getMinMax();
        VoxetWriter.write(vtemp);
    }

    public double[][] getValues(int k, boolean init) {
        double[][] v = new double[this.NX][this.NY];
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int n = this.getIndex(i, j, k);
                v[i][j] = n > -1 ? (init ? this.x0[n] : this.x[n]) : (this.bccodes[i][j][k] == 1 ? this.bcval[i][j][k] : -999.25);
                ++j;
            }
            ++i;
        }
        return v;
    }

    public double getValues(boolean init, int i, int j, int k) {
        int n = this.getIndex(i, j, k);
        if (n > -1) {
            if (init) {
                return this.x0[n];
            }
            return this.x[n];
        }
        return -999.25;
    }

    public boolean defined(int i, int j, int k) {
        return this.getIndex(i, j, k) > -1;
    }

    public double[][][] getValues(boolean init, double[][][] v) {
        if (v == null || v.length != this.NX || v[0].length != this.NY || v[0][0].length != this.NZ) {
            v = new double[this.NX][this.NY][this.NZ];
        }
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    int n = this.getIndex(i, j, k);
                    v[i][j][k] = n > -1 ? (init ? this.x0[n] : this.x[n]) : (this.bccodes[i][j][k] == 1 ? this.bcval[i][j][k] : -999.25);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return v;
    }

    @Override
    public void setupstartvalue() {
        int n;
        int k;
        int j;
        this.x0 = new double[this.nx];
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    n = this.getIndex(i, j, k);
                    if (n > -1) {
                        this.x0[n] = this.getDefaultvalue();
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    boolean[] ok = this.okconnect[i][j];
                    if (ok[0]) {
                        if (this.infinite[5] && k == 0 && (n = this.getIndex(i, j, k)) > -1) {
                            this.x0[n] = this.potentialval[5];
                        }
                        if (this.infinite[6] && k == this.NZ - 1 && (n = this.getIndex(i, j, k)) > -1) {
                            this.x0[n] = this.potentialval[6];
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void setupstartvalue(double[][] v) {
        this.setupstartvalue();
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    int n = this.getIndex(i, j, k);
                    if (n > -1) {
                        this.x0[n] = v[i][j];
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void setupstartvalue(double[][][] v) {
        this.setupstartvalue();
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    int n = this.getIndex(i, j, k);
                    if (n > -1) {
                        this.x0[n] = v[i][j][k];
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    public void initBCPressure(ModelBCContainer bcContainer) {
        int i = 0;
        while (i < bcContainer.size()) {
            ModelBC bc = bcContainer.getModelBoundaryCondition(i);
            int ii = bc.getIlow();
            int jj = bc.getJlow();
            int kk = bc.getKlow();
            if (bc.getType() == 7) {
                this.bccodes[ii][jj][kk] = 2;
                this.bcval[ii][jj][kk] = bc.getValue() * this.h[ii][jj][kk] * this.dx * this.dy;
                System.out.println("( " + ii + "," + jj + "," + kk + "  SOURCE " + bc.getValue());
            } else if (bc.getType() == 8) {
                this.bccodes[ii][jj][kk] = 3;
                this.bcval[ii][jj][kk] = bc.getValue();
                this.CWC[ii][jj][kk] = bc.getCwc();
                System.out.println("( " + ii + "," + jj + "," + kk + "  CWC " + this.CWC[ii][jj][kk]);
            }
            ++i;
        }
    }

    private void initBCPressure() {
        double source = 10000.0;
        int k = 1;
        while (k < this.NZ - 1) {
            this.bccodes[30][30][k] = 2;
            this.bcval[30][30][k] = -source;
            this.bccodes[30][50][k] = 2;
            this.bcval[30][50][k] = 2.0 * source;
            ++k;
        }
    }

    private void initBCTemperature() {
        int k = this.NZ - 5;
        double source = 80.0;
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                this.bccodes[i][j][k] = 1;
                this.bcval[i][j][k] = source;
                ++j;
            }
            ++i;
        }
    }

    public void initializeTemperatureFromGrid(Grid g, double depth, float def, boolean average) {
        int k = (int)(depth / this.h[0][0][0]);
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                float x = (float)(this.originx + (double)i * this.dx);
                float y = (float)(this.originy + (double)j * this.dy);
                float v = 0.0f;
                v = !average ? g.getValueAtxy(x, y) : g.getValueAtxy(x, y);
                if (!g.defined(v)) {
                    v = def;
                }
                if (g.defined(v)) {
                    this.bccodes[i][j][k] = 1;
                    this.bcval[i][j][k] = v;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void mainLITHGrids(String dir, String vkname, float tSURF, String[] inputtempgrids, double[] tempdepths, String surfacehf) {
        Voxet kx;
        PCG3DBand g = new PCG3DBand();
        Grid gsurfacehf = new Grid(String.valueOf(dir) + surfacehf);
        int ntempgrids = inputtempgrids.length;
        Grid[] tempgrids = new Grid[ntempgrids];
        int i = 0;
        while (i < ntempgrids) {
            tempgrids[i] = new Grid(String.valueOf(dir) + inputtempgrids[i]);
            ++i;
        }
        Voxet ky = kx = VoxetReader.read(String.valueOf(dir) + vkname);
        Voxet kz = kx;
        Object A = null;
        double rhocp = 2700000.0;
        double rhocpscale = 1.0;
        DIAGSCALE = 1.0;
        DIRICHMULT = 1.0;
        g.initGeometryProp(kx, ky, kz, null, rhocpscale, rhocp, 100);
        g.initializeValTemperatureLITH(200.0);
        g.setDefaultvalue(1.0);
        g.initializeDirichlet(null);
        System.out.println(" number of equations after setting dirichlet :" + g.nx);
        g.initializeDefaultValue();
        g.setDefaultvalue(0.0);
        g.setupstartvalue();
        g.outputAsGrids(kx, true);
        g.doPCG(1000, 1);
        System.out.println("ready");
        g.outputAsGrids(kx, false);
    }

    public static void mainLITH() {
        PCG3DBand g = new PCG3DBand();
        String dir = "C:/Users/Public/wees/data/papers/thermalmodel3D/pcgtest";
        Voxet kx = VoxetReader.read(String.valueOf(dir) + "/KH.vo");
        Voxet ky = VoxetReader.read(String.valueOf(dir) + "/KH.vo");
        Voxet kz = VoxetReader.read(String.valueOf(dir) + "/KV.vo");
        Voxet A = VoxetReader.read(String.valueOf(dir) + "/A.vo");
        InputXyzPropData bcd = new InputXyzPropData(String.valueOf(dir) + "/wellnewDBnew3_ZED01_AAPGcorrectedV2.txt");
        double rhocp = 2700000.0;
        double rhocpscale = 1.0;
        DIAGSCALE = 1.0;
        DIRICHMULT = 1.0;
        g.initGeometryProp(kx, ky, kz, A, rhocpscale, rhocp, 30);
        g.initializeValTemperatureBCDNEW();
        g.setDefaultvalue(1.0);
        g.initializeDirichlet(bcd);
        System.out.println(" number of equations after setting dirichlet :" + g.nx);
        g.initializeDefaultValue();
        g.setDefaultvalue(0.0);
        g.setupstartvalue();
        g.outputAsGrids(kx, true);
        g.doPCGrestart(10000, 1, true, true, true);
        System.out.println("ready");
        g.doPCGrestart(10000, 1, false, false, false);
        g.outputAsGrids(kx, false);
    }

    public static void mainBCD() {
        PCG3DBand g = new PCG3DBand();
        String dir = "C:/Users/Public/wees/data/papers/thermalmodel3D/pcgtest/Residual";
        Voxet kx = VoxetReader.read(String.valueOf(dir) + "/KH.vo");
        Voxet ky = VoxetReader.read(String.valueOf(dir) + "/KH.vo");
        Voxet kz = VoxetReader.read(String.valueOf(dir) + "/KV.vo");
        Object A = null;
        InputXyzPropData bcd = new InputXyzPropData(String.valueOf(dir) + "/residuals_bcd.txt");
        double rhocp = 2700000.0;
        double rhocpscale = 1.0;
        DIAGSCALE = 1.0;
        DIRICHMULT = 1.0;
        g.initGeometryProp(kx, ky, kz, null, rhocpscale, rhocp, 30);
        g.initializeValTemperatureBCD();
        g.setDefaultvalue(1.0);
        g.initializeDirichlet(bcd);
        System.out.println(" number of equations after setting dirichlet :" + g.nx);
        g.initializeDefaultValue();
        g.setDefaultvalue(0.0);
        g.setupstartvalue();
        g.outputAsGrids(kx, true);
        g.doPCG(1000, 1);
        System.out.println("ready");
        g.outputAsGrids(kx, false);
    }

    public static void mainPRES() {
        PCG3DBand g = new PCG3DBand();
        String dir = "C:/Users/Public/wees/data/papers/thermalmodel3D/pcgtest";
        Voxet kx = VoxetReader.read(String.valueOf(dir) + "/KH.vo");
        Voxet ky = VoxetReader.read(String.valueOf(dir) + "/KH.vo");
        Voxet kz = VoxetReader.read(String.valueOf(dir) + "/KV.vo");
        Object A = null;
        InputXyzPropData bcd = new InputXyzPropData(String.valueOf(dir) + "/residuals_bcd.txt");
        double rhocp = 2700000.0;
        double rhocpscale = 1.0;
        DIAGSCALE = 1.0;
        DIRICHMULT = 1.0;
        g.initGeometryProp(kx, ky, kz, null, rhocpscale, rhocp, 30);
        g.initializeValPressure(100.0);
        g.setDefaultvalue(1.0);
        g.initBCPressure();
        g.initializeDirichlet(null);
        System.out.println(" number of equations after setting dirichlet :" + g.nx);
        g.initializeDefaultValue();
        g.setDefaultvalue(0.0);
        g.setupstartvalue();
        g.outputAsGrids(kx, true);
        g.doPCG(1000, 1);
        System.out.println("ready");
        g.outputAsGrids(kx, false);
    }

    public static void main(String[] args) {
        PCG3DBand.mainLITH();
    }

    public void extendBCCondition(int ii, int jj, int k, int LOD) {
        int bc = this.bccodes[ii][jj][k];
        double v = this.bcval[ii][jj][k];
        int n = 0;
        int i = ii - LOD;
        while (i < ii + LOD) {
            int j = jj - LOD;
            while (j < jj + LOD) {
                int jr;
                int ir = Math.min(Math.max(0, i), this.NX - 1);
                n = this.getIndex(ir, jr = Math.min(Math.max(0, j), this.NY - 1), k);
                if (n > -1) {
                    this.bccodes[ir][jr][k] = bc;
                    this.bcval[ir][jr][k] = v;
                }
                ++j;
            }
            ++i;
        }
    }

    public double getValueXyz(double x, double y, double zref, boolean init) {
        double val = 0.0;
        double kres = 0.0;
        double ires = 0.0;
        double jres = 0.0;
        int k = (int)Math.floor((x - this.originx) / this.dx);
        kres = (x - this.originx - (double)k * this.dx) / this.dx;
        int k2 = k + 1;
        k = Math.min(Math.max(0, k), this.NX - 1);
        k2 = Math.min(Math.max(0, k2), this.NX - 1);
        int j = (int)Math.floor((y - this.originy) / this.dy);
        jres = (y - this.originy - (double)j * this.dy) / this.dy;
        int j2 = j + 1;
        j = Math.min(Math.max(0, j), this.NY - 1);
        j2 = Math.min(Math.max(0, j2), this.NY - 1);
        double z = zref - this.topdepth[k][j];
        if (z < 0.0) {
            return -999.25;
        }
        double hr = z;
        int i = 0;
        int i2 = 0;
        while (hr > this.h[k][j][i] && i < this.NZ - 1) {
            i2 = i + 1;
            i2 = Math.min(Math.max(0, i2), this.NZ - 1);
            hr -= 0.5 * (this.h[k][j][i] + this.h[k][j][i2]);
            ++i;
        }
        if (hr > this.h[k][j][i]) {
            return -999.25;
        }
        ires = hr / (0.5 * (this.h[k][j][i] + this.h[k][j][i2]));
        val = !this.defined(k, j, i) || !this.defined(k2, j, i) || !this.defined(k, j, i2) || !this.defined(k2, j, i2) || !this.defined(k, j2, i) || !this.defined(k2, j2, i) || !this.defined(k2, j2, i) || !this.defined(k2, j2, i2) ? -999.25 : (1.0 - ires) * (1.0 - jres) * (1.0 - kres) * values[i][j][k] + (1.0 - ires) * (1.0 - jres) * kres * values[i][j][k2] + ires * (1.0 - jres) * (1.0 - kres) * values[i2][j][k] + ires * (1.0 - jres) * kres * values[i2][j][k2] + (1.0 - ires) * jres * (1.0 - kres) * values[i][j2][k] + (1.0 - ires) * jres * kres * values[i][j2][k2] + ires * jres * (1.0 - kres) * values[i2][j2][k] + ires * jres * kres * values[i2][j2][k2];
        return val;
    }
}

