/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.pcg;

import tno.geoenergy.data.InputXyzPropData;
import tno.geoenergy.pcg.PCG3DBand;

public class PCG3DBandEclipse
extends PCG3DBand {
    boolean[][][] okconnectcells = null;
    double[][][] connectxmin = null;
    double[][][] connectxplus = null;
    double[][][] connectymin = null;
    double[][][] connectyplus = null;
    double[][][] connectzmin = null;
    double[][][] connectzplus = null;
    double[][][] actnumflow = null;
    double[][][] connectxmin_temp = null;
    double[][][] connectxplus_temp = null;
    double[][][] connectymin_temp = null;
    double[][][] connectyplus_temp = null;
    double[][][] connectzmin_temp = null;
    double[][][] connectzplus_temp = null;
    double[][][] actnumtemp = null;

    private void initializeArrays() {
        boolean okallocate;
        boolean bl = okallocate = this.h == null || this.h.length < this.NX || this.h[0].length < this.NY || this.h[0][0].length < this.NZ;
        if (okallocate) {
            this.topdepth = new double[this.NX][this.NY];
            this.h = new double[this.NX][this.NY][this.NZ];
            this.z = new double[this.NX][this.NY][this.NZ];
            this.indexYstart = new int[this.NX][this.NY];
            this.conductancei = new double[this.NX][this.NY][this.NZ];
            this.conductancej = new double[this.NX][this.NY][this.NZ];
            this.conductancek = new double[this.NX][this.NY][this.NZ];
            this.overcpdxdydz = new double[this.NX][this.NY][this.NZ];
            this.density = new double[this.NX][this.NY][this.NZ];
            this.densitypseudosourcei = new double[this.NX][this.NY][this.NZ];
            this.densitypseudosourcej = new double[this.NX][this.NY][this.NZ];
            this.densitypseudosourcek = new double[this.NX][this.NY][this.NZ];
            this.rightHandSide = new double[this.NX][this.NY][this.NZ];
            this.connectxmin = new double[this.NX][this.NY][this.NZ];
            this.connectxplus = new double[this.NX][this.NY][this.NZ];
            this.connectymin = new double[this.NX][this.NY][this.NZ];
            this.connectyplus = new double[this.NX][this.NY][this.NZ];
            this.connectzmin = new double[this.NX][this.NY][this.NZ];
            this.connectzplus = new double[this.NX][this.NY][this.NZ];
            this.actnumflow = new double[this.NX][this.NY][this.NZ];
            this.connectxplus_temp = new double[this.NX][this.NY][this.NZ];
            this.connectymin_temp = new double[this.NX][this.NY][this.NZ];
            this.connectyplus_temp = new double[this.NX][this.NY][this.NZ];
            this.connectzmin_temp = new double[this.NX][this.NY][this.NZ];
            this.connectzplus_temp = new double[this.NX][this.NY][this.NZ];
            this.actnumtemp = new double[this.NX][this.NY][this.NZ];
            this.bccodes = new int[this.NX][this.NY][this.NZ];
            this.bcval = new double[this.NX][this.NY][this.NZ];
            this.CWC = new double[this.NX][this.NY][this.NZ];
            this.heatprodA = new double[this.NX][this.NY][this.NZ];
            this.okconnect = new boolean[this.NX][this.NY][5];
            this.okconnectcells = new boolean[this.NX][this.NY][7];
            this.index = new int[this.NX][this.NY][this.NZ];
            this.actnum = new int[this.NX][this.NY][this.NZ];
        }
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    this.actnum[i][j][k] = 1;
                    this.topdepth[i][j] = 0.0;
                    this.h[i][j][k] = 0.0;
                    this.z[i][j][k] = 0.0;
                    this.indexYstart[i][j] = 0;
                    this.conductancei[i][j][k] = 0.0;
                    this.conductancej[i][j][k] = 0.0;
                    this.conductancek[i][j][k] = 0.0;
                    this.density[i][j][k] = 0.0;
                    this.bccodes[i][j][k] = 0;
                    this.bcval[i][j][k] = 0.0;
                    this.index[i][j][k] = 0;
                    this.CWC[i][j][k] = 0.0;
                    this.heatprodA[i][j][k] = 0.0;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void initializeConnectivityMatrices(double[][][] connectxminVal, double[][][] connectxplusVal, double[][][] connectyminVal, double[][][] connectyplusVal, double[][][] connectzminVal, double[][][] connectzplusVal, double[][][] actnumflowVal, double[][][] connectxminTempVal, double[][][] connectxplusTempVal, double[][][] connectyminTempVal, double[][][] connectyplusTempVal, double[][][] connectzminTempVal, double[][][] connectzplusTempVal, double[][][] actnumtempVal) {
        this.connectxmin = connectxminVal;
        this.connectxplus = connectxplusVal;
        this.connectymin = connectyminVal;
        this.connectyplus = connectyplusVal;
        this.connectzmin = connectzminVal;
        this.connectzplus = connectzplusVal;
        this.actnumflow = actnumflowVal;
        this.connectxmin_temp = connectxminTempVal;
        this.connectxplus_temp = connectxplusTempVal;
        this.connectymin_temp = connectyminTempVal;
        this.connectyplus_temp = connectyplusTempVal;
        this.connectzmin_temp = connectzminTempVal;
        this.connectzplus_temp = connectzplusTempVal;
        this.actnumtemp = actnumtempVal;
    }

    public void initGeometryProp(int nx, int ny, int nz, double dx, double dy, double orx, double ory, double[][][] iconductancei, double[][][] iconductancej, double[][][] iconductancek, double unknown, double refDensityVal, double[][] itopdepth, double[][][] ih, double[][][] iactnum, double[][][] overrhocp, double[][][] densityVal, double[][][] densityPseudoSourcei, double[][][] densityPseudoSourcej, double[][][] densityPseudoSourcek, double[][][] rhsforoutput, double[][][] connectxminVal, double[][][] connectxplusVal, double[][][] connectyminVal, double[][][] connectyplusVal, double[][][] connectzminVal, double[][][] connectzplusVal, double[][][] actnumflowVal, double[][][] connectxminTempVal, double[][][] connectxplusTempVal, double[][][] connectyminTempVal, double[][][] connectyplusTempVal, double[][][] connectzminTempVal, double[][][] connectzplusTempVal, double[][][] actnumtempVal) {
        int k;
        int j;
        this.rhocpscale = 1.0;
        this.NX = nx;
        this.NY = ny;
        this.NZ = nz;
        this.originx = orx;
        this.originy = ory;
        this.originz = 0.0;
        this.dx = dx;
        this.dy = dy;
        this.initializeArrays();
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                this.topdepth[i][j] = this.originz + itopdepth[i][j];
                k = 0;
                while (k < this.NZ) {
                    this.h[i][j][k] = ih[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.generateZarray();
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    this.actnum[i][j][k] = (int)iactnum[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        nx = this.initializeOrigIndex(itopdepth, unknown);
        this.initializeConnectivityMatrices(connectxminVal, connectxplusVal, connectyminVal, connectyplusVal, connectzminVal, connectzplusVal, actnumflowVal, connectxminTempVal, connectxplusTempVal, connectyminTempVal, connectyplusTempVal, connectzminTempVal, connectzplusTempVal, actnumtempVal);
        this.initializeOK(this.okconnectcells);
        this.initializeOvercpdxdydzConstant(1.0);
        this.initializeConductance(iconductancei, iconductancej, iconductancek);
        this.initializeDensity(densityVal);
        this.initializeDensityPseudoSource(densityPseudoSourcei, densityPseudoSourcej, densityPseudoSourcek);
        this.initializeRefDensity(refDensityVal);
        this.initializeRhsForOutput(rhsforoutput);
    }

    private void getOK(boolean[] ok, int i, int j, int k) {
        int n = this.getOrigIndex(i, j, k);
        boolean bl = ok[0] = n >= 0 && this.actnumflow[i][j][k] > 0.0;
        if (ok[0]) {
            boolean active_cell;
            if (i == 0) {
                n = -100000000;
                active_cell = false;
            } else {
                int xmin = (int)this.connectxmin[i][j][k];
                boolean bl2 = active_cell = xmin >= 0;
                if (active_cell) {
                    n = this.getOrigIndex(xmin, j, k);
                }
            }
            boolean bl3 = ok[1] = n > -1 && active_cell;
            if (i == this.NX - 1) {
                n = -100000000;
                active_cell = false;
            } else {
                int xplus = (int)this.connectxplus[i][j][k];
                boolean bl4 = active_cell = xplus > 0;
                if (active_cell) {
                    n = this.getOrigIndex(xplus, j, k);
                }
            }
            boolean bl5 = ok[2] = n > 0 && active_cell;
            if (j == 0) {
                n = -100000000;
                active_cell = false;
            } else {
                int ymin = (int)this.connectymin[i][j][k];
                boolean bl6 = active_cell = ymin >= 0;
                if (active_cell) {
                    n = this.getOrigIndex(i, ymin, k);
                }
            }
            boolean bl7 = ok[3] = n > -1 && active_cell;
            if (j == this.NY - 1) {
                n = -100000000;
                active_cell = false;
            } else {
                int yplus = (int)this.connectyplus[i][j][k];
                boolean bl8 = active_cell = yplus > 0;
                if (active_cell) {
                    n = this.getOrigIndex(i, yplus, k);
                }
            }
            boolean bl9 = ok[4] = n > -1 && active_cell;
            if (k == 0) {
                n = -100000000;
                active_cell = false;
            } else {
                int zmin = (int)this.connectzmin[i][j][k];
                boolean bl10 = active_cell = zmin >= 0;
                if (active_cell) {
                    n = this.getOrigIndex(i, j, zmin);
                }
            }
            boolean bl11 = ok[5] = n > -1 && active_cell;
            if (j == this.NY - 1) {
                n = -100000000;
                active_cell = false;
            } else {
                int zplus = (int)this.connectzplus[i][j][k];
                boolean bl12 = active_cell = zplus > 0;
                if (active_cell) {
                    n = this.getOrigIndex(i, j, zplus);
                }
            }
            ok[6] = n > -1 && active_cell;
        }
    }

    @Override
    public void APrepare(int iprepmode) {
        int i;
        boolean[] ok = null;
        int idiagcount = 0;
        int ioffset = -1;
        int ioffset0 = -1;
        int icount_i = -1;
        int nold = -1;
        if (iprepmode == 0) {
            this.symband.nfill = 0;
        }
        if (iprepmode == 1) {
            i = 0;
            while (i < this.symband.nfill) {
                this.symband.a[i] = 0.0;
                ++i;
            }
        }
        i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    int n;
                    this.getOK(this.okconnectcells[i][j], i, j, k);
                    ok = this.okconnectcells[i][j];
                    if (ok[0] && (n = this.getIndex(i, j, k)) >= 0 && this.actnumflow[i][j][k] > 0.0) {
                        int n2;
                        double t = this.x[n];
                        if (iprepmode == 0) {
                            if (n != nold + 1) {
                                System.out.println(" ordering of valid nodes not increasing from 0.. nnodes: node n" + n + "  nold " + nold);
                            }
                            nold = n;
                            ++this.symband.nfill;
                            this.symband.idiag[idiagcount] = this.symband.nfill - 1;
                            ++idiagcount;
                        }
                        if (iprepmode == 1) {
                            if ((ioffset = this.symband.idiag[++icount_i]) == 104) {
                                boolean bl = true;
                            }
                            ioffset0 = ioffset;
                            this.symband.ix[ioffset] = n;
                            if (this.bccodes[i][j][k] == 3) {
                                double cwc = this.CWC[i][j][k];
                                int n3 = ioffset0;
                                this.symband.a[n3] = this.symband.a[n3] + -cwc * this.overcpdxdydz[i][j][k];
                            }
                        }
                        double dd = 0.0;
                        this.adiag = 0.0;
                        int xplus = (int)this.connectxplus[i][j][k];
                        if (xplus > 0) {
                            n2 = this.getIndex(xplus, j, k);
                            double txf = 0.0;
                            if (n2 >= n) {
                                txf = this.x[n2];
                                if (iprepmode == 0) {
                                    ++this.symband.nfill;
                                }
                                if (iprepmode == 1) {
                                    this.symband.ix[++ioffset] = n2;
                                }
                            }
                            dd += this.conductancei[i][j][k] * (txf - t);
                            if (iprepmode == 1) {
                                double cc = this.conductancei[i][j][k];
                                double oo = this.overcpdxdydz[i][j][k];
                                int n4 = ioffset0;
                                this.symband.a[n4] = this.symband.a[n4] + -this.conductancei[i][j][k] * this.overcpdxdydz[i][j][k];
                                if (n2 >= n) {
                                    if (ioffset == 1) {
                                        System.out.println(" a[1] " + this.conductancei[i][j][k] * this.overcpdxdydz[i][j][k]);
                                    }
                                    int n5 = ioffset;
                                    this.symband.a[n5] = this.symband.a[n5] + this.conductancei[i][j][k] * this.overcpdxdydz[i][j][k];
                                }
                            }
                            this.adiag += this.conductancei[i][j][k];
                        } else {
                            dd = this.applyBCside(dd, i, j, k, 2, ioffset0);
                        }
                        int yplus = (int)this.connectyplus[i][j][k];
                        if (yplus > 0) {
                            n2 = this.getIndex(i, yplus, k);
                            double tyf = 0.0;
                            if (n2 >= n) {
                                tyf = this.x[n2];
                                if (iprepmode == 0) {
                                    ++this.symband.nfill;
                                }
                                if (iprepmode == 1) {
                                    this.symband.ix[++ioffset] = n2;
                                }
                            }
                            dd += this.conductancej[i][j][k] * (tyf - t);
                            if (iprepmode == 1) {
                                int n6 = ioffset0;
                                this.symband.a[n6] = this.symband.a[n6] + -this.conductancej[i][j][k] * this.overcpdxdydz[i][j][k];
                                if (n2 >= n) {
                                    int n7 = ioffset;
                                    this.symband.a[n7] = this.symband.a[n7] + this.conductancej[i][j][k] * this.overcpdxdydz[i][j][k];
                                }
                            }
                            this.adiag += this.conductancej[i][j][k];
                        } else {
                            dd = this.applyBCside(dd, i, j, k, 4, ioffset0);
                        }
                        int xmin = (int)this.connectxmin[i][j][k];
                        if (xmin >= 0) {
                            n2 = this.getIndex(xmin, j, k);
                            double txb = 0.0;
                            if (n2 >= n) {
                                txb = this.x[n2];
                                if (iprepmode == 0) {
                                    ++this.symband.nfill;
                                }
                                if (iprepmode == 1) {
                                    this.symband.ix[++ioffset] = n2;
                                }
                            }
                            dd += this.conductancei[xmin][j][k] * (txb - t);
                            if (iprepmode == 1) {
                                int n8 = ioffset0;
                                this.symband.a[n8] = this.symband.a[n8] + -this.conductancei[xmin][j][k] * this.overcpdxdydz[i][j][k];
                                if (n2 >= n) {
                                    int n9 = ioffset;
                                    this.symband.a[n9] = this.symband.a[n9] + this.conductancei[xmin][j][k] * this.overcpdxdydz[i][j][k];
                                }
                            }
                            this.adiag += this.conductancei[xmin][j][k];
                        } else {
                            dd = this.applyBCside(dd, i, j, k, 1, ioffset0);
                        }
                        int ymin = (int)this.connectymin[i][j][k];
                        if (ymin >= 0) {
                            n2 = this.getIndex(i, ymin, k);
                            double tyb = 0.0;
                            if (n2 >= n) {
                                tyb = this.x[n2];
                                if (iprepmode == 0) {
                                    ++this.symband.nfill;
                                }
                                if (iprepmode == 1) {
                                    this.symband.ix[++ioffset] = n2;
                                }
                            }
                            dd += this.conductancej[i][ymin][k] * (tyb - t);
                            if (iprepmode == 1) {
                                int n10 = ioffset0;
                                this.symband.a[n10] = this.symband.a[n10] + -this.conductancej[i][ymin][k] * this.overcpdxdydz[i][j][k];
                                if (n2 >= n) {
                                    int n11 = ioffset;
                                    this.symband.a[n11] = this.symband.a[n11] + this.conductancej[i][ymin][k] * this.overcpdxdydz[i][j][k];
                                }
                            }
                            this.adiag += this.conductancej[i][ymin][k];
                        } else {
                            dd = this.applyBCside(dd, i, j, k, 3, ioffset0);
                        }
                        int zplus = (int)this.connectzplus[i][j][k];
                        if (zplus > 0) {
                            n2 = this.getIndex(i, j, zplus);
                            double tzf = 0.0;
                            if (n2 >= n) {
                                tzf = this.x[n2];
                                if (iprepmode == 0) {
                                    ++this.symband.nfill;
                                }
                                if (iprepmode == 1) {
                                    this.symband.ix[++ioffset] = n2;
                                }
                            }
                            dd += this.conductancek[i][j][k] * (tzf - t);
                            if (iprepmode == 1) {
                                int n12 = ioffset0;
                                this.symband.a[n12] = this.symband.a[n12] + -this.conductancek[i][j][k] * this.overcpdxdydz[i][j][k];
                                if (n2 >= n) {
                                    int n13 = ioffset;
                                    this.symband.a[n13] = this.symband.a[n13] + this.conductancek[i][j][k] * this.overcpdxdydz[i][j][k];
                                }
                            }
                            this.adiag += this.conductancek[i][j][k];
                        } else {
                            dd = this.applyBCside(dd, i, j, k, 6, ioffset0);
                        }
                        int zmin = (int)this.connectzmin[i][j][k];
                        if (zmin >= 0) {
                            n2 = this.getIndex(i, j, zmin);
                            double tzb = 0.0;
                            if (n2 >= n) {
                                tzb = this.x[n2];
                                if (iprepmode == 0) {
                                    ++this.symband.nfill;
                                }
                                if (iprepmode == 1) {
                                    this.symband.ix[++ioffset] = n2;
                                }
                            }
                            dd += this.conductancek[i][j][zmin] * (tzb - t);
                            if (iprepmode == 1) {
                                int n14 = ioffset0;
                                this.symband.a[n14] = this.symband.a[n14] + -this.conductancek[i][j][zmin] * this.overcpdxdydz[i][j][k];
                                if (n2 >= n) {
                                    int n15 = ioffset;
                                    this.symband.a[n15] = this.symband.a[n15] + this.conductancek[i][j][zmin] * this.overcpdxdydz[i][j][k];
                                }
                            }
                            this.adiag += this.conductancek[i][j][zmin];
                        } else {
                            dd = this.applyBCside(dd, i, j, k, 5, ioffset0);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (iprepmode == 0) {
            System.out.println(" surplue diagonal entry at " + idiagcount);
            this.symband.idiag[idiagcount] = this.symband.nfill;
        }
    }

    @Override
    void scaleOvercdxdydz(int[] idiag, double[] a, double[] b) {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    int n = this.getIndex(i, j, k);
                    if (n >= 0 && this.actnumflow[i][j][k] > 0.0) {
                        int in = idiag[n];
                        while (in < idiag[n + 1]) {
                            int n2 = in++;
                            a[n2] = a[n2] / 1.0;
                            int n3 = n;
                            b[n3] = b[n3] / 1.0;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private int initializeIndex() {
        int lastindex = 0;
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    this.index[i][j][k] = -1;
                    if (this.getOrigIndex(i, j, k) >= 0 && this.bccodes[i][j][k] != 1 && this.actnumflow[i][j][k] > 0.0) {
                        this.index[i][j][k] = lastindex++;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return lastindex;
    }

    @Override
    public void initializeDirichlet(InputXyzPropData bcd, boolean constantpres) {
        int k;
        int j;
        boolean fixedyet = false;
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    if (this.actnum[i][j][k] == 1 && (this.bccodes[i][j][k] == 1 || this.bccodes[i][j][k] == 3)) {
                        fixedyet = true;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        fixedyet = true;
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    this.getOK(this.okconnectcells[i][j], i, j, k);
                    boolean[] ok = this.okconnectcells[i][j];
                    if (ok[0]) {
                        int ik = 1;
                        while (ik < 5) {
                            if (!ok[ik]) {
                                if (!this.heatflow[ik] && !this.infinite[ik]) {
                                    if (this.bccodes[i][j][k] == 0) {
                                        this.bccodes[i][j][k] = 1;
                                        this.bcval[i][j][k] = this.potentialval[ik];
                                    }
                                } else if (this.heatflow[ik] && !constantpres && this.actnum[i][j][k] == 1 && !fixedyet) {
                                    int ii = 0;
                                    while (ii < this.NX) {
                                        int jj = 0;
                                        while (jj < this.NY) {
                                            this.bccodes[ii][jj][0] = 1;
                                            this.bcval[ii][jj][0] = 0.0;
                                            ++jj;
                                        }
                                        ++ii;
                                    }
                                    fixedyet = true;
                                }
                            }
                            ++ik;
                        }
                        ik = -1;
                        if (k == 0) {
                            ik = 5;
                        } else if (k == this.NZ - 1) {
                            ik = 6;
                        }
                        if (ik > 0 && !this.heatflow[ik] && !this.infinite[ik] && this.bccodes[i][j][k] == 0) {
                            this.bccodes[i][j][k] = 1;
                            this.bcval[i][j][k] = this.potentialval[ik];
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (bcd != null) {
            this.setBCfromdata(bcd);
        }
        this.nx = this.initializeIndex();
        System.out.println("number of equations " + this.nx);
    }

    @Override
    public void initializeOK(boolean[][][] ok) {
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    this.getOK(ok[i][j], i, j, k);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void initializeConstantDensityRHS(double[] b) {
        int k;
        int j;
        int n = 0;
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    n = this.getIndex(i, j, k);
                    if (n > -1 && this.actnumflow[i][j][k] > 0.0) {
                        b[n] = 0.0;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.initialize_dirichlet();
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    if (this.bccodes[i][j][k] == 2 && (n = this.getIndex(i, j, k)) > -1 && this.actnumflow[i][j][k] > 0.0) {
                        int n2 = n;
                        b[n2] = b[n2] + -this.heatprodA[i][j][k] * (this.dx * this.dy * this.h[i][j][k]) * DIAGSCALE * this.overcpdxdydz[i][j][k];
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    if (this.bccodes[i][j][k] == 2) {
                        n = this.getIndex(i, j, k);
                        if (this.actnumflow[i][j][k] > 0.0) {
                            b[n] = -this.bcval[i][j][k] * DIAGSCALE * this.overcpdxdydz[i][j][k];
                        }
                    }
                    if (this.bccodes[i][j][k] == 3) {
                        n = this.getIndex(i, j, k);
                        if (this.actnumflow[i][j][k] > 0.0) {
                            b[n] = -this.bcval[i][j][k] * this.CWC[i][j][k] * DIAGSCALE * this.overcpdxdydz[i][j][k];
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.NX) {
            int j2 = 0;
            while (j2 < this.NY) {
                int k2 = 0;
                while (k2 < this.NZ) {
                    if (this.active[i2][j2]) {
                        boolean ok;
                        boolean bl = ok = k2 == this.NZ - 1;
                        if (ok && this.heatflow[6] && (n = this.getIndex(i2, j2, k2)) > -1 && this.actnumflow[i2][j2][k2] > 0.0) {
                            int n3 = n;
                            b[n3] = b[n3] + -this.heatflowval[6] * (this.dx * this.dy) * DIAGSCALE * this.overcpdxdydz[i2][j2][k2];
                        }
                        boolean bl2 = ok = k2 == 0;
                        if (ok && this.heatflow[5] && (n = this.getIndex(i2, j2, k2)) > -1 && this.actnumflow[i2][j2][k2] > 0.0) {
                            int n4 = n;
                            b[n4] = b[n4] + -this.heatflowval[5] * (this.dx * this.dy) * DIAGSCALE * this.overcpdxdydz[i2][j2][k2];
                        }
                    }
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
    }

    @Override
    public void initializeVariableDensityRHS(double[] b) {
        int k;
        int j;
        int k2;
        int j2;
        int n = 0;
        this.initialize_dirichlet();
        double[][][] densitypseudosource2 = new double[this.NX][this.NY][this.NZ];
        int i = 0;
        while (i < this.NX) {
            int j3 = 0;
            while (j3 < this.NY) {
                int k3 = 0;
                while (k3 < this.NZ) {
                    n = this.getIndex(i, j3, k3);
                    if (n > -1 && this.actnumflow[i][j3][k3] > 0.0) {
                        double rhs;
                        int xplus = (int)this.connectxplus[i][j3][k3];
                        int xmin = (int)this.connectxmin[i][j3][k3];
                        int yplus = (int)this.connectyplus[i][j3][k3];
                        int ymin = (int)this.connectymin[i][j3][k3];
                        int zplus = (int)this.connectzplus[i][j3][k3];
                        int zmin = (int)this.connectzmin[i][j3][k3];
                        b[n] = 0.0;
                        boolean upflowboundary = k3 == 0 || zmin < 0;
                        boolean downflowboundary = k3 == this.NZ - 1 || zplus < 0;
                        boolean jlflowboundary = j3 == 0 || ymin < 0;
                        boolean jrflowboundary = j3 == this.NY - 1 || yplus < 0;
                        boolean ilflowboundary = i == 0 || xmin < 0;
                        boolean irflowboundary = i == this.NX - 1 || xplus < 0;
                        int iplus = xplus;
                        int jplus = yplus;
                        int kplus = zplus;
                        int imin = xmin;
                        int jmin = ymin;
                        int kmin = zmin;
                        if (this.NZ == 1) {
                            kplus = k3;
                            kmin = k3;
                        }
                        if (upflowboundary) {
                            kmin = k3;
                        }
                        if (downflowboundary) {
                            kplus = k3;
                        }
                        if (jlflowboundary) {
                            jmin = j3;
                        }
                        if (jrflowboundary) {
                            jplus = j3;
                        }
                        if (ilflowboundary) {
                            imin = i;
                        }
                        if (irflowboundary) {
                            iplus = i;
                        }
                        double condcPlus = this.conductancei[i][j3][k3];
                        double condrPlus = this.conductancej[i][j3][k3];
                        double condvPlus = this.conductancek[i][j3][k3];
                        double dziPlus = this.z[iplus][j3][k3] - this.z[i][j3][k3];
                        double dzjPlus = this.z[i][jplus][k3] - this.z[i][j3][k3];
                        double dzkPlus = this.z[i][j3][kplus] - this.z[i][j3][k3];
                        double densityiPlus = (this.density[i][j3][k3] + this.density[iplus][j3][k3]) / 2.0;
                        double densityjPlus = (this.density[i][j3][k3] + this.density[i][jplus][k3]) / 2.0;
                        double densitykPlus = dzkPlus > 1.0E-10 ? (this.density[i][j3][k3] * 0.5 * this.h[i][j3][k3] + this.density[i][j3][kplus] * 0.5 * this.h[i][j3][kplus]) / dzkPlus : 1.0E-10;
                        double condcMinus = this.conductancei[imin][j3][k3];
                        double condrMinus = this.conductancej[i][jmin][k3];
                        double condvMinus = this.conductancek[i][j3][kmin];
                        double dziMinus = this.z[imin][j3][k3] - this.z[i][j3][k3];
                        double dzjMinus = this.z[i][jmin][k3] - this.z[i][j3][k3];
                        double dzkMinus = -(this.z[i][j3][k3] - this.z[i][j3][kmin]);
                        double densityiMinus = (this.density[imin][j3][k3] + this.density[i][j3][k3]) / 2.0;
                        double densityjMinus = (this.density[i][jmin][k3] + this.density[i][j3][k3]) / 2.0;
                        double densitykMinus = -dzkMinus > 1.0E-10 ? (this.density[i][j3][kmin] * 0.5 * this.h[i][j3][kmin] + this.density[i][j3][k3] * 0.5 * this.h[i][j3][k3]) / -dzkMinus : 1.0E-5;
                        if (this.NZ == 1) {
                            condvPlus = 0.0;
                            condvMinus = 0.0;
                        }
                        if (upflowboundary) {
                            condvMinus = 0.0;
                        }
                        if (downflowboundary) {
                            condvPlus = 0.0;
                        }
                        if (jlflowboundary) {
                            condrMinus = 0.0;
                        }
                        if (jrflowboundary) {
                            condrPlus = 0.0;
                        }
                        if (ilflowboundary) {
                            condcMinus = 0.0;
                        }
                        if (irflowboundary) {
                            condcPlus = 0.0;
                        }
                        double correction = 9.81 * this.refDensity * 1.0E-5;
                        densitypseudosource2[i][j3][k3] = rhs = correction * condcPlus * ((densityiPlus - this.refDensity) * dziPlus / this.refDensity) + correction * condcMinus * ((densityiMinus - this.refDensity) * dziMinus / this.refDensity) + correction * condrPlus * ((densityjPlus - this.refDensity) * dzjPlus / this.refDensity) + correction * condrMinus * ((densityjMinus - this.refDensity) * dzjMinus / this.refDensity) + correction * condvPlus * ((densitykPlus - this.refDensity) * dzkPlus / this.refDensity) + correction * condvMinus * ((densitykMinus - this.refDensity) * dzkMinus / this.refDensity);
                        this.densitypseudosourcei[i][j3][k3] = dziPlus * 9.81 * (densityiPlus - this.refDensity) * 1.0E-5;
                        this.densitypseudosourcej[i][j3][k3] = dzjPlus * 9.81 * (densityjPlus - this.refDensity) * 1.0E-5;
                        this.densitypseudosourcek[i][j3][k3] = dzkPlus * 9.81 * (densitykPlus - this.refDensity) * 1.0E-5;
                        int n2 = n;
                        b[n2] = b[n2] + DIAGSCALE * rhs;
                    }
                    ++k3;
                }
                ++j3;
            }
            ++i;
        }
        double sumeff = 0.0;
        int i2 = 0;
        while (i2 < this.NX) {
            j2 = 0;
            while (j2 < this.NY) {
                k2 = 0;
                while (k2 < this.NZ) {
                    sumeff += -densitypseudosource2[i2][j2][k2];
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
        System.out.println("RHS density  terms concvection " + sumeff);
        i2 = 0;
        while (i2 < this.NX) {
            j2 = 0;
            while (j2 < this.NY) {
                k2 = 0;
                while (k2 < this.NZ) {
                    if (this.bccodes[i2][j2][k2] == 2 && (n = this.getIndex(i2, j2, k2)) > -1 && this.actnumflow[i2][j2][k2] > 0.0) {
                        int n3 = n;
                        b[n3] = b[n3] + -this.heatprodA[i2][j2][k2] * (this.dx * this.dy * this.h[i2][j2][k2]) * DIAGSCALE * this.overcpdxdydz[i2][j2][k2];
                    }
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
        double[][] middepth = new double[this.NX][this.NY];
        double[][] correctionpseudo = new double[this.NX][this.NY];
        int i3 = 0;
        while (i3 < this.NX) {
            j = 0;
            while (j < this.NY) {
                double zsum = 0.0;
                int ncount = 0;
                double z = this.topdepth[i3][j] - 0.5 * this.h[i3][j][0];
                int k4 = 0;
                while (k4 < this.NZ) {
                    z += this.h[i3][j][k4];
                    if (this.actnum[i3][j][k4] > 0) {
                        zsum += z;
                        ++ncount;
                    }
                    ++k4;
                }
                middepth[i3][j] = zsum / (double)ncount;
                z = this.topdepth[i3][j] - 0.5 * this.h[i3][j][0];
                boolean found = false;
                int k5 = 0;
                while (k5 < this.NZ) {
                    z += this.h[i3][j][k5];
                    if (!found) {
                        double[] dArray = correctionpseudo[i3];
                        int n4 = j;
                        dArray[n4] = dArray[n4] + this.densitypseudosourcek[i3][j][k5];
                        if (z > middepth[i3][j]) {
                            found = true;
                        }
                    }
                    ++k5;
                }
                ++j;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < this.NX) {
            j = 0;
            while (j < this.NY) {
                double correction = 0.0;
                double sumcorrection = 0.0;
                int k6 = 0;
                while (k6 < this.NZ) {
                    if (this.bccodes[i3][j][k6] == 2 && (n = this.getIndex(i3, j, k6)) > -1 && this.actnumflow[i3][j][k6] > 0.0) {
                        int n5 = n;
                        b[n5] = b[n5] + -this.bcval[i3][j][k6] * DIAGSCALE * this.overcpdxdydz[i3][j][k6];
                    }
                    sumcorrection += this.densitypseudosourcek[i3][j][k6];
                    if (this.bccodes[i3][j][k6] == 3 && (n = this.getIndex(i3, j, k6)) > -1 && this.actnumflow[i3][j][k6] > 0.0) {
                        int n6 = n;
                        b[n6] = b[n6] + -this.bcval[i3][j][k6] * this.CWC[i3][j][k6] * DIAGSCALE * this.overcpdxdydz[i3][j][k6];
                        correction = -(sumcorrection - correctionpseudo[i3][j]);
                        int n7 = n;
                        b[n7] = b[n7] + correction * this.CWC[i3][j][k6] * DIAGSCALE * this.overcpdxdydz[i3][j][k6];
                    }
                    ++k6;
                }
                ++j;
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.NX) {
            int j4 = 0;
            while (j4 < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    if (this.active[i4][j4]) {
                        boolean ok;
                        boolean bl = ok = k == this.NZ - 1;
                        if (ok && this.heatflow[6] && (n = this.getIndex(i4, j4, k)) > -1 && this.actnumflow[i4][j4][k] > 0.0) {
                            int n8 = n;
                            b[n8] = b[n8] + -this.heatflowval[6] * (this.dx * this.dy) * DIAGSCALE * this.overcpdxdydz[i4][j4][k];
                        }
                        boolean bl2 = ok = k == 0;
                        if (ok && this.heatflow[5] && (n = this.getIndex(i4, j4, k)) > -1 && this.actnumflow[i4][j4][k] > 0.0) {
                            int n9 = n;
                            b[n9] = b[n9] + -this.heatflowval[5] * (this.dx * this.dy) * DIAGSCALE * this.overcpdxdydz[i4][j4][k];
                        }
                    }
                    ++k;
                }
                ++j4;
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < this.NX) {
            int j5 = 0;
            while (j5 < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    n = this.getIndex(i4, j5, k);
                    if (n > -1 && this.actnumflow[i4][j5][k] > 0.0) {
                        this.rightHandSide[i4][j5][k] = b[n];
                    }
                    ++k;
                }
                ++j5;
            }
            ++i4;
        }
    }

    @Override
    public void initialize_dirichlet() {
        boolean[] ok = null;
        if (this.b == null) {
            this.b = new double[this.nx];
        }
        int i = 0;
        while (i < this.nx) {
            this.b[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    int n;
                    this.getOK(this.okconnectcells[i][j], i, j, k);
                    ok = this.okconnectcells[i][j];
                    if (ok[0] && (n = this.getIndex(i, j, k)) >= 0 && this.actnumflow[i][j][k] > 0.0) {
                        int ik = 1;
                        while (ik < 5) {
                            if (!ok[ik] && this.infinite[ik]) {
                                if (ik < 3) {
                                    int n2 = n;
                                    this.b[n2] = this.b[n2] + -DIAGSCALE * this.overcpdxdydz[i][j][k] * this.conductancei[i][j][k] * this.lmult[ik] * this.getDefaultPotential(ik, i, j, k);
                                } else {
                                    int n3 = n;
                                    this.b[n3] = this.b[n3] + -DIAGSCALE * this.overcpdxdydz[i][j][k] * this.conductancej[i][j][k] * this.lmult[ik] * this.getDefaultPotential(ik, i, j, k);
                                }
                            }
                            ++ik;
                        }
                        boolean okKMIN = k > 0;
                        boolean okKPLUS = k < this.NZ - 1;
                        ik = -1;
                        if (okKMIN) {
                            ik = 5;
                        } else if (okKPLUS) {
                            ik = 6;
                        }
                        if (ik > 0 && this.infinite[ik]) {
                            int n4 = n;
                            this.b[n4] = this.b[n4] + -DIAGSCALE * this.overcpdxdydz[i][j][k] * this.conductancek[i][j][k] * this.lmult[ik] * this.getDefaultPotential(ik, i, j, k);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.initialize_DirichletInternal();
    }

    @Override
    public void initialize_DirichletInternal() {
        boolean[] ok = null;
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    int n;
                    this.getOK(this.okconnectcells[i][j], i, j, k);
                    ok = this.okconnectcells[i][j];
                    if (ok[0] && (n = this.getIndex(i, j, k)) >= 0 && this.actnumflow[i][j][k] > 0.0) {
                        int zmin;
                        int zplus;
                        int ymin;
                        int xmin;
                        int yplus;
                        int n2;
                        int xplus;
                        if (ok[2] && (xplus = (int)this.connectxplus[i][j][k]) > 0 && (n2 = this.getIndex(xplus, j, k)) < 0 && this.bccodes[xplus][j][k] == 1) {
                            double txf = this.bcval[xplus][j][k];
                            int n3 = n;
                            this.b[n3] = this.b[n3] - this.conductancei[i][j][k] * txf * this.overcpdxdydz[i][j][k];
                        }
                        if (ok[4] && (yplus = (int)this.connectyplus[i][j][k]) > 0 && (n2 = this.getIndex(i, yplus, k)) < 0 && this.bccodes[i][yplus][k] == 1) {
                            double tyf = this.bcval[i][yplus][k];
                            int n4 = n;
                            this.b[n4] = this.b[n4] - this.conductancej[i][j][k] * tyf * this.overcpdxdydz[i][j][k];
                        }
                        if (ok[1] && (xmin = (int)this.connectxmin[i][j][k]) > 0 && (n2 = this.getIndex(xmin, j, k)) < 0 && this.bccodes[xmin][j][k] == 1) {
                            double txb = this.bcval[xmin][j][k];
                            int n5 = n;
                            this.b[n5] = this.b[n5] - this.conductancei[xmin][j][k] * txb * this.overcpdxdydz[i][j][k];
                        }
                        if (ok[3] && (ymin = (int)this.connectymin[i][j][k]) > 0 && (n2 = this.getIndex(i, ymin, k)) < 0 && this.bccodes[i][ymin][k] == 1) {
                            double tyb = this.bcval[i][ymin][k];
                            int n6 = n;
                            this.b[n6] = this.b[n6] - this.conductancej[i][ymin][k] * tyb * this.overcpdxdydz[i][j][k];
                        }
                        if (ok[6] && (zplus = (int)this.connectzplus[i][j][k]) > 0 && (n2 = this.getIndex(i, j, zplus)) < 0 && this.bccodes[i][j][zplus] == 1) {
                            double tzf = this.bcval[i][j][zplus];
                            int n7 = n;
                            this.b[n7] = this.b[n7] - this.conductancek[i][j][k] * tzf * this.overcpdxdydz[i][j][k];
                        }
                        if (ok[5] && (zmin = (int)this.connectzmin[i][j][k]) > 0 && (n2 = this.getIndex(i, j, zmin)) < 0 && this.bccodes[i][j][zmin] == 1) {
                            double tzb = this.bcval[i][j][zmin];
                            int n8 = n;
                            this.b[n8] = this.b[n8] - this.conductancek[i][j][zmin] * tzb * this.overcpdxdydz[i][j][k];
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public double[][] getValues(int k, boolean init) {
        double[][] v = new double[this.NX][this.NY];
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int n = this.getIndex(i, j, k);
                v[i][j] = n > -1 && this.actnumflow[i][j][k] > 0.0 ? (init ? this.x0[n] : this.x[n]) : (this.bccodes[i][j][k] == 1 ? this.bcval[i][j][k] : -999.25);
                ++j;
            }
            ++i;
        }
        return v;
    }

    @Override
    public double getValues(boolean init, int i, int j, int k) {
        int n = this.getIndex(i, j, k);
        if (n > -1 && this.actnumflow[i][j][k] > 0.0) {
            if (init) {
                return this.x0[n];
            }
            return this.x[n];
        }
        return -999.25;
    }

    @Override
    public void setupstartvalue() {
        int n;
        int k;
        int j;
        this.x0 = new double[this.nx];
        int i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    n = this.getIndex(i, j, k);
                    if (n > -1 && this.actnumflow[i][j][k] > 0.0) {
                        this.x0[n] = this.getDefaultvalue();
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.NX) {
            j = 0;
            while (j < this.NY) {
                k = 0;
                while (k < this.NZ) {
                    this.getOK(this.okconnectcells[i][j], i, j, k);
                    boolean[] ok = this.okconnectcells[i][j];
                    if (ok[0]) {
                        if (this.infinite[5] && k == 0 && (n = this.getIndex(i, j, k)) > -1 && this.actnumflow[i][j][k] > 0.0) {
                            this.x0[n] = this.potentialval[5];
                        }
                        if (this.infinite[6] && k == this.NZ - 1 && (n = this.getIndex(i, j, k)) > -1 && this.actnumflow[i][j][k] > 0.0) {
                            this.x0[n] = this.potentialval[6];
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void setupstartvalue(double[][] v) {
        this.setupstartvalue();
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    int n = this.getIndex(i, j, k);
                    if (n > -1 && this.actnumflow[i][j][k] > 0.0) {
                        this.x0[n] = v[i][j];
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void setupstartvalue(double[][][] v) {
        this.setupstartvalue();
        int i = 0;
        while (i < this.NX) {
            int j = 0;
            while (j < this.NY) {
                int k = 0;
                while (k < this.NZ) {
                    int n = this.getIndex(i, j, k);
                    if (n > -1 && this.actnumflow[i][j][k] > 0.0) {
                        this.x0[n] = v[i][j][k];
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

