/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.pcg;

import tno.geoenergy.pcg.PCGbase;
import tno.geoenergy.pcg.SymBandMatrix;

public abstract class PCGBand
extends PCGbase {
    SymBandMatrix symband = null;
    public static final int PREPMODE_GETNFILL = 0;
    public static final int PREPMODE_FILLA = 1;
    public static final int RUNMODE = 2;

    @Override
    public void initParameters(int nx) {
        this.nx = nx;
        this.setupstartvalue();
    }

    @Override
    public void setupstartvalue() {
        this.x0 = new double[this.nx];
        int i = 0;
        while (i < this.nx) {
            this.x0[i] = i;
            ++i;
        }
        this.x0[0] = 10.0;
    }

    public void doPCGDIAG(int maxiter, int miniter) {
        this.x = new double[this.nx];
        if (this.b == null) {
            this.b = new double[this.nx];
        }
        this.r = new double[this.nx];
        this.d = new double[this.nx];
        this.q = new double[this.nx];
        this.s = new double[this.nx];
        this.diag = new double[this.nx];
        if (this.symband == null) {
            this.symband = new SymBandMatrix(this.nx);
            this.APrepare(0);
            System.out.println(" number of equations :" + this.symband.nx);
            System.out.println(" number of band components :" + this.symband.nfill);
            this.symband.setA(new double[this.symband.nfill]);
            this.symband.setIx(new int[this.symband.nfill]);
        }
        int iter = 0;
        boolean converged = false;
        this.APrepare(1);
        this.initializeRHS(this.b);
        double mindiag = this.symband.scaleA_b(this.b);
        System.out.println(" scaling A and b with inverse of : " + mindiag);
        int idef = this.symband.checkPosdef();
        System.out.println("status of the A Matrix is " + SymBandMatrix.DEFNAMES[idef + 1]);
        this.AtimesVBand(this.x, this.diag, this.x0);
        PCGBand.clone(this.r, this.b);
        PCGBand.subtractBfromA(this.r, this.x);
        PCGBand.clone(this.d, this.r);
        super.preconditionV(this.d, this.diag);
        PCGBand.clone(this.x, this.x0);
        this.dnew = PCGBand.innerProduct(this.r, this.d);
        while (!(iter >= maxiter || converged && iter >= miniter)) {
            this.AtimesVBand(this.q, this.diag, this.d);
            this.alfa = this.dnew / PCGBand.innerProduct(this.d, this.q);
            PCGBand.scaleAB(this.x, this.d, this.alfa);
            if ((iter + 1) % 10 == 0) {
                PCGBand.clone(this.r, this.x);
                this.AtimesVBand(this.q, this.diag, this.r);
                PCGBand.clone(this.r, this.b);
                PCGBand.subtractBfromA(this.r, this.q);
            } else {
                PCGBand.scaleAB(this.r, this.q, -this.alfa);
            }
            PCGBand.clone(this.s, this.r);
            super.preconditionV(this.s, this.diag);
            this.dold = this.dnew;
            this.dnew = PCGBand.innerProduct(this.r, this.s);
            this.beta = this.dnew / this.dold;
            boolean bl = converged = Math.abs(this.dnew) < Math.pow(TINY, 2.0);
            if (!converged) {
                this.beta = this.dnew / this.dold;
                PCGBand.scaleAB(this.s, this.d, this.beta);
                PCGBand.clone(this.d, this.s);
            }
            System.out.println("iteration " + iter + " dnew " + this.dnew);
            System.out.println(" x " + this.x[0] + " " + this.x[1]);
            ++iter;
        }
    }

    @Override
    public void doPCG(int maxiter, int miniter) {
        this.doPCG(maxiter, miniter, true);
    }

    public void doPCG(int maxiter, int miniter, boolean newAB) {
        if (newAB) {
            this.x = new double[this.nx];
            if (this.b == null) {
                this.b = new double[this.nx];
            }
            this.r = new double[this.nx];
            this.d = new double[this.nx];
            this.q = new double[this.nx];
            this.s = new double[this.nx];
            this.diag = new double[this.nx];
            if (this.symband == null) {
                this.symband = new SymBandMatrix(this.nx);
                this.APrepare(0);
                System.out.println(" number of equations :" + this.symband.nx);
                System.out.println(" number of band components :" + this.symband.nfill);
                this.symband.setA(new double[this.symband.nfill]);
                this.symband.setIx(new int[this.symband.nfill]);
            }
            this.APrepare(1);
            this.initializeRHS(this.b);
            double mindiag = this.symband.scaleA_b(this.b);
            System.out.println(" scaling A and b with inverse of : " + mindiag);
            int idef = this.symband.checkPosdef();
            System.out.println("status of the A Matrix is " + SymBandMatrix.DEFNAMES[idef + 1]);
            this.symband.IncompleteCholeskyFactorization();
        }
        int iter = 0;
        boolean converged = false;
        this.AtimesVBand(this.x, this.diag, this.x0);
        PCGBand.clone(this.r, this.b);
        PCGBand.subtractBfromA(this.r, this.x);
        PCGBand.clone(this.d, this.r);
        this.preconditionV(this.d, this.diag);
        PCGBand.clone(this.x, this.x0);
        this.dnew = PCGBand.innerProduct(this.r, this.d);
        System.out.println(this.dnew);
        while (!(iter >= maxiter || converged && iter >= miniter)) {
            this.AtimesVBand(this.q, this.diag, this.d);
            this.alfa = this.dnew / PCGBand.innerProduct(this.d, this.q);
            PCGBand.scaleAB(this.x, this.d, this.alfa);
            if ((iter + 1) % 10 == 0) {
                PCGBand.clone(this.r, this.x);
                this.AtimesVBand(this.q, this.diag, this.r);
                PCGBand.clone(this.r, this.b);
                PCGBand.subtractBfromA(this.r, this.q);
            } else {
                PCGBand.scaleAB(this.r, this.q, -this.alfa);
            }
            PCGBand.clone(this.s, this.r);
            this.preconditionV(this.s, this.diag);
            this.dold = this.dnew;
            this.dnew = PCGBand.innerProduct(this.r, this.s);
            this.beta = this.dnew / this.dold;
            boolean bl = converged = Math.abs(this.dnew) < Math.pow(TINY, 2.0);
            if (!converged) {
                this.beta = this.dnew / this.dold;
                PCGBand.scaleAB(this.s, this.d, this.beta);
                PCGBand.clone(this.d, this.s);
            }
            if (iter % 100 == 0) {
                System.out.println("iteration " + iter + " dnew " + this.dnew);
            }
            if (iter % 100 == 0) {
                System.out.println(" x " + this.x[0] + " " + this.x[1]);
            }
            ++iter;
        }
    }

    public void doPCGrestart(int maxiter, int miniter, boolean rA, boolean rb, boolean rx) {
        if (this.x == null || rx) {
            this.x = new double[this.nx];
        }
        if (rA) {
            if (this.symband == null || this.symband.nx != this.nx) {
                this.b = new double[this.nx];
                this.r = new double[this.nx];
                this.d = new double[this.nx];
                this.q = new double[this.nx];
                this.s = new double[this.nx];
                this.diag = new double[this.nx];
                System.out.println(" Generating new symband: ");
                this.symband = new SymBandMatrix(this.nx);
                this.APrepare(0);
                System.out.println(" number of equations :" + this.symband.nx);
                System.out.println(" number of band components :" + this.symband.nfill);
                this.symband.setA(new double[this.symband.nfill]);
                this.symband.setIx(new int[this.symband.nfill]);
            } else {
                int i = 0;
                while (i < this.nx) {
                    this.b[i] = 0.0;
                    this.r[i] = 0.0;
                    this.d[i] = 0.0;
                    this.q[i] = 0.0;
                    this.s[i] = 0.0;
                    this.diag[i] = 0.0;
                    ++i;
                }
            }
            this.APrepare(1);
            this.initializeRHS(this.b);
            int idef = this.symband.checkPosdef();
            System.out.println("status of the A Matrix is " + SymBandMatrix.DEFNAMES[idef + 1]);
            this.symband.IncompleteCholeskyFactorization();
        } else if (rb) {
            this.initializeRHS(this.b);
        }
        int iter = 0;
        boolean converged = false;
        this.AtimesVBand(this.x, this.diag, this.x0);
        PCGBand.clone(this.r, this.b);
        PCGBand.subtractBfromA(this.r, this.x);
        PCGBand.clone(this.d, this.r);
        this.preconditionV(this.d, this.diag);
        PCGBand.clone(this.x, this.x0);
        this.dnew = PCGBand.innerProduct(this.r, this.d);
        System.out.println(this.dnew);
        double d0 = this.dnew;
        while (!(iter >= maxiter || converged && iter >= miniter)) {
            this.AtimesVBand(this.q, this.diag, this.d);
            this.alfa = this.dnew / PCGBand.innerProduct(this.d, this.q);
            PCGBand.scaleAB(this.x, this.d, this.alfa);
            if ((iter + 1) % 10 == 0) {
                PCGBand.clone(this.r, this.x);
                this.AtimesVBand(this.q, this.diag, this.r);
                PCGBand.clone(this.r, this.b);
                PCGBand.subtractBfromA(this.r, this.q);
            } else {
                PCGBand.scaleAB(this.r, this.q, -this.alfa);
            }
            PCGBand.clone(this.s, this.r);
            this.preconditionV(this.s, this.diag);
            this.dold = this.dnew;
            this.dnew = PCGBand.innerProduct(this.r, this.s);
            this.beta = this.dnew / this.dold;
            boolean bl = converged = Math.abs(this.dnew) < Math.pow(TINY, 2.0);
            if (!converged) {
                this.beta = this.dnew / this.dold;
                PCGBand.scaleAB(this.s, this.d, this.beta);
                PCGBand.clone(this.d, this.s);
            }
            if (iter % 100 == 0) {
                System.out.println("iteration " + iter + " dnew " + this.dnew);
            }
            if (iter % 100 == 0) {
                System.out.println(" x " + this.x[0] + " " + this.x[1]);
            }
            ++iter;
        }
        if (converged) {
            System.out.println();
            System.out.println("iteration: " + iter + " converged dnew: " + this.dnew);
        } else {
            System.out.println();
            System.out.println("iteration: " + iter + " NOT converged dnew: " + this.dnew);
        }
    }

    void scaleOvercdxdydz(int[] idiag, double[] a, double[] b) {
    }

    private void AtimesVBand(double[] x, double[] diag, double[] x0) {
        this.symband.Atimesb(x0, x);
        int i = 0;
        while (i < this.nx) {
            diag[i] = 1.0 / this.symband.getA()[this.symband.getIdiag()[i]];
            ++i;
        }
    }

    abstract void APrepare(int var1);

    @Override
    public void initialize_dirichlet() {
        if (this.b == null) {
            this.b = new double[this.nx];
        }
        this.b[0] = -10.0;
        this.b[this.nx - 1] = -10.0;
    }

    @Override
    double getDefaultvalue() {
        return 0.0;
    }

    @Override
    public void initializeRHS(double[] b) {
        Object cbc = null;
        double source = 1.0;
        int i = 0;
        while (i < this.nx) {
            b[i] = 0.0;
            ++i;
        }
        this.initialize_dirichlet();
    }

    @Override
    public void preconditionV(double[] r, double[] diag) {
        this.symband.BacksubSym(r, r);
    }

    public static double innerProduct(double[] a, double[] b) {
        double sum = 0.0;
        int i = 0;
        while (i < a.length) {
            sum += a[i] * b[i];
            ++i;
        }
        return sum;
    }

    public static void subtractBfromA(double[] a, double[] b) {
        int i = 0;
        while (i < a.length) {
            a[i] = a[i] - b[i];
            ++i;
        }
    }

    private static void clone(double[] a, double[] b) {
        int i = 0;
        while (i < a.length) {
            a[i] = b[i];
            ++i;
        }
    }

    public static void scale(double[] a, double fac) {
        int i = 0;
        while (i < a.length) {
            a[i] = a[i] * fac;
            ++i;
        }
    }

    public static void scaleAB(double[] a, double[] b, double fac) {
        int i = 0;
        while (i < a.length) {
            a[i] = a[i] + fac * b[i];
            ++i;
        }
    }
}

