/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.pcg;

public class PCGbase {
    public static double DIRICHMULT = 1.0E8;
    public static double TINY = 1.0E-4;
    public static double DIAGSCALE = 1000.0;
    double[] x0 = null;
    double[] x = null;
    double[] x1 = null;
    double[] r = null;
    double[] b = null;
    double[] d = null;
    double[] s = null;
    double[] q = null;
    double[] q1 = null;
    double[] diag = null;
    double alfa = 0.0;
    double beta = 0.0;
    double dold = 0.0;
    double dnew = 0.0;
    public int nx = 100;
    private double[] trans;

    public void initParameters(int nx) {
        this.nx = nx;
        this.setupstartvalue();
    }

    public void setupstartvalue() {
        this.x0 = new double[this.nx];
        int i = 0;
        while (i < this.nx) {
            this.x0[i] = -i;
            ++i;
        }
        this.x0[0] = 10.0;
    }

    public void doPCG(int maxiter, int miniter) {
        this.x = new double[this.nx];
        if (this.b == null) {
            this.b = new double[this.nx];
        }
        this.r = new double[this.nx];
        this.d = new double[this.nx];
        this.q = new double[this.nx];
        this.s = new double[this.nx];
        this.diag = new double[this.nx];
        int iter = 0;
        boolean converged = false;
        this.AtimesV(this.x, this.diag, this.x0);
        this.initializeRHS(this.b);
        PCGbase.clone(this.r, this.b);
        PCGbase.subtractBfromA(this.r, this.x);
        PCGbase.clone(this.d, this.r);
        this.preconditionV(this.d, this.diag);
        PCGbase.clone(this.x, this.x0);
        this.dnew = PCGbase.innerProduct(this.r, this.d);
        while (!(iter >= maxiter || converged && iter >= miniter)) {
            this.AtimesV(this.q, this.diag, this.d);
            this.alfa = this.dnew / PCGbase.innerProduct(this.d, this.q);
            PCGbase.scaleAB(this.x, this.d, this.alfa);
            if ((iter + 1) % 10 == 0) {
                PCGbase.clone(this.r, this.x);
                this.AtimesV(this.q, this.diag, this.r);
                PCGbase.clone(this.r, this.b);
                PCGbase.subtractBfromA(this.r, this.q);
            } else {
                PCGbase.scaleAB(this.r, this.q, -this.alfa);
            }
            PCGbase.clone(this.s, this.r);
            this.preconditionV(this.s, this.diag);
            this.dold = this.dnew;
            this.dnew = PCGbase.innerProduct(this.r, this.s);
            this.beta = this.dnew / this.dold;
            boolean bl = converged = this.dnew < Math.pow(TINY, 2.0);
            if (!converged) {
                this.beta = this.dnew / this.dold;
                PCGbase.scaleAB(this.s, this.d, this.beta);
                PCGbase.clone(this.d, this.s);
            }
            System.out.println("iteration " + iter + " dnew " + this.dnew);
            System.out.println(" x " + this.x[0] + " " + this.x[1]);
            ++iter;
        }
    }

    public void doCG(int maxiter, int miniter) {
        this.x = new double[this.nx];
        this.b = new double[this.nx];
        this.r = new double[this.nx];
        this.q = new double[this.nx];
        double[] p = new double[this.nx];
        double[] rplus = new double[this.nx];
        this.diag = new double[this.nx];
        int iter = 0;
        boolean converged = false;
        this.AtimesV(this.x, this.diag, this.x0);
        this.initializeRHS(this.b);
        PCGbase.clone(this.r, this.b);
        PCGbase.subtractBfromA(this.r, this.x);
        PCGbase.clone(p, this.r);
        PCGbase.clone(this.x, this.x0);
        this.dnew = PCGbase.innerProduct(this.r, this.r);
        while (!(iter >= maxiter || converged && iter >= miniter)) {
            this.AtimesV(this.q, this.diag, p);
            this.alfa = this.dnew / PCGbase.innerProduct(p, this.q);
            PCGbase.scaleAB(this.x, p, this.alfa);
            if ((iter + 1) % 10 == 0) {
                PCGbase.clone(rplus, this.x);
                this.AtimesV(this.r, this.diag, rplus);
                PCGbase.clone(rplus, this.b);
                PCGbase.subtractBfromA(rplus, this.r);
            } else {
                PCGbase.clone(rplus, this.r);
                PCGbase.scaleAB(rplus, this.q, -this.alfa);
            }
            this.dold = this.dnew;
            this.dnew = PCGbase.innerProduct(rplus, rplus);
            boolean bl = converged = this.dnew < Math.pow(TINY, 2.0);
            if (!converged) {
                this.beta = this.dnew / this.dold;
                PCGbase.clone(this.r, rplus);
                PCGbase.scaleAB(rplus, p, this.beta);
                PCGbase.clone(p, rplus);
            }
            System.out.println("iteration " + iter + " dnew " + this.dnew);
            System.out.println(" x " + this.x[0] + " " + this.x[1]);
            ++iter;
        }
    }

    public void initialize_dirichlet() {
        if (this.b == null) {
            this.b = new double[this.nx];
        }
        this.b[0] = -10.0;
        this.b[this.nx - 1] = -10.0;
    }

    double getDefaultvalue() {
        return 0.0;
    }

    public void AtimesV(double[] ax, double[] diag, double[] x) {
        double SIGN = 1.0;
        int i = 0;
        while (i < this.nx) {
            ax[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.nx) {
            double t = x[i];
            double txf = this.getDefaultvalue();
            double txb = this.getDefaultvalue();
            if (i != 0) {
                txb = x[i - 1];
            }
            if (i != this.nx - 1) {
                txf = x[i + 1];
            }
            if (i == 0) {
                txb = 0.0;
            }
            if (i == this.nx - 1) {
                txf = 0.0;
            }
            ax[i] = SIGN * (this.trans[i] * (txf - t) - this.trans[Math.max(0, i - 1)] * (t - txb));
            diag[i] = SIGN * 1.0 / (2.0 * this.trans[i]);
            ++i;
        }
    }

    public void initializetrans() {
        this.trans = new double[this.nx];
        int i = 0;
        while (i < this.nx) {
            this.trans[i] = i + 1;
            ++i;
        }
    }

    public void initializeRHS(double[] b) {
        Object cbc = null;
        double source = 1.0;
        int i = 0;
        while (i < this.nx) {
            b[i] = 0.0;
            ++i;
        }
        this.initialize_dirichlet();
    }

    public void preconditionV(double[] r, double[] diag) {
        int i = 0;
        while (i < r.length) {
            int n = i;
            r[n] = r[n] * diag[i];
            ++i;
        }
    }

    public static double innerProduct(double[] a, double[] b) {
        double sum = 0.0;
        int i = 0;
        while (i < a.length) {
            sum += a[i] * b[i];
            ++i;
        }
        return sum;
    }

    public static void subtractBfromA(double[] a, double[] b) {
        int i = 0;
        while (i < a.length) {
            a[i] = a[i] - b[i];
            ++i;
        }
    }

    private static void clone(double[] a, double[] b) {
        int i = 0;
        while (i < a.length) {
            a[i] = b[i];
            ++i;
        }
    }

    public static void scale(double[] a, double fac) {
        int i = 0;
        while (i < a.length) {
            a[i] = a[i] * fac;
            ++i;
        }
    }

    public static void scaleAB(double[] a, double[] b, double fac) {
        int i = 0;
        while (i < a.length) {
            a[i] = a[i] + fac * b[i];
            ++i;
        }
    }

    public static void main(String[] args) {
        PCGbase g = new PCGbase();
        g.initParameters(50);
        g.initializetrans();
        g.doPCG(1000, 100);
        System.out.println("ready");
        int i = 0;
        while (i < g.nx) {
            System.out.println(String.valueOf(i) + " " + g.x[i]);
            ++i;
        }
    }
}

