/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.pcg;

import tno.geoenergy.util.AsciiOut;

public class SymBandMatrix {
    public static int POSDEF = 1;
    public static int NEGDEF = -1;
    public static int NOTDEF = 0;
    public static String[] DEFNAMES = new String[]{"NEG DEFINITE", "UNDEFINED", "POS DEFINITE"};
    double[] a = null;
    int[] idiag = null;
    int[] ix = null;
    int nx = 0;
    int nfill = 0;
    double[] icf = null;
    int[] icfdiagcomplement = null;
    double[] icfcomplement = null;
    int[] ixcomplement = null;

    SymBandMatrix(int nx) {
        this.a = null;
        this.ix = null;
        this.idiag = new int[nx + 1];
        this.nx = nx;
        this.nfill = 0;
    }

    SymBandMatrix(double[][] amatrix) {
        this.nx = amatrix.length;
        this.nfill = 0;
        this.idiag = new int[this.nx + 1];
        int ioffset = 0;
        int i = 0;
        while (i < this.nx) {
            this.idiag[i] = this.nfill;
            this.nfill += this.nx - i;
            ++i;
        }
        this.idiag[this.nx] = this.nfill;
        System.out.println("nfill " + this.nfill);
        this.a = new double[this.nfill];
        this.ix = new int[this.nfill];
        i = 0;
        while (i < this.nx) {
            ioffset = this.idiag[i];
            int j = i;
            while (j < this.nx) {
                this.a[ioffset] = amatrix[i][j];
                this.ix[ioffset] = j++;
                ++ioffset;
            }
            ++i;
        }
    }

    public void Atimesb(double[] b, double[] r) {
        int k;
        int i = 0;
        while (i < this.nx) {
            r[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.nx) {
            if (i == 20) {
                boolean bl = true;
            }
            k = this.idiag[i];
            while (k < this.idiag[i + 1]) {
                double aa = this.a[k];
                double xx = this.ix[k];
                double bb = b[this.ix[k]];
                int n = i;
                r[n] = r[n] + this.a[k] * b[this.ix[k]];
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < this.nx) {
            k = this.idiag[i] + 1;
            while (k < this.idiag[i + 1]) {
                int n = this.ix[k];
                r[n] = r[n] + this.a[k] * b[i];
                ++k;
            }
            ++i;
        }
    }

    public int checkPosdef() {
        int idef = NOTDEF;
        if (this.a[this.idiag[0]] >= 0.0) {
            idef = POSDEF;
        }
        if (this.a[this.idiag[0]] < 0.0) {
            idef = NEGDEF;
        }
        int i = 1;
        while (i < this.nx) {
            if (this.a[this.idiag[i]] >= 0.0 && idef == NEGDEF) {
                idef = NOTDEF;
            }
            if (this.a[this.idiag[i]] < 0.0 && idef == POSDEF) {
                idef = NOTDEF;
            }
            ++i;
        }
        return idef;
    }

    public double scaleA_b(double[] rhs) {
        double mindiag = 1.0E38;
        int i = 0;
        while (i < this.nx) {
            if (Math.abs(this.a[this.idiag[i]]) < mindiag) {
                mindiag = Math.abs(this.a[this.idiag[i]]);
            }
            ++i;
        }
        mindiag = Math.max(1.0E-30, mindiag);
        System.out.println("minimum diagonal entry" + mindiag);
        i = 0;
        while (i < this.nfill) {
            int n = i++;
            this.a[n] = this.a[n] / mindiag;
        }
        i = 0;
        while (i < this.nx) {
            int n = i++;
            rhs[n] = rhs[n] / mindiag;
        }
        return mindiag;
    }

    public boolean IncompleteCholeskyFactorization() {
        System.out.println("starting ICF");
        int idef = this.checkPosdef();
        if (idef == NOTDEF) {
            System.out.println(" A not defined ");
            return false;
        }
        if (this.icf == null) {
            this.icf = new double[this.nfill];
        }
        int i = 0;
        while (i < this.nfill) {
            this.icf[i] = (double)idef * this.a[i];
            ++i;
        }
        int k = 0;
        while (k < this.nx) {
            int kdiag = this.idiag[k];
            this.icf[kdiag] = Math.sqrt(this.icf[kdiag]);
            int ii = kdiag + 1;
            while (ii < this.idiag[k + 1]) {
                this.icf[ii] = this.icf[ii] / this.icf[kdiag];
                ++ii;
            }
            int jj = kdiag + 1;
            while (jj < this.idiag[k + 1]) {
                int ii2 = jj;
                while (ii2 < this.idiag[k + 1]) {
                    int j = this.ix[jj];
                    int jjj = this.idiag[j];
                    while (jjj < this.idiag[j + 1]) {
                        if (this.ix[jjj] == this.ix[ii2]) {
                            this.icf[jjj] = this.icf[jjj] - this.icf[ii2] * this.icf[jj];
                        }
                        ++jjj;
                    }
                    ++ii2;
                }
                ++jj;
            }
            if (k % 10000 == 0) {
                System.out.print(".");
            }
            ++k;
        }
        this.IncompleteCholeskyFactorizationSetupComplement();
        System.out.println("finished");
        return true;
    }

    private void IncompleteCholeskyFactorizationSetupComplement() {
        int j;
        int i;
        int[] icount = new int[this.nfill];
        if (this.icfcomplement == null) {
            this.icfcomplement = new double[this.nfill];
            this.ixcomplement = new int[this.nfill];
            this.icfdiagcomplement = new int[this.nx + 1];
        } else {
            i = 0;
            while (i < this.nfill) {
                this.ixcomplement[i] = 0;
                ++i;
            }
            i = 0;
            while (i < this.nx + 1) {
                this.icfdiagcomplement[i] = 0;
                ++i;
            }
        }
        i = 0;
        while (i < this.nx) {
            j = this.idiag[i];
            while (j < this.idiag[i + 1]) {
                if (this.ix[j] != i) {
                    int n = this.ix[j] + 1;
                    this.icfdiagcomplement[n] = this.icfdiagcomplement[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        this.icfdiagcomplement[0] = 0;
        i = 1;
        while (i < this.nx + 1) {
            this.icfdiagcomplement[i] = this.icfdiagcomplement[i - 1] + this.icfdiagcomplement[i];
            ++i;
        }
        i = 0;
        while (i < this.nx) {
            j = this.idiag[i];
            while (j < this.idiag[i + 1]) {
                int irow = this.ix[j];
                if (irow != i) {
                    int ioffset = this.icfdiagcomplement[irow] + icount[irow];
                    int n = irow;
                    icount[n] = icount[n] + 1;
                    this.ixcomplement[ioffset] = i;
                    this.icfcomplement[ioffset] = this.icf[j];
                }
                ++j;
            }
            ++i;
        }
    }

    public void ICFtimesb(double[] b, double[] r) {
        int k;
        int i = 0;
        while (i < this.nx) {
            r[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.nx) {
            k = this.idiag[i];
            while (k < this.idiag[i + 1]) {
                int n = i;
                r[n] = r[n] + this.icf[k] * b[this.ix[k]];
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < this.nx) {
            b[i] = r[i];
            ++i;
        }
        i = 0;
        while (i < this.nx) {
            r[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.nx) {
            k = this.idiag[i];
            while (k < this.idiag[i + 1]) {
                int n = this.ix[k];
                r[n] = r[n] + this.icf[k] * b[i];
                ++k;
            }
            ++i;
        }
    }

    public void BacksubSym(double[] x, double[] r) {
        int ii;
        int kdiag;
        int i = 0;
        while (i < this.nx) {
            r[i] = x[i];
            ++i;
        }
        double sum = 0.0;
        int i2 = 0;
        while (i2 < this.nx) {
            if (i2 % 10000 == 0) {
                System.out.print(".");
            }
            sum = 0.0;
            kdiag = this.idiag[i2];
            ii = this.icfdiagcomplement[i2];
            while (ii < this.icfdiagcomplement[i2 + 1]) {
                sum += r[this.ixcomplement[ii]] * this.icfcomplement[ii];
                ++ii;
            }
            r[i2] = (r[i2] - sum) / this.icf[kdiag];
            ++i2;
        }
        i2 = this.nx - 1;
        while (i2 >= 0) {
            sum = 0.0;
            kdiag = this.idiag[i2];
            ii = this.idiag[i2] + 1;
            while (ii < this.idiag[i2 + 1]) {
                sum += r[this.ix[ii]] * this.icf[ii];
                ++ii;
            }
            r[i2] = (r[i2] - sum) / this.icf[kdiag];
            --i2;
        }
    }

    public void BacksubSymOld(double[] x, double[] r) {
        int kdiag;
        System.out.print("starting Backsub..");
        int i = 0;
        while (i < this.nx) {
            r[i] = x[i];
            ++i;
        }
        double sum = 0.0;
        int i2 = 0;
        while (i2 < this.nx) {
            if (i2 % 10000 == 0) {
                System.out.print(".");
            }
            sum = 0.0;
            kdiag = this.idiag[i2];
            int jj = 0;
            while (jj < i2) {
                int ii = this.idiag[jj];
                while (ii < this.idiag[jj + 1]) {
                    if (this.ix[ii] == i2) {
                        sum += r[jj] * this.icf[ii];
                    }
                    ++ii;
                }
                ++jj;
            }
            r[i2] = (r[i2] - sum) / this.icf[kdiag];
            ++i2;
        }
        i2 = this.nx - 1;
        while (i2 >= 0) {
            sum = 0.0;
            kdiag = this.idiag[i2];
            int ii = this.idiag[i2] + 1;
            while (ii < this.idiag[i2 + 1]) {
                sum += r[this.ix[ii]] * this.icf[ii];
                ++ii;
            }
            r[i2] = (r[i2] - sum) / this.icf[kdiag];
            --i2;
        }
        System.out.println("finshed");
    }

    public double[] getA() {
        return this.a;
    }

    public void setA(double[] a) {
        this.a = a;
    }

    public int[] getIdiag() {
        return this.idiag;
    }

    public void setIdiag(int[] idiag) {
        this.idiag = idiag;
    }

    public int[] getIx() {
        return this.ix;
    }

    public void setIx(int[] ix) {
        this.ix = ix;
    }

    public void print(double[] a, boolean fullstructure) {
        int ioffset = 0;
        AsciiOut f1 = new AsciiOut("00.0000", 9);
        if (fullstructure) {
            System.out.println("-------------------------------------");
            int i = 0;
            while (i < this.nx) {
                ioffset = this.idiag[i];
                int j = 0;
                while (j < this.nx) {
                    if (this.ix[ioffset] == j && ioffset < this.idiag[i + 1]) {
                        System.out.print(f1.format(a[ioffset]));
                        ++ioffset;
                    } else {
                        System.out.print(f1.format(0));
                    }
                    ++j;
                }
                System.out.println();
                ++i;
            }
            System.out.println("-------------------------------------");
        }
    }

    public void printVector(double[] v) {
        AsciiOut f1 = new AsciiOut("00.0000", 9);
        int nx = v.length;
        System.out.println("-------------------------------------");
        int i = 0;
        while (i < nx) {
            System.out.print(f1.format(v[i]));
            ++i;
        }
        System.out.println();
        System.out.println("-------------------------------------");
    }

    public static void main(String[] args) {
        double[][] amatrix = new double[][]{{24.0, 0.0, 6.0, 0.0, 0.0}, {0.0, 8.0, 2.0, 0.0, 0.0}, {6.0, 2.0, 8.0, -6.0, 2.0}, {0.0, 0.0, -6.0, 24.0, 0.0}, {0.0, 0.0, 2.0, 0.0, 8.0}};
        double[] r = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        double[] x = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        SymBandMatrix sbm = new SymBandMatrix(amatrix);
        sbm.print(sbm.a, true);
        sbm.IncompleteCholeskyFactorization();
        sbm.print(sbm.icf, true);
        sbm.BacksubSym(x, r);
        sbm.printVector(r);
        sbm.ICFtimesb(r, x);
        sbm.printVector(x);
    }
}

