/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.projection;

import com.jhlabs.map.proj.Projection;
import com.jhlabs.map.proj.ProjectionFactory;
import java.util.Arrays;
import tno.geoenergy.projection.TnoProjectionFactory;

public class ProjectionConverter {
    private int initESPG;
    private int targetESPG;
    private Projection initProjection;
    private Projection targetProjection;
    private double[] x;
    private double[] y;
    private static final String INIT_PREFIX = "+init=";
    private double[][] targetCoords;
    public static int UTM31N = 32631;
    public static int GAUSS_BOAGA_east_fuse = 3004;
    public static int WEBMERCATOR = 3785;
    public static int GK3 = 31467;
    public static int LAMBERTPSPBA = 9802;
    public static int LL = -1;

    public ProjectionConverter(int initESPG, int targetESPG, double[] x, double[] y) {
        this.initESPG = initESPG;
        this.targetESPG = targetESPG;
        this.x = x;
        this.y = y;
        if (initESPG > 0) {
            this.initProjection = ProjectionConverter.getProjection(initESPG);
            System.out.println("initProj: " + this.initProjection.getPROJ4Description());
        } else {
            this.initProjection = null;
        }
        if (targetESPG > 0) {
            this.targetProjection = ProjectionConverter.getProjection(targetESPG);
            System.out.println("targetProj: " + this.targetProjection.getPROJ4Description());
        } else {
            this.targetProjection = null;
        }
    }

    public static ProjectionConverter utm31n2WebMercartor(double[] xc, double[] yc) {
        return new ProjectionConverter(UTM31N, WEBMERCATOR, xc, yc);
    }

    public static ProjectionConverter webMercartor2utm31n(double[] xc, double[] yc) {
        return new ProjectionConverter(WEBMERCATOR, UTM31N, xc, yc);
    }

    public static ProjectionConverter webMercartor2LL(double[] xc, double[] yc) {
        return new ProjectionConverter(WEBMERCATOR, LL, xc, yc);
    }

    public static ProjectionConverter LL2WebMercartor(double[] xc, double[] yc) {
        return new ProjectionConverter(LL, WEBMERCATOR, xc, yc);
    }

    public static Projection getProjection(int espg) {
        String arg = INIT_PREFIX + Integer.toString(espg);
        String[] arguments = new String[]{arg};
        Projection projection = ProjectionFactory.fromPROJ4Specification((String[])arguments);
        return projection;
    }

    public double[][] getTransformedCoords() {
        double[][] longLat = TnoProjectionFactory.convert(this.initProjection, this.x, this.y, true);
        this.targetCoords = TnoProjectionFactory.convert(this.targetProjection, longLat[0], longLat[1], false);
        return this.targetCoords;
    }

    public double[] getCoordinates(int i) {
        int length = this.targetCoords[0].length;
        if (i < 0 && i >= length) {
            return null;
        }
        double[] coords = new double[]{this.targetCoords[0][i], this.targetCoords[1][i]};
        return coords;
    }

    public float[] transformCoordinates(double xc, double yc) {
        this.x = new double[]{xc};
        this.y = new double[]{yc};
        this.getTransformedCoords();
        return new float[]{(float)this.targetCoords[0][0], (float)this.targetCoords[1][0]};
    }

    public float[] getCoordinatesAsFloat(int i) {
        double[] doubleCoords = this.getCoordinates(i);
        if (doubleCoords == null) {
            return null;
        }
        float[] floatCoords = new float[]{(float)doubleCoords[0], (float)doubleCoords[1]};
        return floatCoords;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.targetCoords.length) {
            sb.append(this.targetCoords[0][i]).append(" / ").append(this.targetCoords[1][i]).append("\n");
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        double[] xc = new double[]{570168.8615103138, 637294.3658945197};
        double[] yc = new double[]{5650300.786646548, 5762926.812915765};
        ProjectionConverter pc = new ProjectionConverter(GK3, -1, null, null);
        System.out.println(Arrays.toString(pc.transformCoordinates(3383000.0, 5750000.0)));
    }
}

