/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.projection;

public class UTM2RD {
    static double E0 = 663395.607;
    static double N0 = 5781194.38;

    public static double[] convert2RD(double UTM_E, double UTM_N, boolean utm2rd) {
        if (utm2rd) {
            return UTM2RD.convert2RD(UTM_E, UTM_N);
        }
        return UTM2RD.convert2UTM(UTM_E, UTM_N);
    }

    public static double[] convert2RD(double UTM_E, double UTM_N) {
        double A = 56.619;
        double B = 3290.362;
        double C = 20.184;
        double D = -0.861;
        double E = 2.082;
        double F = -0.023;
        double G = 0.07;
        double H = -0.025;
        double X = (UTM_E - E0) * 1.0E-5;
        double Y = (UTM_N - N0) * 1.0E-5;
        double P = X;
        double Q = Y;
        double R = P * X - Q * Y;
        double S = P * Y + Q * X;
        double T = R * X - S * Y;
        double U = R * Y + S * X;
        double V = T * X - U * Y;
        double W = T * Y + U * X;
        double dX = A * P - B * Q + C * R - D * S + E * T - F * U + G * V - H * W;
        double dY = B * P + A * Q + D * R + C * S + F * T + E * U + H * V + G * W;
        double RD_X = UTM_E - E0 + 155000.0 - dX;
        double RD_Y = UTM_N - N0 + 463000.0 - dY;
        double[] output = new double[]{RD_X, RD_Y};
        return output;
    }

    public static double[] convert2UTM(double RD_X, double RD_Y) {
        double A = -51.681;
        double B = 3290.525;
        double C = 20.172;
        double D = 1.133;
        double E = 2.075;
        double F = 0.251;
        double G = 0.075;
        double H = -0.012;
        double X = (RD_X - 155000.0) * 1.0E-5;
        double Y = (RD_Y - 463000.0) * 1.0E-5;
        double P = X;
        double Q = Y;
        double R = P * X - Q * Y;
        double S = P * Y + Q * X;
        double T = R * X - S * Y;
        double U = R * Y + S * X;
        double V = T * X - U * Y;
        double W = T * Y + U * X;
        double dX = A * P - B * Q + C * R - D * S + E * T - F * U + G * V - H * W;
        double dY = B * P + A * Q + D * R + C * S + F * T + E * U + H * V + G * W;
        double E_UTM = E0 + (RD_X - 155000.0) + dX;
        double N_UTM = N0 + (RD_Y - 463000.0) + dY;
        double[] output = new double[]{E_UTM, N_UTM};
        return output;
    }

    public static double[] convertLatLong2UTM(double Lat, double Long2) {
        double k = 0.9996;
        double a = 6378388.0;
        double e2 = 0.00672267002;
        double A = 1.00507398882;
        double B = 0.00254234295;
        double C = 2.67953E-6;
        double D = 3.51E-9;
        double Long0 = Math.toRadians(3.0);
        double Latr = Math.toRadians(Lat);
        Long2 = Math.toRadians(Long2);
        double x = a * (1.0 - e2) * (A * Latr - B * Math.sin(2.0 * Lat) + C * Math.sin(4.0 * Lat) - D * Math.sin(6.0 * Lat));
        double dlong = (Long2 - Long0) * Math.cos(Latr);
        double t = Math.tan(Latr);
        double t2 = Math.pow(t, 2.0);
        double n2 = e2 * Math.pow(Math.cos(Latr), 2.0) / (1.0 - e2);
        double R = a / Math.sqrt(1.0 - e2 * Math.pow(Math.sin(Latr), 2.0));
        double p = 0.0 * (5.0 - t2 + 9.0 * n2 + 4.0 * n2 * n2);
        double q = 0.0 * (61.0 - 58.0 * t2 + Math.pow(t, 4.0) + 270.0 * n2 - 330.0 * t2 * n2);
        double r = 0.0 * (1.0 - t2 + n2);
        double s = 0.0 * (5.0 - 18.0 * t2 + Math.pow(t, 4.0) + 14.0 * n2 - 58.0 * t2 * n2);
        double u = 0.0 * (61.0 - 479.0 * t2 + 179.0 * Math.pow(t, 4.0) - Math.pow(t, 6.0));
        double dx = 0.5 * Math.pow(dlong, 2.0) * R * t * (1.0 + p * Math.pow(dlong, 2.0) + q * Math.pow(dlong, 4.0));
        double y = dlong * R * (1.0 + r * Math.pow(dlong, 2.0) + s * Math.pow(dlong, 4.0) + u * Math.pow(dlong, 6.0));
        double E_UTM = k * y + 500000.0;
        double N_UTM = k * (x + dx);
        double[] output = new double[]{N_UTM, E_UTM};
        return output;
    }

    public static double[] convertUTM2LatLong(double N_UTM, double E_UTM) {
        double k = 0.9996;
        double a = 6378388.0;
        double e2 = 0.00672267002;
        double A = 1.00507398882;
        double B = 0.00254234295;
        double C = 2.67953E-6;
        double D = 3.51E-9;
        double Long0 = 3.0;
        double y = (E_UTM - 500000.0) / k;
        double x_dx = N_UTM / k;
        double Lat_est = 52.0;
        int i = 0;
        while (i < 4) {
            Lat_est = x_dx / (a * (1.0 - e2)) * 1.0 / A + B / A * Math.sin(2.0 * Lat_est) - C / A * Math.sin(4.0 * Lat_est) + D / A * Math.sin(6.0 * Lat_est);
            Lat_est = Math.toDegrees(Lat_est);
            System.out.println(Lat_est);
            ++i;
        }
        double Lat_est_r = Math.toRadians(Lat_est);
        double t = Math.tan(Lat_est);
        double t2 = Math.pow(t, 2.0);
        double n2 = e2 * Math.pow(Math.cos(Lat_est), 2.0) / (1.0 - e2);
        double R = a / Math.sqrt(1.0 - e2 * Math.pow(Math.sin(Lat_est), 2.0));
        double y_est = y / R;
        double p = 0.0 * (5.0 + 3.0 * t2 + n2 - 9.0 * t2 * n2);
        double q = 0.0 * (61.0 + 90.0 * t2 + 45.0 * Math.pow(t, 4.0) + 107.0 * n2 - 162.0 * t2 * n2 - 45.0 * Math.pow(t, 4.0) * n2);
        double r = 0.0 * (1.0 + 2.0 * t2 + n2);
        double s = 0.0 * (5.0 + 28.0 * t2 + 24.0 * Math.pow(t, 4.0) + 6.0 * n2 + 8.0 * t2 * n2);
        double u = 0.0 * (61.0 + 662.0 * t2 + 1320.0 * Math.pow(t, 4.0) + 720.0 * Math.pow(t, 6.0));
        double dLat = 0.5 * Math.pow(y_est, 2.0) * t * (1.0 + n2) * (1.0 - p * Math.pow(y_est, 2.0) + q * Math.pow(y_est, 4.0));
        double dLong = y_est / Math.cos(Lat_est_r) * (1.0 - r * Math.pow(y_est, 2.0) + s * Math.pow(y_est, 4.0) - u * Math.pow(y_est, 6.0));
        dLat = Math.toDegrees(dLat);
        dLong = Math.toDegrees(dLong);
        System.out.println("dlong" + dLong);
        System.out.println("dlat" + dLat);
        double Lat = Lat_est - dLat;
        double Long2 = Long0 + dLong;
        double[] output = new double[]{Lat, Long2};
        return output;
    }

    public static double[] convertLatLong2RD(double Lat, double Long2) {
        double x0 = 155000.0;
        double y0 = 463000.0;
        double Lat0 = 52.156160556;
        double Long0 = 5.38763889;
        double dlat = (Lat - Lat0) * 0.36;
        double dlong = (Long2 - Long0) * 0.36;
        double C01 = 190066.98903;
        double C11 = -11830.85831;
        double C21 = -114.19754;
        double C03 = -32.3836;
        double C31 = -2.34078;
        double C13 = -0.60639;
        double C23 = 0.15774;
        double C41 = -0.04158;
        double C05 = -0.00661;
        double D10 = 309020.3181;
        double D02 = 3638.36193;
        double D12 = -157.95222;
        double D20 = 72.97141;
        double D30 = 59.79734;
        double D22 = -6.43481;
        double D04 = 0.09351;
        double D32 = -0.07379;
        double D14 = -0.05419;
        double D40 = -0.03444;
        double dx = C01 * dlong + C11 * dlat * dlong + C21 * Math.pow(dlat, 2.0) * dlong + C03 * Math.pow(dlong, 3.0) + C31 * Math.pow(dlat, 3.0) * dlong + C13 * dlat * Math.pow(dlong, 3.0) + C23 * Math.pow(dlat, 2.0) * Math.pow(dlong, 3.0) + C41 * Math.pow(dlat, 4.0) * dlong + C05 * Math.pow(dlong, 5.0);
        double dy = D10 * dlat + D20 * Math.pow(dlat, 2.0) + D02 * Math.pow(dlong, 2.0) + D12 * dlat * Math.pow(dlong, 2.0) + D30 * Math.pow(dlat, 3.0) + D22 * Math.pow(dlat, 2.0) * Math.pow(dlong, 2.0) + D40 * Math.pow(dlat, 4.0) + D04 * Math.pow(dlong, 4.0) + D32 * Math.pow(dlat, 3.0) * Math.pow(dlong, 2.0) + D14 * dlat * Math.pow(dlong, 4.0);
        double RD_X = x0 + dx;
        double RD_Y = y0 + dy;
        double[] output = new double[]{RD_X, RD_Y};
        return output;
    }

    public static double[] convertRD2LatLong(double x, double y) {
        double x0 = 155000.0;
        double y0 = 463000.0;
        double Lat0 = 52.156160556;
        double Long0 = 5.38763889;
        double dx = (x - x0) * 1.0E-5;
        double dy = (y - y0) * 1.0E-5;
        double A01 = 3236.0331637;
        double A20 = -32.5915821;
        double A02 = -0.2472814;
        double A21 = -0.8501341;
        double A03 = -0.0655238;
        double A22 = -0.0171137;
        double A40 = 0.0052771;
        double A23 = -3.859E-4;
        double A41 = 3.314E-4;
        double A04 = 3.471E-5;
        double A42 = 1.43E-5;
        double A24 = -9.0E-6;
        double B10 = 5261.3028966;
        double B11 = 105.9780241;
        double B12 = 2.4576469;
        double B30 = -0.8192156;
        double B31 = -0.0560092;
        double B13 = 0.0560089;
        double B32 = -0.0025614;
        double B14 = 0.001277;
        double B50 = 2.574E-4;
        double B33 = -9.73E-5;
        double B51 = 2.93E-5;
        double B15 = 2.91E-5;
        double dlat = A01 * dy + A20 * Math.pow(dx, 2.0) + A02 * Math.pow(dy, 2.0) + A21 * Math.pow(dx, 2.0) * dy + A03 * Math.pow(dy, 3.0) + A40 * Math.pow(dx, 4.0) + A22 * Math.pow(dx, 2.0) * Math.pow(dy, 2.0) + A04 * Math.pow(dy, 4.0) + A41 * Math.pow(dx, 4.0) * dy + A23 * Math.pow(dx, 2.0) * Math.pow(dy, 3.0) + A42 * Math.pow(dx, 4.0) * Math.pow(dy, 2.0) + A24 * Math.pow(dx, 2.0) * Math.pow(dy, 4.0);
        double dlong = B10 * dx + B11 * dx * dy + B30 * Math.pow(dx, 3.0) + B12 * dx * Math.pow(dy, 2.0) + B31 * Math.pow(dx, 3.0) * dy + B13 * dx * Math.pow(dy, 3.0) + B50 * Math.pow(dx, 5.0) + B32 * Math.pow(dx, 3.0) * Math.pow(dy, 2.0) + B14 * dx * Math.pow(dy, 4.0) + B51 * Math.pow(dx, 5.0) * dy + B33 * Math.pow(dx, 3.0) * Math.pow(dy, 3.0) + B15 * dx * Math.pow(dy, 5.0);
        double Lat = Lat0 + dlat / 3600.0;
        double Long2 = Long0 + dlong / 3600.0;
        double[] output = new double[]{Lat, Long2};
        return output;
    }

    public static double[] webMercatorToGeographic(double mercatorX, double mercatorY) throws Exception {
        if (mercatorX < -2.00375083427892E7 || mercatorX > 2.00375083427892E7) {
            throw new Exception("Point does not fall within a valid range of the mercator projection.");
        }
        double R = 6378137.0;
        double x = mercatorX;
        double y = mercatorY;
        double lat = Math.toDegrees(2.0 * Math.atan(Math.exp(y / R))) - 90.0;
        double lon = Math.toDegrees(x / R);
        double[] output = new double[]{lat, lon};
        return output;
    }

    public static double[] geographicToWebMercator(double lat, double lon) throws Exception {
        if (lat < -90.0 || lon > 90.0) {
            throw new Exception("Point does not fall within a valid range of a geographic coordinate system. lat: " + lat + "long: " + lon);
        }
        double R = 6378137.0;
        double x = R * Math.toRadians(lon);
        lat = Math.toRadians(lat);
        double y = 0.5 * R * Math.log((1.0 + Math.sin(lat)) / (1.0 - Math.sin(lat)));
        double mercatorX = x;
        double mercatorY = y;
        double[] output = new double[]{mercatorX, mercatorY};
        return output;
    }

    public static double[] convertUTM2WebMercator(double utm_e, double utm_n) throws Exception {
        double[] rd = UTM2RD.convert2RD(utm_e, utm_n);
        double[] latlong = UTM2RD.convertRD2LatLong(rd[0], rd[1]);
        double[] output = UTM2RD.geographicToWebMercator(latlong[0], latlong[1]);
        return output;
    }

    public static double[] convertWebMercator2UTM(double x, double y) throws Exception {
        double[] latlong = UTM2RD.webMercatorToGeographic(x, y);
        double[] rd = UTM2RD.convertLatLong2RD(latlong[0], latlong[1]);
        double[] output = UTM2RD.convert2UTM(rd[0], rd[1]);
        return output;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("== test ==");
        double x = 760430.79;
        double y = 5721326.199;
        double e = 250000.0;
        double n = 400000.0;
        double lat = 52.12345;
        double lon = 5.12345;
        double n1 = 5777015.88;
        double e1 = 645373.51;
        double lat1 = 53.0;
        double lon1 = 6.0;
        double x1 = 196105.2833;
        double y1 = 557057.741;
        double lat2 = 52.1793;
        double lon2 = 5.2149;
        double x2 = 580520.0;
        double y2 = 6832606.0;
        double[] out3 = UTM2RD.convertLatLong2UTM(lat, lon);
        double[] out4 = UTM2RD.convertUTM2LatLong(n1, e1);
        System.out.println(String.valueOf(out3[0]) + " expected: " + n1);
        System.out.println(String.valueOf(out3[1]) + " expected: " + e1);
        System.out.println("=========");
        System.out.println(String.valueOf(out4[0]) + " expected: " + lat);
        System.out.println(String.valueOf(out4[1]) + " expected: " + lon);
    }
}

