/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.properties;

import tno.geoenergy.properties.PropertyFactory;

public class AquiferProperties {
    public static final double SI2MDARCY = 1.0132502738308866E15;
    public static int INX = -1;
    public static int IMINX = -1;
    public static int IMAXX = -1;
    public static int INY = -1;
    public static int IMINY = -1;
    public static int IMAXY = -1;
    public static int INZ = -1;
    public static int IMINZ = -1;
    public static int IMAXZ = -1;
    public static int IMASKGEOM = -1;
    public static int IMODELPRESSURE = -1;
    public static int IMODELTEMPERATURE = -1;
    public static int IMODELDIFTEMPERATURE = -1;
    public static int IINITIALPRESSURE = -1;
    public static int IINITIALTEMPERATURE = -1;
    public static int ISWITCH_PTS_SUBSIDENCE = -1;
    public static int ISWITCH_PTS_VISCOSITY = -1;
    public static int ISWITCH_PTS_DENSITY = -1;
    public static int ISWITCH_STEADYSTATE = -1;
    public static int ISWITCH_PRESSURE_CALC = -1;
    public static int IPERMEABILITYI = -1;
    public static int IPERMEABILITYJ = -1;
    public static int IPERMEABILITYK = -1;
    public static int IOUTPUTMASSBAL = -1;
    public static int IPOROSITY = -1;
    public static int ITHICKNESS = -1;
    public static int IACTNUM = -1;
    public static int ING = -1;
    public static int IVISCOSITY = -1;
    public static int ISUBSIDENCE = -1;
    public static int IDENSITY = -1;
    public static int IREFDENSITY = -1;
    public static int IRHS = -1;
    public static int IBCCODES = -1;
    public static int IDENSITYPSEUDOSOURCEI = -1;
    public static int IDENSITYPSEUDOSOURCEJ = -1;
    public static int IDENSITYPSEUDOSOURCEK = -1;
    public static int ISTORAGECAPACITY = -1;
    public static int IFINITEELEMENTLENGTH = -1;
    public static int ICONNECTXMIN = -1;
    public static int ICONNECTXPLUS = -1;
    public static int ICONNECTYMIN = -1;
    public static int ICONNECTYPLUS = -1;
    public static int ICONNECTZMIN = -1;
    public static int ICONNECTZPLUS = -1;
    public static int IACTNUMFLOW = -1;
    public static int ICONNECTXMINTEMP = -1;
    public static int ICONNECTXPLUSTEMP = -1;
    public static int ICONNECTYMINTEMP = -1;
    public static int ICONNECTYPLUSTEMP = -1;
    public static int ICONNECTZMINTEMP = -1;
    public static int ICONNECTZPLUSTEMP = -1;
    public static int IACTNUMTEMP = -1;
    public static int IROCKDENSITY = -1;
    public static int IROCKHEATCAPACITY = -1;
    public static int IROCKCONDUCTIVITY = -1;
    public static int IWATERCONDUCTIVITY = -1;
    public static int IROCKYOUNGSMODULUS = -1;
    public static int IROCKPOISSONSRATIO = -1;
    public static int IROCKCOMPACTION = -1;
    public static int IROCKTHERMALCOMPACTION = -1;
    public static int IWATERSALINITY = -1;
    public static int IAQUIFERDEPTH = -1;
    public static int IINJECTIONTEMPERATURE = -1;
    public static int ISWITCH_INCLUDEWALL = -1;
    public static int ISWITCH_FIXTEMPTOPBOTTOM = -1;
    public static int ISWITCH_NOFLOWBC = -1;
    public static int ICALC_T_C = -1;
    public static int ICALC_T_OVERC = -1;
    public static int ICALC_T_RATIORHOCP = -1;
    public static int ICALC_T_CONDUC = -1;
    public static int ICALC_T_CONDUCTANCEI = -1;
    public static int ICALC_T_CONDUCTANCEJ = -1;
    public static int ICALC_T_CONDUCTANCEK = -1;
    public static int ICALC_P_OVERC = -1;
    public static int ICALC_P_CONDUCTANCEI = -1;
    public static int ICALC_P_CONDUCTANCEJ = -1;
    public static int ICALC_P_CONDUCTANCEK = -1;
    public static int ICALC_TOTALPRES = -1;
    public static int ICALC_RANFACTORS = -1;
    public static int ILIFETIMECALC = -1;
    public static int ILIFETIMEPROD = -1;
    public static int ITIMESTEP = -1;
    public static int ITIMESTEP_POSTPROD = -1;
    public static int IFILEFORMAT = -1;
    public static int IFILEFORMATVTK = -1;
    public static int IDEBUG_OUTPUT = -1;
    public static int IWELLNAME = -1;
    public static int IWELLX = -1;
    public static int IWELLY = -1;
    public static int IWELLDIAMETER = -1;
    public static int IWELLSKIN = -1;
    public static int IWELLFLOWRATE = -1;
    public static int IWELLTEMP = -1;
    public static int IWELLPRES = -1;
    public static double DEFAULTUNKNOWN = -999.25;

    public static int generateProperty(String name, String units, int geomtype, double defaultvalue) {
        return PropertyFactory.generateProperty(name, units, geomtype, defaultvalue, DEFAULTUNKNOWN, false);
    }

    public static int generateProperty(String name, String units, int geomtype, double defaultvalue, boolean save) {
        return PropertyFactory.generateProperty(name, units, geomtype, defaultvalue, DEFAULTUNKNOWN, save);
    }

    public static int generateProperty(String name, String units, int geomtype, double defaultvalue, double unknown, boolean save) {
        return PropertyFactory.generateProperty(name, units, geomtype, defaultvalue, unknown, save);
    }

    public static void instantiateProperties(int modelgeom) {
        PropertyFactory.clearAllProperties();
        PropertyFactory.setITYPEGEOM(modelgeom);
        int igeom = PropertyFactory.getITYPEGEOM();
        int iscalar = 1;
        int ivector = 5;
        INX = AquiferProperties.generateProperty("nx", "-", iscalar, 50.0, true);
        IMINX = AquiferProperties.generateProperty("xmin", "m", iscalar, 0.0, true);
        IMAXX = AquiferProperties.generateProperty("xmax", "m", iscalar, 5000.0, true);
        INY = AquiferProperties.generateProperty("ny", "-", iscalar, 50.0, true);
        IMINY = AquiferProperties.generateProperty("ymin", "m", iscalar, 0.0, true);
        IMAXY = AquiferProperties.generateProperty("ymax", "m", iscalar, 5000.0, true);
        INZ = AquiferProperties.generateProperty("nz", "-", iscalar, 10.0, true);
        IMINZ = AquiferProperties.generateProperty("zmin", "m", iscalar, 0.0, true);
        IMAXZ = AquiferProperties.generateProperty("zmax", "m", iscalar, 6000.0, true);
        IMASKGEOM = AquiferProperties.generateProperty("grid geometry", "", igeom, 0.0, true);
        IMODELPRESSURE = AquiferProperties.generateProperty("model_pressure", "bar", igeom, 0.0, false);
        IINITIALPRESSURE = AquiferProperties.generateProperty("initial pressure", "bar", igeom, 0.0, false);
        IMODELTEMPERATURE = AquiferProperties.generateProperty("model_temperature", "C", igeom, 65.0, false);
        IMODELDIFTEMPERATURE = AquiferProperties.generateProperty("model_dif_temperature", "C", igeom, 65.0, false);
        IINITIALTEMPERATURE = AquiferProperties.generateProperty("initial temperature", "C", igeom, 65.0, true);
        IPERMEABILITYI = AquiferProperties.generateProperty("permeability in xdir", "mDarcy", igeom, 200.0, true);
        IPERMEABILITYJ = AquiferProperties.generateProperty("permeability in ydir", "mDarcy", igeom, 200.0, true);
        IPERMEABILITYK = AquiferProperties.generateProperty("permeability in zdir", "mDarcy", igeom, 200.0, true);
        IOUTPUTMASSBAL = AquiferProperties.generateProperty("mass balance of cell", "m3/h", igeom, 0.0, false);
        IPOROSITY = AquiferProperties.generateProperty("porosity", "-", igeom, 0.12, true);
        ITHICKNESS = AquiferProperties.generateProperty("(cell) thickness", "m", igeom, 100.0, true);
        IACTNUM = AquiferProperties.generateProperty("actnum", "-", igeom, 1.0, true);
        ICONNECTXMIN = AquiferProperties.generateProperty("connectxmin", "-", igeom, 1.0, false);
        ICONNECTXPLUS = AquiferProperties.generateProperty("connectxplus", "-", igeom, 1.0, false);
        ICONNECTYMIN = AquiferProperties.generateProperty("connectymin", "-", igeom, 1.0, false);
        ICONNECTYPLUS = AquiferProperties.generateProperty("connectyplus", "-", igeom, 1.0, false);
        ICONNECTZMIN = AquiferProperties.generateProperty("connectzmin", "-", igeom, 1.0, false);
        ICONNECTZPLUS = AquiferProperties.generateProperty("connectzplus", "-", igeom, 1.0, false);
        ICONNECTXMINTEMP = AquiferProperties.generateProperty("connectxmin_temp", "-", igeom, 1.0, false);
        ICONNECTXPLUSTEMP = AquiferProperties.generateProperty("connectxplus_temp", "-", igeom, 1.0, false);
        ICONNECTYMINTEMP = AquiferProperties.generateProperty("connectymin_temp", "-", igeom, 1.0, false);
        ICONNECTYPLUSTEMP = AquiferProperties.generateProperty("connectyplus_temp", "-", igeom, 1.0, false);
        ICONNECTZMINTEMP = AquiferProperties.generateProperty("connectzmin_temp", "-", igeom, 1.0, false);
        ICONNECTZPLUSTEMP = AquiferProperties.generateProperty("connectzplus_temp", "-", igeom, 1.0, false);
        IACTNUMTEMP = AquiferProperties.generateProperty("actnumtemp", "-", igeom, 1.0, false);
        IACTNUMFLOW = AquiferProperties.generateProperty("actnumflow", "-", igeom, 1.0, false);
        ING = AquiferProperties.generateProperty("net to gross", "-", igeom, 1.0, true);
        IVISCOSITY = AquiferProperties.generateProperty("viscosity", "Pa s", igeom, 0.001, true);
        ISUBSIDENCE = AquiferProperties.generateProperty("subsidence", "mm", igeom, 0.001, false);
        IDENSITY = AquiferProperties.generateProperty("density", "kg m-3", igeom, 0.001, false);
        IREFDENSITY = AquiferProperties.generateProperty("refdensity", "kg m-3", igeom, 0.001, false);
        IRHS = AquiferProperties.generateProperty("righthandside", "bar", igeom, 0.001, false);
        IBCCODES = AquiferProperties.generateProperty("bccodes", "bar", igeom, 0.001, false);
        IDENSITYPSEUDOSOURCEI = AquiferProperties.generateProperty("densitypseudosource in idir", "bar", igeom, 0.001, false);
        IDENSITYPSEUDOSOURCEJ = AquiferProperties.generateProperty("densitypseudosource in jdir", "bar", igeom, 0.001, false);
        IDENSITYPSEUDOSOURCEK = AquiferProperties.generateProperty("densitypseudosource in kdir", "bar", igeom, 0.001, false);
        ISTORAGECAPACITY = AquiferProperties.generateProperty("storage capacity", "m3 Pa-1", iscalar, 1.0E-9, true);
        IFINITEELEMENTLENGTH = AquiferProperties.generateProperty("finite element length scale", "times dx dy", iscalar, 1000.0, false);
        IROCKDENSITY = AquiferProperties.generateProperty("rock density", "kg m-3", iscalar, 2700.0, true);
        IROCKHEATCAPACITY = AquiferProperties.generateProperty("heat capacity", "J kg-1 K-1", iscalar, 1000.0, true);
        IROCKCONDUCTIVITY = AquiferProperties.generateProperty("rock conductivity", "W K-1 m-1", iscalar, 4.0, true);
        IWATERCONDUCTIVITY = AquiferProperties.generateProperty("water conductivity", "W K-1 m-1", iscalar, 0.6, true);
        IWATERSALINITY = AquiferProperties.generateProperty("water salinity", "ppm", iscalar, 70000.0, true);
        IROCKYOUNGSMODULUS = AquiferProperties.generateProperty("Young's modulus", "Pa", iscalar, 9.0E9, true);
        IROCKPOISSONSRATIO = AquiferProperties.generateProperty("Poisson's ratio", "-", iscalar, 0.35, true);
        IROCKCOMPACTION = AquiferProperties.generateProperty("compaction coefficient", "bar-1", iscalar, 1.0E-5, true);
        IROCKTHERMALCOMPACTION = AquiferProperties.generateProperty("thermal compaction coefficient", "C-1", iscalar, 2.0E-5, true);
        IAQUIFERDEPTH = AquiferProperties.generateProperty("aquifer depth", "m", 2, 1500.0, true);
        IINJECTIONTEMPERATURE = AquiferProperties.generateProperty("injection temperature", "C", iscalar, 35.0, true);
        ISWITCH_INCLUDEWALL = AquiferProperties.generateProperty("cooling 3D", "-", iscalar, 0.0, true);
        ISWITCH_FIXTEMPTOPBOTTOM = AquiferProperties.generateProperty("fix temperatures top/bottom", "-", iscalar, 0.0, true);
        ISWITCH_NOFLOWBC = AquiferProperties.generateProperty("no flow boundary", "-", iscalar, 1.0, true);
        ICALC_T_C = AquiferProperties.generateProperty("reservoir heat capacity", "J m-3 K-1", igeom, 2700000.0, false);
        ICALC_T_OVERC = AquiferProperties.generateProperty("reciprocal heat capacity of cell volumes", "J-1 K", igeom, 1.0E-6, false);
        ICALC_T_RATIORHOCP = AquiferProperties.generateProperty("ration water CP and reservoir CP", "-", igeom, 1.0E-6, false);
        ICALC_T_CONDUC = AquiferProperties.generateProperty("bulk_conductivity", "W K-1 m-1", igeom, 1000000.0, false);
        ICALC_T_CONDUCTANCEI = AquiferProperties.generateProperty("conductance in idir", "W K-1", igeom, 1000000.0, false);
        ICALC_T_CONDUCTANCEJ = AquiferProperties.generateProperty("conductance in jdir", "W K-1", igeom, 1000000.0, false);
        ICALC_T_CONDUCTANCEK = AquiferProperties.generateProperty("conductance in kdir", "W K-1", igeom, 1000000.0, false);
        ICALC_P_OVERC = AquiferProperties.generateProperty("reciprocal storage capacity of cell volumes", "m-3 bar-1", igeom, 1.0E9, false);
        ICALC_P_CONDUCTANCEI = AquiferProperties.generateProperty("conductance in idir", "m3/s bar-1", igeom, 1000000.0, false);
        ICALC_P_CONDUCTANCEJ = AquiferProperties.generateProperty("conductance in jdir", "m3/s bar-1", igeom, 1000000.0, false);
        ICALC_P_CONDUCTANCEK = AquiferProperties.generateProperty("conductance in kdir", "m3/s bar-1", igeom, 1000000.0, false);
        ICALC_RANFACTORS = AquiferProperties.generateProperty("multiplication numbers for permeability", "-", igeom, 1.0, false);
        ICALC_TOTALPRES = AquiferProperties.generateProperty("total pressure", "bar", igeom, 0.0, false);
        ISWITCH_PTS_SUBSIDENCE = AquiferProperties.generateProperty("calculate subsidence", "-", iscalar, 0.0, true);
        ISWITCH_PTS_VISCOSITY = AquiferProperties.generateProperty("temperature dependent viscosity", "-", iscalar, 1.0, true);
        ISWITCH_PTS_DENSITY = AquiferProperties.generateProperty("temperature dependent density", "-", iscalar, 1.0, true);
        ISWITCH_STEADYSTATE = AquiferProperties.generateProperty("steady state calculation", "-", iscalar, 1.0, false);
        ISWITCH_PRESSURE_CALC = AquiferProperties.generateProperty("pressure constraint", "-", iscalar, 0.0, true);
        ILIFETIMECALC = AquiferProperties.generateProperty("time end analysis", "yrs", iscalar, 15.0, true);
        ILIFETIMEPROD = AquiferProperties.generateProperty("time end production", "yrs", iscalar, 15.0, true);
        ITIMESTEP = AquiferProperties.generateProperty("output interval", "yrs", iscalar, 1.0, true);
        ITIMESTEP_POSTPROD = AquiferProperties.generateProperty("output/calculation interval after production", "yrs", iscalar, 250.0, true);
        IFILEFORMAT = AquiferProperties.generateProperty("output fileformat", "-", iscalar, 0.0, true);
        IFILEFORMATVTK = AquiferProperties.generateProperty("output VTK (ParaView) fileformat", "-", iscalar, 0.0, true);
        IDEBUG_OUTPUT = AquiferProperties.generateProperty("write debug output grids", "-", iscalar, 0.0, true);
        IWELLX = AquiferProperties.generateProperty("x", "m", ivector, 0.0, true);
        IWELLY = AquiferProperties.generateProperty("y", "m", ivector, 0.0, true);
        IWELLDIAMETER = AquiferProperties.generateProperty("well diameter", "inch", ivector, 7.0, true);
        IWELLSKIN = AquiferProperties.generateProperty("well skin", "-", ivector, 0.0, true);
        IWELLFLOWRATE = AquiferProperties.generateProperty("well flow rate", "m3/h", ivector, 160.0, true);
        IWELLTEMP = AquiferProperties.generateProperty("well (inj) temperature", "C", ivector, 30.0, true);
        IWELLPRES = AquiferProperties.generateProperty("well excess pressure", "bar", ivector, 30.0, true);
    }
}

