/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.properties;

import tno.geoenergy.data.SmartGrid;
import tno.geoenergy.fdintegration.model.ModelGrid;
import tno.geoenergy.properties.AquiferProperties;
import tno.geoenergy.properties.Property;

public class Grid2DProperty
extends Property {
    SmartGrid input = null;
    boolean usegrid = false;
    double[][] values = null;
    int nx;
    int ny;
    double orx;
    double ory;
    double dx;
    double dy;
    double unknown;
    ModelGrid geometry = null;

    public Grid2DProperty(String name, String units, ModelGrid g, double defaultValue, double unknown, boolean save) {
        super(name, units, g, defaultValue, save);
        this.unknown = unknown;
    }

    @Override
    public void initialize() {
        if (this.ientry == AquiferProperties.IINITIALTEMPERATURE) {
            boolean bl = true;
        }
        this.geometry = this.geom;
        if (this.geometry != null) {
            this.nx = this.geometry.getNx();
            this.ny = this.geometry.getNy();
            this.orx = this.geometry.getOrx();
            this.ory = this.geometry.getOry();
            this.dx = this.geometry.getDx();
            this.dy = this.geometry.getDy();
            this.values = new double[this.nx][this.ny];
            if (this.usegrid && this.input != null) {
                int i = 0;
                while (i < this.nx) {
                    int j = 0;
                    while (j < this.ny) {
                        float f = this.input.m_Grid.getValueAtxy((float)(this.orx + (double)i * this.dx), (float)(this.ory + (double)j * this.dy));
                        this.values[i][j] = this.input.m_Grid.defined(f) ? (double)f : this.unknown;
                        ++j;
                    }
                    ++i;
                }
            } else {
                this.setValue(this.defaultvalue);
            }
        }
    }

    public double[][] getValues() {
        return this.values;
    }

    public void setValues(double[][] values) {
        this.values = values;
    }

    public void setValue(double value) {
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                this.values[i][j] = value;
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void setValue(int ii, int jj, int kk, double d) {
        this.values[ii][jj] = d;
    }

    @Override
    public double getValue(int i, int j, int k) {
        return this.values[i][j];
    }

    public SmartGrid getGridValues() {
        SmartGrid grid = new SmartGrid();
        grid.values = new float[this.nx][this.ny];
        grid.originx = (float)this.orx;
        grid.originy = (float)this.ory;
        grid.dx = (float)this.dx;
        grid.dy = (float)this.dy;
        grid.nx = this.nx;
        grid.ny = this.ny;
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                grid.values[i][j] = (float)this.values[i][j];
                ++j;
            }
            ++i;
        }
        grid.m_Grid.originx = grid.originx;
        grid.m_Grid.originy = grid.originy;
        grid.m_Grid.dx = grid.dx;
        grid.m_Grid.dy = grid.dy;
        grid.m_Grid.nx = grid.nx;
        grid.m_Grid.ny = grid.ny;
        grid.m_Grid.values = grid.values;
        grid.m_Grid.unknown = -999.25f;
        return grid;
    }

    public SmartGrid getInput() {
        return this.input;
    }

    public void setInput(SmartGrid input) {
        this.input = input;
    }

    public boolean isUsegrid() {
        return this.usegrid;
    }

    public void setUsegrid(boolean usegrid) {
        this.usegrid = usegrid;
    }
}

