/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.properties;

import tno.geoenergy.data.SmartGrid;
import tno.geoenergy.data.SmartVoxet;
import tno.geoenergy.fdintegration.model.ModelGrid;
import tno.geoenergy.fdintegration.model.model3d.Grid3D;
import tno.geoenergy.properties.AquiferProperties;
import tno.geoenergy.properties.Property;

public class Grid3DProperty
extends Property {
    SmartVoxet input = null;
    boolean usegrid = false;
    double[][][] values = null;
    int nx;
    int ny;
    int nz;
    double orx;
    double ory;
    double orz;
    double dx;
    double dy;
    double dz;
    Grid3D geometry = null;

    public Grid3DProperty(String name, String units, ModelGrid g, double defaultValue, boolean save) {
        super(name, units, g, defaultValue, save);
    }

    @Override
    public void initialize() {
        if (this.ientry == AquiferProperties.IINITIALTEMPERATURE) {
            boolean bl = true;
        }
        this.geometry = (Grid3D)this.geom;
        if (this.geometry != null) {
            this.nx = this.geometry.getNx();
            this.ny = this.geometry.getNy();
            this.nz = this.geometry.getNz();
            this.orx = this.geometry.getOrx();
            this.ory = this.geometry.getOry();
            this.orz = this.geometry.getOrz();
            this.dx = this.geometry.getDx();
            this.dy = this.geometry.getDy();
            this.dz = Double.isInfinite(this.geometry.getDz()) ? 0.0 : this.geometry.getDz();
            this.values = new double[this.nx][this.ny][this.nz];
            if (this.usegrid && this.input != null) {
                System.out.println(String.valueOf(this.getName()) + " has an input voxet " + this.input.getVoxet().getFileNamePath());
                int i = 0;
                while (i < this.nx) {
                    int j = 0;
                    while (j < this.ny) {
                        int k = 0;
                        while (k < this.nz) {
                            this.values[i][j][k] = this.input.getVoxet().getCellValueXyzConstantXYZ(this.orx + (double)i * this.dx, this.ory + (double)j * this.dy, this.orz + (double)k * this.dz);
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                this.setValue(this.defaultvalue);
            }
        }
    }

    public double[][][] getValues() {
        return this.values;
    }

    public void setValues(double[][][] values) {
        this.values = values;
    }

    public void setValue(double value) {
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                int k = 0;
                while (k < this.nz) {
                    this.values[i][j][k] = value;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public double getValue(int i, int j, int k) {
        return this.values[i][j][k];
    }

    @Override
    public void setValue(int ii, int jj, int kk, double d) {
        this.values[ii][jj][kk] = d;
    }

    public SmartGrid getGridValues(int k) {
        SmartGrid grid = new SmartGrid();
        grid.values = new float[this.nx][this.ny];
        grid.originx = (float)this.orx;
        grid.originy = (float)this.ory;
        grid.dx = (float)this.dx;
        grid.dy = (float)this.dy;
        grid.nx = this.nx;
        grid.ny = this.ny;
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                grid.values[i][j] = (float)this.values[i][j][k];
                ++j;
            }
            ++i;
        }
        grid.m_Grid.originx = grid.originx;
        grid.m_Grid.originy = grid.originy;
        grid.m_Grid.dx = grid.dx;
        grid.m_Grid.dy = grid.dy;
        grid.m_Grid.nx = grid.nx;
        grid.m_Grid.ny = grid.ny;
        grid.m_Grid.values = grid.values;
        grid.m_Grid.unknown = -999.25f;
        return grid;
    }

    public SmartVoxet getInput() {
        return this.input;
    }

    public void setInput(SmartVoxet input) {
        this.input = input;
    }

    public boolean isUsegrid() {
        return this.usegrid;
    }

    public void setUsegrid(boolean usegrid) {
        this.usegrid = usegrid;
    }
}

