/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.properties;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import tno.geoenergy.data.Grid;
import tno.geoenergy.data.SmartGrid;
import tno.geoenergy.data.SmartVoxet;
import tno.geoenergy.data.Voxet;
import tno.geoenergy.data.VoxetWriter;
import tno.geoenergy.fdintegration.model.ModelGrid;
import tno.geoenergy.fdintegration.model.model2d.Grid2Dregular;
import tno.geoenergy.geothermalaquifer.gui.components.GuiProperty;
import tno.geoenergy.geothermalaquifer.gui.components.GuiWellProperty;
import tno.geoenergy.logging.Logger;
import tno.geoenergy.properties.Grid1DProperty;
import tno.geoenergy.properties.Grid2DProperty;
import tno.geoenergy.properties.Grid3DProperty;
import tno.geoenergy.properties.Property;
import tno.geoenergy.properties.WellProperty;

public class PropertyFactory {
    private static Logger logger = Logger.getLogger(Grid2Dregular.class.getName());
    public static final int SURFER = 0;
    public static final int ARCINFO = 1;
    public static final int ZYCOR = 2;
    public static final int GMT = 3;
    public static final int CSV = 4;
    public static final String[] GRIDEXTENSION = new String[]{".grd", ".asc", ".dat", ".txt", ".csv"};
    public static final String[] GRIDDATAFORMAT = new String[]{"SURFER", "ARC", "ZYCOR", "GMT", "CSV"};
    public static final int ISCALAR = 1;
    public static final int IGRID2D = 2;
    public static final int IGRID3D = 3;
    public static final int IGRID1D = 4;
    public static final int IVECTOR = 5;
    private static int ITYPEGEOM = 2;
    private static int ITYPEVECTOR = 2;
    private static Vector ALLPROPERTIES = new Vector();

    public static int getITYPEGEOM() {
        return ITYPEGEOM;
    }

    public static void setITYPEGEOM(int iTYPEGEOM) {
        ITYPEGEOM = iTYPEGEOM;
    }

    public static int getITYPEVECTOR() {
        return ITYPEVECTOR;
    }

    public static void setITYPEVECTOR(int iTYPEVECTOR) {
        ITYPEVECTOR = iTYPEVECTOR;
    }

    public static void printAllProperties() {
        Property p = null;
        int i = 0;
        while (i < ALLPROPERTIES.size()) {
            p = PropertyFactory.getProperty(i);
            System.out.println(String.valueOf(p.getName()) + " " + p.getDefaultvalue());
            ++i;
        }
    }

    public static int addProperty(Property p) {
        int i = ALLPROPERTIES.size();
        ALLPROPERTIES.add(p);
        return i;
    }

    public static Property getProperty(int i) {
        if (i >= 0 && i < ALLPROPERTIES.size()) {
            return (Property)ALLPROPERTIES.get(i);
        }
        logger.error("index out of bound " + i);
        return null;
    }

    public static Vector getALLPROPERTIES() {
        return ALLPROPERTIES;
    }

    public static void clearAllProperties() {
        ALLPROPERTIES.clear();
    }

    public static Property findProperty(String name) {
        Property p = null;
        int i = 0;
        while (i < ALLPROPERTIES.size()) {
            p = PropertyFactory.getProperty(i);
            if (p.getName().equals(name)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public static Property findPropertyByTag(String node) {
        Property p = null;
        int i = 0;
        while (i < ALLPROPERTIES.size()) {
            p = PropertyFactory.getProperty(i);
            if (p.getTag().equals(node)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public static void updateGeometry(ModelGrid g) {
        int i = 0;
        while (i < ALLPROPERTIES.size()) {
            PropertyFactory.getProperty(i).updateGeometry(g);
            ++i;
        }
    }

    public static void updateVector() {
        int i = 0;
        while (i < ALLPROPERTIES.size()) {
            PropertyFactory.getProperty(i).updateVector();
            ++i;
        }
    }

    public static int generateProperty(String name, String units, int geomtype, double defaultValue, double unknown, boolean save) {
        Property p = geomtype == 1 ? new Property(name, units, null, defaultValue, save) : (geomtype == 4 ? new Grid1DProperty(name, units, null, defaultValue, save) : (geomtype == 2 ? new Grid2DProperty(name, units, null, defaultValue, unknown, save) : (geomtype == 3 ? new Grid3DProperty(name, units, null, defaultValue, save) : (geomtype == 5 ? new WellProperty(name, units, null, defaultValue, save) : new Property(name, units, null, defaultValue, save)))));
        return p.getIentry();
    }

    public static double[][] getValues(Property p) {
        if (p instanceof Grid2DProperty) {
            return ((Grid2DProperty)p).getValues();
        }
        logger.error("can not retrieve values[][] in property" + p.getName());
        return null;
    }

    public static void setValues(Property p, double[][] values) {
        if (p instanceof Grid2DProperty) {
            ((Grid2DProperty)p).setValues(values);
        } else {
            logger.error("can not fill values[][] in property" + p.getName());
        }
    }

    public static void setGuiProperty(Property p, GuiProperty gp) {
        gp.updatePropertyFromGui();
        p.setDefaultValue(new Double(gp.value));
        if (p instanceof Grid2DProperty) {
            ((Grid2DProperty)p).setUsegrid(gp.useGrid);
            SmartGrid grid = null;
            if (!gp.filename.equals("none")) {
                grid = new SmartGrid(gp.filename, new File(gp.filename).getName());
                ((Grid2DProperty)p).setInput(grid);
            }
        } else if (p instanceof Grid3DProperty) {
            ((Grid3DProperty)p).setUsegrid(gp.useGrid);
            SmartVoxet vox = null;
            if (!gp.filename.equals("none")) {
                vox = new SmartVoxet(gp.filename, new File(gp.filename).getName());
                ((Grid3DProperty)p).setInput(vox);
            }
        }
    }

    public static void setGuiProperty(Property p, GuiWellProperty gwp) {
        if (p instanceof WellProperty) {
            gwp.updatePropertyFromGui();
            double[] res = new double[ITYPEVECTOR];
            int i = 0;
            while (i < ITYPEVECTOR) {
                res[i] = new Double(gwp.value[i]);
                ++i;
            }
            ((WellProperty)p).setValues(res);
        }
    }

    public static GuiProperty getGuiProperty(Property p) {
        String t = new Double(p.getDefaultvalue()).toString();
        String f = "none";
        boolean u = false;
        String n = p.getName();
        String unit = p.getUnits();
        if (p instanceof Grid2DProperty) {
            u = ((Grid2DProperty)p).isUsegrid();
            if (((Grid2DProperty)p).getInput() != null) {
                f = ((Grid2DProperty)p).getInput().getPath();
            }
        }
        return new GuiProperty(t, f, u, n, unit);
    }

    public static void setGuiProperty(Property p, double value) {
        p.setDefaultValue(value);
    }

    public static String getPropertyResultTag(Property p) {
        String res = "";
        if (p instanceof WellProperty) {
            double[] pres = ((WellProperty)p).getValues();
            int i = 0;
            while (i < pres.length) {
                res = String.valueOf(res) + pres[i] + " ";
                ++i;
            }
        } else {
            res = "" + p.getDefaultvalue();
            if (p instanceof Grid2DProperty) {
                int k = 0;
                if (((Grid2DProperty)p).isUsegrid()) {
                    k = 1;
                }
                String name = "none";
                if (((Grid2DProperty)p).getInput() != null && (name = ((Grid2DProperty)p).getInput().getPath()).contains(" ")) {
                    name = String.valueOf('\"') + name + '\"';
                }
                res = String.valueOf(p.getDefaultvalue()) + " " + k + " " + name;
            } else if (p instanceof Grid3DProperty) {
                int k = 0;
                if (((Grid3DProperty)p).isUsegrid()) {
                    k = 1;
                }
                String name = "none";
                if (((Grid3DProperty)p).getInput() != null && (name = ((Grid3DProperty)p).getInput().getPath()).contains(" ")) {
                    name = String.valueOf('\"') + name + '\"';
                }
                res = String.valueOf(p.getDefaultvalue()) + " " + k + " " + name;
            }
        }
        return res;
    }

    public static void setPropertyResultTag(String tag, String input) throws IOException {
        Property prop = PropertyFactory.findPropertyByTag(tag);
        if (prop != null) {
            if (prop instanceof WellProperty) {
                String[] splitinput = input.split(" ");
                PropertyFactory.setITYPEVECTOR(splitinput.length);
                double[] res = new double[ITYPEVECTOR];
                int i = 0;
                while (i < ITYPEVECTOR) {
                    res[i] = Double.parseDouble(splitinput[i]);
                    ++i;
                }
                ((WellProperty)prop).setValues(res);
            } else {
                String[] splitinput = input.split(" ", 3);
                prop.setDefaultValue(Double.parseDouble(splitinput[0]));
                if (prop instanceof Grid2DProperty) {
                    ((Grid2DProperty)prop).setUsegrid(Double.parseDouble(splitinput[1]) >= 1.0);
                    String gridname = splitinput[2];
                    SmartGrid grid = null;
                    if (!gridname.equals("none")) {
                        gridname = gridname.replace("\"", "");
                        grid = new SmartGrid(gridname, new File(gridname).getName());
                    }
                    ((Grid2DProperty)prop).setInput(grid);
                } else if (prop instanceof Grid3DProperty) {
                    ((Grid3DProperty)prop).setUsegrid(Double.parseDouble(splitinput[1]) >= 1.0);
                    String gridname = splitinput[2];
                    SmartVoxet vox = null;
                    if (!gridname.equals("none")) {
                        gridname = gridname.replace("\"", "");
                        vox = new SmartVoxet(gridname, new File(gridname).getName());
                    }
                    ((Grid3DProperty)prop).setInput(vox);
                }
            }
        }
    }

    public static void outputGrid(Property property, String dir, String name, int format) {
        SmartGrid grid = null;
        String fname = String.valueOf(dir) + "\\" + name;
        if (property instanceof Grid2DProperty) {
            grid = ((Grid2DProperty)property).getGridValues();
            grid.m_Grid.setFileName(String.valueOf(fname) + GRIDEXTENSION[format]);
            grid.m_Grid.setDataFormat(GRIDDATAFORMAT[format]);
            try {
                grid.m_Grid.write();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void outputGrid(Property property, String dir, String name, int format, int k) {
        SmartGrid grid = null;
        String fname = String.valueOf(dir) + name;
        if (property instanceof Grid3DProperty) {
            grid = ((Grid3DProperty)property).getGridValues(k);
            grid.m_Grid.setFileName(String.valueOf(fname) + GRIDEXTENSION[format]);
            grid.m_Grid.setDataFormat(GRIDDATAFORMAT[format]);
            try {
                grid.m_Grid.write();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static int getAllPropertySize() {
        return ALLPROPERTIES.size();
    }

    public static void setDefaultGridValues(Property property, SmartGrid grid) {
        if (property instanceof Grid2DProperty) {
            Grid2DProperty prop = (Grid2DProperty)property;
            prop.setInput(grid);
            prop.setUsegrid(true);
        }
    }

    public static void setDefaultGridValues(Property property, SmartVoxet vox) {
        if (property instanceof Grid3DProperty) {
            Grid3DProperty prop = (Grid3DProperty)property;
            prop.setInput(vox);
            prop.setUsegrid(true);
        }
    }

    public static double[][] getValues(Property p, double[][] v) {
        if (p instanceof Grid2DProperty) {
            return ((Grid2DProperty)p).getValues();
        }
        logger.error("can not retrieve values[][] in property " + p.getName());
        return null;
    }

    public static double[][][] getValues(Property p, double[][][] v) {
        if (p instanceof Grid3DProperty) {
            Grid3DProperty pg = (Grid3DProperty)p;
            int nx = pg.getGeom().getNx();
            int ny = pg.getGeom().getNy();
            int nz = pg.getGeom().getNz();
            return pg.getValues();
        }
        logger.error("can not retrieve values[][][] in property " + p.getName());
        return null;
    }

    public static Voxet getVoxet(String dir, String voxetname, ModelGrid g, double[][][] values) {
        Voxet voxet = new Voxet();
        voxet.setFileName(String.valueOf(dir) + "/" + voxetname);
        voxet.setOriginx((float)g.getOrx());
        voxet.setOriginy((float)g.getOry());
        voxet.setOriginz((float)g.getOrz());
        voxet.setDx((float)g.getDx());
        voxet.setDy((float)g.getDy());
        voxet.setDz((float)g.getDz());
        voxet.setNx(g.getNx());
        voxet.setNy(g.getNy());
        voxet.setNz(g.getNz());
        voxet.setUnknown(-999.25f);
        voxet.setPropName(voxetname);
        float[][][] voval = new float[voxet.getNz()][voxet.getNy()][voxet.getNx()];
        voxet.setValues(voval);
        int i = 0;
        while (i < voxet.getNx()) {
            int j = 0;
            while (j < voxet.getNy()) {
                int k = 0;
                while (k < voxet.getNz()) {
                    voxet.getValues()[k][j][i] = (float)values[i][j][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return voxet;
    }

    public static double[][][] writeVoxet(int iprop, String dir, String voxetname, ModelGrid g, double[][][] val) {
        val = PropertyFactory.getValues(PropertyFactory.getProperty(iprop), val);
        Voxet v = PropertyFactory.getVoxet(dir, voxetname, g, val);
        VoxetWriter.write(v);
        return val;
    }

    public static Grid getGrid(String gridname, double orx, double ory, double dx, double dy, double unknown, float[][] values) {
        Grid grid = new Grid();
        int nx = values.length;
        int ny = values[0].length;
        grid.values = values;
        grid.originx = (float)orx;
        grid.originy = (float)ory;
        grid.dx = (float)dx;
        grid.dy = (float)dy;
        grid.nx = nx;
        grid.ny = ny;
        grid.setDataFormat("SURFER");
        grid.setFileName(gridname);
        grid.unknown = (float)unknown;
        return grid;
    }

    public static void write(int iprop, String dir, String name, ModelGrid g, int iformat) {
        Property p = PropertyFactory.getProperty(iprop);
        if (p instanceof Grid2DProperty) {
            PropertyFactory.outputGrid(p, dir, name, iformat);
        } else if (p instanceof Grid3DProperty) {
            double[][][] val = null;
            val = PropertyFactory.getValues(p, val);
            PropertyFactory.writeVoxet(iprop, dir, name, g, val);
        }
    }
}

