/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.stochastic;

import tno.geoenergy.stochastic.TnoDistributionVariable;

public class TnoDistributionVarNormal
extends TnoDistributionVariable {
    public static double SD_PVALUE = 0.1587;

    public TnoDistributionVarNormal(double min, double median, double max) {
        super(min, median, max);
    }

    public TnoDistributionVarNormal(double min, double median, double max, int seed) {
        super(min, median, max);
    }

    public void setParameters(double mean, double sd) {
        this.a = mean;
        this.b = sd;
    }

    @Override
    public void setParameters(double mean, double sd, double nomeaning) {
        this.setParameters(mean, sd);
    }

    @Override
    public double PDF(double x) {
        return 0.0;
    }

    @Override
    public double CDF(double x) {
        return 0.0;
    }

    @Override
    public double NextValue() {
        double s = this.randomNumber.nextGaussian();
        s = s * this.b + this.a;
        return s;
    }

    @Override
    public double[] generateSamples(int numSamples) {
        double[] samples = new double[numSamples];
        int r = 0;
        int[] hussle = new int[numSamples];
        hussle = this.createRandomIndexArray(numSamples);
        int comp = 0;
        while (comp < numSamples) {
            double sample = this.NextValue();
            samples[hussle[r++]] = sample;
            ++comp;
        }
        return samples;
    }

    private int[] createRandomIndexArray(int numSamples) {
        int swapValue;
        int randomIndex2;
        int randomIndex1;
        int[] index = new int[numSamples];
        int i = 0;
        while (i < numSamples) {
            index[i] = i;
            ++i;
        }
        i = 0;
        while (i < numSamples) {
            randomIndex1 = i;
            randomIndex2 = (int)Math.floor(this.randomNumber.nextDouble() * (double)numSamples);
            if (randomIndex1 < 0) {
                randomIndex1 = 0;
            }
            if (randomIndex2 > numSamples) {
                randomIndex2 = numSamples;
            }
            swapValue = index[randomIndex1];
            index[randomIndex1] = index[randomIndex2];
            index[randomIndex2] = swapValue;
            ++i;
        }
        i = 0;
        while (i < numSamples) {
            randomIndex1 = numSamples - i - 1;
            randomIndex2 = (int)Math.floor(this.randomNumber.nextDouble() * (double)numSamples);
            if (randomIndex1 < 0) {
                randomIndex1 = 0;
            }
            if (randomIndex2 > numSamples) {
                randomIndex2 = numSamples;
            }
            swapValue = index[randomIndex1];
            index[randomIndex1] = index[randomIndex2];
            index[randomIndex2] = swapValue;
            ++i;
        }
        return index;
    }
}

