/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.stochastic;

import java.util.Random;
import tno.geoenergy.stochastic.TnoDistributionVariable;

public class TnoDistributionVarTriangular
extends TnoDistributionVariable {
    public static double SD_PVALUE = 0.1587;

    public TnoDistributionVarTriangular(double min, double median, double max) {
        super(min, median, max);
    }

    public TnoDistributionVarTriangular(double min, double median, double max, int seed) {
        super(min, median, max);
    }

    public void setParameters(double min, double median, double max, String name) {
        if (!(min >= median) && !(median >= max)) {
            this.a = min;
            this.b = median;
            this.c = max;
            this.mean = 0.0;
            this.mean = this.a == this.b ? (this.mean += 0.5 * this.b) : (this.mean += 1.0 / (6.0 * (this.b - this.a) * (this.b - this.a)) * (2.0 * this.b * this.b * this.b - 3.0 * this.a * this.b * this.b + this.a * this.a * this.a));
            this.mean = this.b == this.c ? (this.mean += 0.5 * this.b) : (this.mean += 1.0 / (6.0 * (this.c - this.b) * (this.c - this.b)) * (2.0 * this.b * this.b * this.b - 3.0 * this.c * this.b * this.b + this.c * this.c * this.c));
        }
    }

    @Override
    public void setParameters(double min, double median, double max) {
        this.setParameters(min, median, max, null);
    }

    public void setParameters(double min, double median, double max, String name, int seed) {
        this.randomNumber = new Random(seed);
        this.setParameters(min, median, max, name);
    }

    public void SetParameters(double min, double median, double max, int seed) {
        this.setParameters(min, median, max, null, seed);
    }

    @Override
    public double PDF(double x) {
        double pdf = x < this.a ? 0.0 : (x < this.b ? (x - this.a) / ((this.b - this.a) * (this.b - this.a)) : (x == this.b ? 0.5 * ((x - this.a) / ((this.b - this.a) * (this.b - this.a)) + (this.c - x) / ((this.c - this.b) * (this.c - this.b))) : (x < this.c ? (this.c - x) / ((this.c - this.b) * (this.c - this.b)) : 0.0)));
        return pdf;
    }

    @Override
    public double CDF(double x) {
        double cdf = x < this.a ? 0.0 : (x < this.b ? 0.5 * (x - this.a) * (x - this.a) / ((this.b - this.a) * (this.b - this.a)) : (x == this.b ? 0.5 : (x < this.c ? 1.0 - 0.5 * (this.c - x) * (this.c - x) / ((this.c - this.b) * (this.c - this.b)) : 1.0)));
        return cdf;
    }

    @Override
    public double NextValue() {
        double s = this.randomNumber.nextDouble();
        if (s < 0.5) {
            return this.a + (this.b - this.a) * Math.sqrt(2.0 * s);
        }
        if (s == 0.5) {
            return this.b;
        }
        return this.c - (this.c - this.b) * Math.sqrt(2.0 * (1.0 - s));
    }

    public void constructACFromP10P90(double p10, double p90, boolean minzero) {
        this.a = (p90 - this.b * Math.sqrt(0.2)) / (1.0 - Math.sqrt(0.2));
        if (minzero) {
            this.a = Math.max(0.0, this.a);
        }
        this.c = (p10 - this.b * Math.sqrt(0.2)) / (1.0 - Math.sqrt(0.2));
    }

    public void constructACFromPSD(double pluspsd, double minpsd, boolean minzero) {
        this.a = (minpsd - this.b * Math.sqrt(2.0 * SD_PVALUE)) / (1.0 - Math.sqrt(2.0 * SD_PVALUE));
        if (minzero) {
            this.a = Math.max(0.0, this.a);
        }
        this.c = (pluspsd - this.b * Math.sqrt(2.0 * SD_PVALUE)) / (1.0 - Math.sqrt(2.0 * SD_PVALUE));
        System.out.println("STDEV (a2+b2+c2 -ab-ac-bc)/18 :" + Math.sqrt((this.a * this.a + this.b * this.b + this.c * this.c - this.a * this.b - this.a * this.c - this.b * this.c) / 18.0));
    }

    @Override
    public double[] generateSamples(int numSamples) {
        double[] samples = new double[numSamples];
        int r = 0;
        int[] hussle = new int[numSamples];
        hussle = this.createRandomIndexArray(numSamples);
        int comp = 0;
        while (comp < numSamples) {
            double sample = ((double)comp + this.randomNumber.nextDouble()) / ((double)numSamples * 1.0);
            samples[hussle[r++]] = this.getPDF_Value(sample);
            ++comp;
        }
        return samples;
    }

    private double getPDF_Value(double s) {
        if (s < 0.5) {
            if (this.b - this.a < 1.0E-20) {
                return this.a;
            }
            return this.a + (this.b - this.a) * Math.sqrt(2.0 * s);
        }
        if (s == 0.5) {
            return this.b;
        }
        if (this.c - this.b < 1.0E-20) {
            return this.b;
        }
        return this.c - (this.c - this.b) * Math.sqrt(2.0 * (1.0 - s));
    }

    private int[] createRandomIndexArray(int numSamples) {
        int swapValue;
        int randomIndex2;
        int randomIndex1;
        int[] index = new int[numSamples];
        int i = 0;
        while (i < numSamples) {
            index[i] = i;
            ++i;
        }
        i = 0;
        while (i < numSamples) {
            randomIndex1 = i;
            randomIndex2 = (int)Math.floor(this.randomNumber.nextDouble() * (double)numSamples);
            if (randomIndex1 < 0) {
                randomIndex1 = 0;
            }
            if (randomIndex2 > numSamples) {
                randomIndex2 = numSamples;
            }
            swapValue = index[randomIndex1];
            index[randomIndex1] = index[randomIndex2];
            index[randomIndex2] = swapValue;
            ++i;
        }
        i = 0;
        while (i < numSamples) {
            randomIndex1 = numSamples - i - 1;
            randomIndex2 = (int)Math.floor(this.randomNumber.nextDouble() * (double)numSamples);
            if (randomIndex1 < 0) {
                randomIndex1 = 0;
            }
            if (randomIndex2 > numSamples) {
                randomIndex2 = numSamples;
            }
            swapValue = index[randomIndex1];
            index[randomIndex1] = index[randomIndex2];
            index[randomIndex2] = swapValue;
            ++i;
        }
        return index;
    }
}

