/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.stochastic;

import java.util.Random;
import tno.geoenergy.stochastic.TnoDistributionObject;

public abstract class TnoDistributionVariable
extends TnoDistributionObject {
    protected double a;
    protected double b;
    protected double c;
    protected double mean;
    protected boolean isStochastic;

    public double getMin() {
        return this.a;
    }

    public double getMedian() {
        return this.b;
    }

    public double getMax() {
        return this.c;
    }

    public double getMean() {
        return this.mean;
    }

    public TnoDistributionVariable(double median) {
        this.b = median;
        this.isStochastic = false;
    }

    public TnoDistributionVariable(double min, double median, double max) {
        this.setParameters(min, median, max);
        this.isStochastic = true;
        this.randomNumber = new Random();
    }

    public TnoDistributionVariable(double min, double median, double max, int seed) {
        this.setParameters(min, median, max);
        this.randomNumber = new Random(seed);
    }

    public abstract void setParameters(double var1, double var3, double var5);

    public abstract double PDF(double var1);

    public abstract double CDF(double var1);

    public abstract double NextValue();

    public abstract double[] generateSamples(int var1);
}

