/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.stochastic;

import tno.geoenergy.stochastic.TnoSingularContainer;
import tno.geoenergy.stochastic.TnoStochasticObject;

public class TnoSingularVariable
extends TnoStochasticObject {
    private double value;
    private double[] arrayvalue;
    private boolean optional;

    public TnoSingularVariable(String name, String unit, double value) {
        this.name = name;
        this.units = unit;
        this.value = value;
        TnoSingularContainer.singularVariables.add(this);
    }

    public TnoSingularVariable(String name, String unit, double value, double unitFactor, int round) {
        this.name = name;
        this.units = unit;
        this.value = value;
        this.unitFactor = unitFactor;
        this.round = round;
        TnoSingularContainer.singularVariables.add(this);
    }

    public TnoSingularVariable(String name, String unit, double value, double unitFactor, int round, boolean optional) {
        this.name = name;
        this.units = unit;
        this.value = value;
        this.unitFactor = unitFactor;
        this.round = round;
        this.optional = optional;
        TnoSingularContainer.singularVariables.add(this);
    }

    public TnoSingularVariable(String name, String unit, double value, boolean optional) {
        this.name = name;
        this.units = unit;
        this.value = value;
        this.optional = optional;
        TnoSingularContainer.singularVariables.add(this);
    }

    public TnoSingularVariable(String name, String unit, double[] value) {
        this.name = name;
        this.units = unit;
        this.arrayvalue = value;
        TnoSingularContainer.singularVariables.add(this);
    }

    public TnoSingularVariable(String name, String unit, double[] value, double unitFactor, int round) {
        this.name = name;
        this.units = unit;
        this.arrayvalue = value;
        this.unitFactor = unitFactor;
        this.round = round;
        TnoSingularContainer.singularVariables.add(this);
    }

    public TnoSingularVariable(String name, String unit, double[] value, double unitFactor, int round, boolean optional) {
        this.name = name;
        this.units = unit;
        this.arrayvalue = value;
        this.unitFactor = unitFactor;
        this.round = round;
        this.optional = optional;
        TnoSingularContainer.singularVariables.add(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.units;
    }

    public double getValue() {
        return this.value;
    }

    public String getStrValue(int i) {
        if (i < this.arrayvalue.length) {
            return Double.toString(this.arrayvalue[i]);
        }
        return "";
    }

    public int getSize() {
        return this.arrayvalue.length;
    }

    public double[] getArray() {
        return this.arrayvalue;
    }

    public final double getValueForm() {
        return this.format(this.value);
    }

    public final String getStrValueForm() {
        try {
            double[] arr = this.format(this.arrayvalue);
            String res = "";
            int i = 0;
            while (i < arr.length) {
                res = String.valueOf(res) + arr[i];
                if (i != arr.length - 1) {
                    res = String.valueOf(res) + ",";
                }
                ++i;
            }
            return res;
        }
        catch (Exception e) {
            return Double.toString(this.format(this.value));
        }
    }

    @Override
    public String getTitle() {
        String s = String.valueOf(this.name) + " " + "(" + this.units + ")";
        if (!this.optional) {
            return s;
        }
        return "[ " + s + " ]";
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setArray(double[] value) {
        this.arrayvalue = value;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

