/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.stochastic;

import tno.geoenergy.stochastic.TnoStochasticContainerTS;
import tno.geoenergy.stochastic.TnoStochasticContainerVar;
import tno.geoenergy.stochastic.TnoStochasticTimeSeries;
import tno.geoenergy.stochastic.TnoStochasticVariable;

public abstract class TnoStochasticObject {
    protected String name = "none";
    protected String units = "-";
    protected int idtype = 0;
    protected int round = 0;
    protected double unitFactor = 1.0;

    public String getUnits() {
        return this.units;
    }

    public int getRound() {
        return this.round;
    }

    public double getUnitFactor() {
        return this.unitFactor;
    }

    public TnoStochasticObject() {
    }

    public TnoStochasticObject(String name, String units, int idType) {
        this.name = name;
        this.units = units;
        this.idtype = idType;
        if (this.isStochasticTimeSeries()) {
            TnoStochasticContainerTS.getStochObjects().add((TnoStochasticTimeSeries)this);
        } else {
            TnoStochasticContainerVar.getStochObjects().add((TnoStochasticVariable)this);
        }
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public int getIdtype() {
        return this.idtype;
    }

    public void setIdtype(int idtype) {
        this.idtype = idtype;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return String.valueOf(this.name) + " " + "(" + this.units + ")";
    }

    public boolean isStochasticTimeSeries() {
        return this instanceof TnoStochasticTimeSeries;
    }

    public boolean isInput() {
        if (this instanceof TnoStochasticTimeSeries) {
            return ((TnoStochasticTimeSeries)this).getDistribution() != null;
        }
        return ((TnoStochasticVariable)this).getDistribution() != null;
    }

    public static double numRound(double num, int dec) {
        double p = Math.pow(10.0, dec);
        return (double)Math.round(num * p) / p;
    }

    protected double format(double value) {
        return TnoStochasticObject.numRound(value *= this.unitFactor, this.round);
    }

    protected double[] format(double[] value) {
        double[] formValues = new double[value.length];
        int i = 0;
        while (i < value.length) {
            formValues[i] = TnoStochasticObject.numRound(value[i] * this.unitFactor, this.round);
            ++i;
        }
        return formValues;
    }
}

