/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.stochastic;

import tno.geoenergy.stochastic.TnoDistributionTimeSeries;
import tno.geoenergy.stochastic.TnoRunControl;
import tno.geoenergy.stochastic.TnoStochasticObject;
import tno.geoenergy.stochastic.TnoStochasticVariable;

public class TnoStochasticTimeSeries
extends TnoStochasticObject {
    protected double[][] realisations;
    public TnoDistributionTimeSeries distribution = null;
    private int numSamples = TnoRunControl.numSamples;
    private int numYears = TnoRunControl.numYears;

    public TnoStochasticTimeSeries(String name, String units, int idType) {
        super(name, units, idType);
    }

    public TnoDistributionTimeSeries getDistribution() {
        return this.distribution;
    }

    public void setDistribution(TnoDistributionTimeSeries distribution) {
        this.distribution = distribution;
    }

    public void buildRealisations() {
        if (this.distribution != null) {
            this.distribution.generateSamples(this.numSamples, this.numYears);
        } else {
            this.createEmptyRealisations();
        }
    }

    public double[] getRealisationHandle(int i) {
        if (this.realisations != null) {
            return this.realisations[i];
        }
        System.out.println("no realisations");
        return null;
    }

    public double[] calcPValue(double chance) {
        double[] dist = new double[this.realisations[0].length];
        int year = 0;
        while (year < this.realisations[0].length) {
            double[] timeSlice = new double[this.realisations.length];
            int r = 0;
            while (r < this.realisations.length) {
                timeSlice[r] = this.realisations[r][year];
                ++r;
            }
            TnoStochasticVariable stochVar = new TnoStochasticVariable(timeSlice);
            dist[year] = stochVar.calcPValue(chance);
            ++year;
        }
        return dist;
    }

    public void createEmptyRealisations() {
        this.realisations = new double[this.numSamples][this.numYears];
    }

    public void disposeRealisations() {
        this.realisations = null;
    }

    public double[] getRealisationAt(int index) {
        return this.realisations[index];
    }

    public double[][] getRealisations() {
        return this.realisations;
    }

    @Override
    public boolean isStochasticTimeSeries() {
        return true;
    }

    public int size() {
        if (this.realisations == null) {
            return 0;
        }
        return this.numSamples;
    }

    public int getNumYears() {
        return this.numYears;
    }

    public void initialiseTimeSeries(int samples, int lifetime) {
        this.setNumSamples(samples);
        this.setNumYears(lifetime);
        this.buildRealisations();
    }

    public void setNumSamples(int numSamples) {
        this.numSamples = numSamples;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumYears(int numYears) {
        this.numYears = numYears;
    }
}

