/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.tableutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import tno.geoenergy.tableutil.TableFD;
import tno.geoenergy.util.ByteBufferHelper;

public class TableDataBinIO {
    public static int icount = 0;
    File output = null;
    FileOutputStream outputStream = null;
    FileChannel channel = null;
    ByteBufferHelper buffer = null;

    public static void write(int[] colTypes, String[] values, ByteBufferHelper buffer) throws IOException {
        int i = 0;
        while (i < values.length) {
            if (i < colTypes.length) {
                float v;
                if (colTypes[i] == TableFD.DOUBLE) {
                    v = Float.parseFloat(values[i]);
                    buffer.putFloat(v);
                } else if (colTypes[i] == TableFD.INT) {
                    v = Float.parseFloat(values[i]);
                    buffer.putInt(Math.round(v));
                } else if (colTypes[i] == TableFD.STRING) {
                    buffer.putString(values[i]);
                } else if (colTypes[i] == TableFD.BOOLEAN) {
                    buffer.putString(values[i]);
                } else if (colTypes[i] == TableFD.CATEGORY) {
                    buffer.putString(values[i]);
                }
                ++icount;
            }
            ++i;
        }
    }

    public static void write(float[] values, ByteBufferHelper buffer) throws IOException {
        int i = 0;
        while (i < values.length) {
            buffer.putFloat(values[i]);
            ++icount;
            ++i;
        }
    }

    public static void main(String[] args) {
        String dirname = "d:/0-spool/";
        int[] coltypes = new int[]{TableFD.DOUBLE, TableFD.DOUBLE};
        int nsamp = 1;
        String[] data = new String[]{"0.1", "0.2"};
        TableDataBinIO[] t = new TableDataBinIO[200];
        int i = 0;
        while (i < 200) {
            try {
                t[i] = new TableDataBinIO(String.valueOf(dirname) + " file" + i, nsamp);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        i = 0;
        while (i < 200) {
            int j = 0;
            while (j < nsamp) {
                try {
                    TableDataBinIO.write(coltypes, data, t[i].buffer);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 200) {
            try {
                t[i].closeFileForAppend();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private static void read(int[] colTypes, String[] values, ByteBufferHelper buffer) throws IOException {
        int i = 0;
        while (i < colTypes.length) {
            String s;
            if (colTypes[i] == TableFD.DOUBLE) {
                float v = buffer.getFloat();
                values[i] = new String("" + v);
            } else if (colTypes[i] == TableFD.INT) {
                int ii = buffer.getInt();
                values[i] = new String("" + ii);
            } else if (colTypes[i] == TableFD.STRING) {
                values[i] = s = buffer.getString();
            } else if (colTypes[i] == TableFD.BOOLEAN) {
                values[i] = s = buffer.getString();
            } else if (colTypes[i] == TableFD.CATEGORY) {
                values[i] = s = buffer.getString();
            }
            ++icount;
            ++i;
        }
    }

    public TableDataBinIO(String fileName, int nsamples) throws IOException {
        this.output = new File(fileName);
        this.outputStream = new FileOutputStream(this.output);
        this.channel = this.outputStream.getChannel();
        this.buffer = new ByteBufferHelper(this.channel);
        this.buffer.putInt(nsamples);
        icount = 0;
    }

    public void closeFileForAppend() throws IOException {
        this.buffer.flipwrite();
        this.channel.close();
        this.outputStream.close();
    }

    public static void writeData(String[][] data, String fileName, int[] coltypes) throws IOException {
        File output = new File(fileName);
        FileOutputStream outputStream = new FileOutputStream(output);
        FileChannel channel = outputStream.getChannel();
        ByteBufferHelper buffer = new ByteBufferHelper(channel);
        int length = data.length;
        buffer.putInt(data.length);
        icount = 0;
        int i = 0;
        while (i < data.length) {
            TableDataBinIO.write(coltypes, data[i], buffer);
            ++i;
        }
        buffer.flipwrite();
        channel.close();
        outputStream.close();
    }

    public static String[][] readData(String fileName, int[] coltypes) {
        String[][] data;
        block21: {
            FileInputStream is = null;
            AbstractInterruptibleChannel channel = null;
            data = null;
            try {
                try {
                    File f = new File(fileName);
                    is = new FileInputStream(f);
                    channel = is.getChannel();
                    ByteBufferHelper buffer = new ByteBufferHelper((FileChannel)channel);
                    buffer.clearread();
                    int nlines = buffer.getInt();
                    data = new String[nlines][coltypes.length];
                    icount = 0;
                    int i = 0;
                    while (i < data.length) {
                        TableDataBinIO.read(coltypes, data[i], buffer);
                        ++i;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    if (is == null) break block21;
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            finally {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return data;
    }
}

