/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.tableutil;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import tno.geoenergy.tableutil.SimpleTableModel;
import tno.geoenergy.tableutil.TableFD;

public class TableDlg
extends JDialog {
    JTextField LengthField = null;
    JTable table;
    SimpleTableModel tableModel;
    protected TableFD data;
    Object StoredObject;
    Object UndoObject;
    Object[] UndoVector;
    Object[] StoredVector;
    boolean CanUndo = false;
    boolean FieldUndo = false;
    boolean InsertUndo = false;
    boolean DeleteUndo = false;
    private JPopupMenu tablePopup;
    int lc = 0;
    int lr = 0;
    int ncols;
    int nrows;
    Object m_project;
    JScrollPane tablePane;
    private boolean ok = false;
    private boolean changeTableDimensions = false;
    JScrollPane VelocityTablePane;

    public TableDlg(Frame aParent, Object myProject, String title, boolean changeTableDimensions) {
        super(aParent, title, true);
        this.changeTableDimensions = changeTableDimensions;
        this.m_project = myProject;
        this.connectdata(myProject);
        this.initialize();
    }

    public void connectdata(Object myProject) {
    }

    public boolean showDialog() {
        this.setVisible(true);
        if (this.ok) {
            this.updateData();
            this.data.SaveFile();
        }
        return this.ok;
    }

    private void initialize() {
        this.nrows = this.data.getData().length;
        this.ncols = this.data.getData()[0].length;
        this.UndoVector = new Object[this.ncols];
        this.StoredVector = new Object[this.ncols];
        if (this.changeTableDimensions) {
            this.tablePopup = this.maketablePopup();
        }
        JPanel Panel1 = new JPanel();
        JPanel buttonPanel = new JPanel();
        JButton OK = new JButton("OK");
        OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TableDlg.this.table.getCellEditor() != null) {
                    TableDlg.this.table.getCellEditor().stopCellEditing();
                }
                TableDlg.this.ok = true;
                TableDlg.this.setVisible(false);
            }
        });
        buttonPanel.add(OK);
        JButton CANCEL = new JButton("CANCEL");
        CANCEL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableDlg.this.ok = false;
                TableDlg.this.setVisible(false);
            }
        });
        buttonPanel.add(CANCEL);
        this.MakeTable();
        this.tablePane = new JScrollPane(this.table);
        MouseAdapter mltable = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if ((e.getModifiers() & 4) == 4) {
                    TableDlg.this.tablePopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        if (this.changeTableDimensions) {
            this.table.addMouseListener(mltable);
        }
        Panel1.setLayout(new BorderLayout());
        Panel1.add((Component)this.tablePane, "Center");
        Panel1.add((Component)buttonPanel, "South");
        Panel1.setSize(new Dimension((1 + this.ncols) * 80, (1 + this.nrows) * 40));
        this.getContentPane().add(Panel1);
        this.pack();
    }

    private void MakeTable() {
        Object[][] data2 = this.data.getTableModelData();
        this.tableModel = new SimpleTableModel(data2, this.data.getColNames());
        this.tableModel.setEditable(this.data.getEditable());
        this.table = new JTable(this.tableModel);
        int j = 0;
        while (j < this.ncols) {
            if (this.data.getColTypes()[j] == TableFD.CATEGORY) {
                if (this.data.getCategories()[j] != null) {
                    TableColumnModel tcm = this.table.getColumnModel();
                    TableColumn tc = tcm.getColumn(j);
                    this.setUpComboColumn(tc, this.data.getCategories()[j]);
                } else {
                    System.out.println("no categories specified in class");
                }
            }
            ++j;
        }
        this.packTable(this.table, 2);
        this.table.revalidate();
    }

    public void updateData() {
        String[][] dlgData = this.data.getData();
        if (this.changeTableDimensions) {
            dlgData = new String[this.nrows][this.ncols];
        }
        int j = 0;
        while (j < this.ncols) {
            int i = 0;
            while (i < this.nrows) {
                dlgData[i][j] = this.tableModel.getValueAt(i, j).toString();
                this.data.setData(dlgData);
                ++i;
            }
            ++j;
        }
    }

    public void setUpComboColumn(TableColumn interColumn, Vector categories) {
        JComboBox comboBox = new JComboBox();
        int i = 0;
        while (i < categories.size()) {
            comboBox.addItem(categories.elementAt(i));
            ++i;
        }
        interColumn.setCellEditor(new DefaultCellEditor(comboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Click for combo box");
        interColumn.setCellRenderer(renderer);
        TableCellRenderer headerRenderer = interColumn.getHeaderRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText("Click the field to see a list of choices");
        }
    }

    private void packTable(JTable table, int margin) {
        table.setAutoResizeMode(0);
        int i = 0;
        while (i < table.getColumnCount()) {
            TableColumn col = table.getColumnModel().getColumn(i);
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
            int width = comp.getPreferredSize().width;
            int r = 0;
            while (r < table.getRowCount()) {
                renderer = table.getCellRenderer(r, i);
                comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, i), false, false, r, i);
                width = Math.max(width, comp.getPreferredSize().width);
                ++r;
            }
            col.setPreferredWidth(width += margin * 2);
            ++i;
        }
    }

    private JPopupMenu maketablePopup() {
        JMenuItem menuFieldUndo = new JMenuItem("Undo");
        menuFieldUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TableDlg.this.CanUndo) {
                    if (TableDlg.this.DeleteUndo) {
                        TableDlg.this.tableModel.insertRow(TableDlg.this.lr, TableDlg.this.UndoVector);
                        TableDlg.this.DeleteUndo = false;
                        ++TableDlg.this.nrows;
                    }
                    if (TableDlg.this.InsertUndo) {
                        TableDlg.this.tableModel.removeRow(TableDlg.this.lr);
                        --TableDlg.this.nrows;
                        TableDlg.this.InsertUndo = false;
                    }
                    TableDlg.this.CanUndo = false;
                }
            }
        });
        JMenuItem menuRowDelete = new JMenuItem("Delete Row");
        menuRowDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rr = TableDlg.this.table.getSelectedRow();
                if (rr >= 0) {
                    int cc = 0;
                    while (cc < TableDlg.this.ncols) {
                        TableDlg.this.UndoVector[cc] = TableDlg.this.table.getValueAt(rr, cc);
                        ++cc;
                    }
                    TableDlg.this.tableModel.removeRow(rr);
                    --TableDlg.this.nrows;
                    TableDlg.this.lr = rr;
                    TableDlg.this.CanUndo = true;
                    TableDlg.this.DeleteUndo = true;
                }
            }
        });
        JMenuItem menuRowCopy = new JMenuItem("Copy Row");
        menuRowCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rr = TableDlg.this.table.getSelectedRow();
                int cc = 0;
                while (cc < TableDlg.this.ncols) {
                    TableDlg.this.StoredVector[cc] = TableDlg.this.table.getValueAt(rr, cc);
                    ++cc;
                }
            }
        });
        JMenuItem menuRowPaste = new JMenuItem("Paste Row");
        menuRowPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rr;
                TableDlg.this.lr = rr = TableDlg.this.table.getSelectedRow();
                TableDlg.this.tableModel.insertRow(rr, TableDlg.this.StoredVector);
                TableDlg.this.CanUndo = true;
                TableDlg.this.InsertUndo = true;
                ++TableDlg.this.nrows;
            }
        });
        JPopupMenu Popup2 = new JPopupMenu("Table Menu");
        Popup2.add(menuRowCopy);
        Popup2.add(menuRowPaste);
        Popup2.add(menuRowDelete);
        Popup2.add(menuFieldUndo);
        return Popup2;
    }
}

