/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.tableutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import tno.geoenergy.tableutil.TableDataBinIO;
import tno.geoenergy.tableutil.TableFD;

public class TableFD_old {
    protected FileInputStream StreamIn;
    protected byte[] byteDataIn;
    protected String StringIn;
    protected String filename;
    protected String m_file = null;
    protected String newline = "\n";
    private TableDataBinIO tableDataBinIO = null;
    public static int INT = 1;
    public static int DOUBLE = 2;
    public static int STRING = 3;
    public static int BOOLEAN = 4;
    public static int CATEGORY = 5;
    public static int BINARY = 1;
    public static int ASCII = 2;
    protected boolean incrementalsave = false;
    protected int readwritemode = TableFD.BINARY;
    protected String[][] m_data;
    public static int XCOLUMN = 1;
    public static int YCOLUMN = 2;
    public static int ZCOLUMN = 3;
    public static int SELCOLUMN = 4;
    public static int LINECOLUMN = 5;
    public static final int[] colTypes = null;
    int numberOfColumns = 0;
    int numberOfLines = 0;
    public static final String[] colNames = null;
    protected static final Vector[] CATEGORIES = new Vector[1];
    private static final boolean[] editable;

    static {
        TableFD_old.CATEGORIES[0] = new Vector();
        CATEGORIES[0].addElement("U");
        CATEGORIES[0].addElement("G");
        editable = null;
    }

    public String[] getColNames() {
        return colNames;
    }

    public Vector getColNamesVector() {
        String[] cn = this.getColNames();
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < cn.length) {
            v.add(cn[i]);
            ++i;
        }
        return v;
    }

    public int[] getColTypes() {
        return colTypes;
    }

    public Vector[] getCategories() {
        return CATEGORIES;
    }

    public boolean[] getEditable() {
        return editable;
    }

    public TableFD_old() {
        this.numberOfColumns = this.getColNames() != null ? this.getColNames().length : 0;
    }

    public void setFilename(String f) {
        this.filename = f;
        this.m_file = new String(f);
    }

    public void readdataAscii() {
        File file = new File(this.filename);
        try {
            this.StreamIn = new FileInputStream(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("File Open Error");
        }
        int nbytes = (int)file.length();
        this.byteDataIn = new byte[nbytes];
        try {
            int toRead = nbytes;
            int position = 0;
            while (toRead > 0) {
                int read = this.StreamIn.read(this.byteDataIn, position, toRead);
                if (read <= 0) {
                    System.out.println("Failed reading " + this.filename);
                    break;
                }
                toRead -= read;
                position += read;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e);
        }
        try {
            this.StreamIn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e);
        }
        String Str = new String(this.byteDataIn, 0, nbytes);
        StringTokenizer StrTok = new StringTokenizer(Str, this.newline);
        StringTokenizer strTok2 = null;
        this.setNumberOfLines(StrTok.countTokens());
        this.m_data = new String[this.getNumberOfLines()][this.getNumberOfColumns()];
        int line = 0;
        int col = 0;
        try {
            line = 0;
            while (line < this.getNumberOfLines()) {
                String tmpStr = StrTok.nextToken();
                strTok2 = new StringTokenizer(tmpStr);
                col = 0;
                while (col < this.getNumberOfColumns()) {
                    this.m_data[line][col] = strTok2.nextToken();
                    ++col;
                }
                ++line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("problem reading line " + line + " column " + col);
            e.printStackTrace();
        }
    }

    public TableFD_old(String fileName) {
        this.setNumberOfColumns(this.getColNames().length);
        this.filename = fileName;
        this.m_file = new String(fileName);
        this.readdata();
    }

    public TableFD_old(String fileName, int readmode) {
        this.setNumberOfColumns(this.getColNames().length);
        this.filename = fileName;
        this.m_file = new String(fileName);
        this.setReadwritemode(readmode);
        this.readdata();
    }

    public void readdata() {
        if (this.readwritemode == TableFD.BINARY) {
            this.readdataBin();
        } else {
            this.readdataAscii();
        }
    }

    public void readdataBin() {
        this.m_data = TableDataBinIO.readData(this.filename, this.getColTypes());
        this.setNumberOfLines(this.m_data.length);
    }

    public void setData(String[][] s) {
        this.m_data = s;
        this.numberOfLines = this.m_data.length;
    }

    public String[][] getData() {
        return this.m_data;
    }

    public double[][] getXYplotData() {
        int[] ind = this.getXYplotColumnsIndex();
        int plotlength = this.getXYplotColumnsLength();
        double[][] pxy = new double[plotlength][this.m_data.length];
        int j = 0;
        while (j < this.numberOfColumns) {
            if (ind[j] != -1) {
                int i = 0;
                while (i < this.numberOfLines) {
                    try {
                        pxy[ind[j]][i] = Double.parseDouble(this.m_data[i][j]);
                    }
                    catch (Exception e) {
                        pxy[ind[j]][i] = 0.0;
                    }
                    ++i;
                }
            }
            ++j;
        }
        return pxy;
    }

    public String[] getXYplotColumnNames() {
        int[] ind = this.getXYplotColumnsIndex();
        int plotlength = this.getXYplotColumnsLength();
        int icount = 0;
        String[] s = new String[plotlength];
        int j = 0;
        while (j < this.getNumberOfColumns()) {
            if (ind[j] != -1) {
                s[icount] = this.getColNames()[j];
                ++icount;
            }
            ++j;
        }
        return s;
    }

    public int indexOf(String columnName, String recordName) {
        int icolumn = 0;
        int j = 0;
        while (j < this.getNumberOfColumns()) {
            if (this.getColNames()[j].equals(columnName)) {
                icolumn = j;
            }
            ++j;
        }
        int i = 0;
        while (i < this.getNumberOfLines()) {
            if (this.m_data[i][icolumn].equals(recordName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int[] getXYplotColumnsIndex() {
        int count = 0;
        int[] ind = new int[this.getNumberOfColumns()];
        int j = 0;
        while (j < this.getNumberOfColumns()) {
            ind[j] = -1;
            if (this.getColTypes()[j] == TableFD.INT || this.getColTypes()[j] == TableFD.DOUBLE) {
                ind[j] = count++;
            }
            ++j;
        }
        return ind;
    }

    public int getXYplotColumnsLength() {
        int count = 0;
        int j = 0;
        while (j < this.getNumberOfColumns()) {
            if (this.getColTypes()[j] == TableFD.INT || this.getColTypes()[j] == TableFD.DOUBLE) {
                ++count;
            }
            ++j;
        }
        return count;
    }

    public Object[][] getTableModelData() {
        Object[][] m = new Object[this.getNumberOfLines()][this.getNumberOfColumns()];
        int i = 0;
        while (i < this.getNumberOfLines()) {
            int j = 0;
            while (j < this.getNumberOfColumns()) {
                m[i][j] = this.getColTypes()[j] == TableFD.BOOLEAN ? new Boolean(this.m_data[i][j]) : this.m_data[i][j];
                ++j;
            }
            ++i;
        }
        return m;
    }

    public void SaveFile() {
        if (this.readwritemode == TableFD.BINARY) {
            this.SaveFileBin();
        } else {
            this.SaveFileAscii();
        }
    }

    public void SaveFileBin() {
        if (!this.isIncrementalsave()) {
            try {
                TableDataBinIO.writeData(this.m_data, this.filename, this.getColTypes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void openToSave(int nsamp) {
        try {
            this.tableDataBinIO = new TableDataBinIO(this.filename, nsamp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeRow(String[] data) {
        try {
            TableDataBinIO.write(this.getColTypes(), data, this.tableDataBinIO.buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeRow(float[] data) {
        try {
            TableDataBinIO.write(data, this.tableDataBinIO.buffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void closeToSave() {
        try {
            this.tableDataBinIO.closeFileForAppend();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void SaveFileAscii() {
        StringBuffer Strbuf = new StringBuffer();
        File myfile = new File(this.filename);
        FileOutputStream StreamOut = null;
        try {
            StreamOut = new FileOutputStream(this.filename);
        }
        catch (IOException e) {
            System.out.println("Error opening output file: " + this.filename);
        }
        double[] nrs = new double[this.getColNames().length];
        int line = 0;
        while (line < this.m_data.length) {
            try {
                int i = 0;
                while (i < nrs.length) {
                    if (i > 0) {
                        Strbuf.append("\t");
                    }
                    Strbuf.append(this.m_data[line][i]);
                    ++i;
                }
                Strbuf.append("\n");
            }
            catch (NumberFormatException er) {
                break;
            }
            catch (NullPointerException en) {
                break;
            }
            String Str = Strbuf.toString();
            byte[] byteDataOut = Str.getBytes();
            Strbuf = new StringBuffer();
            try {
                StreamOut.write(byteDataOut);
            }
            catch (IOException e) {
                System.out.println("Error writing to output file " + this.filename);
            }
            ++line;
        }
        try {
            StreamOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e);
        }
    }

    public String[] getColumnData(String columnName) throws Exception {
        int index = this.existColumnName(columnName);
        if (index != -1) {
            int length = this.m_data.length;
            String[] s = new String[length];
            int i = 0;
            while (i < this.numberOfLines) {
                s[i] = this.m_data[i][index];
                ++i;
            }
            return s;
        }
        throw new Exception("column not found :" + columnName + "\n in file " + this.getFilename());
    }

    public int existColumnName(String columnName) {
        int i = 0;
        while (i < this.getNumberOfColumns()) {
            if (columnName.toLowerCase().trim().equals(this.getColNames()[i].toLowerCase().trim())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public double[] parseDouble(String columnName, boolean throwformatexception) throws Exception {
        String[] s = this.getColumnData(columnName);
        if (s == null) {
            throw new Exception("column not found :" + columnName + "\n in file " + this.getFilename());
        }
        double[] d = new double[s.length];
        int i = 0;
        while (i < this.getNumberOfLines()) {
            try {
                d[i] = Double.parseDouble(s[i]);
            }
            catch (Exception e) {
                if (throwformatexception) {
                    throw new Exception("format error in column (expecting double): " + columnName + " at record nr: " + i + " value " + s[i] + "\n in file " + this.getFilename());
                }
                d[i] = 0.0;
            }
            ++i;
        }
        return d;
    }

    public int[] parseInt(String columnName, boolean throwformatexception) throws Exception {
        String[] s = this.getColumnData(columnName);
        if (s == null) {
            throw new Exception("column not found :" + columnName + "\n in file " + this.getFilename());
        }
        int[] d = new int[s.length];
        int i = 0;
        while (i < this.getNumberOfLines()) {
            try {
                d[i] = (int)Math.round(Double.parseDouble(s[i]));
            }
            catch (Exception e) {
                if (throwformatexception) {
                    throw new Exception("format error in column (expecting integer): " + columnName + " at record nr: " + i + "\n in file " + this.getFilename());
                }
                d[i] = 0;
            }
            ++i;
        }
        return d;
    }

    public boolean[] parseBoolean(String columnName, boolean throwformatexception) throws Exception {
        String[] s = this.getColumnData(columnName);
        if (s == null) {
            throw new Exception("column not found" + columnName + "\n in file " + this.getFilename());
        }
        boolean[] d = new boolean[s.length];
        int i = 0;
        while (i < this.getNumberOfLines()) {
            try {
                d[i] = s[i].equals("true");
            }
            catch (Exception e) {
                if (throwformatexception) {
                    throw new Exception("format error in column (expecting boolean): " + columnName + " at record nr: " + i + "\n in file " + this.getFilename());
                }
                d[i] = true;
            }
            ++i;
        }
        return d;
    }

    public void parseAll() throws Exception {
        int i = 0;
        while (i < this.getNumberOfColumns()) {
            if (this.getColTypes()[i] == TableFD.BOOLEAN) {
                this.parseBoolean(this.getColNames()[i], true);
            } else if (this.getColTypes()[i] == TableFD.DOUBLE) {
                this.parseDouble(this.getColNames()[i], true);
            } else if (this.getColTypes()[i] == TableFD.INT) {
                this.parseInt(this.getColNames()[i], true);
            }
            ++i;
        }
    }

    public static void main(String[] args) {
    }

    public int getNumberOfLines() {
        return this.numberOfLines;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public static Vector[] getCATEGORIES() {
        return CATEGORIES;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
    }

    public void setNumberOfLines(int numberOfLines) {
        this.numberOfLines = numberOfLines;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isIncrementalsave() {
        return this.incrementalsave;
    }

    public void setIncrementalsave(boolean incrementalsave) {
        this.incrementalsave = incrementalsave;
    }

    public int getReadwritemode() {
        return this.readwritemode;
    }

    public void setReadwritemode(int readwritemode) {
        this.readwritemode = readwritemode;
    }
}

