/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.tableutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import tno.geoenergy.tableutil.TableFD;

public class TableHeaderFD
extends TableFD {
    public int[] customcolTypes = null;
    public String[] customcolNames = null;
    protected Vector[] customCATEGORIES;
    private boolean[] customeditable = null;
    private String headerextension = null;

    public TableHeaderFD() {
        this.numberOfColumns = 0;
    }

    public TableHeaderFD(String fileName) {
        this.numberOfColumns = 0;
        System.out.println("this does not make much sense");
    }

    public TableHeaderFD(String fileName, String headerextension) {
        this.setFilename(fileName);
        this.setHeaderextension(headerextension);
        this.readHeader();
        this.readdata();
    }

    @Override
    public String[] getColNames() {
        return this.customcolNames;
    }

    @Override
    public Vector getColNamesVector() {
        String[] cn = this.getColNames();
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < cn.length) {
            v.add(cn[i]);
            ++i;
        }
        return v;
    }

    @Override
    public int[] getColTypes() {
        return this.customcolTypes;
    }

    @Override
    public Vector[] getCategories() {
        return this.customCATEGORIES;
    }

    @Override
    public boolean[] getEditable() {
        return this.customeditable;
    }

    public Vector[] getCategoriesAllDouble(String[] columns) {
        Vector[] v = new Vector[columns.length];
        return v;
    }

    public int[] getTypesAllDouble(String[] columns) {
        int[] v = new int[columns.length];
        int i = 0;
        i = 0;
        while (i < columns.length) {
            v[i] = DOUBLE;
            ++i;
        }
        return v;
    }

    public boolean[] getEditableAllDouble(String[] columns) {
        boolean[] v = new boolean[columns.length];
        int i = 0;
        i = 0;
        while (i < columns.length) {
            v[i] = true;
            ++i;
        }
        return v;
    }

    public void readHeader() {
        File file = new File(this.getHeadername());
        try {
            this.StreamIn = new FileInputStream(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("File Open Error " + this.getHeadername());
        }
        int nbytes = (int)file.length();
        this.byteDataIn = new byte[nbytes];
        try {
            int toRead = nbytes;
            int position = 0;
            while (toRead > 0) {
                int read = this.StreamIn.read(this.byteDataIn, position, toRead);
                if (read <= 0) {
                    System.out.println("Failed reading " + this.getHeadername());
                    break;
                }
                toRead -= read;
                position += read;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e);
        }
        try {
            this.StreamIn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e);
        }
        String Str = new String(this.byteDataIn, 0, nbytes);
        StringTokenizer strTok = new StringTokenizer(Str);
        this.numberOfColumns = strTok.countTokens();
        String[] columns = new String[this.numberOfColumns];
        int i = 0;
        try {
            i = 0;
            while (i < this.numberOfColumns) {
                columns[i] = strTok.nextToken();
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("problem reading column " + i);
            e.printStackTrace();
        }
        this.setCustomcolNames(columns);
    }

    public String getHeadername() {
        int i = this.filename.lastIndexOf(".");
        String baseName = this.filename.substring(0, i);
        System.out.println(" Header file name |" + baseName + "." + this.headerextension);
        return String.valueOf(baseName) + "." + this.headerextension;
    }

    public String getHeaderextension() {
        return this.headerextension;
    }

    public void setHeaderextension(String headerextension) {
        this.headerextension = headerextension;
    }

    @Override
    public void SaveFile() {
        super.SaveFile();
        StringBuffer Strbuf = new StringBuffer();
        File myfile = new File(this.getHeadername());
        FileOutputStream StreamOut = null;
        try {
            StreamOut = new FileOutputStream(this.getHeadername());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error opening output file: " + this.getHeadername());
        }
        int i = 0;
        while (i < this.getColNames().length) {
            try {
                if (i > 0) {
                    Strbuf.append("\t");
                }
                Strbuf.append(this.getColNames()[i]);
            }
            catch (NumberFormatException er) {
                break;
            }
            catch (NullPointerException en) {
                break;
            }
            String Str = Strbuf.toString();
            byte[] byteDataOut = Str.getBytes();
            Strbuf = new StringBuffer();
            try {
                StreamOut.write(byteDataOut);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("Error writing to output file " + this.getHeadername());
            }
            ++i;
        }
        try {
            StreamOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e);
        }
    }

    public void setCustomcolNames(String[] customcolNames) {
        this.customcolNames = customcolNames;
        this.customcolTypes = this.getTypesAllDouble(customcolNames);
        this.customCATEGORIES = this.getCategoriesAllDouble(customcolNames);
        this.customeditable = this.getEditableAllDouble(customcolNames);
    }
}

