/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.tableutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import tno.geoenergy.tableutil.TableHeaderFD;

public class TableHeaderTSFD
extends TableHeaderFD {
    public String[] TimeSeriesNames = null;
    public String[] TSdefX = null;
    public String[] TSdefY = null;
    private String headerTSextension = null;

    public TableHeaderTSFD() {
    }

    public TableHeaderTSFD(String fileName) {
        super(fileName);
    }

    public TableHeaderTSFD(String fileName, String headerextension, String headerTSextension) {
        this.setFilename(fileName);
        this.setHeaderextension(headerextension);
        this.setHeaderTSextension(headerTSextension);
        this.readHeader();
        this.readdata();
    }

    public Vector getTimeSeriesNamesVector() {
        String[] cn = this.getTimeSeriesNames();
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < cn.length) {
            v.add(cn[i]);
            ++i;
        }
        return v;
    }

    public String getTSHeadername() {
        int i = this.filename.lastIndexOf(".");
        String baseName = this.filename.substring(0, i);
        System.out.println(" Header Timeseries file name |" + baseName + "." + this.headerTSextension);
        return String.valueOf(baseName) + "." + this.headerTSextension;
    }

    @Override
    public void readHeader() {
        File file = new File(this.getTSHeadername());
        try {
            this.StreamIn = new FileInputStream(file);
        }
        catch (IOException e) {
            System.out.println("File Open Error " + this.getTSHeadername());
        }
        int nbytes = (int)file.length();
        this.byteDataIn = new byte[nbytes];
        try {
            int toRead = nbytes;
            int position = 0;
            while (toRead > 0) {
                int read = this.StreamIn.read(this.byteDataIn, position, toRead);
                if (read <= 0) {
                    System.out.println("Failed reading " + this.getTSHeadername());
                    break;
                }
                toRead -= read;
                position += read;
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
        try {
            this.StreamIn.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        String Str = new String(this.byteDataIn, 0, nbytes);
        StringTokenizer strTok = new StringTokenizer(Str);
        int nCols = strTok.countTokens() / 3;
        String[] columns = new String[nCols];
        String[] xdefs = new String[nCols];
        String[] ydefs = new String[nCols];
        int i = 0;
        try {
            i = 0;
            while (i < nCols) {
                columns[i] = strTok.nextToken();
                xdefs[i] = strTok.nextToken();
                ydefs[i] = strTok.nextToken();
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("problem reading column " + i);
            e.printStackTrace();
        }
        this.setTimeSeriesNames(columns);
        this.setTSdefX(xdefs);
        this.setTSdefY(ydefs);
    }

    @Override
    public void SaveFile() {
        super.SaveFile();
        StringBuffer Strbuf = new StringBuffer();
        File myfile = new File(this.getTSHeadername());
        FileOutputStream StreamOut = null;
        try {
            StreamOut = new FileOutputStream(this.getTSHeadername());
        }
        catch (IOException e) {
            System.out.println("Error opening output file: " + this.getTSHeadername());
        }
        int i = 0;
        while (i < this.getTimeSeriesNames().length) {
            try {
                if (i > 0) {
                    Strbuf.append("\t");
                }
                Strbuf.append(this.getTimeSeriesNames()[i]);
                Strbuf.append("\t");
                Strbuf.append(this.getTSdefX()[i]);
                Strbuf.append("\t");
                Strbuf.append(this.getTSdefY()[i]);
            }
            catch (NumberFormatException er) {
                break;
            }
            catch (NullPointerException en) {
                break;
            }
            String Str = Strbuf.toString();
            byte[] byteDataOut = Str.getBytes();
            Strbuf = new StringBuffer();
            try {
                StreamOut.write(byteDataOut);
            }
            catch (IOException e) {
                System.out.println("Error writing to output file " + this.getHeadername());
            }
            ++i;
        }
        try {
            StreamOut.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public String getHeaderTSextension() {
        return this.headerTSextension;
    }

    public String[] getTimeSeriesNames() {
        return this.TimeSeriesNames;
    }

    public String[] getTSdefX() {
        return this.TSdefX;
    }

    public void setHeaderTSextension(String headerTSextension) {
        this.headerTSextension = headerTSextension;
    }

    public void setTimeSeriesNames(String[] timeSeriesNames) {
        this.TimeSeriesNames = timeSeriesNames;
    }

    public void setTSdefX(String[] tSdefX) {
        this.TSdefX = tSdefX;
    }

    public String[] getTSdefY() {
        return this.TSdefY;
    }

    public void setTSdefY(String[] tSdefY) {
        this.TSdefY = tSdefY;
    }
}

