/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class AsciiOut {
    DecimalFormat exppos;
    DecimalFormat expneg;
    boolean exponent;
    boolean stringquotes;
    String leadingspaces;
    int fieldwidth;
    int expnegtreshold;

    public AsciiOut(String pattern, int fieldwid) {
        int nrlength;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        dfs.setGroupingSeparator(',');
        this.fieldwidth = fieldwid;
        this.leadingspaces = new String("");
        this.exponent = pattern.indexOf(69) > 0;
        if (this.exponent) {
            nrlength = pattern.length() + 1;
            this.exppos = new DecimalFormat(String.valueOf(pattern) + "0", dfs);
            this.expneg = new DecimalFormat(pattern, dfs);
            this.expnegtreshold = 1;
            int i = 0;
            while (i < pattern.indexOf(46) - 1) {
                this.expnegtreshold *= 10;
                ++i;
            }
        } else {
            nrlength = pattern.length();
            this.exppos = new DecimalFormat(pattern, dfs);
        }
        int nrofspacesneg = this.fieldwidth - nrlength - 1;
        int i = 0;
        while (i < nrofspacesneg) {
            this.leadingspaces = this.leadingspaces.concat(" ");
            ++i;
        }
        this.stringquotes = false;
    }

    public void setStringQuotes(boolean v) {
        this.stringquotes = v;
    }

    public String format(float value) {
        if (value >= 0.0f) {
            if (!this.exponent || this.exponent && value >= (float)this.expnegtreshold) {
                return String.valueOf(this.leadingspaces) + " " + this.exppos.format(value);
            }
            return String.valueOf(this.leadingspaces) + " " + this.expneg.format(value);
        }
        if (!this.exponent || this.exponent && value < (float)(-this.expnegtreshold)) {
            return String.valueOf(this.leadingspaces) + this.exppos.format(value);
        }
        return String.valueOf(this.leadingspaces) + this.expneg.format(value);
    }

    public String format(double value) {
        return this.format((float)value);
    }

    public String format(int value) {
        return this.format((float)value);
    }

    public String format(String value) {
        value = value.trim();
        if (this.stringquotes) {
            value = "'" + value + "'";
        }
        char[] rvalue = new char[this.fieldwidth];
        int i = 0;
        int ioffset = this.fieldwidth - value.length();
        i = 0;
        while (i < value.length()) {
            if (i + ioffset >= 0) {
                rvalue[i + ioffset] = value.charAt(i);
            }
            ++i;
        }
        i = 0;
        while (i < ioffset) {
            rvalue[i] = 32;
            ++i;
        }
        return new String(rvalue);
    }

    public static void main(String[] args) {
        AsciiOut as_f1 = new AsciiOut("00000.00", 15);
        AsciiOut as_f2 = new AsciiOut("00000.00", 9);
        AsciiOut as_f3 = new AsciiOut("000E00", 8);
        AsciiOut as_f4 = new AsciiOut("00000", 6);
        System.out.println(String.valueOf(as_f1.format("0123456789012345678")) + as_f2.format("01234567890123456789012345678901234567890") + as_f3.format("01234567890123456789012345678901234567890") + as_f4.format("01234567890123456789012345678901234567890"));
        System.out.println(String.valueOf(as_f1.format(-30132.04567)) + as_f2.format(-30132.04567) + as_f3.format(-30132.04567) + as_f4.format(-30132.04567));
        System.out.println(String.valueOf(as_f1.format(-30132.045f)) + as_f2.format(-30132.045f) + as_f3.format(-30132.045f) + as_f4.format(-30132.045f));
        System.out.println(String.valueOf(as_f1.format(-30132)) + as_f2.format(-30132) + as_f3.format(-30132) + as_f4.format(-30132));
    }
}

