/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import tno.geoenergy.util.IllegalFormatException;

public class AsciiStream
extends BufferedInputStream {
    public static final int SPACES = 0;
    public static final int STANDARD_DELIMITERS = 1;
    public static final int ALPHA = 2;
    public static final int STANDARD_ALPHA_DELIMITERS = 3;
    public static final int NUMERIC = 4;
    public static final int NEW_LINE = 5;
    public static final int QUOTE = 6;
    public static final int DEFAULT_MAX_STRING_LENGTH = 200;
    protected static final String STREAM_NA = "Stream not available";
    protected int skipType = 0;
    protected int delimiterType = 1;
    protected boolean autoSkipSpaces = true;
    protected int maxStringLength = 200;
    private static int MAX_UNIT = 0xCCCCCCB;

    public AsciiStream(InputStream in) {
        super(in);
    }

    public AsciiStream(InputStream in, int size) {
        super(in, size);
    }

    public int getSkipType() {
        return this.skipType;
    }

    public void setSkipType(int type) {
        this.skipType = type;
    }

    public int getDelimiter() {
        return this.delimiterType;
    }

    public void setDelimiter(int type) {
        this.delimiterType = type;
    }

    public boolean getAutoSkipSpaces() {
        return this.autoSkipSpaces;
    }

    public void setAutoSkipSpaces(boolean v) {
        this.autoSkipSpaces = v;
    }

    public synchronized boolean more() throws IOException {
        if (this.in == null) {
            throw new IOException(STREAM_NA);
        }
        return this.moreAvailable();
    }

    protected boolean moreAvailable() throws IOException {
        if (this.count > this.pos) {
            return true;
        }
        this.fillBuffer();
        return this.count > this.pos;
    }

    public synchronized int skipTag(String tag) throws IOException {
        int length;
        this.marklimit = length = tag.length();
        this.markpos = this.pos;
        int skipped = length;
        boolean ma = true;
        int i = 0;
        while (true) {
            if (i < length) {
                ma = this.moreAvailable();
                if (ma && tag.charAt(i) == this.buf[this.pos++]) {
                    ++i;
                    continue;
                }
            }
            if (i == length || !ma) break;
            this.pos = ++this.markpos;
            ++skipped;
        }
        this.markpos = -1;
        return i == length ? skipped : -1;
    }

    public boolean nextLine() throws IOException {
        return this.skipTag("\n") == -1;
    }

    protected void fillBuffer() throws IOException {
        if (this.markpos < 0) {
            this.pos = 0;
        } else if (this.pos >= this.buf.length) {
            if (this.markpos > 0) {
                int sz = this.pos - this.markpos;
                System.arraycopy(this.buf, this.markpos, this.buf, 0, sz);
                this.pos = sz;
                this.markpos = 0;
            } else if (this.buf.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
            } else {
                int nsz = this.pos * 2;
                if (nsz > this.marklimit) {
                    nsz = this.marklimit;
                }
                byte[] nbuf = new byte[nsz];
                System.arraycopy(this.buf, 0, nbuf, 0, this.pos);
                this.buf = nbuf;
            }
        }
        this.count = this.pos;
        int n = this.in.read(this.buf, this.pos, this.buf.length - this.pos);
        if (n > 0) {
            this.count = n + this.pos;
        }
    }

    protected void throwIllegalFormatException(String expectedFormat) throws IllegalFormatException {
        StringBuffer message = new StringBuffer("Got '");
        int i = this.markpos;
        while (i < this.pos) {
            message.append((char)this.buf[i]);
            ++i;
        }
        message.append('\'');
        message.append(", expected: '");
        message.append(expectedFormat);
        message.append('\'');
        this.pos = this.markpos;
        this.markpos = -1;
        throw new IllegalFormatException(message.toString());
    }

    private void readFloatIllegalFormat() throws IllegalFormatException {
        this.throwIllegalFormatException("[skip chars]float<delimiter | eos>");
    }

    public synchronized float readFloat() throws IOException {
        return this.doReadFloat();
    }

    public synchronized double readDouble() throws IOException {
        return this.doReadDouble();
    }

    public synchronized float parseFloat(int digits, boolean allowNewline) throws IOException {
        String s = this.doReadString(digits, allowNewline);
        return s == null ? Float.NaN : Float.parseFloat(s);
    }

    public synchronized float safeReadFloat() throws IOException {
        if (this.in == null) {
            throw new IOException(STREAM_NA);
        }
        try {
            return this.doReadFloat();
        }
        catch (Exception e) {
            System.err.println(e);
            return Float.NaN;
        }
    }

    public synchronized int readFloats(float[] f) throws IOException {
        return this.doReadFloats(f, 0, f.length);
    }

    public synchronized int readFloats(float[] f, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > f.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.doReadFloats(f, off, len);
    }

    private int doReadFloats(float[] f, int off, int len) throws IOException {
        if (this.in == null) {
            throw new IOException(STREAM_NA);
        }
        int n = 0;
        try {
            while (this.moreAvailable() && n < len) {
                f[off++] = this.doReadFloat();
                ++n;
            }
        }
        catch (IllegalFormatException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return n;
    }

    public synchronized int readNonSkipCharacter() throws IOException {
        return this.doReadNonSkipCharacter(this.skipType);
    }

    protected int doReadNonSkipCharacter(int skipChars) throws IOException {
        boolean ma = this.moreAvailable();
        int read = -1;
        this.markpos = -1;
        switch (skipChars) {
            case 0: {
                while (ma && (read = this.buf[this.pos++]) <= 32) {
                    ma = this.moreAvailable();
                }
                break;
            }
            case 1: {
                while (ma && this.isStandardDelimiter(read = this.buf[this.pos++])) {
                    ma = this.moreAvailable();
                }
                break;
            }
            case 2: {
                while (ma && this.isAlpha(read = this.buf[this.pos++])) {
                }
                ma = this.moreAvailable();
                break;
            }
            case 3: {
                while (ma && this.isStandardAlphaDelimiter(read = this.buf[this.pos++])) {
                    ma = this.moreAvailable();
                }
                break;
            }
            case 4: {
                while (ma && (read = this.buf[this.pos++]) <= 57 && read >= 48) {
                    ma = this.moreAvailable();
                }
                break;
            }
            case 5: {
                while (ma && (read = this.buf[this.pos++]) == 10 || read == 13) {
                    ma = this.moreAvailable();
                }
                break;
            }
        }
        if (ma) {
            this.markpos = this.pos - 1;
        } else {
            read = -1;
        }
        return read;
    }

    protected boolean isDelimiter(int c) {
        switch (this.delimiterType) {
            case 0: {
                return c <= 32;
            }
            case 1: {
                return this.isStandardDelimiter(c);
            }
            case 2: {
                return this.isAlpha(c);
            }
            case 3: {
                return this.isStandardAlphaDelimiter(c);
            }
            case 5: {
                return c == 10 || c == 13;
            }
            case 6: {
                return c == 34 || c == 34;
            }
        }
        return false;
    }

    public boolean isStandardDelimiter(int c) {
        return c <= 32 || c == 59 || c == 44 || c == 58;
    }

    protected boolean isStandardAlphaDelimiter(int c) {
        return this.isStandardDelimiter(c) || c == 46;
    }

    protected boolean isAlpha(int c) {
        return c != 46 && c != 43 && c != 45 && (c < 48 || c > 57);
    }

    private double doReadDouble() throws IOException {
        boolean sign;
        boolean ma;
        this.marklimit = 50;
        int read = this.doReadNonSkipCharacter(this.skipType);
        boolean bl = ma = read != -1;
        if (!ma) {
            throw new IOException("Stream Exhausted");
        }
        boolean bl2 = sign = read == 45;
        if (sign || read == 43) {
            ma = this.moreAvailable();
            if (!ma) {
                this.readFloatIllegalFormat();
            }
            read = this.buf[this.pos++];
        }
        boolean dotFound = false;
        int dot = 0;
        boolean unitFound = false;
        int unit = 0;
        while (true) {
            if (48 <= read && read <= 57) {
                if (unit > MAX_UNIT) {
                    do {
                        if (dotFound) continue;
                        ++dot;
                    } while ((ma = this.moreAvailable()) && (read = this.buf[this.pos++]) <= 57 && read >= 48);
                    break;
                }
                unitFound = true;
                unit = 10 * unit + read - 48;
                if (dotFound) {
                    --dot;
                }
            } else {
                if (read != 46) break;
                if (dotFound) {
                    this.readFloatIllegalFormat();
                } else {
                    dotFound = true;
                }
            }
            if (!(ma = this.moreAvailable())) break;
            read = this.buf[this.pos++];
        }
        if (!unitFound) {
            this.readFloatIllegalFormat();
        }
        double number = sign ? -unit : unit;
        if (!ma || this.isDelimiter(read)) {
            if (dot < 0) {
                number *= Math.pow(10.0, dot);
            }
            if (this.autoSkipSpaces && this.doReadNonSkipCharacter(0) != -1) {
                --this.pos;
            }
            this.markpos = -1;
            return number;
        }
        if (read != 101 && read != 69 || !(ma = this.moreAvailable())) {
            this.readFloatIllegalFormat();
        }
        boolean bl3 = sign = (read = this.buf[this.pos++]) == 45;
        if (sign || read == 43) {
            ma = this.moreAvailable();
            if (!ma) {
                this.readFloatIllegalFormat();
            }
            read = this.buf[this.pos++];
        }
        unit = 0;
        unitFound = false;
        while (48 <= read && read <= 57) {
            unitFound = true;
            unit = 10 * unit + read - 48;
            ma = this.moreAvailable();
            if (!ma) break;
            read = this.buf[this.pos++];
        }
        if (!unitFound || ma && !this.isDelimiter(read)) {
            this.readFloatIllegalFormat();
        }
        if (this.autoSkipSpaces && this.doReadNonSkipCharacter(0) != -1) {
            --this.pos;
        }
        if (sign) {
            unit = -unit;
        }
        if ((unit += dot) != 0) {
            number *= Math.pow(10.0, unit);
        }
        this.markpos = -1;
        return number;
    }

    private float doReadFloat() throws IOException {
        boolean sign;
        boolean ma;
        this.marklimit = 50;
        int read = this.doReadNonSkipCharacter(this.skipType);
        boolean bl = ma = read != -1;
        if (!ma) {
            throw new IOException("Stream Exhausted");
        }
        boolean bl2 = sign = read == 45;
        if (sign || read == 43) {
            ma = this.moreAvailable();
            if (!ma) {
                this.readFloatIllegalFormat();
            }
            read = this.buf[this.pos++];
        }
        boolean dotFound = false;
        int dot = 0;
        boolean unitFound = false;
        int unit = 0;
        while (true) {
            if (48 <= read && read <= 57) {
                if (unit > MAX_UNIT) {
                    do {
                        if (dotFound) continue;
                        ++dot;
                    } while ((ma = this.moreAvailable()) && (read = this.buf[this.pos++]) <= 57 && read >= 48);
                    break;
                }
                unitFound = true;
                unit = 10 * unit + read - 48;
                if (dotFound) {
                    --dot;
                }
            } else {
                if (read != 46) break;
                if (dotFound) {
                    this.readFloatIllegalFormat();
                } else {
                    dotFound = true;
                }
            }
            if (!(ma = this.moreAvailable())) break;
            read = this.buf[this.pos++];
        }
        if (!unitFound) {
            this.readFloatIllegalFormat();
        }
        float number = sign ? -unit : unit;
        if (!ma || this.isDelimiter(read)) {
            if (dot < 0) {
                number *= (float)Math.pow(10.0, dot);
            }
            if (this.autoSkipSpaces && this.doReadNonSkipCharacter(0) != -1) {
                --this.pos;
            }
            this.markpos = -1;
            return number;
        }
        if (read != 101 && read != 69 || !(ma = this.moreAvailable())) {
            this.readFloatIllegalFormat();
        }
        boolean bl3 = sign = (read = this.buf[this.pos++]) == 45;
        if (sign || read == 43) {
            ma = this.moreAvailable();
            if (!ma) {
                this.readFloatIllegalFormat();
            }
            read = this.buf[this.pos++];
        }
        unit = 0;
        unitFound = false;
        while (48 <= read && read <= 57) {
            unitFound = true;
            unit = 10 * unit + read - 48;
            ma = this.moreAvailable();
            if (!ma) break;
            read = this.buf[this.pos++];
        }
        if (!unitFound || ma && !this.isDelimiter(read)) {
            this.readFloatIllegalFormat();
        }
        if (this.autoSkipSpaces && this.doReadNonSkipCharacter(0) != -1) {
            --this.pos;
        }
        if (sign) {
            unit = -unit;
        }
        if ((unit += dot) != 0) {
            number *= (float)Math.pow(10.0, unit);
        }
        this.markpos = -1;
        return number;
    }

    public synchronized String readString() throws IOException {
        boolean ma;
        if (this.delimiterType == 2) {
            throw new IOException("Wrong delimiter type");
        }
        this.marklimit = this.maxStringLength + 1;
        if (this.doReadNonSkipCharacter(this.skipType) < 0) {
            return null;
        }
        while ((ma = this.moreAvailable()) && !this.isDelimiter(this.buf[this.pos++])) {
        }
        if (this.markpos < 0) {
            throw new IOException("Exceeded max string length");
        }
        if (ma) {
            --this.pos;
        }
        String string = new String(this.buf, this.markpos, this.pos - this.markpos);
        this.markpos = -1;
        return string;
    }

    public synchronized String readString(boolean allowQuotedSpace) throws IOException {
        boolean ma;
        if (this.delimiterType == 2) {
            throw new IOException("Wrong delimiter type");
        }
        this.marklimit = this.maxStringLength + 1;
        if (this.doReadNonSkipCharacter(this.skipType) < 0) {
            return null;
        }
        if (allowQuotedSpace && (this.buf[this.markpos] == 34 || this.buf[this.markpos] == 34)) {
            this.setDelimiter(6);
            ++this.markpos;
        }
        while ((ma = this.moreAvailable()) && !this.isDelimiter(this.buf[this.pos++])) {
        }
        this.setDelimiter(0);
        if (this.markpos < 0) {
            throw new IOException("Exceeded max string length");
        }
        if (ma) {
            --this.pos;
        }
        String string = new String(this.buf, this.markpos, this.pos - this.markpos);
        this.markpos = -1;
        return string;
    }

    public synchronized String readString(int number, boolean allowNewline) throws IOException {
        return this.doReadString(number, allowNewline);
    }

    protected String doReadString(int number, boolean allowNewline) throws IOException {
        String string = null;
        if (number > 0) {
            int read;
            this.markpos = this.pos;
            this.marklimit = number;
            int i = 0;
            while (i < number && this.moreAvailable()) {
                if (!allowNewline && (this.buf[this.pos] == 10 || this.buf[this.pos] == 13)) break;
                ++this.pos;
                ++i;
            }
            if ((read = this.pos - this.markpos) > 0) {
                string = new String(this.buf, this.markpos, read);
            }
            this.markpos = -1;
        }
        return string;
    }

    public static void main(String[] args) {
        AsciiStream as;
        FileInputStream fi;
        block24: {
            fi = null;
            try {
                try {
                    int s;
                    fi = new FileInputStream("R:\\3dviewer\\src\\nitg\\geo3djviewer\\util\\text.txt");
                    as = new AsciiStream(fi, 4098);
                    as.setSkipType(3);
                    as.setDelimiter(3);
                    while ((s = as.read()) != -1) {
                        System.out.println(s);
                    }
                }
                catch (IOException e) {
                    System.err.println(e);
                    try {
                        fi.close();
                    }
                    catch (IOException e2) {
                        System.err.println(e2);
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                try {
                    fi.close();
                }
                catch (IOException e) {
                    System.err.println(e);
                }
                throw throwable;
            }
            try {
                fi.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
        try {
            try {
                String s;
                fi = new FileInputStream("text.txt");
                as = new AsciiStream(fi, 4098);
                as.setSkipType(3);
                as.setDelimiter(3);
                while ((s = as.readString(5, true)) != null) {
                    System.out.println(s);
                }
            }
            catch (IOException e) {
                System.err.println(e);
                try {
                    fi.close();
                }
                catch (IOException e3) {
                    System.err.println(e3);
                }
            }
        }
        finally {
            try {
                fi.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
        }
    }

    public static void main3(String[] args) {
        block28: {
            block27: {
                FileInputStream fi = null;
                byte[] b = null;
                try {
                    try {
                        fi = new FileInputStream("/tmp/15MIdiep.grd.DAT");
                        b = new byte[fi.available()];
                        fi.read(b);
                    }
                    catch (IOException e) {
                        System.err.println(e);
                        if (fi != null) {
                            try {
                                fi.close();
                            }
                            catch (IOException e2) {
                                System.err.println(e2);
                            }
                        }
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    if (fi != null) {
                        try {
                            fi.close();
                        }
                        catch (IOException e) {
                            System.err.println(e);
                        }
                    }
                    throw throwable;
                }
                if (fi != null) {
                    try {
                        fi.close();
                    }
                    catch (IOException e) {
                        System.err.println(e);
                    }
                }
            }
            BufferedInputStream as = null;
            try {
                try {
                    float flt;
                    as = new AsciiStream(new FileInputStream("/tmp/15MIdiep.grd.DAT"), 4098);
                    ((AsciiStream)as).skipTag("@");
                    ((AsciiStream)as).skipTag("@");
                    System.out.println("Start parsing numbers");
                    long timer = System.currentTimeMillis();
                    while (((AsciiStream)as).more() && !Float.isNaN(flt = ((AsciiStream)as).safeReadFloat())) {
                    }
                    timer = System.currentTimeMillis() - timer;
                    System.out.println("Ready (" + timer + " ms)");
                }
                catch (IOException e) {
                    System.err.println(e);
                    if (as == null) break block28;
                    try {
                        as.close();
                    }
                    catch (IOException e3) {
                        System.err.println(e3);
                    }
                }
            }
            finally {
                if (as != null) {
                    try {
                        as.close();
                    }
                    catch (IOException e) {
                        System.err.println(e);
                    }
                }
            }
        }
    }
}

