/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ByteBufferHelper {
    private ByteBuffer buffer;
    private FileChannel channel;
    private long offset = 0L;
    static int LENGTHBUF = 10000000;
    static byte[] skipbuf = new byte[LENGTHBUF];

    public ByteBufferHelper(FileChannel channel) {
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(LENGTHBUF);
    }

    public static void main(String[] args) {
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void flipwrite() throws IOException {
        this.buffer.flip();
        this.channel.write(this.buffer);
        this.buffer.clear();
    }

    public void clearread() throws IOException {
        this.buffer.clear();
        this.channel.read(this.buffer);
        this.buffer.position(0);
    }

    public void putLong(long l) throws IOException {
        if (this.buffer.remaining() < 8) {
            this.flipwrite();
        }
        this.buffer.putLong(l);
    }

    public void putInt(int l) throws IOException {
        if (this.buffer.remaining() < 4) {
            this.flipwrite();
        }
        this.buffer.putInt(l);
    }

    public void putFloat(float l) throws IOException {
        if (this.buffer.remaining() < 4) {
            this.flipwrite();
        }
        this.buffer.putFloat(l);
    }

    public void putDouble(double l) throws IOException {
        if (this.buffer.remaining() < 8) {
            this.flipwrite();
        }
        this.buffer.putDouble(l);
    }

    public void putString(String l) throws IOException {
        byte[] b = l.getBytes();
        this.buffer.putInt(b.length);
        int k = 0;
        while (k < b.length) {
            this.buffer.putInt(b[k]);
            ++k;
        }
    }

    public int getInt() throws IOException {
        if (this.buffer.remaining() < 4) {
            this.clearread();
        }
        this.offset += 4L;
        return this.buffer.getInt();
    }

    public long getLong() throws IOException {
        if (this.buffer.remaining() < 8) {
            this.clearread();
        }
        this.offset += 8L;
        return this.buffer.getLong();
    }

    public float getFloat() throws IOException {
        if (this.buffer.remaining() < 4) {
            this.clearread();
        }
        this.offset += 4L;
        return this.buffer.getFloat();
    }

    public double getDouble() throws IOException {
        if (this.buffer.remaining() < 8) {
            this.clearread();
        }
        return this.buffer.getDouble();
    }

    public void skipFloat(int n) throws IOException {
        int remaining = n * 4;
        int skipped = 0;
        while (remaining > 0) {
            if (this.buffer.remaining() < 1) {
                this.clearread();
            }
            skipped = Math.min(this.buffer.remaining(), remaining);
            this.buffer.get(skipbuf, 0, skipped);
            remaining -= skipped;
        }
        this.offset += (long)(n * 4);
    }

    public void skipInt(int n) throws IOException {
        int remaining = n * 4;
        int skipped = 0;
        while (remaining > 0) {
            if (this.buffer.remaining() < 1) {
                this.clearread();
            }
            skipped = Math.min(this.buffer.remaining(), remaining);
            this.buffer.get(skipbuf, 0, skipped);
            remaining -= skipped;
        }
        this.offset += (long)(n * 4);
    }

    public String getString() throws IOException {
        int nk = this.buffer.getInt();
        byte[] b = new byte[nk];
        int k = 0;
        while (k < nk) {
            b[k] = (byte)this.buffer.getInt();
            ++k;
        }
        this.offset += (long)((nk + 1) * 4);
        return new String(b);
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }
}

