/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.util;

import java.awt.Color;

public class Convolution
extends Thread {
    public static double singlePixelConvolution(double[][] input, int x, int y, double[][] k, int kernelWidth, int kernelHeight) {
        double output = 0.0;
        int i = 0;
        while (i < kernelWidth) {
            int j = 0;
            while (j < kernelHeight) {
                output += input[x + i][y + j] * k[i][j];
                ++j;
            }
            ++i;
        }
        return output;
    }

    public static int applyConvolution(int[][] input, int x, int y, double[][] k, int kernelWidth, int kernelHeight) {
        int output = 0;
        int i = 0;
        while (i < kernelWidth) {
            int j = 0;
            while (j < kernelHeight) {
                output += (int)Math.round((double)input[x + i][y + j] * k[i][j]);
                ++j;
            }
            ++i;
        }
        return output;
    }

    public static double[][] convolution2D(double[][] input, int width, int height, double[][] kernel, int kernelWidth, int kernelHeight) {
        int j;
        int smallWidth = width - kernelWidth + 1;
        int smallHeight = height - kernelHeight + 1;
        double[][] output = new double[smallWidth][smallHeight];
        int i = 0;
        while (i < smallWidth) {
            j = 0;
            while (j < smallHeight) {
                output[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < smallWidth) {
            j = 0;
            while (j < smallHeight) {
                output[i][j] = Convolution.singlePixelConvolution(input, i, j, kernel, kernelWidth, kernelHeight);
                ++j;
            }
            ++i;
        }
        return output;
    }

    public static double[][] convolution2DPadded(double[][] input, int width, int height, double[][] kernel, int kernelWidth, int kernelHeight) {
        int i;
        int smallWidth = width - kernelWidth + 1;
        int smallHeight = height - kernelHeight + 1;
        int top = kernelHeight / 2;
        int left = kernelWidth / 2;
        double[][] small = new double[smallWidth][smallHeight];
        small = Convolution.convolution2D(input, width, height, kernel, kernelWidth, kernelHeight);
        double[][] large = new double[width][height];
        int j = 0;
        while (j < height) {
            i = 0;
            while (i < width) {
                large[i][j] = 0.0;
                ++i;
            }
            ++j;
        }
        j = 0;
        while (j < smallHeight) {
            i = 0;
            while (i < smallWidth) {
                large[i + left][j + top] = small[i][j];
                ++i;
            }
            ++j;
        }
        return large;
    }

    public static double[] convolutionDouble(double[][] input, int width, int height, double[][] kernel, int kernelWidth, int kernelHeight) {
        int smallWidth = width - kernelWidth + 1;
        int smallHeight = height - kernelHeight + 1;
        double[][] small = new double[smallWidth][smallHeight];
        small = Convolution.convolution2D(input, width, height, kernel, kernelWidth, kernelHeight);
        double[] result = new double[smallWidth * smallHeight];
        int j = 0;
        while (j < smallHeight) {
            int i = 0;
            while (i < smallWidth) {
                result[j * smallWidth + i] = small[i][j];
                ++i;
            }
            ++j;
        }
        return result;
    }

    public static double[] convolutionDoublePadded(double[][] input, int width, int height, double[][] kernel, int kernelWidth, int kernelHeight) {
        double[][] result2D = new double[width][height];
        result2D = Convolution.convolution2DPadded(input, width, height, kernel, kernelWidth, kernelHeight);
        double[] result = new double[width * height];
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                result[j * width + i] = result2D[i][j];
                ++i;
            }
            ++j;
        }
        return result;
    }

    public static int[] doublesToValidPixels(double[] greys) {
        int[] result = new int[greys.length];
        int i = 0;
        while (i < greys.length) {
            int grey = greys[i] > 255.0 ? 255 : (greys[i] < 0.0 ? 0 : (int)Math.round(greys[i]));
            result[i] = new Color(grey, grey, grey).getRGB();
            ++i;
        }
        return result;
    }

    public double[][] convolutionType1(double[][] input, int width, int height, double[][] kernel, int kernelWidth, int kernelHeight, int iterations) {
        double[][] newInput = (double[][])input.clone();
        double[][] output = (double[][])input.clone();
        int i = 0;
        while (i < iterations) {
            int smallWidth = width - kernelWidth + 1;
            int smallHeight = height - kernelHeight + 1;
            output = new double[smallWidth][smallHeight];
            output = Convolution.convolution2D(newInput, width, height, kernel, kernelWidth, kernelHeight);
            width = smallWidth;
            height = smallHeight;
            newInput = (double[][])output.clone();
            ++i;
        }
        return output;
    }

    public double[][] convolutionType2(double[][] input, int width, int height, double[][] kernel, int kernelWidth, int kernelHeight, int iterations) {
        double[][] newInput = (double[][])input.clone();
        double[][] output = (double[][])input.clone();
        int i = 0;
        while (i < iterations) {
            output = new double[width][height];
            output = Convolution.convolution2DPadded(newInput, width, height, kernel, kernelWidth, kernelHeight);
            newInput = (double[][])output.clone();
            ++i;
        }
        return output;
    }

    public static int[] convolution_image(int[] input, int width, int height, double[][] kernel, int kernelWidth, int kernelHeight, double scale, double offset) {
        int i;
        double[][] input2D = new double[width][height];
        double[] output = new double[width * height];
        int j = 0;
        while (j < height) {
            i = 0;
            while (i < width) {
                input2D[i][j] = new Color(input[j * width + i]).getRed();
                ++i;
            }
            ++j;
        }
        output = Convolution.convolutionDoublePadded(input2D, width, height, kernel, kernelWidth, kernelHeight);
        int[] outputInts = new int[width * height];
        i = 0;
        while (i < outputInts.length) {
            outputInts[i] = (int)Math.round(output[i] * scale + offset);
            if (outputInts[i] > 255) {
                outputInts[i] = 255;
            }
            if (outputInts[i] < 0) {
                outputInts[i] = 0;
            }
            int g = outputInts[i];
            outputInts[i] = new Color(g, g, g).getRGB();
            ++i;
        }
        return outputInts;
    }
}

