/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.util;

import java.io.IOException;
import java.io.InputStream;
import tno.geoenergy.util.AsciiStream;

public class EclipseAsciiStream
extends AsciiStream {
    private float floatinbuffer;
    private int howmanyleft = 0;
    private String commentType = "";

    public EclipseAsciiStream(InputStream in) {
        super(in);
    }

    public EclipseAsciiStream(InputStream in, int size) {
        super(in, size);
    }

    public void setCommentType(String comment) {
        this.commentType = comment;
    }

    protected int doSkipCommentLine() throws IOException {
        boolean ma = this.moreAvailable();
        int read = -1;
        this.pos = this.markpos;
        if (ma) {
            int length = this.commentType.length();
            int i = 0;
            while (i < length) {
                ma = this.moreAvailable();
                if (!ma || this.commentType.charAt(i) != this.buf[this.pos++]) break;
                ++i;
            }
            if (i == length) {
                while (!(ma && (read = this.buf[this.pos++]) == 10 || read == 13)) {
                    ma = this.moreAvailable();
                }
            } else {
                this.pos = this.markpos;
                read = -1;
            }
        }
        return read;
    }

    @Override
    protected int doReadNonSkipCharacter(int skipChars) throws IOException {
        int newread;
        int read = super.doReadNonSkipCharacter(skipChars);
        if (read != -1 && (newread = this.doSkipCommentLine()) != -1) {
            read = this.doReadNonSkipCharacter(skipChars);
        }
        return read;
    }

    @Override
    public float readFloat() {
        if (this.howmanyleft > 0) {
            --this.howmanyleft;
            return this.floatinbuffer;
        }
        try {
            String tokens = super.readString();
            int iasterisk = tokens.indexOf("*");
            if (iasterisk < 0) {
                return Float.parseFloat(tokens);
            }
            String before = tokens.substring(0, iasterisk);
            this.howmanyleft = Integer.parseInt(before) - 1;
            String after = tokens.substring(iasterisk + 1, tokens.length());
            this.floatinbuffer = Float.parseFloat(after);
            return this.floatinbuffer;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 123456.0f;
        }
    }
}

