/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.util;

import tno.geoenergy.data.Grid;

public class GaussianSmoothingGrid {
    public static double gaussianSmooth(double sigma, int x, int y) {
        double g = 0.0;
        double ySubPixel = (double)y - 0.5;
        while (ySubPixel < (double)y + 0.55) {
            double xSubPixel = (double)x - 0.5;
            while (xSubPixel < (double)x + 0.55) {
                g += 1.0 / (Math.PI * 2 * sigma * sigma) * Math.pow(Math.E, -(xSubPixel * xSubPixel + ySubPixel * ySubPixel) / (2.0 * sigma * sigma));
                xSubPixel += 0.1;
            }
            ySubPixel += 0.1;
        }
        return g /= 121.0;
    }

    public static double[][] gaussian2D(double sigma, int size) {
        double[][] kernel = new double[size][size];
        int j = 0;
        while (j < size) {
            int i = 0;
            while (i < size) {
                kernel[i][j] = GaussianSmoothingGrid.gaussianSmooth(sigma, i - size / 2, j - size / 2);
                ++i;
            }
            ++j;
        }
        double sum = 0.0;
        int j2 = 0;
        while (j2 < size) {
            int i = 0;
            while (i < size) {
                sum += kernel[i][j2];
                ++i;
            }
            ++j2;
        }
        return kernel;
    }

    public static void smoothGrid(Grid g, double filtersigma) {
        double scaledsigma = filtersigma / (0.5 * (double)(g.dx + g.dy));
        int size = (int)(scaledsigma * 4.0);
        if (size % 2 == 0) {
            ++size;
        }
        int icentral = size / 2;
        double[][] kernel = GaussianSmoothingGrid.gaussian2D(scaledsigma, size);
        Grid gcopy = new Grid(g);
        int nx = g.nx;
        int ny = g.ny;
        double val = 0.0;
        double weight = 0.0;
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                if (g.defined(i, j)) {
                    val = 0.0;
                    weight = 0.0;
                    int ii = 0;
                    while (ii < size) {
                        int jj = 0;
                        while (jj < size) {
                            int ig = i - (ii - icentral);
                            int jg = j - (jj - icentral);
                            if (g.defined(ig, jg)) {
                                val += (double)gcopy.values[ig][jg] * kernel[ii][jj];
                                weight += kernel[ii][jj];
                            }
                            ++jj;
                        }
                        ++ii;
                    }
                    g.values[i][j] = (float)(val / weight);
                    System.out.println(g.values[i][j] / gcopy.values[i][j]);
                }
                ++j;
            }
            ++i;
        }
    }

    public static void smoothValues(boolean[][] active, double[][] g, double dxdy, double filtersigma) {
        double scaledsigma = filtersigma / dxdy;
        int size = (int)(scaledsigma * 4.0);
        if (size % 2 == 0) {
            ++size;
        }
        int icentral = size / 2;
        double[][] kernel = GaussianSmoothingGrid.gaussian2D(scaledsigma, size);
        int nx = g.length;
        int ny = g[0].length;
        double[][] gcopy = new double[nx][ny];
        int i = 0;
        while (i < nx) {
            int j = 0;
            while (j < ny) {
                gcopy[i][j] = g[i][j];
                ++j;
            }
            ++i;
        }
        double val = 0.0;
        double weight = 0.0;
        int i2 = 0;
        while (i2 < nx) {
            int j = 0;
            while (j < ny) {
                if (active[i2][j]) {
                    val = 0.0;
                    weight = 0.0;
                    int ii = 0;
                    while (ii < size) {
                        int jj = 0;
                        while (jj < size) {
                            int ig = i2 - (ii - icentral);
                            int jg = j - (jj - icentral);
                            if (ig > 0 && ig < nx && jg > 0 && jg < ny && active[ig][jg]) {
                                val += gcopy[ig][jg] * kernel[ii][jj];
                                weight += kernel[ii][jj];
                            }
                            ++jj;
                        }
                        ++ii;
                    }
                    g[i2][j] = val / weight;
                }
                ++j;
            }
            ++i2;
        }
    }

    public static void main(String[] args) {
        String name = "D:\\papers\\thermalmodel3D\\manuel\\3dmodelnorm1_step1\\heatcrustUC0";
        Grid g = new Grid(String.valueOf(name) + ".grd");
        double filtersigma = 5000.0;
        GaussianSmoothingGrid.smoothGrid(g, filtersigma);
        g.setFileName(String.valueOf(name) + "_filtered" + ".grd");
        g.setDataFormat("SURFER");
        try {
            g.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

