/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.util;

import java.awt.Color;
import tno.geoenergy.util.Convolution;

public class Gaussiansmoothing
extends Thread {
    public static double gaussianDiscrete2D(double theta, int x, int y) {
        double g = 0.0;
        double ySubPixel = (double)y - 0.5;
        while (ySubPixel < (double)y + 0.55) {
            double xSubPixel = (double)x - 0.5;
            while (xSubPixel < (double)x + 0.55) {
                g += 1.0 / (Math.PI * 2 * theta * theta) * Math.pow(Math.E, -(xSubPixel * xSubPixel + ySubPixel * ySubPixel) / (2.0 * theta * theta));
                xSubPixel += 0.1;
            }
            ySubPixel += 0.1;
        }
        return g /= 121.0;
    }

    public static double[][] gaussian2D(double theta, int size) {
        double[][] kernel = new double[size][size];
        int j = 0;
        while (j < size) {
            int i = 0;
            while (i < size) {
                kernel[i][j] = Gaussiansmoothing.gaussianDiscrete2D(theta, i - size / 2, j - size / 2);
                ++i;
            }
            ++j;
        }
        double sum = 0.0;
        int j2 = 0;
        while (j2 < size) {
            int i = 0;
            while (i < size) {
                sum += kernel[i][j2];
                ++i;
            }
            ++j2;
        }
        return kernel;
    }

    public static double[][] smooth(double[][] input, int width, int height, int ks, double theta) {
        Convolution convolution = new Convolution();
        double[][] gaussianKernel = new double[ks][ks];
        double[][] output = new double[width][height];
        gaussianKernel = Gaussiansmoothing.gaussian2D(theta, ks);
        output = Convolution.convolution2DPadded(input, width, height, gaussianKernel, ks, ks);
        return output;
    }

    public static int[] smooth_image(int[] input, int w, int h, int ks, double theta) {
        int i;
        double[][] input2D = new double[w][h];
        double[] output1D = new double[w * h];
        double[][] output2D = new double[w][h];
        int[] output = new int[w * h];
        int j = 0;
        while (j < h) {
            i = 0;
            while (i < w) {
                input2D[i][j] = new Color(input[j * w + i]).getRed();
                ++i;
            }
            ++j;
        }
        output2D = Gaussiansmoothing.smooth(input2D, w, h, ks, theta);
        j = 0;
        while (j < h) {
            i = 0;
            while (i < w) {
                output1D[j * w + i] = output2D[i][j];
                ++i;
            }
            ++j;
        }
        int i2 = 0;
        while (i2 < output1D.length) {
            int grey = (int)Math.round(output1D[i2]);
            if (grey > 255) {
                grey = 255;
            }
            if (grey < 0) {
                grey = 0;
            }
            output[i2] = new Color(grey, grey, grey).getRGB();
            ++i2;
        }
        return output;
    }
}

