/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.vinsome;

import java.util.Random;

public class Vinsome {
    private static double k = 1.0E-6;
    private static double conductivity = 3.0;
    private double d = 0.0;
    private double time;
    private double oldtime = this.time = 0.0;
    double pc = 0.0;
    double oldpc;
    double qc;
    double oldqc = this.qc = 0.0;
    double theta;
    double oldtheta = this.theta = 0.0;
    double Ic;
    double oldIc = this.Ic = 0.0;

    public double getPc() {
        return this.pc;
    }

    public double getQc() {
        return this.qc;
    }

    public double getIc() {
        return this.Ic;
    }

    private void calcD() {
        this.d = Math.pow(k * this.time, 0.5) * 0.5;
    }

    public double calcHeatflow() {
        double q = conductivity * (this.theta / this.d - this.pc);
        return q;
    }

    public void updatePcQc(double newtime, double newtheta) {
        double dtheta = newtheta - this.theta;
        double dtime = newtime - this.time;
        this.backup();
        this.Ic = this.theta * this.d + this.pc * this.d * this.d + 2.0 * this.qc * this.d * this.d * this.d;
        this.setTime(newtime);
        this.theta = newtheta;
        double kk = k;
        this.pc = (kk * dtime * this.theta / this.d + this.Ic - this.d * this.d * this.d * dtheta / (kk * dtime)) / (3.0 * this.d * this.d + kk * dtime);
        this.qc = (2.0 * this.pc * this.d - this.theta + this.d * this.d * dtheta / (kk * dtime)) / (2.0 * this.d * this.d);
    }

    private void backup() {
        this.oldtheta = this.theta;
        this.oldtime = this.time;
        this.oldIc = this.Ic;
        this.oldqc = this.qc;
        this.oldpc = this.pc;
    }

    private void restore() {
        this.theta = this.oldtheta;
        this.time = this.oldtime;
        this.Ic = this.oldIc;
        this.qc = this.oldqc;
        this.pc = this.oldpc;
        this.calcD();
    }

    public static void main(String[] args) {
        double tinit = 200.0;
        double twall = 50.0;
        Vinsome vinsome = new Vinsome();
        double startup = 10.0;
        double theta = tinit - twall;
        int ndays = 100;
        System.out.println("time [days], heat flow [W/m-2], pc, qc, Ic ");
        int Nmult = 1;
        double day = 0.1;
        double stepday = 0.1;
        Random r = new Random();
        int i = 1;
        while (i < 100 * Nmult) {
            vinsome.updatePcQc((day += stepday) * 24.0 * 3600.0 / (double)Nmult, theta);
            if (i % Nmult == 0) {
                System.out.println(day + " " + vinsome.calcHeatflow() + " " + vinsome.getPc() + " " + vinsome.getQc() + " " + vinsome.getIc());
            }
            ++i;
        }
        System.out.println("temperature profile for days : " + day);
        System.out.println("x[m]  temp[C] ");
        double step = 0.1;
        int nx = 50;
        double[] temp = vinsome.getTemperature(tinit, nx, step);
        int i2 = 0;
        while (i2 < nx) {
            System.out.println((double)i2 * step + " " + temp[i2]);
            ++i2;
        }
    }

    public double[] getTemperature(double initialTemperatureWall, int nx, double step) {
        double[] temp = new double[nx];
        double x = 0.0;
        int i = 0;
        while (i < nx) {
            x = (double)i * step;
            temp[i] = initialTemperatureWall - (this.theta + this.pc * x + this.qc * x * x) * Math.exp(-x / this.d);
            ++i;
        }
        return temp;
    }

    public static double getK() {
        return k;
    }

    public static void setK(double k) {
        Vinsome.k = k;
    }

    public static double getConductivity() {
        return conductivity;
    }

    public static void setConductivity(double conductivity) {
        Vinsome.conductivity = conductivity;
    }

    public double getD() {
        return this.d;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
        this.calcD();
    }
}

