/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class KdTree<T extends XYZPoint> {
    private int k = 3;
    private KdNode root = null;
    private static final Comparator<XYZPoint> X_COMPARATOR = new Comparator<XYZPoint>(){

        @Override
        public int compare(XYZPoint o1, XYZPoint o2) {
            if (o1.x < o2.x) {
                return -1;
            }
            if (o1.x > o2.x) {
                return 1;
            }
            return 0;
        }
    };
    private static final Comparator<XYZPoint> Y_COMPARATOR = new Comparator<XYZPoint>(){

        @Override
        public int compare(XYZPoint o1, XYZPoint o2) {
            if (o1.y < o2.y) {
                return -1;
            }
            if (o1.y > o2.y) {
                return 1;
            }
            return 0;
        }
    };
    private static final Comparator<XYZPoint> Z_COMPARATOR = new Comparator<XYZPoint>(){

        @Override
        public int compare(XYZPoint o1, XYZPoint o2) {
            if (o1.z < o2.z) {
                return -1;
            }
            if (o1.z > o2.z) {
                return 1;
            }
            return 0;
        }
    };
    protected static final int X_AXIS = 0;
    protected static final int Y_AXIS = 1;
    protected static final int Z_AXIS = 2;

    public KdTree() {
    }

    public KdTree(List<XYZPoint> list) {
        this.root = KdTree.createNode(list, this.k, 0);
    }

    private static KdNode createNode(List<XYZPoint> list, int k, int depth) {
        if (list == null || list.size() == 0) {
            return null;
        }
        int axis = depth % k;
        if (axis == 0) {
            Collections.sort(list, X_COMPARATOR);
        } else if (axis == 1) {
            Collections.sort(list, Y_COMPARATOR);
        } else {
            Collections.sort(list, Z_COMPARATOR);
        }
        int mediaIndex = list.size() / 2;
        KdNode node = new KdNode(k, depth, list.get(mediaIndex));
        if (list.size() > 0) {
            List<XYZPoint> more;
            List<XYZPoint> less;
            if (mediaIndex - 1 >= 0 && (less = list.subList(0, mediaIndex)).size() > 0) {
                node.lesser = KdTree.createNode(less, k, depth + 1);
                node.lesser.parent = node;
            }
            if (mediaIndex + 1 <= list.size() - 1 && (more = list.subList(mediaIndex + 1, list.size())).size() > 0) {
                node.greater = KdTree.createNode(more, k, depth + 1);
                node.greater.parent = node;
            }
        }
        return node;
    }

    public boolean add(T value) {
        if (value == null) {
            return false;
        }
        if (this.root == null) {
            this.root = new KdNode((XYZPoint)value);
            return true;
        }
        KdNode node = this.root;
        while (true) {
            if (KdNode.compareTo(node.depth, node.k, node.id, value) <= 0) {
                if (node.lesser == null) {
                    KdNode newNode = new KdNode(this.k, node.depth + 1, (XYZPoint)value);
                    newNode.parent = node;
                    node.lesser = newNode;
                    break;
                }
                node = node.lesser;
                continue;
            }
            if (node.greater == null) {
                KdNode newNode = new KdNode(this.k, node.depth + 1, (XYZPoint)value);
                newNode.parent = node;
                node.greater = newNode;
                break;
            }
            node = node.greater;
        }
        return true;
    }

    public boolean contains(T value) {
        if (value == null) {
            return false;
        }
        KdNode node = KdTree.getNode(this, value);
        return node != null;
    }

    private static final <T extends XYZPoint> KdNode getNode(KdTree<T> tree, T value) {
        if (tree == null || tree.root == null || value == null) {
            return null;
        }
        KdNode node = tree.root;
        while (!node.id.equals(value)) {
            if (KdNode.compareTo(node.depth, node.k, node.id, value) < 0) {
                if (node.greater == null) {
                    return null;
                }
                node = node.greater;
                continue;
            }
            if (node.lesser == null) {
                return null;
            }
            node = node.lesser;
        }
        return node;
    }

    public boolean remove(T value) {
        if (value == null) {
            return false;
        }
        KdNode node = KdTree.getNode(this, value);
        if (node == null) {
            return false;
        }
        KdNode parent = node.parent;
        if (parent != null) {
            if (parent.lesser != null && node.equals(parent.lesser)) {
                List<XYZPoint> nodes = KdTree.getTree(node);
                if (nodes.size() > 0) {
                    parent.lesser = KdTree.createNode(nodes, node.k, node.depth);
                    if (parent.lesser != null) {
                        parent.lesser.parent = parent;
                    }
                } else {
                    parent.lesser = null;
                }
            } else {
                List<XYZPoint> nodes = KdTree.getTree(node);
                if (nodes.size() > 0) {
                    parent.greater = KdTree.createNode(nodes, node.k, node.depth);
                    if (parent.greater != null) {
                        parent.greater.parent = parent;
                    }
                } else {
                    parent.greater = null;
                }
            }
        } else {
            List<XYZPoint> nodes = KdTree.getTree(node);
            this.root = nodes.size() > 0 ? KdTree.createNode(nodes, node.k, node.depth) : null;
        }
        return true;
    }

    private static final List<XYZPoint> getTree(KdNode root) {
        ArrayList<XYZPoint> list = new ArrayList<XYZPoint>();
        if (root == null) {
            return list;
        }
        if (root.lesser != null) {
            list.add(root.lesser.id);
            list.addAll(KdTree.getTree(root.lesser));
        }
        if (root.greater != null) {
            list.add(root.greater.id);
            list.addAll(KdTree.getTree(root.greater));
        }
        return list;
    }

    public Collection<T> nearestNeighbourSearch(int K, T value) {
        if (value == null) {
            return null;
        }
        TreeSet<KdNode> results = new TreeSet<KdNode>(new EuclideanComparator((XYZPoint)value));
        KdNode prev = null;
        KdNode node = this.root;
        while (node != null) {
            if (KdNode.compareTo(node.depth, node.k, node.id, value) < 0) {
                prev = node;
                node = node.greater;
                continue;
            }
            prev = node;
            node = node.lesser;
        }
        KdNode leaf = prev;
        if (leaf != null) {
            HashSet<KdNode> examined = new HashSet<KdNode>();
            node = leaf;
            while (node != null) {
                KdTree.searchNode(value, node, K, results, examined);
                node = node.parent;
            }
        }
        ArrayList<XYZPoint> collection = new ArrayList<XYZPoint>(K);
        for (KdNode kdNode : results) {
            collection.add(kdNode.id);
        }
        return collection;
    }

    private static final <T extends XYZPoint> void searchNode(T value, KdNode node, int K, TreeSet<KdNode> results, Set<KdNode> examined) {
        boolean lineIntersectsCube;
        double p2;
        double p1;
        Double nodeDistance;
        examined.add(node);
        KdNode lastNode = null;
        Double lastDistance = Double.MAX_VALUE;
        if (results.size() > 0) {
            lastNode = results.last();
            lastDistance = lastNode.id.euclideanDistance(value);
        }
        if ((nodeDistance = Double.valueOf(node.id.euclideanDistance(value))).compareTo(lastDistance) < 0) {
            if (results.size() == K && lastNode != null) {
                results.remove(lastNode);
            }
            results.add(node);
        } else if (nodeDistance.equals(lastDistance)) {
            results.add(node);
        } else if (results.size() < K) {
            results.add(node);
        }
        lastNode = results.last();
        lastDistance = lastNode.id.euclideanDistance(value);
        int axis = node.depth % node.k;
        KdNode lesser = node.lesser;
        KdNode greater = node.greater;
        if (lesser != null && !examined.contains(lesser)) {
            examined.add(lesser);
            p1 = Double.MIN_VALUE;
            p2 = Double.MIN_VALUE;
            if (axis == 0) {
                p1 = node.id.x;
                p2 = ((XYZPoint)value).x - lastDistance;
            } else if (axis == 1) {
                p1 = node.id.y;
                p2 = ((XYZPoint)value).y - lastDistance;
            } else {
                p1 = node.id.z;
                p2 = ((XYZPoint)value).z - lastDistance;
            }
            boolean bl = lineIntersectsCube = p2 <= p1;
            if (lineIntersectsCube) {
                KdTree.searchNode(value, lesser, K, results, examined);
            }
        }
        if (greater != null && !examined.contains(greater)) {
            examined.add(greater);
            p1 = Double.MIN_VALUE;
            p2 = Double.MIN_VALUE;
            if (axis == 0) {
                p1 = node.id.x;
                p2 = ((XYZPoint)value).x + lastDistance;
            } else if (axis == 1) {
                p1 = node.id.y;
                p2 = ((XYZPoint)value).y + lastDistance;
            } else {
                p1 = node.id.z;
                p2 = ((XYZPoint)value).z + lastDistance;
            }
            boolean bl = lineIntersectsCube = p2 >= p1;
            if (lineIntersectsCube) {
                KdTree.searchNode(value, greater, K, results, examined);
            }
        }
    }

    public String toString() {
        return TreePrinter.getString(this);
    }

    protected static class EuclideanComparator
    implements Comparator<KdNode> {
        private XYZPoint point = null;

        public EuclideanComparator(XYZPoint point) {
            this.point = point;
        }

        @Override
        public int compare(KdNode o1, KdNode o2) {
            Double d2;
            Double d1 = this.point.euclideanDistance(o1.id);
            if (d1.compareTo(d2 = Double.valueOf(this.point.euclideanDistance(o2.id))) < 0) {
                return -1;
            }
            if (d2.compareTo(d1) < 0) {
                return 1;
            }
            return o1.id.compareTo(o2.id);
        }
    }

    public static class KdNode
    implements Comparable<KdNode> {
        private int k = 3;
        private int depth = 0;
        private XYZPoint id = null;
        private KdNode parent = null;
        private KdNode lesser = null;
        private KdNode greater = null;

        public KdNode(XYZPoint id) {
            this.id = id;
        }

        public KdNode(int k, int depth, XYZPoint id) {
            this(id);
            this.k = k;
            this.depth = depth;
        }

        public static int compareTo(int depth, int k, XYZPoint o1, XYZPoint o2) {
            int axis = depth % k;
            if (axis == 0) {
                return X_COMPARATOR.compare(o1, o2);
            }
            return Y_COMPARATOR.compare(o1, o2);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof KdNode)) {
                return false;
            }
            KdNode kdNode = (KdNode)obj;
            return this.compareTo(kdNode) == 0;
        }

        @Override
        public int compareTo(KdNode o) {
            return KdNode.compareTo(this.depth, this.k, this.id, o.id);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("k=").append(this.k);
            builder.append(" depth=").append(this.depth);
            builder.append(" id=").append(this.id.toString());
            return builder.toString();
        }
    }

    protected static class TreePrinter {
        protected TreePrinter() {
        }

        public static <T extends XYZPoint> String getString(KdTree<T> tree) {
            if (((KdTree)tree).root == null) {
                return "Tree has no nodes.";
            }
            return TreePrinter.getString(((KdTree)tree).root, "", true);
        }

        private static <T extends Comparable<T>> String getString(KdNode node, String prefix, boolean isTail) {
            StringBuilder builder = new StringBuilder();
            if (node.parent != null) {
                String side = "left";
                if (node.parent.greater != null && node.id.equals(node.parent.greater.id)) {
                    side = "right";
                }
                builder.append(String.valueOf(prefix) + (isTail ? "\u00e2\u201d\u201d\u00e2\u201d\u20ac\u00e2\u201d\u20ac " : "\u00e2\u201d\u0153\u00e2\u201d\u20ac\u00e2\u201d\u20ac ") + "[" + side + "] " + "depth=" + node.depth + " id=" + node.id + "\n");
            } else {
                builder.append(String.valueOf(prefix) + (isTail ? "\u00e2\u201d\u201d\u00e2\u201d\u20ac\u00e2\u201d\u20ac " : "\u00e2\u201d\u0153\u00e2\u201d\u20ac\u00e2\u201d\u20ac ") + "depth=" + node.depth + " id=" + node.id + "\n");
            }
            ArrayList<KdNode> children = null;
            if (node.lesser != null || node.greater != null) {
                children = new ArrayList<KdNode>(2);
                if (node.lesser != null) {
                    children.add(node.lesser);
                }
                if (node.greater != null) {
                    children.add(node.greater);
                }
            }
            if (children != null) {
                int i = 0;
                while (i < children.size() - 1) {
                    builder.append(TreePrinter.getString((KdNode)children.get(i), String.valueOf(prefix) + (isTail ? "    " : "\u00e2\u201d\u201a   "), false));
                    ++i;
                }
                if (children.size() >= 1) {
                    builder.append(TreePrinter.getString((KdNode)children.get(children.size() - 1), String.valueOf(prefix) + (isTail ? "    " : "\u00e2\u201d\u201a   "), true));
                }
            }
            return builder.toString();
        }
    }

    public static class XYZPoint
    implements Comparable<XYZPoint> {
        private double x = Double.NEGATIVE_INFINITY;
        private double y = Double.NEGATIVE_INFINITY;
        private double z = Double.NEGATIVE_INFINITY;

        public XYZPoint(double x, double y) {
            this.x = x;
            this.y = y;
            this.z = 0.0;
        }

        public XYZPoint(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public double euclideanDistance(XYZPoint o1) {
            return XYZPoint.euclideanDistance(o1, this);
        }

        private static final double euclideanDistance(XYZPoint o1, XYZPoint o2) {
            return Math.sqrt(Math.pow(o1.x - o2.x, 2.0) + Math.pow(o1.y - o2.y, 2.0) + Math.pow(o1.z - o2.z, 2.0));
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof XYZPoint)) {
                return false;
            }
            XYZPoint xyzPoint = (XYZPoint)obj;
            int xComp = X_COMPARATOR.compare(this, xyzPoint);
            if (xComp != 0) {
                return false;
            }
            int yComp = Y_COMPARATOR.compare(this, xyzPoint);
            return yComp == 0;
        }

        @Override
        public int compareTo(XYZPoint o) {
            int xComp = X_COMPARATOR.compare(this, o);
            if (xComp != 0) {
                return xComp;
            }
            int yComp = Y_COMPARATOR.compare(this, o);
            return yComp;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            builder.append(this.x).append(", ");
            builder.append(this.y).append(", ");
            builder.append(this.z);
            builder.append(")");
            return builder.toString();
        }
    }
}

