/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import javax.vecmath.Vector3d;

public class AzimDip {
    private double azim = 0.0;
    private double dip = 0.0;
    public static final double TINY = 1.0E-10;
    public static final double RADGR = 57.29577951308232;
    public static final double GRRAD = Math.PI / 180;

    public AzimDip(double a, double d) {
        this.azim = a;
        this.dip = d;
    }

    public static double checkTiny(double x) {
        if (Math.abs(x) < 1.0E-10) {
            if (x < 0.0) {
                return -1.0E-10;
            }
            return 1.0E-10;
        }
        return x;
    }

    public static Vector3d azimdip2Vector(AzimDip ad, Vector3d n) {
        if (n == null) {
            n = new Vector3d(0.0, 0.0, 0.0);
        }
        double dr = ad.dip * (Math.PI / 180);
        double ar = ad.azim * (Math.PI / 180);
        double ch = Math.cos(dr);
        n.x = ch * Math.sin(ar);
        n.y = ch * Math.cos(ar);
        n.z = Math.sin(dr);
        return n;
    }

    public static AzimDip vector2AzimDip(Vector3d n, AzimDip ad) {
        n.normalize();
        if (ad == null) {
            ad = new AzimDip(0.0, 0.0);
        }
        n.z = AzimDip.checkTiny(n.z);
        if (Math.abs(1.0 - Math.pow(n.z, 2.0)) < 1.0E-10) {
            n.z = n.z > 0.0 ? (n.z -= 1.0E-10) : (n.z += 1.0E-10);
        }
        ad.dip = Math.atan(n.z / Math.sqrt(1.0 - Math.pow(n.z, 2.0))) * 57.29577951308232;
        ad.azim = Math.atan2(n.x, n.y) * 57.29577951308232;
        if (ad.azim < 0.0) {
            ad.azim += 360.0;
        }
        return ad;
    }

    public String toString() {
        return this.azim + "/" + this.dip;
    }

    public double getAzim() {
        return this.azim;
    }

    public void setAzim(double azim) {
        this.azim = azim;
    }

    public double getDip() {
        return this.dip;
    }

    public void setDip(double dip) {
        this.dip = dip;
    }

    public void convertNormal2AzimDip() {
        this.dip = 90.0 - this.dip;
        this.azim += 180.0;
        if (this.dip < 0.0) {
            this.azim += 180.0;
            this.dip = -this.dip;
        }
        if (this.azim > 360.0) {
            this.azim -= 360.0;
        }
    }

    public static void procesV(Vector3d v) {
        AzimDip ad = AzimDip.vector2AzimDip(v, null);
        System.out.println("vector azim and dip " + v.x + " " + v.y + " " + v.z + "  " + ad.azim + " " + ad.dip);
        v = AzimDip.azimdip2Vector(ad, v);
        System.out.println("vector azim and dip " + v.x + " " + v.y + " " + v.z + "  " + ad.azim + " " + ad.dip);
    }

    public static void main(String[] args) {
        Vector3d v = new Vector3d(0.0, 1.0, -2.0);
        AzimDip.procesV(v);
        v = new Vector3d(1.0, -0.1, 2.0);
        AzimDip.procesV(v);
        v = new Vector3d(-1.0, 0.0, 2.0);
        AzimDip.procesV(v);
        v = new Vector3d(-1.0, -1.0, 2.0);
        AzimDip.procesV(v);
    }
}

