/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import javax.vecmath.Vector3d;
import wrapper.AzimDip;
import wrapper.CoordinateTransformation;
import wrapper.ObservationPoint;
import wrapper.ObservationPointData;
import wrapper.PointSource;
import wrapper.PointSourceFaultKernel;
import wrapper.RectangularSource;
import wrapper.SetupSources;
import wrapper.SourceFactory;
import wrapper.StressSource;
import wrapper.StressSourceData;
import wrapper.StressSourceDataRupture;

public class CompactionFaultKernel {
    StressSourceDataRupture faultKernel = null;
    ObservationPointData faultKernelobs = null;
    StressSourceData compaction_sources = null;
    public static final double VOLSTRAINDEFAULT = -0.00528;
    public static Vector3d vdif = new Vector3d();
    int NX = 10;
    int NY = 10;
    static double LENGTHFAC = 8.0;
    static double INPLANETOL = LENGTHFAC / 3.0;
    int NXNY2 = 10;
    double dxdy2 = 0.0;
    double reservoirthickness;
    CoordinateTransformation ct = null;
    int istart;
    int iend;
    int jstart;
    int jend;

    public boolean getRange(Vector3d psloc, Vector3d center, double length, double width) {
        vdif.sub(center, psloc);
        this.ct.transformVector(false, vdif);
        if (CompactionFaultKernel.vdif.x * CompactionFaultKernel.vdif.x + CompactionFaultKernel.vdif.y * CompactionFaultKernel.vdif.y < 2500.0) {
            double aaa = 0.0;
            double d = aaa - 1.0;
        }
        if (Math.abs(CompactionFaultKernel.vdif.x) / length < INPLANETOL && Math.abs(CompactionFaultKernel.vdif.y) / width < INPLANETOL && Math.abs(CompactionFaultKernel.vdif.z) < this.reservoirthickness) {
            double dij = length / this.dxdy2;
            this.jstart = (int)Math.max(0.0, 0.5 * (double)this.NXNY2 + CompactionFaultKernel.vdif.x / this.dxdy2 - 0.5 * dij);
            this.istart = (int)Math.max(0.0, 0.5 * (double)this.NXNY2 + CompactionFaultKernel.vdif.y / this.dxdy2 - 0.5 * dij);
            int idij = (int)Math.max(1.0, length / this.dxdy2);
            this.iend = Math.min(this.istart + idij, this.NXNY2 - 1);
            this.jend = Math.min(this.jstart + idij, this.NXNY2 - 1);
            if (this.iend > this.istart && this.jend > this.jstart) {
                return true;
            }
        }
        System.out.println("ERROR  FLAGGED SOURCE AS POINTSOURCE KERNEL, BUT NOT ACCEPTED");
        return false;
    }

    public CompactionFaultKernel(double refdepth, double refazim, double refdip, double dxdydz, double compaction, String basename, int SIGN) {
        this.reservoirthickness = dxdydz;
        double lengthx = dxdydz;
        double lengthy = dxdydz;
        double dxdyplane = lengthx / (double)this.NX;
        boolean USEFAULTKERNEL = true;
        boolean ADOPTROUGHNESS = true;
        AzimDip ad = new AzimDip(refazim, refdip);
        Vector3d origin = new Vector3d(0.0, 0.0, 0.0);
        this.ct = new CoordinateTransformation(ad, origin);
        SetupSources.setPointStressSourcesForKernel(-0.5 * (double)SIGN * lengthx, 0.0, refdepth, refazim, refdip, refdepth, lengthx, lengthy, this.NX, this.NY);
        this.compaction_sources = new StressSourceData(SourceFactory.getStressSourceData());
        SourceFactory.getStressSourceData().clear();
        Vector3d u = new Vector3d();
        this.NXNY2 = (int)LENGTHFAC * this.NX * 2;
        this.dxdy2 = lengthx * LENGTHFAC / (double)this.NXNY2;
        double XSHIFT = 0.67 * (double)SIGN * dxdydz / (double)this.NX;
        SetupSources.setRectStressSources(XSHIFT, 0.0, refdepth, lengthx * LENGTHFAC, lengthy * LENGTHFAC, this.NXNY2, this.NXNY2, 0.0, refazim, refdip, u, StressSource.SOURCE_RECTANGULAR, null, 0.0, 1.0, 1, "testruptprint", !ADOPTROUGHNESS);
        int NOBSPLANE = 0;
        this.faultKernel = new StressSourceDataRupture(SourceFactory.getStressSourceData(), this.NXNY2, this.NXNY2, NOBSPLANE);
        SourceFactory.getStressSourceData().clear();
        this.faultKernelobs = this.faultKernel.getObservationData();
        this.compaction_sources.calculateAll(this.faultKernelobs);
        ObservationPoint[][] gopRuptureRef = this.faultKernel.getObservationPointArray();
        ObservationPointData.outputPlane(gopRuptureRef, ObservationPoint.IDIRNORMAL, basename, "faultkernel", 1);
    }

    public void integrateStressStrainDisp(PointSourceFaultKernel ss) {
        ss.output_eii.scale(0.0);
        ss.output_eij.scale(0.0);
        ss.output_sii.scale(0.0);
        ss.output_sij.scale(0.0);
        ss.output_u.scale(0.0);
        ss.stress_change.mul(0.0);
        int ncount = 0;
        int i = this.istart;
        while (i < this.iend) {
            int j = this.jstart;
            while (j < this.jend) {
                ++ncount;
                int iseed = this.faultKernel.getIseed(i, j);
                ObservationPoint o = this.faultKernelobs.get(iseed);
                ss.output_eii.add(o.eii);
                ss.output_eij.add(o.eij);
                ss.output_sii.add(o.sii);
                ss.output_sij.add(o.sij);
                ss.output_u.add(o.u);
                ss.stress_change.add(o.stress_change);
                ++j;
            }
            ++i;
        }
        double s = ss.volstrain / ((double)ncount * -0.00528);
        ss.output_eii.scale(s);
        ss.output_eij.scale(s);
        ss.output_sii.scale(s);
        ss.output_sij.scale(s);
        ss.output_u.scale(s);
        ss.stress_change.mul(s);
    }

    public static void main(String[] args) {
        double E = 1.8E10;
        double v = 0.2;
        RectangularSource.setStressParameters(E, v);
        PointSource.setStressParameters(E, v);
        String basename = "C:/Users/Public/wees/data/tests/okada/differential_compaction/";
        int SIGN = 1;
        CompactionFaultKernel cfk = new CompactionFaultKernel(2000.0, 270.0, 89.9, 20.0, 0.16, basename, SIGN);
    }
}

