/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import wrapper.AzimDip;

public class CoordinateTransformation {
    public static final boolean F2G = true;
    Matrix4d transformG2F = new Matrix4d();
    Matrix4d transformF2G = new Matrix4d();
    private static Vector4d vtrans = new Vector4d();

    public Matrix4d getTransformG2F() {
        return this.transformG2F;
    }

    public Matrix4d getTransformF2G() {
        return this.transformF2G;
    }

    public CoordinateTransformation(AzimDip ad, Vector3d ad_origin) {
        Matrix4d result = new Matrix4d();
        Matrix4d resultrotation = new Matrix4d();
        Matrix4d trans = new Matrix4d();
        trans.setIdentity();
        trans.setTranslation(ad_origin);
        Matrix4d r1 = new Matrix4d();
        r1.rotX(ad.getDip() * (Math.PI / 180));
        Matrix4d r2 = new Matrix4d();
        r2.rotZ(-ad.getAzim() * (Math.PI / 180));
        resultrotation.mul(r2, r1);
        result.mul(trans, resultrotation);
        this.transformF2G = result;
        this.transformG2F.invert(this.transformF2G);
    }

    public void transformVector(boolean F2G, Vector3d v) {
        CoordinateTransformation.vtrans.w = 1.0;
        CoordinateTransformation.vtrans.x = v.x;
        CoordinateTransformation.vtrans.y = v.y;
        CoordinateTransformation.vtrans.z = v.z;
        if (F2G) {
            this.transformF2G.transform(vtrans);
        } else {
            this.transformG2F.transform(vtrans);
        }
        v.x = CoordinateTransformation.vtrans.x;
        v.y = CoordinateTransformation.vtrans.y;
        v.z = CoordinateTransformation.vtrans.z;
    }

    public void transformNormal(boolean F2G, Vector3d v) {
        if (F2G) {
            this.transformF2G.transform(v);
        } else {
            this.transformG2F.transform(v);
        }
    }

    public static void main(String[] args) {
        AzimDip ad = new AzimDip(90.0, 20.0);
        Vector3d or = new Vector3d(1000.0, 0.0, 0.0);
        CoordinateTransformation t = new CoordinateTransformation(ad, or);
        System.out.println("t matrix:  " + t.toString());
        Vector4d vad = new Vector4d(100.0, 0.0, 0.0, 1.0);
        Vector4d v = new Vector4d();
        t.getTransformF2G().transform(vad, v);
        t.getTransformG2F().transform(v, vad);
        System.out.println("vector v " + v.toString());
        System.out.println("vector vad " + vad.toString());
        Vector3d vn = new Vector3d(0.0, 0.0, 1.0);
        t.transformNormal(true, vn);
        System.out.println("vector vn " + vn.toString());
        Vector3d v1 = new Vector3d(vad.x, vad.y, vad.z);
        t.transformVector(true, v1);
        System.out.println("vector v1 " + v1.toString());
        Vector3d vad2 = new Vector3d(v.x, v.y, v.z);
        t.transformVector(false, vad2);
        System.out.println("vector vad " + vad2.toString());
    }
}

