/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import java.util.Random;
import javax.vecmath.Vector3d;
import okada.DC3D0;
import tno.geoenergy.data.Grid;
import tno.geoenergy.util.AsciiOut;
import wrapper.AzimDip;
import wrapper.CoordinateTransformation;

public class FaultRoughness {
    int nx;
    int ny;
    double dx;
    double dy;
    AzimDip azimdip = new AzimDip(0.0, 0.0);
    Vector3d originglobal = new Vector3d(0.0, 0.0, 0.0);
    CoordinateTransformation transform = new CoordinateTransformation(this.azimdip, this.originglobal);
    Grid gfault = null;
    Grid gcenter = null;
    Grid gtile = null;
    AzimDip[][] adcenter = null;
    double r;
    double beta;
    int imode = 1;
    public static final int IDR = 1;
    public static final int IF = 2;
    public static final int IREADIDR = 3;
    public static final int IREADIF = 4;
    public static Random ran = null;

    public AzimDip[][] getAdcenter() {
        return this.adcenter;
    }

    public Grid getGcenter() {
        return this.gcenter;
    }

    public CoordinateTransformation getTransform() {
        return this.transform;
    }

    public FaultRoughness(int nx, int ny, double dx, double dy, String dirbasename, double r, double beta, int IMODE) {
        this.nx = nx;
        this.ny = ny;
        this.dx = dx;
        this.dy = dy;
        int n = 1;
        while (Math.pow(2.0, n) < (double)nx || Math.pow(2.0, n) < (double)ny) {
            ++n;
        }
        int nxny = (int)Math.pow(2.0, n);
        if (IMODE >= 3) {
            AsciiOut as_f1 = new AsciiOut("0.00", 4);
            AsciiOut as_f2 = new AsciiOut("00.000", 5);
            String add = null;
            if (IMODE == 3) {
                add = "_r" + as_f1.format(r).trim() + "_b_READ" + as_f1.format(beta).trim();
            }
            if (IMODE == 4) {
                add = "_r" + as_f1.format(r).trim() + "_b(km)_READ" + as_f1.format(beta * 0.001).trim();
            }
            add = String.valueOf(add) + ".grd";
            try {
                this.gfault = new Grid(String.valueOf(dirbasename) + "gfault" + add);
                this.gtile = new Grid(String.valueOf(dirbasename) + "gtile" + add);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("FAILED TO READ THE ROUGHNESS GRID, REVERTING TO GENERATE THE FAULT");
                System.exit(0);
                this.gfault = DC3D0.getGrid(0.0, 0.0, dx, dy, nx + 1, ny + 1, String.valueOf(dirbasename) + "gfault");
                this.gfault.unknown = -9999.0f;
                this.gtile = DC3D0.getGrid(0.0, 0.0, dx, dy, nxny + 1, nxny + 1, String.valueOf(dirbasename) + "gtile");
                this.gtile.unknown = -9999.0f;
            }
        } else {
            this.gfault = DC3D0.getGrid(0.0, 0.0, dx, dy, nx + 1, ny + 1, String.valueOf(dirbasename) + "gfault");
            this.gfault.unknown = -9999.0f;
            this.gtile = DC3D0.getGrid(0.0, 0.0, dx, dy, nxny + 1, nxny + 1, String.valueOf(dirbasename) + "gtile");
            this.gtile.unknown = -9999.0f;
        }
        this.r = r;
        this.beta = beta;
        this.imode = IMODE;
        this.gcenter = DC3D0.getGrid(0.5 * dx, 0.5 * dy, dx, dy, nx, ny, String.valueOf(dirbasename) + "gcenter");
        this.gcenter.unknown = -9999.0f;
    }

    private AzimDip[][] getCoordinatesAzimDip(AzimDip adplane) {
        Vector3d vcenter = new Vector3d(0.0, 0.0, 0.0);
        Vector3d v1 = new Vector3d();
        Vector3d v2 = new Vector3d();
        AzimDip[][] ads = new AzimDip[this.nx][this.ny];
        int i = 0;
        while (i < this.nx) {
            int j = 0;
            while (j < this.ny) {
                float x = this.gcenter.originx + (float)i * this.gfault.dx;
                float y = this.gcenter.originy + (float)j * this.gfault.dy;
                this.gcenter.values[i][j] = this.gfault.getValueAtxy(x, y);
                vcenter.x = x;
                vcenter.y = y;
                vcenter.z = this.gcenter.values[i][j];
                v1.x = (double)x + 0.1 * (double)this.gfault.dx;
                v1.y = y;
                v1.z = this.gfault.getValueAtxy((float)v1.x, (float)v1.y);
                v1.sub(vcenter);
                v2.x = x;
                v2.y = (double)y + 0.1 * (double)this.gfault.dy;
                v2.z = this.gfault.getValueAtxy((float)v2.x, (float)v2.y);
                v2.sub(vcenter);
                v1.cross(v1, v2);
                v1.normalize();
                this.getTransform().transformNormal(true, v1);
                ads[i][j] = new AzimDip(0.0, 0.0);
                AzimDip.vector2AzimDip(v1, ads[i][j]);
                ads[i][j].convertNormal2AzimDip();
                ++j;
            }
            ++i;
        }
        return ads;
    }

    public void output2file() {
        AsciiOut as_f1 = new AsciiOut("0.00", 4);
        AsciiOut as_f2 = new AsciiOut("00.000", 5);
        String add = null;
        if (this.imode == 1) {
            add = "_r" + as_f1.format(this.r).trim() + "_b_" + as_f1.format(this.beta).trim();
        }
        if (this.imode == 2) {
            add = "_r" + as_f1.format(this.r).trim() + "_b(km)_" + as_f1.format(this.beta * 0.001).trim();
        }
        add = String.valueOf(add) + ".grd";
        String fname = this.gtile.getFileName();
        this.gtile.setFileName(String.valueOf(fname) + add);
        try {
            this.gtile.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.gtile.setFileName(fname);
        fname = this.gfault.getFileName();
        this.gfault.setFileName(String.valueOf(fname) + add);
        try {
            this.gfault.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.gfault.setFileName(fname);
    }

    public void fillTile() {
        if (this.imode < 3) {
            this.diamondsquare(this.gtile.values);
            int i = 0;
            while (i < this.nx + 1) {
                int j = 0;
                while (j < this.ny + 1) {
                    this.gfault.values[i][j] = this.gtile.values[i][j];
                    ++j;
                }
                ++i;
            }
        }
        this.adcenter = this.getCoordinatesAzimDip(this.azimdip);
    }

    public float findrandom(int d) {
        float val = 0.0f;
        if (ran == null) {
            ran = new Random();
        }
        float actuallength = (float)d * this.gtile.dx;
        double actualpower = Math.log((this.gtile.nx - 1) / d) / Math.log(2.0);
        if (this.imode == 2) {
            double range_sd = this.beta * Math.pow(2.0, -actualpower * this.r);
            val = (float)((ran.nextDouble() - 0.5) * 2.0 * range_sd);
        } else if (this.imode == 1) {
            double range_sd = this.beta * Math.pow(actuallength, this.r);
            val = (float)(ran.nextGaussian() * range_sd);
        }
        return val;
    }

    private void square(float[][] map, int size, int x, int y, int d) {
        float sum = 0.0f;
        int num = 0;
        if (x - d >= 0) {
            if (y - d >= 0) {
                ++num;
                sum += map[x - d][y - d];
            }
            if (y + d <= size) {
                ++num;
                sum += map[x - d][y + d];
            }
        }
        if (x + d >= 0) {
            if (y - d >= 0) {
                ++num;
                sum += map[x + d][y - d];
            }
            if (y + d <= size) {
                ++num;
                sum += map[x + d][y + d];
            }
        }
        map[x][y] = sum / (float)num + this.findrandom(d);
    }

    private void diamond(float[][] map, int size, int x, int y, int d) {
        float sum = 0.0f;
        int num = 0;
        if (x - d >= 0) {
            ++num;
            sum += map[x - d][y];
        }
        if (x + d <= size) {
            ++num;
            sum += map[x + d][y];
        }
        if (y - d >= 0) {
            ++num;
            sum += map[x][y - d];
        }
        if (y + d <= size) {
            ++num;
            sum += map[x][y + d];
        }
        map[x][y] = sum / (float)num + this.findrandom(d);
    }

    private void diamondsquare(float[][] map) {
        int size;
        int d = size = map.length - 1;
        map[0][0] = 0.0f;
        map[0][d] = 0.0f;
        map[d][0] = 0.0f;
        map[d][d] = 0.0f;
        d /= 2;
        while (d >= 1) {
            int y;
            int x = d;
            while (x <= size - 1) {
                y = d;
                while (y <= size - 1) {
                    this.square(map, size, x, y, d);
                    y += 2 * d;
                }
                x += 2 * d;
            }
            x = d;
            while (x <= size - 1) {
                y = 0;
                while (y <= size) {
                    this.diamond(map, size, x, y, d);
                    y += 2 * d;
                }
                x += 2 * d;
            }
            x = 0;
            while (x <= size) {
                y = d;
                while (y <= size - 1) {
                    this.diamond(map, size, x, y, d);
                    y += 2 * d;
                }
                x += 2 * d;
            }
            d /= 2;
        }
    }

    public double getR() {
        return this.r;
    }

    public void setR(double r) {
        this.r = r;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }

    public int getImode() {
        return this.imode;
    }

    public void setImode(int imode) {
        this.imode = imode;
    }

    public AzimDip getAzimdip() {
        return this.azimdip;
    }

    public void setAzimdip(AzimDip azimdip) {
        this.azimdip = azimdip;
        this.transform = new CoordinateTransformation(azimdip, this.originglobal);
    }

    public Vector3d getOriginglobal() {
        return this.originglobal;
    }

    public void setOriginglobal(Vector3d originglobal) {
        this.originglobal = originglobal;
        this.transform = new CoordinateTransformation(this.azimdip, originglobal);
    }

    public int getNx() {
        return this.nx;
    }

    public int getNy() {
        return this.ny;
    }

    public double getDx() {
        return this.dx;
    }

    public double getDy() {
        return this.dy;
    }

    public Grid getGfault() {
        return this.gfault;
    }

    public Grid getGtile() {
        return this.gtile;
    }

    public static void main(String[] args) {
        int dx = 50;
        int dy = 50;
        double length = 2000.0;
        double width = 8000.0;
        int nx = (int)width / dx;
        int ny = (int)length / dy;
        String basename = "C:/Users/Public/wees/data/tests/okada/dynamicrupture_groningen/";
        double r = 1.0;
        double beta_IF = 800.0;
        double beta_IDR = 0.03;
        FaultRoughness fr = new FaultRoughness(nx, ny, dx, dy, basename, r, beta_IF, 1);
        fr.setImode(1);
        fr.setBeta(beta_IDR);
        AzimDip ad = new AzimDip(270.0, 63.5);
        fr.setAzimdip(ad);
        System.out.println();
        fr.fillTile();
        fr.output2file();
    }

    public Vector3d getGlobalShift(Vector3d xref, Vector3d move) {
        double TINY = 0.001;
        Vector3d xplane = new Vector3d(xref);
        Vector3d moveplane = new Vector3d(move);
        this.transform.transformVector(false, xplane);
        this.transform.transformNormal(false, moveplane);
        Grid g = this.getGfault();
        Vector3d moveproposed = new Vector3d();
        Vector3d oldmoveplane = new Vector3d(moveplane);
        float zproj = (float)(xplane.z - 1.0);
        while (xplane.z - (double)zproj > TINY) {
            zproj = g.getValueAtxy((float)xplane.x, (float)xplane.y);
            if (g.defined(zproj)) {
                moveproposed.z = (double)zproj - xplane.z;
                double movescale = moveplane.dot(moveproposed);
                moveplane.scale(movescale);
                xplane.add(moveplane);
                moveplane.set(oldmoveplane);
                continue;
            }
            System.out.println("serious error in FaultRoughness.getGlobalShift");
        }
        Vector3d xglobal = new Vector3d(xplane);
        this.transform.transformVector(true, xglobal);
        return xglobal;
    }
}

