/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import okada.DC3D0;
import tno.geoenergy.data.Grid;
import wrapper.ObservationPointData;
import wrapper.StressSource;
import wrapper.TectonicStress;

public class ObservationPoint {
    public static int IX = 0;
    public static int IU = 1;
    public static int IEDIAG = 2;
    public static int IEDEV = 3;
    public static int ISDIAG = 4;
    public static int ISDEV = 5;
    public static int IPF = 6;
    public static int IFINALU = 7;
    public static int ITRACTION = 8;
    public static int CUMULATE = 0;
    public static int NOTHING = 1;
    public static int CLEAR = 2;
    public Vector3d[] outputs = new Vector3d[9];
    public static String[] EXTENSION = new String[]{"X", "U", "EII", "EIJ", "SII", "SIJ", "pf", "DISPL", "TRACTION"};
    public static String[][] SUBSCRIPT = new String[][]{{"X", "Y", "Z"}, {"X", "Y", "Z"}, {"II", "JJ", "KK"}, {"IJ", "IK", "JK"}, {"II", "JJ", "KK"}, {"IJ", "IK", "JK"}, {"PF", "PRESSURE", "DCS"}, {"U", "V", "W"}, {"U", "V", "W"}};
    Vector3d x;
    Vector3d u = new Vector3d();
    Vector3d eii = new Vector3d();
    Vector3d eij = new Vector3d();
    Vector3d sii = new Vector3d();
    Vector3d sij = new Vector3d();
    private double pf = -1234.0;
    private double pressure = 0.0;
    Vector3d final_u = new Vector3d();
    Matrix3d stress_change = new Matrix3d();
    public double cs = 1.0E38;
    public static int IDIRXZ = 0;
    public static int IDIRYZ = 1;
    public static int IDIRXY = 2;
    public static int IDIRNORMAL = 3;

    public Vector3d getX() {
        return this.x;
    }

    public double getPressure() {
        return this.pressure;
    }

    public void setPressure(double pressure) {
        this.pressure = pressure;
    }

    public double getPf() {
        return this.pf;
    }

    public void setPf(double pf, double pressure, double dcs) {
        this.pf = pf;
        this.pressure = pressure / 100000.0;
        this.outputs[ObservationPoint.IPF].x = pf;
        this.outputs[ObservationPoint.IPF].y = this.pressure;
        this.outputs[ObservationPoint.IPF].z = dcs / 100000.0;
    }

    public ObservationPoint(Vector3d x) {
        this.x = x;
        this.outputs[0] = x;
        this.outputs[1] = this.u;
        this.outputs[2] = this.eii;
        this.outputs[3] = this.eij;
        this.outputs[4] = this.sii;
        this.outputs[5] = this.sij;
        this.outputs[6] = new Vector3d(this.pf, this.pressure, this.pf);
        this.outputs[7] = this.final_u;
        this.outputs[8] = new Vector3d(0.0, 0.0, 0.0);
    }

    public void clearOutput() {
        this.u.set(0.0, 0.0, 0.0);
        this.eii.set(0.0, 0.0, 0.0);
        this.eij.set(0.0, 0.0, 0.0);
        this.sii.set(0.0, 0.0, 0.0);
        this.sij.set(0.0, 0.0, 0.0);
        this.stress_change.mul(0.0);
    }

    public void calculate(StressSource ss, int cumulationmode) {
        ss.ActivateSource();
        ss.calculateAtObservation(this.x);
        ss.rotateOutputGetStressChangeTensor();
        ss.copyStressChange();
        if (cumulationmode == CUMULATE) {
            ss.getCumulativeOutput(this.u, this.eii, this.eij, this.sii, this.sij, this.stress_change);
        }
    }

    private Vector3d scaleInCopy(Vector3d v, double scale) {
        Vector3d temp = new Vector3d(v);
        temp.scale(scale);
        return temp;
    }

    private Matrix3d scaleInCopy(Matrix3d v, double scale) {
        Matrix3d temp = new Matrix3d(v);
        temp.mul(scale);
        return temp;
    }

    public void incrementStressChange(ObservationPoint op, double scale) {
        this.u.add(this.scaleInCopy(op.u, scale));
        this.eii.add(this.scaleInCopy(op.eii, scale));
        this.eij.add(this.scaleInCopy(op.eij, scale));
        this.sii.add(this.scaleInCopy(op.sii, scale));
        this.sij.add(this.scaleInCopy(op.sij, scale));
        this.stress_change.m00 = this.sii.x;
        this.stress_change.m11 = this.sii.y;
        this.stress_change.m22 = this.sii.z;
        this.stress_change.m01 = this.stress_change.m10 = this.sij.x;
        this.stress_change.m02 = this.stress_change.m20 = this.sij.y;
        this.stress_change.m12 = this.stress_change.m21 = this.sij.z;
    }

    public void incrementStressChange(Matrix3d deltastress, double scale) {
        this.stress_change.add(this.scaleInCopy(deltastress, scale));
        this.sii.x += this.stress_change.m00;
        this.sii.y += this.stress_change.m11;
        this.sii.z += this.stress_change.m22;
        this.sij.x += this.stress_change.m10;
        this.sij.y += this.stress_change.m20;
        this.sij.z += this.stress_change.m21;
    }

    public void calculate(StressSource ss) {
        this.calculate(ss, CUMULATE);
    }

    public void output() {
        System.out.println(String.valueOf(this.x.x) + " " + this.x.y + " " + this.x.z + " " + this.u.z + " " + this.eii.z + " " + this.sii.z);
    }

    public static ObservationPoint[][] getObservationPointArrayXZ(Vector3d xx, double length, int NX, int NY, ObservationPointData opd) {
        double dx = length / (double)NX;
        double dz = -xx.z / (double)(NY - 1);
        double sx = xx.x - 0.5 * (double)NX * dx;
        double sz = xx.z;
        ObservationPoint[][] gop = new ObservationPoint[NX][NY];
        int i = 0;
        while (i < NX) {
            int j = 0;
            while (j < NY) {
                Vector3d x = new Vector3d();
                x.x = sx + (double)i * dx;
                x.y = xx.y;
                x.z = sz + (double)j * dz;
                ObservationPoint op = new ObservationPoint(x);
                opd.add(op);
                gop[i][j] = op;
                ++j;
            }
            ++i;
        }
        return gop;
    }

    public static ObservationPoint[][] getObservationPointArray(Vector3d xxs, Vector3d xxe, int IDIR, int NX, int NY, ObservationPointData opd) {
        double[] dxdy = new double[2];
        double[] sxsy = new double[2];
        Vector3d stepX = new Vector3d();
        Vector3d stepY = new Vector3d();
        ObservationPoint.initializeStepXY(xxs, xxe, IDIR, NX, NY, stepX, stepY, sxsy, dxdy);
        ObservationPoint[][] gop = new ObservationPoint[NX][NY];
        int i = 0;
        while (i < NX) {
            int j = 0;
            while (j < NY) {
                Vector3d x = new Vector3d();
                x.x = xxs.x + (double)i * stepX.x + (double)j * stepY.x;
                x.y = xxs.y + (double)i * stepX.y + (double)j * stepY.y;
                x.z = xxs.z + (double)i * stepX.z + (double)j * stepY.z;
                ObservationPoint op = new ObservationPoint(x);
                opd.add(op);
                gop[i][j] = op;
                ++j;
            }
            ++i;
        }
        return gop;
    }

    public static void initializeStepXY(Vector3d xxs, Vector3d xxe, int IDIR, int NX, int NY, Vector3d stepX, Vector3d stepY, double[] sxsy, double[] dxdy) {
        stepX.scale(0.0);
        stepX.add(xxe);
        stepX.sub(xxs);
        stepY.scale(0.0);
        stepY.add(stepX);
        if (IDIR == 0) {
            stepX.y = 0.0;
            stepX.z = 0.0;
            stepY.x = 0.0;
            stepY.y = 0.0;
            sxsy[0] = xxs.x;
            sxsy[1] = xxs.z;
        } else if (IDIR == 1) {
            stepX.x = 0.0;
            stepX.z = 0.0;
            stepY.x = 0.0;
            stepY.y = 0.0;
            sxsy[0] = xxs.y;
            sxsy[1] = xxs.z;
        } else if (IDIR == 2) {
            stepX.y = 0.0;
            stepX.z = 0.0;
            stepY.x = 0.0;
            stepY.z = 0.0;
            sxsy[0] = xxs.x;
            sxsy[1] = xxs.y;
        }
        stepX.scale(1.0 / (double)(NX - 1));
        stepY.scale(1.0 / (double)(NY - 1));
        if (IDIR == 0) {
            dxdy[0] = stepX.x;
            dxdy[1] = stepY.z;
        } else if (IDIR == 1) {
            dxdy[0] = stepX.y;
            dxdy[1] = stepY.z;
        } else if (IDIR == 2) {
            dxdy[0] = stepX.x;
            dxdy[1] = stepY.y;
        }
    }

    public static void writeOutputGridCSV(ObservationPoint[][] gop, String basename, int loadnumber) {
        int NX = gop.length;
        int NY = gop[0].length;
        int noutputs = gop[0][0].outputs.length;
        PrintStream pos = null;
        String filename = String.valueOf(basename) + "/" + "rupturesurface" + loadnumber + ".csv";
        try {
            pos = new PrintStream(new BufferedOutputStream(new FileOutputStream(filename)));
            int kloop = -1;
            while (kloop < noutputs) {
                if (kloop == -1) {
                    pos.print("X, Y, Z");
                } else {
                    int kk = 0;
                    while (kk < 3) {
                        int k = kloop;
                        String v = String.valueOf(EXTENSION[k]) + "_" + SUBSCRIPT[k][kk];
                        if (kloop != -1 || kk != 0) {
                            pos.print(", ");
                        }
                        pos.print(v);
                        ++kk;
                    }
                }
                ++kloop;
            }
            pos.println();
            Vector3d v = new Vector3d();
            double[] vd = new double[3];
            int i = 0;
            while (i < NX) {
                int j = 0;
                while (j < NY) {
                    int kloop2 = -1;
                    while (kloop2 < noutputs) {
                        int k = kloop2;
                        if (k < 0) {
                            k = 0;
                        }
                        gop[i][j].outputs[k].get(v);
                        vd[0] = v.x;
                        vd[1] = v.y;
                        vd[2] = v.z;
                        int kk = 0;
                        while (kk < 3) {
                            if (kloop2 != -1 || kk != 0) {
                                pos.print(", ");
                            }
                            pos.print(vd[kk]);
                            ++kk;
                        }
                        ++kloop2;
                    }
                    pos.println();
                    ++j;
                }
                ++i;
            }
            pos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeOutputGrid(ObservationPoint[][] gop, String basename, int IDIR, int output, int xyz, int loadnumber) {
        int NX = gop.length;
        int NY = gop[0].length;
        ObservationPoint llx = gop[0][0];
        ObservationPoint urx = gop[NX - 1][NY - 1];
        Vector3d stepX = new Vector3d();
        Vector3d stepY = new Vector3d();
        double[] dxdy = new double[2];
        double[] sxsy = new double[2];
        Grid g = null;
        if (IDIR < 3) {
            ObservationPoint.initializeStepXY(llx.x, urx.x, IDIR, NX, NY, stepX, stepY, sxsy, dxdy);
            g = DC3D0.getGrid(sxsy[0], sxsy[1], dxdy[0], dxdy[1], NX, NY, basename);
        } else {
            Vector3d x = new Vector3d(gop[0][1].x);
            x.sub(gop[0][0].x);
            double dy = x.length();
            x = new Vector3d(gop[1][0].x);
            x.sub(gop[0][0].x);
            double dx = x.length();
            g = DC3D0.getGrid(0.0, 0.0, dy, dx, NY, NX, basename);
        }
        double[] v = new double[3];
        int i = 0;
        while (i < NX) {
            int j = 0;
            while (j < NY) {
                gop[i][j].outputs[output].get(v);
                if (IDIR < 3) {
                    g.values[i][j] = (float)v[xyz];
                } else {
                    g.values[j][i] = (float)v[xyz];
                }
                ++j;
            }
            ++i;
        }
        try {
            String extension = ".grd";
            g.setDataFormat("SURFER");
            g.unknown = 123456.0f;
            g.determine_low_high();
            g.setFileName(String.valueOf(basename) + "/" + loadnumber + "_IDIR" + IDIR + "_" + EXTENSION[output] + "_" + SUBSCRIPT[output][xyz] + extension);
            g.write();
            extension = ".xyz";
            g.setDataFormat("GMT");
            g.setFileName(String.valueOf(basename) + "/" + loadnumber + "_IDIR" + IDIR + "_" + EXTENSION[output] + "_" + SUBSCRIPT[output][xyz] + extension);
            g.write();
            float a = g.getAverage();
            System.out.println("GRID " + g.getFileName());
            System.out.println("GRID AVERAGE " + a);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeOutputGridXZ(ObservationPoint[][] gop, String basename, int output, int xyz) {
        int NX = gop.length;
        int NY = gop[0].length;
        ObservationPoint llx = gop[0][0];
        double sx = llx.x.x;
        double sy = llx.x.z;
        ObservationPoint urx = gop[NX - 1][NY - 1];
        double ex = urx.x.x;
        double ey = urx.x.z;
        double dx = (ex - sx) / (double)NX;
        double dy = (ey - sy) / (double)NY;
        Grid g = DC3D0.getGrid(sx, sy, dx, dy, NX, NY, basename);
        double[] v = new double[3];
        int i = 0;
        while (i < NX) {
            int j = 0;
            while (j < NY) {
                gop[i][j].outputs[output].get(v);
                g.values[i][j] = (float)v[xyz];
                ++j;
            }
            ++i;
        }
        try {
            String extension = ".grd";
            g.setDataFormat("SURFER");
            g.unknown = 123456.0f;
            g.determine_low_high();
            g.setFileName(String.valueOf(basename) + "/" + EXTENSION[output] + "_" + SUBSCRIPT[output][xyz] + extension);
            g.write();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ObservationPoint[][] getOPArraySameAsSP(Vector3d xx, double length, double width, int NX, int NY, ObservationPointData opd) {
        double startx = xx.x - 0.5 * length;
        double starty = xx.y - 0.5 * width;
        double dx = length / (double)NX;
        double dy = width / (double)NY;
        double depth = xx.z;
        ObservationPoint[][] gop = new ObservationPoint[NX][NY];
        Vector3d[][] checkOP = new Vector3d[NX][NY];
        int i = 0;
        while (i < NX) {
            int j = 0;
            while (j < NY) {
                Vector3d x = new Vector3d();
                x.x = startx + ((double)i + 0.5) * dx;
                x.y = starty + ((double)j + 0.5) * dy;
                x.z = -depth;
                ObservationPoint op = new ObservationPoint(x);
                opd.add(op);
                gop[i][j] = op;
                checkOP[i][j] = x;
                System.out.println("Observation point same as source location   " + checkOP[i][j]);
                ++j;
            }
            ++i;
        }
        return gop;
    }

    public void getDcs(double azim, double dip, double frictionangle) {
        double dcs = TectonicStress.getDcs(this.stress_change, azim, dip, frictionangle);
        this.setPf(0.0, frictionangle, dcs);
    }
}

