/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import wrapper.ObservationPoint;
import wrapper.ObservationPointPlane;
import wrapper.StressSource;
import wrapper.StressSourceData;

public class ObservationPointData
extends Vector {
    public static Random RAN = new Random();

    public ObservationPointData() {
    }

    public ObservationPointData(ObservationPointData opd, int n) {
        int i = 0;
        while (i < n) {
            this.add(opd.get(i));
            ++i;
        }
    }

    public ObservationPointData(StressSourceData ssd, int nobs) {
        int i = 0;
        while (i < ssd.size()) {
            ObservationPoint op1;
            StressSource ss = ssd.get(i);
            Vector3d vc = new Vector3d(ss.x);
            Vector3d updip = new Vector3d(ss.vdip);
            Vector3d upstrike = new Vector3d(ss.vstrike);
            Vector3d upnormal = new Vector3d(ss.vnormal);
            updip.scale(ss.width * 0.0);
            upstrike.scale(ss.length * 0.0);
            upnormal.scale((ss.length + ss.width) * 0.0);
            vc.add(updip);
            vc.add(upstrike);
            vc.add(upnormal);
            if (nobs > 0) {
                op1 = new ObservationPointPlane(vc, ss.azim, ss.dip, ss.length, ss.width, nobs);
                this.add(op1);
                ((ObservationPointPlane)op1).outputs[7] = ((ObservationPointPlane)op1).final_u = ss.final_u;
                ((ObservationPointPlane)op1).outputs[8] = ss.SS;
                System.out.println("Plane observation from stress source  " + ss.x + "L" + ss.length + "W" + ss.width + " location " + ((ObservationPointPlane)op1).x);
            } else {
                op1 = new ObservationPoint(vc);
                this.add(op1);
                op1.outputs[7] = op1.final_u = ss.final_u;
                op1.outputs[8] = ss.SS;
                System.out.println("Point observation from stress source  " + ss.x + "L" + ss.length + "W" + ss.width + " location " + op1.x);
            }
            ++i;
        }
    }

    @Override
    public ObservationPoint get(int i) {
        return (ObservationPoint)super.get(i);
    }

    public void output() {
        System.out.println(" observation points [x,y,z,  uz, ez, sz ]");
        int i = 0;
        while (i < this.size()) {
            ObservationPoint op = this.get(i);
            op.output();
            ++i;
        }
    }

    public void getDcs(double azim, double dip, double frictionangle) {
        int i = 0;
        while (i < this.size()) {
            ObservationPoint op = this.get(i);
            op.getDcs(azim, dip, frictionangle);
            ++i;
        }
    }

    public void incrementStressChange(ObservationPointData opd_rupture_copy, double scale, double noise) {
        int i = 0;
        while (i < this.size()) {
            ObservationPoint op = this.get(i);
            ObservationPoint opcopy = opd_rupture_copy.get(i);
            op.incrementStressChange(opcopy, scale * (1.0 - 0.5 * noise + noise * RAN.nextDouble()));
            ++i;
        }
    }

    public void incrementTectonicStress(Matrix3d deltastress, double scale) {
        int i = 0;
        while (i < this.size()) {
            ObservationPoint op = this.get(i);
            op.incrementStressChange(deltastress, scale);
            ++i;
        }
    }

    public static void outputPlaneCSV(ObservationPoint[][] gopXZ, String basename, String subdir, int loadnumber) {
        String dir = String.valueOf(basename) + subdir + "/";
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdir();
        }
        ObservationPoint.writeOutputGridCSV(gopXZ, dir, loadnumber);
    }

    public static void outputPlane(ObservationPoint[][] gopXZ, int IDIR, String basename, String subdir, int loadnumber) {
        String dir = String.valueOf(basename) + subdir + "/";
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdir();
        }
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IX, 0, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IX, 1, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IX, 2, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IU, 0, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IU, 1, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IU, 2, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IEDIAG, 0, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IEDIAG, 1, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IEDIAG, 2, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IEDEV, 0, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IEDEV, 1, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IEDEV, 2, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.ISDIAG, 0, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.ISDIAG, 1, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.ISDIAG, 2, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.ISDEV, 0, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.ISDEV, 1, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.ISDEV, 2, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IPF, 0, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IPF, 1, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IPF, 2, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IFINALU, 0, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IFINALU, 1, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.IFINALU, 2, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.ITRACTION, 0, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.ITRACTION, 1, loadnumber);
        ObservationPoint.writeOutputGrid(gopXZ, dir, IDIR, ObservationPoint.ITRACTION, 2, loadnumber);
    }

    public void clearOutput() {
        int i = 0;
        while (i < this.size()) {
            this.get(i).clearOutput();
            ++i;
        }
    }

    public void saveCsv(String filename) {
        StringBuffer Strbuf = new StringBuffer();
        File myfile = new File(filename);
        FileOutputStream StreamOut = null;
        try {
            StreamOut = new FileOutputStream(filename);
        }
        catch (IOException e) {
            System.out.println("Error opening output file: " + filename);
        }
        Strbuf.append("x[m], y[m], z[m],  UZ[cm],  SX[MPa], SY[MPa], SV[MPa], SXY[MPa], SXZ[MPa], SYZ[MPa], DCS[Mpa]");
        Strbuf.append("\n");
        int i = 0;
        while (i < this.size()) {
            ObservationPoint p = this.get(i);
            Strbuf.append(String.valueOf(p.x.x) + " , " + p.x.y + " , " + -p.x.z + " , " + p.u.z * 100.0 + " , " + p.sii.x / 1000000.0 + " , " + p.sii.y / 1000000.0 + " , " + p.sii.z / 1000000.0 + "," + p.sij.x / 1000000.0 + "," + p.sij.y / 1000000.0 + "," + p.sij.z / 1000000.0 + "," + p.outputs[ObservationPoint.IPF].z / 10.0);
            Strbuf.append("\n");
            String Str = Strbuf.toString();
            byte[] byteDataOut = Str.getBytes();
            Strbuf = new StringBuffer();
            try {
                StreamOut.write(byteDataOut);
            }
            catch (IOException e) {
                System.out.println("Error writing to output file " + filename);
            }
            ++i;
        }
        try {
            StreamOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println(e);
        }
    }
}

