/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import javax.vecmath.Vector3d;
import wrapper.ObservationPoint;
import wrapper.ObservationPointData;
import wrapper.ObservationPointPlane;

public class ObservationPointDataLine
extends ObservationPointData {
    private String name;

    public ObservationPointDataLine(String name, Vector3d start, Vector3d end, double dx) {
        this.init(name, start, end, dx, false, 0.0, 0.0, 0.0, 0.0, 0);
    }

    public ObservationPointDataLine(String name, Vector3d start, Vector3d end, double dx, double azim, double dip, double length, double width, int nobs) {
        this.init(name, start, end, dx, true, azim, dip, length, width, nobs);
    }

    public void init(String name, Vector3d start, Vector3d end, double dx, boolean isPlane, double azim, double dip, double length, double width, int nobs) {
        this.name = name;
        Vector3d step = new Vector3d(end);
        step.sub(start);
        step.scale(dx / step.length());
        Vector3d pos = new Vector3d(start);
        Vector3d dif = new Vector3d();
        dif.sub(pos, end);
        while (dif.dot(step) < 0.0) {
            if (!isPlane) {
                ObservationPoint op = new ObservationPoint(new Vector3d(pos));
                this.add(op);
            } else {
                ObservationPointPlane opp = new ObservationPointPlane(new Vector3d(pos), azim, dip, length, width, nobs);
                this.add(opp);
            }
            pos.add(step);
            dif.sub(pos, end);
        }
    }

    @Override
    public void output() {
        System.out.println("LINE -------- " + this.name + "------------------ LINE ");
        System.out.println("x[m], y[m], z[m],  UZ[cm],  SX[MPa], SY[MPa], SV[MPa], SXY[MPa], SYZ[MPa], SXZ[MPa]");
        int i = 0;
        while (i < this.size()) {
            ObservationPoint p = this.get(i);
            System.out.println(String.valueOf(p.x.x) + " , " + p.x.y + " , " + -p.x.z + " , " + p.u.z * 100.0 + " , " + p.sii.x / 1000000.0 + " , " + p.sii.y / 1000000.0 + " , " + p.sii.z / 1000000.0 + "," + p.sij.x / 1000000.0 + "," + p.sij.y / 1000000.0 + "," + p.sij.z / 1000000.0);
            ++i;
        }
    }

    public static void main(String[] args) {
    }
}

