/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import java.util.Random;
import javax.vecmath.Vector3d;
import wrapper.AzimDip;
import wrapper.CoordinateTransformation;
import wrapper.ObservationPoint;
import wrapper.PointSourceFaultKernel;
import wrapper.StressSource;

public class ObservationPointPlane
extends ObservationPoint {
    public ObservationPoint[] oparray = null;
    ObservationPoint osum = null;
    AzimDip ad = null;
    CoordinateTransformation ct = null;
    double length;
    double width;
    public static int count = 0;

    public ObservationPointPlane(Vector3d x, double azim, double dip, double length, double width, int nobs) {
        super(x);
        this.osum = new ObservationPoint(x);
        this.init2(azim, dip, length, width, nobs);
    }

    public void init(double azim, double dip, double length, double width, int nobs) {
        Random ran = new Random();
        this.length = length;
        this.width = width;
        this.ad = new AzimDip(azim, dip);
        this.ct = new CoordinateTransformation(this.ad, this.x);
        this.oparray = new ObservationPoint[nobs];
        int i = 0;
        while (i < nobs) {
            ObservationPoint op;
            Vector3d xobs = new Vector3d();
            xobs.x = (ran.nextDouble() - 0.5) * length;
            xobs.y = (ran.nextDouble() - 0.5) * width;
            this.ct.transformVector(true, xobs);
            this.oparray[i] = op = new ObservationPoint(xobs);
            ++i;
        }
    }

    public void init2(double azim, double dip, double length, double width, int nobs) {
        this.length = length;
        this.width = width;
        this.ad = new AzimDip(azim, dip);
        this.ct = new CoordinateTransformation(this.ad, this.x);
        if (nobs <= 1) {
            return;
        }
        this.oparray = new ObservationPoint[nobs * nobs];
        double dx = length / (double)nobs;
        double dy = width / (double)nobs;
        int i = 0;
        while (i < nobs) {
            int j = 0;
            while (j < nobs) {
                ObservationPoint op;
                Vector3d xobs = new Vector3d();
                xobs.x = -length * 0.5 + ((double)i + 0.5) * dx;
                xobs.y = -0.5 * width + ((double)j + 0.5) * dy;
                this.ct.transformVector(true, xobs);
                this.oparray[j * nobs + i] = op = new ObservationPoint(xobs);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void calculate(StressSource ss, int cumulationmode) {
        ss.ActivateSource();
        Vector3d dv = new Vector3d(ss.x);
        dv.sub(this.x);
        double dist = dv.length();
        double distkern = Math.sqrt(ss.length * ss.width) * 1.1;
        double distnobs = distkern * 4.0;
        if (dist < distnobs && this.oparray != null) {
            int i = 0;
            while (i < this.oparray.length) {
                ObservationPoint o = this.oparray[i];
                dv = new Vector3d(o.x);
                dv.sub(ss.x);
                double d = dv.length();
                if (d < dist) {
                    dist = d;
                }
                ++i;
            }
        }
        if (dist < distkern && ss instanceof PointSourceFaultKernel) {
            if (ss instanceof PointSourceFaultKernel) {
                PointSourceFaultKernel psk = (PointSourceFaultKernel)ss;
                psk.calculateForFaultPlane(this.x, this.length, this.width);
            }
        } else if (this.oparray != null && dist < distnobs) {
            double scale = 1.0 / (double)this.oparray.length;
            double scalelength = Math.sqrt(scale);
            int i = 0;
            while (i < this.oparray.length) {
                ObservationPoint o = this.oparray[i];
                ss.calculateAtObservation(o.x);
                ss.rotateOutputGetStressChangeTensor();
                ss.copyStressChange();
                ss.getCumulativeOutput(this.osum.u, this.osum.eii, this.osum.eij, this.osum.sii, this.osum.sij, this.osum.stress_change);
                ++i;
            }
            ss.u.scale(scale, this.osum.u);
            ss.output_eii.scale(scale, this.osum.eii);
            ss.output_eij.scale(scale, this.osum.eij);
            ss.output_sii.scale(scale, this.osum.sii);
            ss.output_sij.scale(scale, this.osum.sij);
            ss.stress_change.mul(0.0);
            ss.stress_change.add(this.osum.stress_change);
            ss.stress_change.mul(scale);
            this.osum.clearOutput();
        } else {
            ss.calculateAtObservation(this.x);
            ss.rotateOutputGetStressChangeTensor();
            ss.copyStressChange();
        }
        if (cumulationmode == CUMULATE) {
            ss.getCumulativeOutput(this.u, this.eii, this.eij, this.sii, this.sij, this.stress_change);
        }
    }

    public void calculateOLD(StressSource ss, int cumulationmode) {
        ss.ActivateSource();
        double distmin = 0.0;
        double dist = 1.0E30;
        if (ss.isCheckDist() && this.oparray != null) {
            distmin = Math.sqrt(ss.length * ss.width) * 1.1;
            int i = 0;
            while (i < this.oparray.length) {
                ObservationPoint o = this.oparray[i];
                Vector3d dv = new Vector3d(o.x);
                dv.sub(ss.x);
                double d = dv.length();
                if (d < dist) {
                    dist = d;
                }
                ++i;
            }
        }
        if (!ss.isCheckDist() || this.oparray == null || dist > distmin || ss instanceof PointSourceFaultKernel) {
            if (ss instanceof PointSourceFaultKernel && dist <= distmin) {
                PointSourceFaultKernel psk = (PointSourceFaultKernel)ss;
                psk.calculateForFaultPlane(this.x, this.length, this.width);
            } else {
                ss.calculateAtObservation(this.x);
                ss.rotateOutputGetStressChangeTensor();
                ss.copyStressChange();
            }
        } else {
            double scale = 1.0 / (double)this.oparray.length;
            double scalelength = Math.sqrt(scale);
            int i = 0;
            while (i < this.oparray.length) {
                ObservationPoint o = this.oparray[i];
                ss.calculateAtObservation(o.x);
                ss.rotateOutputGetStressChangeTensor();
                ss.copyStressChange();
                ss.getCumulativeOutput(this.osum.u, this.osum.eii, this.osum.eij, this.osum.sii, this.osum.sij, this.osum.stress_change);
                ++i;
            }
            ss.u.scale(scale, this.osum.u);
            ss.output_eii.scale(scale, this.osum.eii);
            ss.output_eij.scale(scale, this.osum.eij);
            ss.output_sii.scale(scale, this.osum.sii);
            ss.output_sij.scale(scale, this.osum.sij);
            ss.stress_change.mul(0.0);
            ss.stress_change.add(this.osum.stress_change);
            ss.stress_change.mul(scale);
            this.osum.clearOutput();
        }
        if (cumulationmode == CUMULATE) {
            ss.getCumulativeOutput(this.u, this.eii, this.eij, this.sii, this.sij, this.stress_change);
        }
    }
}

