/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import logging.Logging;
import okada.DCCON2;
import wrapper.ObservationPoint;
import wrapper.StressSource;
import wrapper.TectonicStress;

public class PatchDislocation {
    public static final double ITER_TRESHOLD2 = 0.01;
    public static int NITERMAX = 40;
    public static double ULENGTHMAX = 0.03;
    public static double ULENGTHSCALE = 0.01;
    public static final boolean USEDPFABS = true;
    public static final double DILATATIONANGLE = 0.0;
    public static final boolean EXITPROGRAM_NOCONVERGENCE = false;
    private static Logger logger = Logger.getLogger(PatchDislocation.class.getName());
    public static Random ran = new Random();
    public static double ITER_TRESHOLD = 0.001;
    public static double pfOld = 0.0;
    public static double pfNew = 0.0;
    public static double pfmin = 0.0;
    public static Vector3d U_old = null;
    public static Vector3d U_new = null;
    public static Vector3d U_min = null;
    public static Vector3d[] Uhistory = new Vector3d[NITERMAX + 1];
    public static int nhistory = 0;
    public static Vector3d udir = null;
    public static double lold = 0.0;
    public static double lnew = 0.0;
    public static StressSource ss = null;
    public static ObservationPoint op = null;
    public static Matrix3d reference_stress_change = null;
    public static Vector3d reference_u = null;
    private static Matrix3d total = new Matrix3d();
    private static Matrix3d sc = new Matrix3d();
    static Vector3d Disl = new Vector3d();

    public static Vector3d getScalingFactor(StressSource stresssource, Vector3d alternative2SS, double rotangle, double sfric, double dfric) {
        Vector3d U = new Vector3d();
        Vector3d ss = stresssource.SS;
        if (alternative2SS != null) {
            ss = alternative2SS;
        }
        Vector3d u = new Vector3d();
        logger.finest("---- ss ---" + ss + " vstrike " + stresssource.vstrike + " vdip " + stresssource.vdip);
        u.x = stresssource.vstrike.dot(ss);
        u.y = stresssource.vdip.dot(ss);
        double x = u.x;
        double y = u.y;
        double c = Math.cos(Math.PI * rotangle / 180.0);
        double s = Math.sin(Math.PI * rotangle / 180.0);
        u.x = c * x + -s * y;
        u.y = s * x + c * y;
        u.normalize();
        double STRESSDROP = -1000000.0;
        double myu = DCCON2.MYU;
        double Lambda1 = 0.5 * STRESSDROP * (Math.tan(sfric) - Math.tan(dfric)) / (myu * 25.0);
        U.scale(Lambda1, u);
        logger.finest("DISL Try1  " + U);
        return U;
    }

    public static void DislocationTry1(StressSource ssIn, Vector3d alternative2SS, double rotangle, ObservationPoint opIn) {
        nhistory = 0;
        ss = ssIn;
        op = opIn;
        U_old = new Vector3d();
        PatchDislocation.calcPf(U_old, TectonicStress.DFRICMODE, false);
        pfOld = PatchDislocation.ss.pf;
        pfmin = PatchDislocation.ss.pf;
        lold = 0.0;
        logger.finest("----------------------------------starting iteration ------------------ DYNPF " + pfOld);
        Vector3d uTry1 = null;
        uTry1 = PatchDislocation.getScalingFactor(ss, alternative2SS, rotangle, PatchDislocation.ss.sfric, PatchDislocation.ss.dfric);
        udir = new Vector3d(uTry1);
        udir.scale(1.0 / udir.length());
        PatchDislocation.udir.z = Math.tan(0.0);
        lnew = uTry1.length();
        double depth = -PatchDislocation.ss.x.z;
        Vector3d U = new Vector3d(udir);
        U.scale(lnew);
        U_new = PatchDislocation.ss.u = U;
        PatchDislocation.calcPf(PatchDislocation.ss.u, TectonicStress.DFRICMODE, false);
        pfNew = PatchDislocation.ss.pf;
        reference_stress_change = new Matrix3d(PatchDislocation.ss.stress_change);
        U_min = reference_u = new Vector3d(uTry1);
        PatchDislocation.Uhistory[PatchDislocation.nhistory++] = new Vector3d(reference_u);
    }

    public static boolean DislocationIterate() {
        int iter = 0;
        boolean problemconvergence = false;
        boolean breaknonlinear = false;
        while (Math.abs(pfNew) >= ITER_TRESHOLD * 0.001 && iter < NITERMAX) {
            Vector3d Utry = new Vector3d();
            Utry = PatchDislocation.getDislocation(pfNew, pfOld, U_old, U_new);
            PatchDislocation.Uhistory[PatchDislocation.nhistory++] = new Vector3d(Utry);
            if (pfNew < pfmin) {
                pfmin = pfNew;
                U_min = new Vector3d(U_new);
            }
            if (iter != NITERMAX - 1) {
                PatchDislocation.calcPfScale(Utry, TectonicStress.DFRICMODE, iter, false);
            }
            if (iter == NITERMAX - 1) {
                problemconvergence = true;
                if (U_min == null) {
                    logger.warning(" U_min ==null ");
                }
                if (U_min.length() > ULENGTHMAX * ULENGTHSCALE) {
                    double l = U_min.length();
                    U_min.scale(ULENGTHMAX * ULENGTHSCALE / l);
                }
                PatchDislocation.calcPfScale(U_min, TectonicStress.DFRICMODE, iter, false);
                breaknonlinear = true;
                break;
            }
            pfOld = pfNew;
            U_old = U_new;
            U_new = PatchDislocation.ss.u;
            pfNew = PatchDislocation.ss.pf;
            ++iter;
        }
        if (!breaknonlinear && Math.abs(pfNew) >= ITER_TRESHOLD) {
            logger.warning("------------- SERIOUS ERROR IN ITERATION ---------");
            logger.warning("------------- CHECK CODING THIS SHOULD NOT HAPPEN ---------");
            logger.warning("------------- SETTING ss.u to 0---------");
            PatchDislocation.ss.u = new Vector3d(0.0, 0.0, 0.0);
            logger.warning("------------- EXITING PROGRAM -----------");
            System.exit(0);
        } else {
            if (breaknonlinear) {
                PatchDislocation.ss.u = U_min;
            }
            if (PatchDislocation.ss.u.length() > ULENGTHMAX) {
                double l = PatchDislocation.ss.u.length();
                System.out.print("u.");
                PatchDislocation.ss.u.scale(ULENGTHMAX / l);
                PatchDislocation.calcPf(PatchDislocation.ss.u, TectonicStress.DFRICMODE, false);
            } else {
                PatchDislocation.calcPf(PatchDislocation.ss.u, TectonicStress.DFRICMODE, false);
            }
            logger.finer("DISL Iterated  " + PatchDislocation.ss.u + " Pfnew " + pfNew);
            ++iter;
        }
        return problemconvergence;
    }

    public static void DislocationIterateTest(int niter, double scale) {
        int i = 0;
        while (i < niter) {
            PatchDislocation.ss.u.scale(scale);
            System.out.println("DISL Iterated  " + i + " " + PatchDislocation.ss.u);
            PatchDislocation.calcPf(PatchDislocation.ss.u, TectonicStress.DFRICMODE, false);
            pfNew = PatchDislocation.ss.pf;
            if (pfNew < ITER_TRESHOLD) break;
            ++i;
        }
    }

    public static void calcPf(Vector3d Disl, int frictionmode, boolean modify_stressdrop) {
        PatchDislocation.ss.u = Disl;
        op.calculate(ss, ObservationPoint.NOTHING);
        sc.mul(-1.0, PatchDislocation.ss.stress_change);
        total.add(PatchDislocation.ss.stress_tensor_initial, sc);
        if (modify_stressdrop) {
            double addstressdrop = TectonicStress.stressCalculation(PatchDislocation.ss.azim, PatchDislocation.ss.dip, total, PatchDislocation.ss.dfric, PatchDislocation.ss.vnormal, PatchDislocation.ss.pressure, PatchDislocation.ss.stressdrop);
            PatchDislocation.ss.stressdrop += addstressdrop;
        }
        TectonicStress.stressCalculation(PatchDislocation.ss.azim, PatchDislocation.ss.dip, total, PatchDislocation.ss.dfric, PatchDislocation.ss.vnormal, PatchDislocation.ss.pressure, PatchDislocation.ss.stressdrop);
        PatchDislocation.ss.pf = TectonicStress.pf;
        PatchDislocation.ss.SS.scale(1.0, TectonicStress.vparalel);
        PatchDislocation.ss.SN.scale(1.0, TectonicStress.vperp);
        PatchDislocation.ss.snscalar = TectonicStress.sn;
        PatchDislocation.ss.ssscalar = TectonicStress.ss;
        op.setPf(TectonicStress.pf, PatchDislocation.ss.pressure, 0.0);
        double fricangle = PatchDislocation.ss.sfric;
        if (PatchDislocation.op.cs > 1.0E30) {
            PatchDislocation.op.cs = PatchDislocation.ss.ssscalar - Math.tan(fricangle * Math.PI / 180.0) * PatchDislocation.ss.snscalar;
        }
        PatchDislocation.ss.dcs = PatchDislocation.ss.ssscalar - Math.tan(fricangle * Math.PI / 180.0) * PatchDislocation.ss.snscalar;
        op.setPf(TectonicStress.pf, PatchDislocation.ss.pressure, PatchDislocation.ss.dcs);
    }

    public static void calcPfScale(Vector3d Dislin, int frictionmode, int iter, boolean modify_stressdrop) {
        Disl.set(Dislin);
        PatchDislocation.Disl.z = 0.0;
        double uchange = Disl.length() / reference_u.length();
        double dot = Disl.dot(reference_u);
        double sign = 1.0;
        if (dot < 0.0) {
            sign = -1.0;
        }
        PatchDislocation.Disl.z = Disl.length() * PatchDislocation.udir.z;
        PatchDislocation.ss.u = Disl;
        PatchDislocation.ss.stress_change.mul(uchange * sign, reference_stress_change);
        sc.mul(-1.0, PatchDislocation.ss.stress_change);
        total.add(PatchDislocation.ss.stress_tensor_initial, sc);
        if (modify_stressdrop) {
            double addstressdrop = TectonicStress.stressCalculation(PatchDislocation.ss.azim, PatchDislocation.ss.dip, total, PatchDislocation.ss.dfric, PatchDislocation.ss.vnormal, PatchDislocation.ss.pressure, PatchDislocation.ss.stressdrop);
            PatchDislocation.ss.stressdrop += addstressdrop;
        }
        TectonicStress.stressCalculation(PatchDislocation.ss.azim, PatchDislocation.ss.dip, total, PatchDislocation.ss.dfric, PatchDislocation.ss.vnormal, PatchDislocation.ss.pressure, PatchDislocation.ss.stressdrop);
        PatchDislocation.ss.pf = TectonicStress.pf;
        PatchDislocation.ss.SS.scale(1.0, TectonicStress.vparalel);
        PatchDislocation.ss.SN.scale(1.0, TectonicStress.vperp);
        PatchDislocation.ss.snscalar = TectonicStress.sn;
        PatchDislocation.ss.ssscalar = TectonicStress.ss;
        op.setPf(TectonicStress.pf, PatchDislocation.ss.pressure, 0.0);
        double fricangle = PatchDislocation.ss.sfric;
        if (PatchDislocation.op.cs > 1.0E30) {
            PatchDislocation.op.cs = PatchDislocation.ss.ssscalar - Math.tan(fricangle * Math.PI / 180.0) * PatchDislocation.ss.snscalar;
        }
        PatchDislocation.ss.dcs = PatchDislocation.ss.ssscalar - Math.tan(fricangle * Math.PI / 180.0) * PatchDislocation.ss.snscalar;
        op.setPf(TectonicStress.pf, PatchDislocation.ss.pressure, PatchDislocation.ss.dcs);
    }

    public static Vector3d getDislocation(double pfNew, double pfOld, Vector3d uOld, Vector3d uNew) {
        double SCALE = 1.0;
        double MAXSCALE = 10.0;
        double pfRatio = (0.0 - pfNew) / (pfNew - pfOld);
        pfRatio = pfRatio < 0.0 ? Math.max(-MAXSCALE, pfRatio) : Math.min(MAXSCALE, pfRatio);
        logger.finest(" pfTarget " + pfNew + " dpF/dl " + (pfNew - pfOld) / (lnew - lold) + "  ss " + PatchDislocation.ss.ssscalar + " sn " + PatchDislocation.ss.snscalar);
        double temp = lnew;
        lnew += SCALE * (lnew - lold) * pfRatio;
        lold = temp;
        Vector3d U = new Vector3d(udir);
        U.scale(lnew);
        if (U.z < 0.0) {
            U.z = -U.z;
        }
        return U;
    }

    public static Vector3d getDislocationVector(double pfNew, double pfOld, Vector3d uOld, Vector3d uNew) {
        Vector3d U = new Vector3d();
        double SCALE = 1.0;
        double MAXSCALE = 10.0;
        double pfRatio = (0.0 - pfNew) / (pfNew - pfOld);
        pfRatio = pfRatio < 0.0 ? Math.max(-MAXSCALE, pfRatio) : Math.min(MAXSCALE, pfRatio);
        Vector3d uDiff = new Vector3d(uNew);
        uDiff.sub(uOld);
        uDiff.scale(pfRatio);
        U = new Vector3d(uDiff);
        U.add(uNew);
        logger.finest("DISL Iterated  " + U + " Pfold " + pfOld + " Pfnew " + pfNew);
        return U;
    }

    private double func(double x) {
        return 0.0;
    }

    static double sign(double a, double b) {
        if (b > 0.0) {
            return Math.abs(a);
        }
        return -Math.abs(a);
    }

    public double[] brent(double ax, double bx, double cx, double tol, double xmin) {
        double fx;
        double v;
        double[] brentres = new double[2];
        int itbrentmax = 500;
        double cgold = 0.381966;
        double zeps = 1.0E-5;
        boolean skipone = false;
        boolean skiprest = false;
        double d = 0.0;
        double a = ax < cx ? ax : cx;
        double b = ax > cx ? ax : cx;
        double w = v = bx;
        double x = v;
        double e = 0.0;
        double fv = fx = this.func(x);
        double fw = fx;
        int iter = 1;
        while (iter <= itbrentmax) {
            double fu;
            double u;
            skipone = false;
            skiprest = false;
            double xm = 0.5 * (a + b);
            double tol1 = tol * Math.abs(x) + zeps;
            double tol2 = 2.0 * tol1;
            if (Math.abs(x - xm) <= tol2 - 0.5 * (b - a)) {
                brentres[0] = x;
                brentres[1] = fx;
                return brentres;
            }
            if (Math.abs(e) > tol1) {
                double r = (x - w) * (fx - fv);
                double q = (x - v) * (fx - fw);
                double p = (x - v) * q - (x - w) * r;
                if ((q = 2.0 * (q - r)) > 0.0) {
                    p = -p;
                }
                q = Math.abs(q);
                double etemp = e;
                e = d;
                if (Math.abs(p) >= Math.abs(0.5 * q * etemp) || p <= q * (a - x) || p >= q * (b - x)) {
                    skiprest = true;
                }
                if (!skiprest && ((u = x + (d = p / q)) - a < tol2 || b - u < tol2)) {
                    d = PatchDislocation.sign(tol1, xm - x);
                    skipone = true;
                }
            }
            if (!skipone) {
                e = x >= xm ? a - x : b - x;
                d = cgold * e;
            }
            if ((fu = this.func(u = Math.abs(d) >= tol1 ? x + d : x + PatchDislocation.sign(tol1, d))) <= fx) {
                if (u >= x) {
                    a = x;
                } else {
                    b = x;
                }
                v = w;
                fv = fw;
                w = x;
                fw = fx;
                x = u;
                fx = fu;
            } else {
                if (u < x) {
                    a = u;
                } else {
                    b = u;
                }
                if (fu <= fw || w == x) {
                    v = w;
                    fv = fw;
                    w = u;
                    fw = fu;
                } else if (fu <= fv || v == x || v == 2.0) {
                    v = u;
                    fv = fu;
                }
            }
            ++iter;
        }
        logger.warning("fatal in routine BRENT - too many iterations");
        return brentres;
    }

    public static void main(String[] args) {
        Logging.setLogHandler(Level.FINE);
        logger.info("test");
        logger.fine("fine");
        logger.finer("finer");
    }
}

