/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import wrapper.StressSource;

public class PatchStack {
    private int NMAXSTACK = 1000000;
    private StressSource[] stressSource = new StressSource[this.NMAXSTACK];
    private int[] indexStressSource = new int[this.NMAXSTACK];
    private StressSource[] stressSourceTemp = new StressSource[this.NMAXSTACK];
    private int[] indexStressSourceTemp = new int[this.NMAXSTACK];
    int NSTACK = 0;
    int NADDED = 0;
    int NCLEAN = 10;
    int NTOTALADDED = 0;

    public void add2Stack(StressSource ss, int i) {
        if (this.NSTACK > this.NMAXSTACK - 2 || this.NADDED > this.NCLEAN) {
            this.cleanStack();
            this.NADDED = 0;
        }
        this.stressSource[this.NSTACK] = ss;
        this.indexStressSource[this.NSTACK] = i;
        ++this.NSTACK;
        ++this.NADDED;
        ++this.NTOTALADDED;
    }

    public int getNextIndexFromStack(boolean remove) {
        int itemp = 0;
        int icount = 0;
        while (icount < this.NSTACK) {
            if (this.indexStressSource[icount] > -1) {
                itemp = this.indexStressSource[icount];
                if (remove) {
                    this.indexStressSource[icount] = -1;
                }
                return itemp;
            }
            ++icount;
        }
        return -1;
    }

    public int getIseed(int ijseed, int ny) {
        return ijseed / ny;
    }

    public int getJseed(int ijseed, int ny) {
        return ijseed - this.getIseed(ijseed, ny) * ny;
    }

    public int getIJseed(int iseed, int jseed, int ny) {
        return iseed * ny + jseed;
    }

    public void cleanStack() {
        int nstack = this.NSTACK;
        int n2remove = 0;
        while (n2remove < this.NSTACK && this.indexStressSource[n2remove] < 0) {
            ++n2remove;
        }
        this.NSTACK = nstack - n2remove;
        int i = 0;
        while (i < this.NSTACK) {
            this.stressSource[i] = this.stressSource[i + n2remove];
            this.indexStressSource[i] = this.indexStressSource[i + n2remove];
            ++i;
        }
    }

    public void forecedCleanStack() {
        this.NSTACK = 0;
    }

    public static void main(String[] args) {
    }
}

