/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import javax.vecmath.Vector3d;
import okada.DCCON0;
import okada.OkadaDC3DPoint;
import wrapper.StressSource;

public class PointSource
extends StressSource {
    double height = 0.0;

    public PointSource(Vector3d x, double azim, double dip, double length, double width, Vector3d u, double volstrain, boolean checkdist) {
        this.x = x;
        this.azim = azim;
        this.dip = dip;
        this.length = length;
        this.width = width;
        this.height = Math.sqrt(width * length);
        this.u = u;
        this.volstrain = volstrain;
        super.init_v(azim, dip);
        this.setCheckDist(checkdist);
    }

    public PointSource(Vector3d x, double azim, double dip, double length, double width, double height, Vector3d u, double unistrain, boolean checkdist) {
        this.x = x;
        this.azim = azim;
        this.dip = dip;
        this.length = length;
        this.width = width;
        this.height = height;
        this.u = u;
        this.volstrain = unistrain;
        super.init_v(azim, dip);
        this.setCheckDist(checkdist);
    }

    public static void setStressParameters(double E, double v) {
        DCCON0.E = E;
        DCCON0.v = v;
        DCCON0.LAMBDA = E * v / ((1.0 + v) * (1.0 - 2.0 * v));
        DCCON0.MYU = E / (2.0 * (1.0 + v));
        DCCON0.ALPHA = (DCCON0.LAMBDA + DCCON0.MYU) / (DCCON0.LAMBDA + 2.0 * DCCON0.MYU);
    }

    @Override
    public void ActivateStressSource() {
    }

    @Override
    public void calculateAtObservation(Vector3d o) {
        double POT1 = this.u.x * this.length * this.width;
        double POT2 = this.u.y * this.length * this.width;
        double POT3 = this.u.z * this.length * this.width;
        double POT4 = this.volstrain * this.length * this.width * this.height;
        double depth = -this.x.z;
        OkadaDC3DPoint.calculateAtObservation(o.x - this.x.x, o.y - this.x.y, o.z, depth, POT1, POT2, POT3, POT4, DCCON0.ALPHA, DCCON0.E, DCCON0.v);
        this.output_u.x = OkadaDC3DPoint.UX;
        this.output_u.y = OkadaDC3DPoint.UY;
        this.output_u.z = OkadaDC3DPoint.UZ;
        this.output_eii.x = OkadaDC3DPoint.exx;
        this.output_eii.y = OkadaDC3DPoint.eyy;
        this.output_eii.z = OkadaDC3DPoint.ezz;
        this.output_eij.x = OkadaDC3DPoint.exy;
        this.output_eij.y = OkadaDC3DPoint.exz;
        this.output_eij.z = OkadaDC3DPoint.eyz;
        this.output_sii.x = OkadaDC3DPoint.Sxx;
        this.output_sii.y = OkadaDC3DPoint.Syy;
        this.output_sii.z = OkadaDC3DPoint.Szz;
        this.output_sij.x = OkadaDC3DPoint.Sxy;
        this.output_sij.y = OkadaDC3DPoint.Sxz;
        this.output_sij.z = OkadaDC3DPoint.Syz;
    }

    @Override
    public void rotateOutputGetStressChangeTensor() {
    }
}

