/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import javax.vecmath.Vector3d;
import wrapper.CompactionFaultKernel;
import wrapper.PointSource;

public class PointSourceFaultKernel
extends PointSource {
    CompactionFaultKernel cfk = null;

    public PointSourceFaultKernel(Vector3d x, double azim, double dip, double length, double width, Vector3d u, double volstrain) {
        super(x, azim, dip, length, width, u, volstrain, true);
    }

    public PointSourceFaultKernel(Vector3d x, double azim, double dip, double length, double width, Vector3d u, double volstrain, CompactionFaultKernel cfk) {
        super(x, azim, dip, length, width, u, volstrain, true);
        this.cfk = cfk;
    }

    @Override
    public void ActivateStressSource() {
        super.ActivateStressSource();
    }

    @Override
    public void calculateAtObservation(Vector3d o) {
        super.calculateAtObservation(o);
    }

    public void calculateForFaultPlane(Vector3d center, double length, double width) {
        if (this.cfk == null) {
            System.out.println("ERROR: compactionfault kernel has not been initatialized in calcultionforplane in PointSourceFAultKernel ");
            super.calculateAtObservation(center);
        } else {
            boolean okrange = this.cfk.getRange(this.x, center, length, width);
            if (okrange) {
                this.cfk.integrateStressStrainDisp(this);
            } else {
                super.calculateAtObservation(center);
                super.copyStressChange();
            }
        }
    }
}

