/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import javax.vecmath.Vector3d;
import okada.DC3D0;
import okada.DCCON0;
import wrapper.StressSource;

public class PointSource_old
extends StressSource {
    double height = 0.0;

    public PointSource_old(Vector3d x, double azim, double dip, double length, double width, Vector3d u, double volstrain, boolean checkdist) {
        this.x = x;
        this.azim = azim;
        this.dip = dip;
        this.length = length;
        this.width = width;
        this.height = Math.sqrt(width * length);
        this.u = u;
        this.volstrain = volstrain;
        super.init_v(azim, dip);
        this.setCheckDist(checkdist);
    }

    public PointSource_old(Vector3d x, double azim, double dip, double length, double width, double height, Vector3d u, double unistrain, boolean checkdist) {
        this.x = x;
        this.azim = azim;
        this.dip = dip;
        this.length = length;
        this.width = width;
        this.height = height;
        this.u = u;
        this.volstrain = unistrain;
        super.init_v(azim, dip);
        this.setCheckDist(checkdist);
    }

    public static void setStressParameters(double E, double v) {
        DCCON0.E = E;
        DCCON0.v = v;
        DCCON0.LAMBDA = E * v / ((1.0 + v) * (1.0 - 2.0 * v));
        DCCON0.MYU = E / (2.0 * (1.0 + v));
        DCCON0.ALPHA = (DCCON0.LAMBDA + DCCON0.MYU) / (DCCON0.LAMBDA + 2.0 * DCCON0.MYU);
    }

    @Override
    public void ActivateStressSource() {
        DCCON0.setSourceLocation(this.x.x, this.x.y, this.x.z);
        DCCON0.prepareSource(this.azim);
        DC3D0.initializeSource(this.dip, DCCON0.ALPHA);
        DCCON0.POT1 = this.u.x * this.length * this.width;
        DCCON0.POT2 = this.u.y * this.length * this.width;
        DCCON0.POT3 = this.u.z * this.length * this.width;
        double sphereradius = 0.619758375 * Math.pow(this.length * this.width * this.height, 0.333334);
        double area = Math.PI * 4 * Math.pow(sphereradius, 2.0);
        double du = this.volstrain * 0.3333334 * sphereradius;
        DCCON0.POT4 = this.volstrain * this.length * this.width * this.height;
    }

    @Override
    public void calculateAtObservation(Vector3d o) {
        DCCON0.setObervationLocation(o.x - DCCON0.S_X, o.y - DCCON0.S_Y, o.z);
        Vector3d OP = new Vector3d();
        OP.x = DCCON0.ox;
        OP.y = DCCON0.oy;
        OP.z = o.z;
        double depth = -this.x.z;
        double POT1 = DCCON0.POT1;
        double POT2 = DCCON0.POT2;
        double POT3 = DCCON0.POT3;
        double POT4 = DCCON0.POT4;
        DC3D0.calculateAtObservation(OP.x, OP.y, OP.z, depth, POT1, POT2, POT3, POT4);
        this.output_u.x = DC3D0.UX;
        this.output_u.y = DC3D0.UY;
        this.output_u.z = DC3D0.UZ;
        this.output_eii.x = DC3D0.exx;
        this.output_eii.y = DC3D0.eyy;
        this.output_eii.z = DC3D0.UZZ;
        this.output_eij.x = DC3D0.exy;
        this.output_eij.y = DC3D0.exz;
        this.output_eij.z = DC3D0.eyz;
        this.output_sii.x = DC3D0.Sxx;
        this.output_sii.y = DC3D0.Syy;
        this.output_sii.z = DC3D0.Szz;
        this.output_sij.x = DC3D0.Sxy;
        this.output_sij.y = DC3D0.Sxz;
        this.output_sij.z = DC3D0.Syz;
    }

    @Override
    public void rotateOutputGetStressChangeTensor() {
    }
}

