/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import java.util.logging.Logger;

public class PressureWell {
    private static Logger logger = Logger.getLogger(PressureWell.class.getName());
    public static double HTYPICAL = 0.001;
    public static double KTYPICAL = 1000.0;
    public static double VISCTYPICAL = 2.4E-4;
    public static double CPTYPICAL = 5.0E-9;
    public static double QTYPICAL = 50.0;
    double Q = 0.0;
    double h = 0.0;
    double k = 0.0;
    double visc = 0.0;
    double cp = 0.0;
    double conductivity = 0.0;
    double diffusivity = 0.0;
    double storcap = 0.0;

    public PressureWell(double h, double k, double visc, double cp) {
        this.h = h;
        this.k = k;
        this.visc = visc;
        this.cp = cp;
        this.conductivity = k * 100000.0 / (1.0E12 * visc);
        this.storcap = 100000.0 * cp / h;
        this.diffusivity = this.conductivity / this.storcap;
    }

    public static double getPressure(double time, double radius, double Q, double h, double k, double visc, double cp) {
        double conductivity = k * 100000.0 / (1.0E12 * visc);
        double storcap = cp / h;
        double q2m = Q * 0.001 / h;
        double diffusivity = conductivity / storcap;
        double pres = q2m / (12.64 * conductivity) * (Math.log(4.0 * diffusivity * time * 3600.0 / Math.pow(radius, 2.0)) - 0.57772);
        return Math.max(0.0, pres);
    }

    public double getPressure(double time, double radius, double Q) {
        if (time <= 0.0) {
            return 0.0;
        }
        double q2m = Q * 0.001 / this.h;
        double pres = q2m / (12.64 * this.conductivity) * (Math.log(4.0 * this.diffusivity * time * 3600.0 / Math.pow(radius, 2.0)) - 0.57772);
        if ((pres = Math.max(0.0, pres)) > 0.0) {
            logger.finer("time " + time + " radius " + radius + " pressure calculated " + pres);
        }
        return pres;
    }

    public static PressureWell getTypicalWell() {
        return new PressureWell(HTYPICAL, KTYPICAL, VISCTYPICAL, CPTYPICAL);
    }

    public static void main(String[] args) {
        PressureWell pw = PressureWell.getTypicalWell();
        double time = 0.0;
        double Q = QTYPICAL;
        System.out.println("radius [m]  pressure[bar] ");
        int i = 0;
        while (i < 200) {
            double p = pw.getPressure(time, i, Q);
            System.out.println(i + " " + p);
            ++i;
        }
    }
}

