/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import java.util.logging.Logger;
import javax.vecmath.Vector3d;
import okada.DC3D;
import okada.DCCON2;
import wrapper.StressSource;

public class RectangularSource
extends StressSource {
    private static Logger logger = Logger.getLogger(RectangularSource.class.getName());
    public static double SCALESTRAINREF = 1.1;
    public static double ELEMENTSIZEREF = 50.0;
    public static double SCALESTRAIN = SCALESTRAINREF;
    double height = 0.0;

    public static void setSCALESTRAIN(double elementsize) {
        double stepfactor = elementsize / ELEMENTSIZEREF;
        SCALESTRAIN = Math.pow(SCALESTRAINREF, stepfactor);
    }

    public RectangularSource(Vector3d x, double azim, double dip, double length, double width, double height, Vector3d u) {
        this.x = x;
        this.azim = azim;
        this.dip = dip;
        this.length = length;
        this.width = width;
        this.height = height;
        this.u = u;
        super.init_v(azim, dip);
        this.setCheckDist(false);
    }

    public static void setStressParameters(double E, double v) {
        DCCON2.E = E;
        DCCON2.v = v;
        DCCON2.LAMBDA = E * v / ((1.0 + v) * (1.0 - 2.0 * v));
        DCCON2.MYU = E / (2.0 * (1.0 + v));
        DCCON2.ALPHA = (DCCON2.LAMBDA + DCCON2.MYU) / (DCCON2.LAMBDA + 2.0 * DCCON2.MYU);
    }

    @Override
    public void ActivateStressSource() {
        logger.finest("activating source " + this.x);
        DC3D.initializeSource(this.x.x, this.x.y, this.x.z, this.azim, this.dip, this.length, this.width);
    }

    @Override
    public void calculateAtObservation(Vector3d o) {
        DCCON2.setObervationLocation(o.x - this.x.x, o.y - this.x.y, o.z);
        Vector3d OP = new Vector3d();
        OP.x = DCCON2.ox;
        OP.y = DCCON2.oy;
        OP.z = o.z;
        double depth = -this.x.z;
        double DISL1 = this.u.x;
        double DISL2 = this.u.y;
        double DISL3 = this.u.z;
        DC3D.calculateAtObservation(OP.x, OP.y, OP.z, depth, DCCON2.L1, DCCON2.L2, DCCON2.W1, DCCON2.W2, DISL1, DISL2, DISL3);
        Vector3d difvec = new Vector3d(OP.x, OP.y, OP.z + depth);
        double scalestrainstress = 1.0;
        if (difvec.length() < 0.001) {
            scalestrainstress = SCALESTRAIN;
        }
        this.output_u.x = DC3D.UX;
        this.output_u.y = DC3D.UY;
        this.output_u.z = DC3D.UZ;
        this.output_eii.x = DC3D.exx;
        this.output_eii.y = DC3D.eyy;
        this.output_eii.z = DC3D.UZZ;
        this.output_eij.x = DC3D.exy;
        this.output_eij.y = DC3D.exz;
        this.output_eij.z = DC3D.eyz;
        this.output_sii.x = DC3D.Sxx;
        this.output_sii.y = DC3D.Syy;
        this.output_sii.z = DC3D.Szz;
        this.output_sij.x = DC3D.Sxy;
        this.output_sij.y = DC3D.Sxz;
        this.output_sij.z = DC3D.Syz;
        this.output_eii.scale(scalestrainstress);
        this.output_eij.scale(scalestrainstress);
        this.output_sii.scale(scalestrainstress);
        this.output_sij.scale(scalestrainstress);
    }

    @Override
    public void rotateOutputGetStressChangeTensor() {
        double PI8 = Math.PI / 180;
        Vector3d XL = new Vector3d();
        Vector3d YL = new Vector3d();
        XL.x = 1.0;
        XL.y = 0.0;
        XL.z = 0.0;
        YL.x = 0.0;
        YL.y = 1.0;
        YL.z = 0.0;
        double SA = Math.sin(this.azim * PI8);
        double CA = Math.cos(this.azim * PI8);
        double TEMPX = XL.x;
        double TEMPY = XL.y;
        XL.x = CA * TEMPX + SA * TEMPY;
        XL.y = -SA * TEMPX + CA * TEMPY;
        TEMPX = YL.x;
        TEMPY = YL.y;
        YL.x = CA * TEMPX + SA * TEMPY;
        YL.y = -SA * TEMPX + CA * TEMPY;
        if (this.output_u.length() > 1.0E-5) {
            boolean bl = false;
        }
        Vector3d temp = new Vector3d(this.output_u);
        this.output_u.x = temp.x * XL.x + temp.y * XL.y;
        this.output_u.y = temp.x * YL.x + temp.y * YL.y;
        this.output_u.z = temp.z;
        RectangularSource.transformLocal2Global(this.azim, this.output_sii, this.output_sij);
        RectangularSource.transformLocal2Global(this.azim, this.output_eii, this.output_eij);
    }
}

