/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import javax.vecmath.Vector3d;

public class SeismicEvent {
    public static double G = 1.0E10;
    double area = 0.0;
    double d = 0.0;
    double x = 0.0;
    double y = 0.0;
    double z = 0.0;
    double time = 0.0;
    double moment = 0.0;
    double ML = 0.0;
    double MW = 0.0;
    double stressdrop = 0.0;
    Vector3d ruptureCentroid = new Vector3d();

    public void setMoment(double moment) {
        this.moment = moment;
    }

    public void setRuptureCentroid(Vector3d ruptureCentroid) {
        this.ruptureCentroid = ruptureCentroid;
    }

    public Vector3d getRuptureCentroid() {
        return this.ruptureCentroid;
    }

    public SeismicEvent(double x, double y, double z, double time, double area, double d) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.area = area;
        this.time = time;
        this.d = d;
        this.moment = area * d * G;
        this.ML = 0.0;
        this.MW = 0.0;
    }

    public void calculateMoment() {
        this.d = 0.7275654541343787 * this.stressdrop * 100000.0 * Math.pow(this.area / Math.PI, 0.5) / G;
        this.moment = Math.log10(Math.pow(this.area / Math.PI, 1.5) * this.stressdrop * 100000.0 * 16.0 / 7.0);
        this.ML = (Math.log10(Math.pow(10.0, this.moment) * 1.0E7) - 17.5) / 0.9;
    }

    public void calculateSI_MW() {
        this.MW = Math.log10(this.moment) * 0.6666666667 - 6.07;
    }

    public double getStressdrop() {
        return this.stressdrop;
    }

    public void setStressdrop(double stressdrop) {
        this.stressdrop = stressdrop;
    }

    public double getMoment() {
        return this.moment;
    }

    public double getArea() {
        return this.area;
    }

    public void setArea(double area) {
        this.area = area;
    }

    public double getD() {
        return this.d;
    }

    public void setD(double d) {
        this.d = d;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getMw() {
        return this.MW;
    }
}

