/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import java.util.Vector;
import tno.geoenergy.tableutil.TableFD;
import wrapper.SeismicEvent;

public class SeismicEventData
extends TableFD {
    Vector<SeismicEvent> seismicEventContainer = new Vector();
    public static String[] colNames = new String[]{"X", "Y", "Z", "ZAVE", "TIME", "AREA", "DISPLACEMENT", "MO", "SUM_MO", "MW", "DISTANCE", "RANK"};
    public static int[] colTypes = new int[]{TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.DOUBLE, TableFD.INT};
    private static final boolean[] editable = new boolean[12];

    public Vector<SeismicEvent> getSeismicEventContainer() {
        return this.seismicEventContainer;
    }

    @Override
    public int[] getColTypes() {
        return colTypes;
    }

    @Override
    public String[] getColNames() {
        return colNames;
    }

    @Override
    public boolean[] getEditable() {
        return editable;
    }

    @Override
    public Vector[] getCategories() {
        return CATEGORIES;
    }

    public SeismicEventData(String fileName) {
        super(fileName, TableFD.ASCII);
    }

    public SeismicEventData(String fileName, int readwritemode) {
        super(fileName, readwritemode);
    }

    public SeismicEventData() {
        this.setReadwritemode(TableFD.ASCII);
    }

    public int add(SeismicEvent se) {
        this.seismicEventContainer.add(se);
        return this.seismicEventContainer.size() - 1;
    }

    public SeismicEvent get(int i) {
        return this.seismicEventContainer.get(i);
    }

    public void convert2Data(float refx, float refy) {
        String[][] s = new String[this.seismicEventContainer.size()][this.getColNames().length];
        this.setData(s);
        float cummoment = 0.0f;
        int i = 0;
        while (i < this.seismicEventContainer.size()) {
            SeismicEvent se = this.seismicEventContainer.get(i);
            float distance = (float)Math.pow(Math.pow(se.getX() - (double)refx, 2.0) + Math.pow(se.getY() - (double)refy, 2.0), 0.5);
            s[i][0] = "" + se.getX();
            s[i][1] = "" + se.getY();
            s[i][2] = "" + se.getZ();
            s[i][3] = "" + se.getRuptureCentroid().z;
            s[i][4] = "" + se.getTime();
            s[i][5] = "" + se.getArea();
            s[i][6] = "" + se.getD();
            cummoment = (float)((double)cummoment + se.getMoment());
            s[i][7] = "" + se.getMoment();
            s[i][8] = "" + cummoment;
            s[i][9] = "" + se.MW;
            s[i][10] = "" + distance;
            s[i][11] = "" + (i + 1);
            ++i;
        }
    }

    public void SaveFile(String filename, float refx, float refy) {
        this.calculateMoment();
        this.convert2Data(refx, refy);
        this.setFilename(filename);
        super.SaveFile();
    }

    private void calculateMoment() {
        int i = 0;
        while (i < this.seismicEventContainer.size()) {
            this.seismicEventContainer.get(i).calculateMoment();
            ++i;
        }
    }

    public static void main(String[] args) {
    }
}

