/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import java.util.Random;
import javax.vecmath.Vector3d;
import okada.DCCON0;
import tno.geoenergy.data.Grid;
import wrapper.AzimDip;
import wrapper.CompactionFaultKernel;
import wrapper.FaultRoughness;
import wrapper.PointSource;
import wrapper.PointSourceFaultKernel;
import wrapper.SourceFactory;
import wrapper.StressSource;
import wrapper.StressSourceData;

public class SetupSources {
    public static void setPointStressSources(double x, double y, double depth, double length, int NX, int NY, double compaction, Grid g, double xshift) {
        double dx;
        double azim = 0.0;
        double dip = 0.0;
        Vector3d u = new Vector3d();
        double startx = x - 0.5 * length;
        double dy = dx = length / (double)NX;
        double starty = y - 0.5 * length * (double)NY / (double)NX;
        int i = 0;
        while (i < NX) {
            int j = 0;
            while (j < NY) {
                float v;
                Vector3d xx = new Vector3d();
                xx.x = startx + ((double)i + 0.5) * dx;
                xx.y = starty + ((double)j + 0.5) * dy;
                xx.z = -depth;
                if (g != null && g.defined(v = g.getValueAtxy((float)(xx.x + xshift), (float)xx.y))) {
                    compaction = v;
                }
                SourceFactory.createSource(StressSource.SOURCE_POINT, xx, azim, dip, dx, dy, 0.0, u, -compaction * (2.0 + DCCON0.LAMBDA / DCCON0.MYU) / dx, true);
                ++j;
            }
            ++i;
        }
    }

    public static void setPointStressSourcesCompactAtZSplit(double x, double y, double refdepth, double refazim, double refdip, double actdepth, double lengthx, double lengthy, int NX, int NY, double reservoirthickness, double compaction, Grid g, double XSHIFT, FaultRoughness fr, boolean FOLLOWROUGHNESS, String basename, int SIGN) {
        int nsplit;
        double dx = lengthx / (double)NX;
        double DISTANCE = reservoirthickness;
        double DXDYDISTANCE = reservoirthickness;
        boolean USEFAULTKERNEL = true;
        int NX1 = nsplit = (int)(DISTANCE / dx);
        double scale = DXDYDISTANCE / DISTANCE;
        int NX2 = (int)((double)(NX - NX1) / ((double)nsplit * scale));
        double lengthx1 = (double)NX1 * dx;
        double lengthx2 = lengthx - lengthx1;
        double dcx1 = (lengthx - lengthx1) / 2.0;
        double dcx2 = -0.5 * lengthx1;
        int NY2 = (int)((double)NY / ((double)nsplit * scale));
        boolean checkdist = true;
        SetupSources.setPointStressSourcesCompactAtZ(x + (double)SIGN * dcx1, y, refdepth, refazim, refdip, actdepth, lengthx1, lengthy, NX1, NY, reservoirthickness, compaction, g, XSHIFT, 0.0, fr, FOLLOWROUGHNESS, USEFAULTKERNEL, checkdist, basename, SIGN);
        if (NX1 < NX) {
            SetupSources.setPointStressSourcesCompactAtZ(x + (double)SIGN * dcx2, y, refdepth, refazim, refdip, actdepth, lengthx2, lengthy, NX2, NY2, reservoirthickness, compaction, g, XSHIFT, (double)SIGN * lengthx1, fr, FOLLOWROUGHNESS, !USEFAULTKERNEL, !checkdist, basename, SIGN);
        }
    }

    static void setPointStressSourcesCompactAtZ(double x, double y, double refdepth, double refazim, double refdip, double actdepth, double lengthx, double lengthy, int NX, int NY, double reservoirthickness, double compactionin, Grid g, double XSHIFT, double XSHIFTREF, FaultRoughness fr, boolean FOLLOWROUGHNESS, boolean useFaultKernel, boolean checkdist, String basename, int SIGN) {
        CompactionFaultKernel cfk = null;
        Vector3d u = new Vector3d();
        double azimfault = refazim;
        Vector3d vdip = new Vector3d();
        vdip.z = (float)Math.sin(refdip * Math.PI / 180.0);
        float rh = (float)Math.cos(refdip * Math.PI / 180.0);
        float rotradians = (float)(1.5707963267948966 - Math.PI * 2 * azimfault / 360.0);
        vdip.x = (float)Math.cos(rotradians) * rh;
        vdip.y = (float)Math.sin(rotradians) * rh;
        double rotangle = (270.0 - refazim) * Math.PI / 180.0;
        double cr = Math.cos(rotangle);
        double sr = Math.sin(rotangle);
        double startx = x - 0.5 * lengthx;
        double starty = y - 0.5 * lengthy;
        double dx = lengthx / (double)NX;
        double dy = lengthy / (double)NY;
        double azim = 0.0;
        double dip = 0.0;
        int NZ = (int)(reservoirthickness / dx);
        NZ = Math.max(1, NZ);
        double dz = dx;
        double depth = actdepth;
        Vector3d xrefnew = new Vector3d(0.0, 0.0, 0.0);
        double dcompaction = compactionin / (double)NZ;
        double compaction = compactionin;
        if (g != null) {
            g.determine_low_high();
            dcompaction = g.maxXyz().z / (float)NZ;
            compaction = 0.0;
        }
        double dzstep = Math.min(dz, reservoirthickness);
        int k = 0;
        while (k < NZ) {
            depth = actdepth - ((double)k + 0.5) * dzstep;
            double xoffset0 = (refdepth - depth) * vdip.x / vdip.z;
            double compactionoffset = (double)k * dcompaction;
            int j = 0;
            while (j < NY) {
                Vector3d xref = new Vector3d();
                xref.x = SIGN > 0 ? startx + xoffset0 + (double)NX * dx : startx + xoffset0;
                xref.y = starty + ((double)j + 0.5) * dy;
                xref.z = -depth;
                Vector3d move = new Vector3d(1.0, 0.0, 0.0);
                double xoffset = xoffset0;
                if (fr != null && FOLLOWROUGHNESS) {
                    double xi = xref.x;
                    double yi = xref.y;
                    xref.x = cr * xi + -sr * yi;
                    xref.y = sr * xi + cr * yi;
                    xrefnew = fr.getGlobalShift(xref, move);
                    xrefnew.sub(xref);
                    System.out.println("xoffset add " + xrefnew.x);
                }
                int i = NX - 1;
                while (i >= 0) {
                    Vector3d xx = new Vector3d();
                    xx.x = startx + xoffset + ((double)i + 0.5) * dx - XSHIFT - XSHIFTREF;
                    xx.y = starty + ((double)j + 0.5) * dy;
                    xx.z = -depth;
                    double xi = xx.x;
                    double yi = xx.y;
                    xx.x = cr * xi + -sr * yi;
                    xx.y = sr * xi + cr * yi;
                    xx.add(xrefnew);
                    if (g != null) {
                        float v = g.getValueAtxy((float)(xx.x + XSHIFT - xoffset), (float)xx.y);
                        if (g.defined(v)) {
                            double c = (double)v - compactionoffset;
                            compaction = Math.min(Math.max(0.0, c), dcompaction);
                        } else {
                            compaction = 0.0;
                        }
                        compaction *= compactionin;
                    } else {
                        compaction = compactionin;
                    }
                    if (Math.abs(compaction) > 1.0E-20) {
                        compaction *= 2.0 + DCCON0.LAMBDA / DCCON0.MYU;
                        if (useFaultKernel && i == NX - 1 && SIGN == 1) {
                            if (cfk == null) {
                                cfk = new CompactionFaultKernel(-xx.z, refazim, refdip, dx, -0.00528, basename, SIGN);
                            }
                            PointSourceFaultKernel ps = new PointSourceFaultKernel(xx, 0.0, 0.0, dx, dy, u, -compaction / dx, cfk);
                            SourceFactory.getStressSourceData().add(ps);
                            System.out.println("generated Point source  " + ps.x.toString() + "length  " + ps.length + "  width " + ps.width + " " + ps.volstrain);
                        } else if (useFaultKernel && i == 0 && SIGN == -1) {
                            if (cfk == null) {
                                cfk = new CompactionFaultKernel(-xx.z, refazim, refdip, dx, -0.00528, basename, SIGN);
                            }
                            PointSourceFaultKernel ps = new PointSourceFaultKernel(xx, 0.0, 0.0, dx, dy, u, -compaction / dx, cfk);
                            SourceFactory.getStressSourceData().add(ps);
                            System.out.println("generated Point source  " + ps.x.toString() + "length  " + ps.length + "  width " + ps.width + " " + ps.volstrain);
                        } else {
                            PointSource ps = new PointSource(xx, 0.0, 0.0, dx, dy, u, -compaction / dx, i >= NX - 2 && checkdist);
                            SourceFactory.getStressSourceData().add(ps);
                            System.out.println("generated Point source  " + ps.x.toString() + "length  " + ps.length + "  width " + ps.width + " " + ps.volstrain);
                        }
                    }
                    --i;
                }
                ++j;
            }
            ++k;
        }
    }

    static void setPointStressSourcesForKernel(double x, double y, double refdepth, double refazim, double refdip, double actdepth, double lengthx, double lengthy, int NX, int NY) {
        Vector3d u = new Vector3d();
        double azimfault = refazim;
        Vector3d vdip = new Vector3d();
        vdip.z = (float)Math.sin(refdip * Math.PI / 180.0);
        float rh = (float)Math.cos(refdip * Math.PI / 180.0);
        float rotradians = (float)(1.5707963267948966 - Math.PI * 2 * azimfault / 360.0);
        vdip.x = (float)Math.cos(rotradians) * rh;
        vdip.y = (float)Math.sin(rotradians) * rh;
        double startx = x - 0.5 * lengthx;
        double starty = y - 0.5 * lengthy;
        double dx = lengthx / (double)NX;
        double dy = lengthy / (double)NY;
        double azim = 0.0;
        double dip = 0.0;
        int NZ = NX;
        double dz = dx;
        double depth = actdepth;
        double rotangle = (270.0 - refazim) * Math.PI / 180.0;
        double cr = Math.cos(rotangle);
        double sr = Math.sin(rotangle);
        int k = 0;
        while (k < NZ) {
            depth = actdepth - 0.5 * dz - (double)k * dz + 0.5 * (double)NZ * dz;
            double xoffset0 = (refdepth - depth) * vdip.x / vdip.z;
            int j = 0;
            while (j < NY) {
                Vector3d xref = new Vector3d();
                xref.x = startx + xoffset0 + (double)NX * dx;
                xref.y = starty + ((double)j + 0.5) * dy;
                xref.z = -depth;
                Vector3d move = new Vector3d(1.0, 0.0, 0.0);
                double xoffset = xoffset0;
                int i = NX - 1;
                while (i >= 0) {
                    Vector3d xx = new Vector3d();
                    xx.x = startx + xoffset + ((double)i + 0.5) * dx;
                    xx.y = starty + ((double)j + 0.5) * dy;
                    xx.z = -depth;
                    double xi = xx.x;
                    double yi = xx.y;
                    xx.x = cr * xi + -sr * yi;
                    xx.y = sr * xi + cr * yi;
                    PointSource ps = new PointSource(xx, azim, dip, dx, dy, u, -0.00528, true);
                    SourceFactory.getStressSourceData().add(ps);
                    System.out.println("generated Point source for Kernel " + ps.x.toString() + "length  " + ps.length + "  width " + ps.width + " " + ps.volstrain);
                    --i;
                }
                ++j;
            }
            ++k;
        }
    }

    public static void setRectStressSources(double x, double y, double depth, double length, double width, int NX, int NY, double volstrain, double azim, double dip, Vector3d u, int sourcetype) {
        SetupSources.setRectStressSources(x, y, depth, length, width, NX, NY, volstrain, azim, dip, u, sourcetype, 0.0, 0.0);
    }

    public static void setRectStressSources(double x, double y, double depth, double length, double width, int NX, int NY, double volstrain, double azim, double dip, Vector3d u, int sourcetype, double NOISE_AZIM, double NOISE_DIP) {
        Vector3d vdip = new Vector3d();
        vdip.z = (float)Math.sin(dip * Math.PI / 180.0);
        float rh = (float)Math.cos(dip * Math.PI / 180.0);
        float rotradians = (float)(1.5707963267948966 - Math.PI * 2 * azim / 360.0);
        vdip.x = (float)Math.cos(rotradians) * rh;
        vdip.y = (float)Math.sin(rotradians) * rh;
        Vector3d vnormal = new Vector3d();
        double dip2 = 90.0 - dip;
        vnormal.z = -((float)Math.sin(dip2 * Math.PI / 180.0));
        rh = (float)Math.cos(dip2 * Math.PI / 180.0);
        rotradians = (float)(1.5707963267948966 - Math.PI * 2 * azim / 360.0);
        vnormal.x = (float)Math.cos(rotradians) * rh;
        vnormal.y = (float)Math.sin(rotradians) * rh;
        Vector3d vstrike = new Vector3d();
        vstrike = new Vector3d(vnormal);
        vstrike.cross(vdip, vnormal);
        double startx = x;
        double starty = y;
        double startz = -depth;
        double dx = length / (double)NX;
        double dy = width / (double)NY;
        Vector3d vd = new Vector3d(vdip);
        vd.scale(dx);
        double height = Math.abs(vd.z);
        double dxhor = Math.abs(vd.x);
        Random ran = new Random();
        double sy = 0.0;
        int i = 0;
        while (i < NX) {
            int j = 0;
            while (j < NY) {
                double sx = dx * (double)(i - (NX - 1) / 2);
                sy = dy * (double)(j - (NY - 1) / 2);
                Vector3d xx = new Vector3d(startx, starty, startz);
                vd = new Vector3d(vdip);
                Vector3d vs = new Vector3d(vstrike);
                vs.normalize();
                vd.scale(sx);
                vs.scale(sy);
                xx.add(vd);
                xx.add(vs);
                double noiseazim = (-0.5 + ran.nextDouble()) * NOISE_AZIM;
                double noisedip = (-0.5 + ran.nextDouble()) * NOISE_DIP;
                SourceFactory.createSource(sourcetype, xx, azim + noiseazim, dip + noisedip, dy, dx, height, u, -volstrain, true);
                ++j;
            }
            ++i;
        }
    }

    public static FaultRoughness setRectStressSources(double x, double y, double depth, double length, double width, int NX, int NY, double volstrain, double azim, double dip, Vector3d u, int sourcetype, FaultRoughness fr, double beta, double r, int imode, String dirbasename, boolean followroughness) {
        return SetupSources.setRectStressSources(x, y, depth, length, width, NX, NY, volstrain, azim, dip, u, sourcetype, fr, beta, r, imode, dirbasename, followroughness, 0, NX, 0, NY);
    }

    public static FaultRoughness setRectStressSources(double x, double y, double depth, double length, double width, int NX, int NY, double volstrain, double azim, double dip, Vector3d u, int sourcetype, FaultRoughness fr, double beta, double r, int imode, String dirbasename, boolean followroughness, int istart, int iend, int jstart, int jend) {
        Vector3d uzero = new Vector3d();
        Random ran = new Random();
        double dx = length / (double)NX;
        double dy = width / (double)NY;
        if (fr == null) {
            fr = new FaultRoughness(NY, NX, dy, dx, dirbasename, r, beta, imode);
        }
        fr.setAzimdip(new AzimDip(azim, dip));
        Vector3d originglobal = new Vector3d(x, y, -depth);
        fr.setOriginglobal(new Vector3d());
        int imid = NX / 2;
        int jmid = NY / 2;
        Vector3d originplane = new Vector3d(dy * ((double)jmid + 0.5), dx * ((double)imid + 0.5), fr.getGcenter().values[jmid][imid]);
        if (!followroughness) {
            originplane.z = 0.0;
        }
        fr.getTransform().transformVector(true, originplane);
        Vector3d transglobal = new Vector3d(originplane);
        transglobal.sub(originglobal);
        transglobal.scale(-1.0);
        fr.setOriginglobal(transglobal);
        fr.fillTile();
        Vector3d vdip = new Vector3d(0.0, dx, 0.0);
        fr.getTransform().transformVector(true, vdip);
        double height = Math.abs(vdip.z);
        Vector3d xx = new Vector3d();
        int i = 0;
        while (i < NX) {
            int j = 0;
            while (j < NY) {
                boolean oku;
                xx.x = fr.getGcenter().gety(j);
                xx.y = fr.getGcenter().getx(i);
                xx.z = fr.getGcenter().values[j][i];
                if (!followroughness) {
                    xx.z = 0.0;
                }
                fr.getTransform().transformVector(true, xx);
                AzimDip ad = fr.getAdcenter()[j][i];
                Vector3d v = new Vector3d(xx);
                boolean bl = oku = i >= istart && i <= iend && j >= jstart && j <= jend;
                if (oku) {
                    SourceFactory.createSource(sourcetype, v, ad.getAzim(), ad.getDip(), dy, dx, height, u, -volstrain, true);
                } else {
                    SourceFactory.createSource(sourcetype, v, ad.getAzim(), ad.getDip(), dy, dx, height, uzero, -volstrain, true);
                }
                ++j;
            }
            ++i;
        }
        return fr;
    }

    public static void setRectStressSourcesCopyRow(StressSourceData ssd, int NX, int NY, int irow1, int irow2, int j1, int j2, Vector3d u) {
        StressSourceData c = new StressSourceData();
        int j = j1;
        while (j < j2) {
            int i = irow1;
            while (i < irow2) {
                StressSource ss = ssd.get(i * NY + j);
                StressSource css = SourceFactory.createSource(StressSource.SOURCE_RECTANGULAR, ss.x, ss.azim, ss.dip, ss.length, ss.width, ss.height, u, 0.0, true);
                System.out.println("stress loading source : " + css.x + " " + css.u);
                c.add(css);
                ++i;
            }
            ++j;
        }
    }

    public static void setScaleOld(StressSourceData cs, double minuscale, double maxuscale) {
        int imid = cs.size() / 2;
        double step = (maxuscale - minuscale) / (double)imid;
        int i = 0;
        while (i < imid) {
            System.out.println(" scaling u  " + (minuscale + step * (double)i));
            cs.get((int)i).u.scale(minuscale + step * (double)i);
            ++i;
        }
        i = imid;
        while (i < cs.size()) {
            System.out.println(" scaling u  " + (maxuscale - step * (double)(i - imid)));
            cs.get((int)i).u.scale(maxuscale - step * (double)i);
            ++i;
        }
    }

    public static void setScale(StressSourceData cs, double minuscale, double maxuscale) {
        double step = (maxuscale - minuscale) / (double)cs.size();
        int i = 0;
        while (i < cs.size()) {
            System.out.println(" scaling u  " + (minuscale + step * (double)i));
            cs.get((int)i).u.scale(minuscale + step * (double)i);
            ++i;
        }
    }

    public static void setNoise(StressSourceData cs, double noise) {
        Random ran = new Random();
        int i = 0;
        while (i < cs.size()) {
            cs.get((int)i).u.scale(1.0 + ran.nextDouble() * noise);
            ++i;
        }
    }
}

