/*
 * Decompiled with CFR 0.152.
 */
package wrapper;

import javax.vecmath.Vector3d;
import wrapper.PointSource;
import wrapper.RectangularSource;
import wrapper.StressSource;
import wrapper.StressSourceData;

public class SourceFactory {
    static StressSourceData stressSourceData = new StressSourceData();

    public static StressSourceData getStressSourceData() {
        return stressSourceData;
    }

    public static StressSource createSource(int type, Vector3d x, double azim, double dip, double length, double width, double height, Vector3d u, double volstrain, boolean output) {
        if (type == StressSource.SOURCE_POINT) {
            PointSource ps = null;
            ps = Math.abs(height) < 0.001 ? new PointSource(x, azim, dip, length, width, u, volstrain, false) : new PointSource(x, azim, dip, length, width, height, u, volstrain, false);
            stressSourceData.add(ps);
            if (output) {
                System.out.println("generated Point source  " + ps.x.toString() + "length  " + ps.length + "  width " + ps.width + " " + ps.volstrain);
            }
            return ps;
        }
        if (type == StressSource.SOURCE_RECTANGULAR) {
            RectangularSource rs = new RectangularSource(x, azim, dip, length, width, height, u);
            stressSourceData.add(rs);
            if (output) {
                System.out.println("generated Rectangular source (center location)  " + rs.x.toString() + "length  " + rs.length + "  width " + rs.width + " Dip" + rs.dip + "azim" + rs.azim + " U " + u);
            }
            return rs;
        }
        return null;
    }
}

